/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.rules;

import ipipan.spejd.entities.Entity;
import ipipan.spejd.entities.SentenceBorder;
import ipipan.spejd.readers.Reader;
import ipipan.spejd.readers.ReaderFactory;
import ipipan.spejd.rules.LexDictionary;
import ipipan.spejd.util.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import morfologik.stemmers.Stempelator;

public class Sentence {
    Map<String, Entity> map;
    List<Entity> list;
    Reader in;
    PrintStream out;
    String text;
    private LexDictionary dict;
    private Config conf = null;
    private Stempelator stemmer;
    public int lastId = 0;

    public String getNewId() {
        ++this.lastId;
        return String.valueOf('a') + Integer.toHexString(this.lastId);
    }

    public Sentence(Config conf, LexDictionary dict, Stempelator stemmer) {
        this.conf = conf;
        this.map = new TreeMap<String, Entity>();
        this.list = new ArrayList<Entity>();
        this.dict = dict;
        this.stemmer = stemmer;
    }

    public void openFile(File path, Config conf) {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        ReaderFactory rf = new ReaderFactory(conf);
        this.in = rf.getReader(path, conf, this.stemmer);
        try {
            File res = new File(path.getParent(), String.valueOf(this.getCoreName(path)) + conf.outputSuffix);
            this.out = new PrintStream((OutputStream)new FileOutputStream(res), true, "utf-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public Entity get(String segId) {
        return this.map.get(segId);
    }

    void addEntity(Entity e) {
        this.map.put(e.getId(), e);
        this.list.add(e);
    }

    public boolean loadSentence() {
        Entity e = null;
        this.map.clear();
        this.list.clear();
        if (!this.in.nextSentence(this.out)) {
            this.out.close();
            return false;
        }
        this.addEntity(new SentenceBorder('b', this.conf));
        while ((e = this.in.loadToken()) != null) {
            if (this.dict != null) {
                this.dict.apply(e);
            }
            this.addEntity(e);
        }
        this.addEntity(new SentenceBorder('e', this.conf));
        this.updateTxt();
        return true;
    }

    public Entity[] toArray() {
        return this.list.toArray(new Entity[0]);
    }

    void updateTxt() {
        StringBuilder res = new StringBuilder();
        Iterator<Entity> i = this.list.iterator();
        while (i.hasNext()) {
            res.append(i.next().toTxt());
        }
        this.text = res.toString();
    }

    String getCoreName(File f) {
        String name = f.getName();
        if (name.endsWith(".gz")) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (name.indexOf(46) > 0) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        return name;
    }

    public void update() {
        List<Entity> oldList = this.list;
        this.list = new ArrayList<Entity>();
        Iterator<Entity> i = oldList.iterator();
        while (i.hasNext()) {
            Entity e = i.next().getReplacement();
            if (e == null) continue;
            this.addEntity(e);
        }
        this.updateTxt();
    }

    public void printXML() {
        this.out.println("<chunk type=\"s\">");
        Iterator<Entity> i = this.list.iterator();
        while (i.hasNext()) {
            i.next().printXML(this.out);
        }
        this.out.println("</chunk>");
    }
}

