/*
 * Decompiled with CFR 0.152.
 */
package ipipan.spejd.tagset;

import java.util.regex.Pattern;

public class Attribute {
    public static final int ORTH = 0;
    public static final int BASE = 1;
    public static final int POS = 2;
    int id;
    String name;
    String[] values;

    public char intToChar(int i) {
        return (char)(i + 256);
    }

    public int charToInt(char c) {
        return c - 256;
    }

    public Attribute(int id, String name, String[] values) {
        this.id = id;
        this.name = name;
        this.values = values;
    }

    public int nOfValues() {
        return this.values.length;
    }

    public String getValue(char c) {
        int i = this.charToInt(c);
        if (i >= this.values.length) {
            System.err.println("Value [" + c + "] out of range for " + this.name);
            return "-";
        }
        return this.values[this.charToInt(c)];
    }

    public char matchingValue(String value) {
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i].equals(value)) {
                return this.intToChar(i);
            }
            ++i;
        }
        System.err.println("[" + value + "] is not a valid value of " + this.name);
        return '0';
    }

    public String matchingValues(String regexp) {
        Pattern p = Pattern.compile(regexp);
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < this.values.length) {
            if (p.matcher(this.values[i]).matches()) {
                res.append(this.intToChar(i));
            }
            ++i;
        }
        return res.toString();
    }

    public void printValues() {
        System.out.println(String.valueOf(this.id) + ". " + this.name);
        int i = 0;
        while (i < this.values.length) {
            System.out.println("    " + this.intToChar(i) + ". " + this.values[i]);
            ++i;
        }
    }
}

