/*
 * Decompiled with CFR 0.152.
 */
package morfologik;

import java.lang.reflect.Method;
import java.util.TreeMap;
import morfologik.tools.FSADumpTool;
import morfologik.tools.LametyzatorTool;
import morfologik.tools.StempelatorTool;

public final class Tools {
    private static TreeMap getTools() {
        TreeMap<String, ToolInfo> tools = new TreeMap<String, ToolInfo>();
        tools.put("dump", new ToolInfo(FSADumpTool.class, "Dumps the content of FSA dictionaries."));
        tools.put("lametyzator", new ToolInfo(LametyzatorTool.class, "Process text files with Lametyzator stemmer."));
        tools.put("stempelator", new ToolInfo(StempelatorTool.class, "Process text files with Stempelator stemmer."));
        return tools;
    }

    public static void main(String[] args) throws Exception {
        TreeMap tools = Tools.getTools();
        if (args.length == 0) {
            System.out.println("Provide tool name and its command-line options.\nAvailable tools:");
            for (String toolAlias : tools.keySet()) {
                ToolInfo toolInfo = (ToolInfo)tools.get(toolAlias);
                System.out.println("  " + toolAlias + "\t- " + toolInfo.info + "\n");
            }
        } else {
            String toolName = args[0];
            if (!tools.containsKey(toolName)) {
                System.out.println("Tool unknown: " + toolName);
                return;
            }
            String[] subArgs = new String[args.length - 1];
            System.arraycopy(args, 1, subArgs, 0, subArgs.length);
            ToolInfo toolInfo = (ToolInfo)tools.get(toolName);
            Method m = toolInfo.clazz.getMethod("main", String[].class);
            m.invoke(null, new Object[]{subArgs});
        }
    }

    private static final class ToolInfo {
        public final Class clazz;
        public final String info;

        public ToolInfo(Class clazz, String info) {
            this.clazz = clazz;
            this.info = info;
        }
    }
}

