/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa.core;

import morfologik.fsa.core.FSA;
import morfologik.fsa.core.FSAFinalStatesIterator;
import morfologik.fsa.core.FSAMatch;

public class FSATraversalHelper {
    FSATraversalHelper() {
    }

    public FSAFinalStatesIterator getAllSubsequences(FSA.Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null.");
        }
        return new FSAFinalStatesIterator(node);
    }

    public FSAMatch matchSequence(byte[] sequence, FSA fsa) {
        return this.matchSequence(sequence, fsa.getStartNode());
    }

    public FSAMatch matchSequence(byte[] sequence, FSA.Node node) {
        if (node == null) {
            return new FSAMatch(0);
        }
        int i = 0;
        while (i < sequence.length) {
            FSA.Arc arc = node.getArcLabelledWith(sequence[i]);
            if (arc != null) {
                if (arc.isFinal()) {
                    if (i + 1 == sequence.length) {
                        return new FSAMatch(1);
                    }
                    return new FSAMatch(2, i + 1, null);
                }
            } else {
                return new FSAMatch(3, i, node);
            }
            node = arc.getDestinationNode();
            ++i;
        }
        return new FSAMatch(4, 0, node);
    }
}

