/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa.dictionary;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import morfologik.fsa.core.FSA;
import morfologik.fsa.core.FSAFinalStatesIterator;
import morfologik.fsa.core.FSAMatch;
import morfologik.fsa.core.FSATraversalHelper;
import morfologik.fsa.dictionary.Dictionary;
import morfologik.fsa.dictionary.DictionaryFeatures;
import morfologik.stemmers.IStemmer;

public final class DictionaryStemmer
implements IStemmer {
    private static final String[] NO_STEM = null;
    private final FSATraversalHelper matcher;
    private final FSA.Node root;
    private final DictionaryFeatures dictionaryFeatures;

    public DictionaryStemmer(Dictionary dictionary) throws UnsupportedEncodingException, IllegalArgumentException {
        this.dictionaryFeatures = dictionary.features;
        this.root = dictionary.fsa.getStartNode();
        this.matcher = dictionary.fsa.getTraversalHelper();
        if (this.root == null) {
            throw new IllegalArgumentException("Dictionary must have at least the root node.");
        }
        if (this.dictionaryFeatures == null) {
            throw new IllegalArgumentException("Dictionary features must not be null.");
        }
    }

    @Override
    public String[] stem(String word) {
        return this.lookup(word, false);
    }

    @Override
    public String[] stemAndForm(String word) {
        return this.lookup(word, true);
    }

    private String[] lookup(String word, boolean returnForms) {
        String encoding = this.dictionaryFeatures.encoding;
        byte separator = this.dictionaryFeatures.separator;
        try {
            FSA.Arc arc;
            FSAMatch match = this.matcher.matchSequence(word.getBytes(encoding), this.root);
            if (match.getMatchResult() == 4 && (arc = match.getMismatchNode().getArcLabelledWith(separator)) != null && !arc.isFinal()) {
                ArrayList<String> forms = new ArrayList<String>(2);
                FSAFinalStatesIterator i = this.matcher.getAllSubsequences(arc.getDestinationNode());
                while (i.hasNext()) {
                    byte[] baseCompressed = (byte[])i.next();
                    int j = 0;
                    while (j < baseCompressed.length) {
                        if (baseCompressed[j] == separator) break;
                        ++j;
                    }
                    forms.add(this.decompress(new String(baseCompressed, 0, j, encoding), word));
                    if (!returnForms) continue;
                    forms.add(new String(baseCompressed, ++j, baseCompressed.length - j, encoding));
                }
                if (forms.size() == 0) {
                    return NO_STEM;
                }
                return forms.toArray(new String[forms.size()]);
            }
            return NO_STEM;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected Exception: " + e.toString());
        }
    }

    private String decompress(String encodedBase, String inflected) {
        int encodedBaseLength = encodedBase.length();
        boolean fsaPrefixes = this.dictionaryFeatures.usesPrefixes;
        boolean fsaInfixes = this.dictionaryFeatures.usesInfixes;
        if (encodedBaseLength > 0) {
            int code0 = encodedBase.charAt(0) - 65;
            int infLen = inflected.length();
            if (!fsaPrefixes && !fsaInfixes) {
                if (encodedBase.charAt(0) - 65 >= 0) {
                    int stripAtEnd = code0;
                    if (stripAtEnd <= infLen) {
                        return String.valueOf(inflected.substring(0, infLen - stripAtEnd)) + encodedBase.substring(1);
                    }
                    return "";
                }
                return encodedBase;
            }
            if (fsaPrefixes && !fsaInfixes) {
                if (encodedBaseLength > 1 && code0 >= 0) {
                    int stripAtBeginning = code0;
                    int stripAtEnd = encodedBase.charAt(1) - 65;
                    if (stripAtEnd <= infLen && stripAtBeginning <= infLen) {
                        return String.valueOf(inflected.substring(stripAtBeginning, infLen - stripAtEnd)) + encodedBase.substring(2);
                    }
                    return "";
                }
                return encodedBase;
            }
            if (fsaInfixes) {
                if (encodedBaseLength > 2 && code0 >= 0) {
                    int stripPosition = code0;
                    int stripAtBeginning = encodedBase.charAt(1) - 65;
                    int stripAtEnd = encodedBase.charAt(2) - 65;
                    if (stripPosition <= infLen && stripPosition + stripAtBeginning <= infLen && stripAtEnd <= infLen) {
                        return String.valueOf(inflected.substring(0, stripPosition)) + inflected.substring(stripPosition + stripAtBeginning, infLen - stripAtEnd) + encodedBase.substring(3);
                    }
                    return "";
                }
                return encodedBase;
            }
            return encodedBase;
        }
        return encodedBase;
    }
}

