/*
 * Decompiled with CFR 0.152.
 */
package com.dawidweiss.morfeusz;

import com.dawidweiss.morfeusz.InterpMorf;
import java.io.UnsupportedEncodingException;

public final class Analyzer {
    private static final int MAX_GRAPH_NODES = 50;
    private final String encoding;
    private InterpMorf[] morphologicalAnalysis;
    private int tokensNumber;

    Analyzer(String encoding) {
        this.encoding = encoding;
        this.morphologicalAnalysis = new InterpMorf[50];
        for (int i = 0; i < this.morphologicalAnalysis.length; ++i) {
            this.morphologicalAnalysis[i] = new InterpMorf(encoding);
        }
    }

    public InterpMorf[] analyze(String term) {
        try {
            this.tokensNumber = this.morfeusz_analyse(term.getBytes(this.encoding));
            return this.morphologicalAnalysis;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    public InterpMorf[] analyze(byte[] term) {
        this.tokensNumber = this.morfeusz_analyse(term);
        return this.morphologicalAnalysis;
    }

    public int getTokensNumber() {
        return this.tokensNumber;
    }

    private final native int morfeusz_analyse(byte[] var1);
}

