/*
 * Decompiled with CFR 0.152.
 */
package com.dawidweiss.morfeusz;

import java.io.UnsupportedEncodingException;

public final class InterpMorf {
    private static final int MAX_TOKEN_LENGTH = 200;
    private static final int MAX_LEMMA_LENGTH = 200;
    private static final int MAX_TAG_LENGTH = 600;
    private final String morfeuszCharEncoding;
    int p;
    int k;
    final byte[] token = new byte[200];
    int tokenLength;
    final byte[] lemma = new byte[200];
    int lemmaLength;
    final byte[] tag = new byte[600];
    int tagLength;

    InterpMorf(String byteToCharEncoding) {
        this.morfeuszCharEncoding = byteToCharEncoding;
    }

    public final byte[] getToken() {
        return this.token;
    }

    public final byte[] getLemma() {
        return this.lemma;
    }

    public final byte[] getTag() {
        return this.tag;
    }

    public final int getNodeStart() {
        return this.p;
    }

    public final int getNodeEnd() {
        return this.k;
    }

    public final int getLemmaLength() {
        return this.lemmaLength;
    }

    public final int getTagLength() {
        return this.tagLength;
    }

    public final int getTokenLength() {
        return this.tokenLength;
    }

    public final String getTagImage() {
        try {
            return new String(this.getTag(), 0, this.getTagLength(), this.morfeuszCharEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    public final String getLemmaImage() {
        try {
            return new String(this.getLemma(), 0, this.getLemmaLength(), this.morfeuszCharEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    public final String getTokenImage() {
        try {
            return new String(this.getToken(), 0, this.getTokenLength(), this.morfeuszCharEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    public String toString() {
        return this.getNodeStart() + "-" + this.getNodeEnd() + " : " + this.getTokenImage() + " : " + this.getLemmaImage() + " : " + this.getTagImage();
    }

    static {
        try {
            new String("abc".getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Required encoding unsupported: UTF-8");
        }
    }
}

