/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ipipan.spejd.processing;

import java.util.concurrent.LinkedBlockingQueue;
import morfologik.stemmers.Stempelator;
import java.io.File;

/**
 *
 * @author axw
 */
public class ProcessingRunnable implements Runnable {
    
    private File f;
    
    
    private LinkedBlockingQueue<ProcessingRunnable> RnblsInProcessing;
    
    public ProcessingRunnable(File f, LinkedBlockingQueue<ProcessingRunnable> RnblsInProcessing) {
        this.f = f;
        this.RnblsInProcessing = RnblsInProcessing;
    }
    
    
    public void run(){
        
        // check all references carried by ProcessingThread - if one/some of them is null, detect it now and exit
        boolean amIOK = true;
        if (((ProcessingThread) Thread.currentThread()).conf == null) { amIOK=false; System.err.print(" Config reference is null. "); }   
        if (((ProcessingThread) Thread.currentThread()).lock == null) { amIOK=false; System.err.print(" Lock reference is null. "); }
        if (((ProcessingThread) Thread.currentThread()).dict == null) { amIOK=false; System.err.print(" Dictionary reference is null. "); }
        if (((ProcessingThread) Thread.currentThread()).anal == null) { amIOK=false; System.err.print(" Analyzer reference is null. "); }
        if (((ProcessingThread) Thread.currentThread()).rules == null) { amIOK=false; System.err.print(" Ruleset reference is null. "); }
        if (((ProcessingThread) Thread.currentThread()).chunk == null) { amIOK=false; System.err.print(" Chunk reference is null. "); }
        
        
        if(!amIOK) {
            RnblsInProcessing.remove(this);
            synchronized (((ProcessingThread) Thread.currentThread()).lock) {
                ((ProcessingThread) Thread.currentThread()).lock.notify();
            }
            return;
        }
        
        
        // processing data        
        ((ProcessingThread) Thread.currentThread()).chunk.openFile(f, ((ProcessingThread) Thread.currentThread()).conf);
        int n = 0;
        System.err.println("Shallowparsing - " + f.getPath());
        while(((ProcessingThread) Thread.currentThread()).chunk.loadSentence()) {
            
        	try {
            ((ProcessingThread) Thread.currentThread()).rules.applyTo(((ProcessingThread) Thread.currentThread()).chunk);
            ((ProcessingThread) Thread.currentThread()).chunk.printXML();
            n ++;
        	} catch (Exception e) {
        		e.printStackTrace();
        		System.exit(1);
			}
        }
        ((ProcessingThread) Thread.currentThread()).chunk.lastId=0; // restart Entity numeration for each file
        
       
       if (((ProcessingThread) Thread.currentThread()).lock == null) { 
           System.err.print(" ERROR - lock reference null! /while exiting/ - whom should I notify??");
           System.exit(1);
       }


       RnblsInProcessing.remove(this);
       synchronized (((ProcessingThread) Thread.currentThread()).lock) {
           ((ProcessingThread) Thread.currentThread()).lock.notify();
       }
        return;
        
    }
            
    

}
