package ipipan.spejd.util;

import java.util.TreeMap;

/**
 * Configuration class, containing a set of variables with values.
 */
public class SimpleDict extends AbstractDict<String> {

    /**
     * Creates a new configuration with no variables.
     */
    public SimpleDict() {
        dict = new TreeMap<String, String>();
    }

    /**
     * Creates a dictionary with variables loaded from a given filename.
     */
    public SimpleDict(String filename) {
        this();
        // load(filename);
    }

    /**
     * Sets value of a configuration variable.
     *
     * @param var name of the variable to set
     * @param value value of the variable as String
     */
    public void put(String var, String value) {
        dict.put(var, value);
    }

}
