/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ipipan.spejd.processing;

import morfologik.stemmers.Stempelator;

import ipipan.spejd.util.Config;
import ipipan.spejd.rules.LexDictionary;
import ipipan.spejd.rules.RuleSet;
import ipipan.spejd.rules.Sentence;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;

/**
 *
 * @author axw
 */
public class ProcessingThreadsFactory implements ThreadFactory {

    private Stempelator stemmer = null;
    private final Config conf;
    private final Object lock;
        
   public ProcessingThreadsFactory(Object lock, Config conf) {
       this.lock = lock;
       this.conf = conf;
   }

   
   // 
   public ProcessingThread newThread(Runnable r) {
       
       try {
           this.stemmer = new Stempelator();
       } catch (IOException ex) { ex.printStackTrace(); }

       RuleSet rules = new RuleSet(conf);
       LexDictionary dict = new LexDictionary(conf.lexDictionaries, conf);
       Sentence chunk = new Sentence(conf, dict, stemmer);
       
       return new ProcessingThread(r, stemmer, dict, rules, chunk, conf, lock);
   }
   

   
}
