/*
 * Copyright (C) 2007 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of Spejd.
 *
 * Spejd is free software: it may be distributed and/or modified under
 * the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

 

package ipipan.spejd.readers;

import ipipan.spejd.util.Config;
import java.io.File;
import java.nio.charset.Charset;
import morfologik.stemmers.Stempelator;


public class ReaderFactory {

    public static final int UNKNOWN   = -1;
    public static final int AUTO      =  0;
    public static final int PLAIN_TXT =  1;
    public static final int XCES_ANA  =  2;
    public static final int CWB_OUT   =  3;

    private Config conf;

    public ReaderFactory(Config conf) {
        this.conf=conf;
    }

    int getReaderType(String type) {
        if(type.equals("auto"))
            return AUTO;
        if(type.equals("txt"))
            return PLAIN_TXT;
        if(type.equals("xcesAna"))
            return XCES_ANA;
        if(type.equals("cwb"))
            return CWB_OUT;
        System.out.println("Unknown inputType [" + type + "], please correct configuration.");
        return UNKNOWN;
    }

    int getFileType(File path) {
        String f = path.getName();
        //if(f.equals("morph.xml") || f.equals("morph.xml.gz"))
        if(f.endsWith(".xml"))
            return XCES_ANA;
        if(f.endsWith(".txt"))
            return PLAIN_TXT;
        if(f.endsWith(".out"))
            return CWB_OUT;
        System.out.println("Unknown type of file: " + f);
        return UNKNOWN;
    }

    /**
     * Get the appropriate reader for this path.
     */
    public Reader getReader(File path, Config conf, Stempelator stemmer) {
        
        
        int readerType = getReaderType(conf.inputType);

        int type = readerType == AUTO ? getFileType(path) : readerType;

        switch(type) {
            case PLAIN_TXT:
                    PlainTextReader plainTextReader = new PlainTextReader(conf, stemmer);
                    plainTextReader.readTextFile(path.getPath(), Charset.forName(conf.inputEncoding));
                    return plainTextReader;
            case XCES_ANA:
                    return new MorphReader(path, conf);
            case CWB_OUT:
                    return new WorkbenchReader(path, conf);
            default:
                    return null;
        }
    }


}
