/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.util.LinkedList;
import termopl.AndTemplate;
import termopl.MatchedFragment;
import termopl.MatchedToken;
import termopl.OrTemplate;
import termopl.SimpleTemplate;
import termopl.Tagset;
import termopl.Tester;
import termopl.Token;

public abstract class Template {
    public static final int NO_QUANTIFIER = 0;
    public static final int ZERO_OR_ONE = 1;
    public static final int ZERO_OR_MORE = 2;
    public static final int ONE_OR_MORE = 3;
    public static Template adjp = Template.ADJP();
    public int quantifier;
    public boolean computeBaseForm;
    public boolean head;
    public Tester tester;

    public Template() {
        this.quantifier = 0;
        this.computeBaseForm = false;
        this.head = false;
        this.tester = null;
    }

    public Template(boolean computeBaseForm) {
        this.quantifier = 0;
        this.computeBaseForm = computeBaseForm;
        this.head = false;
        this.tester = null;
    }

    public Template(int quantifier) {
        this.quantifier = quantifier;
        this.computeBaseForm = false;
        this.head = false;
        this.tester = null;
    }

    public Template(int quantifier, boolean computeBaseForm) {
        this.quantifier = quantifier;
        this.computeBaseForm = computeBaseForm;
        this.head = false;
        this.tester = null;
    }

    public void setQuantifier(int quantifier) {
        this.quantifier = quantifier;
    }

    public void setTester(Tester tester) {
        this.tester = tester;
    }

    public void setComputeBaseForm(boolean computeBaseForm) {
        this.computeBaseForm = computeBaseForm;
    }

    public void setHead(boolean head) {
        this.head = head;
    }

    public boolean test(Token token, Tagset tagset) {
        if (this.tester != null) {
            return this.tester.test(token, tagset);
        }
        return true;
    }

    public boolean test(MatchedFragment matched, Tagset tagset) {
        if (this.tester != null) {
            return this.tester.test(matched, tagset);
        }
        return true;
    }

    public abstract LinkedList<Template> getElements();

    public static boolean testPOS(Token token, Tagset tagset, String ... POS) {
        String pos = token.getPOS(tagset);
        String[] stringArray = POS;
        int n = POS.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (pos.equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean testForm(Token token, String form) {
        return token.form.equals(form);
    }

    public static boolean testLemma(Token token, String lemma) {
        return token.lemma.equals(lemma);
    }

    public static boolean testAgreement(MatchedFragment matched, Tagset tagset) {
        return Template.testAgreement(matched, tagset, null, null, null);
    }

    public static boolean testAgreement(MatchedFragment matched, Tagset tagset, String gcase, String gender, String number) {
        LinkedList<MatchedToken> tokens = matched.getMatchedTokens();
        int size = tokens.size();
        if (size == 1) {
            Token t = tokens.getFirst().token;
            String t_gcase = tagset.getCategory(t, "case");
            String t_gender = tagset.getCategory(t, "gender");
            String t_number = tagset.getCategory(t, "number");
            if (t_gcase != null && t_gender != null && t_number != null) {
                return Template.agree(gcase, t_gcase, gender, t_gender, number, t_number);
            }
        } else {
            for (MatchedToken mt : tokens) {
                Token t = mt.token;
                String t_gcase = tagset.getCategory(t, "case");
                String t_gender = tagset.getCategory(t, "gender");
                String t_number = tagset.getCategory(t, "number");
                if (t_gcase == null || t_gender == null || t_number == null) continue;
                if (!Template.agree(gcase, t_gcase, gender, t_gender, number, t_number)) {
                    return false;
                }
                if (gcase == null) {
                    gcase = t_gcase;
                }
                if (gender == null) {
                    gender = t_gender;
                }
                if (number != null) continue;
                number = t_number;
            }
        }
        return true;
    }

    public static boolean agree(String c1, String c2, String g1, String g2, String n1, String n2) {
        if (c1 != null && !c2.equals(c1)) {
            return false;
        }
        if (g1 != null && !g2.equals(g1)) {
            return false;
        }
        return n1 == null || n2.equals(n1);
    }

    public static Template adj() {
        SimpleTemplate st = new SimpleTemplate(){

            @Override
            public boolean test(Token token, Tagset tagset) {
                return 1.testPOS(token, tagset, "adj");
            }
        };
        return st;
    }

    public static Template ppas() {
        SimpleTemplate st = new SimpleTemplate(){

            @Override
            public boolean test(Token token, Tagset tagset) {
                return 2.testPOS(token, tagset, "ppas");
            }
        };
        return st;
    }

    public static Template noun() {
        SimpleTemplate st = new SimpleTemplate(true){

            @Override
            public boolean test(Token token, Tagset tagset) {
                return 3.testPOS(token, tagset, "subst", "ger");
            }
        };
        return st;
    }

    public static Template adja() {
        SimpleTemplate st = new SimpleTemplate(){

            @Override
            public boolean test(Token token, Tagset tagset) {
                return 4.testPOS(token, tagset, "adja");
            }
        };
        return st;
    }

    public static Template dash() {
        SimpleTemplate st = new SimpleTemplate(){

            @Override
            public boolean test(Token token, Tagset tagset) {
                return 5.testLemma(token, "-");
            }
        };
        return st;
    }

    public static Template adja_adj() {
        return new AndTemplate(Template.adja(), Template.dash(), Template.adj());
    }

    public static Template ADJ_star() {
        return new OrTemplate(2, Template.adj(), Template.ppas(), Template.adja_adj());
    }

    public static Template NAP() {
        AndTemplate at = new AndTemplate(true, new Template[]{Template.ADJ_star(), Template.noun(), Template.ADJ_star()}){

            @Override
            public boolean test(MatchedFragment matched, Tagset tagset) {
                return 6.testAgreement(matched, tagset);
            }
        };
        return at;
    }

    public static Template NAP_gen_star() {
        AndTemplate at = new AndTemplate(2, new Template[]{Template.ADJ_star(), Template.noun(), Template.ADJ_star()}){

            @Override
            public boolean test(MatchedFragment matched, Tagset tagset) {
                return 7.testAgreement(matched, tagset, "gen", null, null);
            }
        };
        return at;
    }

    public static Template NPP() {
        return new AndTemplate(Template.NAP(), Template.NAP_gen_star());
    }

    public static Template ADJP() {
        return new OrTemplate(Template.adj(), Template.ppas(), Template.adja_adj());
    }
}

