/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import termopl.TermoPL;

public class About
extends JPanel {
    private static final String DESCRIPTION = "<html><p>TermoPL is a tool for extracting terminology from domain corpora.<br><br>The program extracts phrases, candidates for terms, using Universal<br>Dependency (UD) structures obtained from UD parsers or through a <br>simple grammar that can be customized. It applies the C-value method<br>to rank term candidates being either the longest identified acceptable<br>phrases or their nested subphrases.<br><br>The extraction method operates on simplified base forms in order to<br>unify morhological variants of terms and to recognize their contexts.<br>For Polish, the program has an option to convert simplified forms of<br>phrases into correct phrases in the nominal case.<br><br>TermoPL can be used to compare two lists of candidate terms using<br>different coefficients to show the asymmetry in the occurrence of terms<br>in the data. For Polish texts, TermoPL can group semantically related<br>terms using plWordNet.</html></p>";
    private JDialog dialog;

    public About() {
        this.setBackground(new Color(255, 255, 225));
        this.setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 16));
        this.arrangeComponents();
    }

    public void arrangeComponents() {
        URL url = ClassLoader.getSystemClassLoader().getResource("java.png");
        ImageIcon icon = new ImageIcon(url);
        Font font = new Font("SansSerif", 0, 11);
        Box vbox = Box.createVerticalBox();
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalGlue());
        JLabel label = new JLabel("TermoPL");
        label.setForeground(Color.red);
        label.setFont(new Font("SansSerif", 1, 16));
        hbox.add(label);
        hbox.add(Box.createHorizontalGlue());
        vbox.add(hbox);
        vbox.add(Box.createVerticalStrut(16));
        hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalGlue());
        label = new JLabel("Version 8.1.0");
        label.setFont(new Font("SansSerif", 1, 12));
        hbox.add(label);
        hbox.add(Box.createHorizontalGlue());
        vbox.add(hbox);
        vbox.add(Box.createVerticalStrut(8));
        hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalGlue());
        label = new JLabel("Institute of Computer Science, Polish Academy of Sciences");
        label.setFont(font);
        hbox.add(label);
        hbox.add(Box.createHorizontalGlue());
        vbox.add(hbox);
        vbox.add(Box.createVerticalStrut(8));
        hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalGlue());
        label = new JLabel("Software co-funded by CLARIN-PL");
        label.setFont(font);
        hbox.add(label);
        hbox.add(Box.createHorizontalGlue());
        vbox.add(hbox);
        vbox.add(Box.createVerticalStrut(16));
        hbox = Box.createHorizontalBox();
        label = new JLabel(DESCRIPTION);
        label.setFont(new Font("Serif", 0, 14));
        hbox.add(label);
        vbox.add(hbox);
        vbox.add(Box.createVerticalStrut(16));
        hbox = Box.createHorizontalBox();
        label = new JLabel("Java version: " + System.getProperty("java.version"));
        label.setFont(font);
        label.setIcon(icon);
        hbox.add(label);
        hbox.add(Box.createHorizontalGlue());
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                About.this.dialog.dispose();
            }
        });
        hbox.add(ok);
        vbox.add(hbox);
        this.add(vbox);
    }

    public void doDialog() {
        this.dialog = new JDialog((Frame)TermoPL.dialogOwner, true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setResizable(false);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(TermoPL.dialogOwner);
        this.dialog.setTitle("About TermoPL");
        this.dialog.setVisible(true);
    }
}

