/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import termopl.AndTemplate;
import termopl.CompoundTemplate;
import termopl.Evaluator;
import termopl.MatchedElement;
import termopl.OrTemplate;
import termopl.Parser;
import termopl.ParserError;
import termopl.ParserException;
import termopl.QList;
import termopl.QSym;
import termopl.Rule;
import termopl.SimpleTemplate;
import termopl.Tagset;
import termopl.Template;
import termopl.Test;
import termopl.Tester;
import termopl.Token;

public class GParser
extends Parser {
    private File grammarFile;
    private Tagset tagset;
    private LinkedList<Rule> rules;
    private LinkedList<String> headSymbols;
    private Template template;
    private HashMap<String, Tester> tsym;

    public GParser(File file, Tagset tagset, Object owner) {
        super(owner);
        this.grammarFile = file;
        this.tagset = tagset;
        this.rules = new LinkedList();
        this.headSymbols = new LinkedList();
        this.tsym = new HashMap();
    }

    @Override
    public void parse() {
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.grammarFile), "UTF8"));
            this.getSymbol();
            do {
                boolean head;
                if (this.symbol == Parser.Symbol.CIRCMFX) {
                    head = true;
                    this.getSymbol();
                } else {
                    head = false;
                }
                if (this.symbol == Parser.Symbol.IDENTIFIER) {
                    this.parseRule(head);
                    continue;
                }
                this.symbol = Parser.Symbol.UNKNOWN;
                this.error(3);
                this.skip(Parser.Symbol.IDENTIFIER);
            } while (!this.tooManyErrors() && this.symbol != Parser.Symbol.EMPTY);
            if (this.noErrors()) {
                if (this.rules.isEmpty()) {
                    this.error(9);
                } else {
                    Collection<Tester> testers = this.tsym.values();
                    boolean found = false;
                    for (Tester t : testers) {
                        if (!t.hasAnythingToDo()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.error(10);
                    }
                }
            }
            if (this.noErrors()) {
                this.template = this.compileRules();
            }
        }
        catch (Exception exception) {
            try {
                this.error(exception.getStackTrace().toString());
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
        this.reportErrors();
    }

    public void parseRule(boolean head) throws ParserException {
        Rule rule = new Rule(head);
        this.parseSymbol(rule);
        if (this.symbol == Parser.Symbol.SCOLON) {
            this.getSymbol();
        } else {
            this.error(4);
        }
        if (this.noErrors()) {
            if (rule.subst != null) {
                this.rules.add(rule);
            }
            if (head) {
                this.headSymbols.add(rule.id);
            }
        }
    }

    public void parseSymbol(Rule rule) throws ParserException {
        String sym = this.identifier;
        Tester tester = this.tsym.get(sym);
        rule.id = sym;
        if (tester == null) {
            tester = new Tester();
        }
        this.getSymbol();
        this.parseCondition(tester);
        if (this.noErrors()) {
            this.tsym.put(sym, tester);
        }
        if (this.symbol == Parser.Symbol.COLON) {
            if (rule.head) {
                this.error(30);
                this.skip(Parser.Symbol.SCOLON);
            } else {
                this.getSymbol();
                this.parseTemplate(rule);
            }
        }
    }

    public void parseCondition(Tester tester) throws ParserException {
        if (this.symbol == Parser.Symbol.LBRCT) {
            this.getSymbol();
            this.parseTestList(tester);
            if (this.symbol == Parser.Symbol.RBRCT) {
                this.getSymbol();
            } else {
                this.error(6);
                this.skip(Parser.Symbol.COLON, Parser.Symbol.SCOLON, Parser.Symbol.IDENTIFIER);
            }
        }
    }

    public void parseTestList(Tester tester) throws ParserException {
        boolean done = false;
        do {
            this.parseTest(tester);
            if (this.symbol == Parser.Symbol.SCOLON) {
                this.getSymbol();
                continue;
            }
            done = true;
        } while (!this.tooManyErrors() && !done);
    }

    public void parseTest(Tester tester) throws ParserException {
        if (this.symbol == Parser.Symbol.IDENTIFIER) {
            String id = this.identifier;
            this.getSymbol();
            if (this.symbol == Parser.Symbol.EQ || this.symbol == Parser.Symbol.NEQ || this.symbol == Parser.Symbol.MATCH || this.symbol == Parser.Symbol.NMATCH) {
                Test test = new Test();
                if (this.symbol == Parser.Symbol.EQ) {
                    test.op = 1;
                } else if (this.symbol == Parser.Symbol.NEQ) {
                    test.op = 2;
                } else if (this.symbol == Parser.Symbol.MATCH) {
                    test.op = 3;
                } else if (this.symbol == Parser.Symbol.NMATCH) {
                    test.op = 4;
                }
                test = this.getTest(id, test, Token.class);
                this.parseArguments(test);
                tester.add(test);
            } else {
                String def = this.tagset.getDefinition(id);
                if (def != null) {
                    String[] cats;
                    String[] stringArray = cats = def.split(",");
                    int n = cats.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String c = stringArray[n2];
                        tester.add(this.getTest(c, null, MatchedElement.class));
                        ++n2;
                    }
                } else {
                    tester.add(this.getTest(id, null, MatchedElement.class));
                }
            }
        } else {
            this.error(2);
            this.skip(Parser.Symbol.SCOLON, Parser.Symbol.RBRCT);
        }
    }

    public Test getTest(String id, Test test, Class<?> cl) {
        Object[] params;
        Method method;
        if (test == null) {
            test = new Test();
        }
        if ((method = this.getMethod(id, cl)) == null) {
            method = this.getMethod(cl);
            params = new Object[3];
            params[1] = id;
            params[2] = this.tagset;
        } else {
            params = new Object[2];
            params[1] = this.tagset;
        }
        test.setParams(params);
        test.method = method;
        return test;
    }

    public Method getMethod(Class<?> cl) {
        Method method;
        Class<Evaluator> e = Evaluator.class;
        String id = null;
        try {
            if (cl.getSimpleName().equals("Token")) {
                id = "categoryValue";
                method = e.getDeclaredMethod(id, cl, String.class, Tagset.class);
            } else {
                id = "agreement";
                method = e.getDeclaredMethod(id, cl, String.class, Tagset.class);
            }
        }
        catch (Exception exception) {
            method = null;
        }
        return method;
    }

    public Method getMethod(String id, Class<?> cl) {
        Method method;
        Class<Evaluator> e = Evaluator.class;
        try {
            if (id.equals("pos") && this.tagset.getType() == 2) {
                id = "tag";
            }
            method = e.getDeclaredMethod(String.valueOf(id) + "_", cl, Tagset.class);
        }
        catch (Exception e1) {
            method = null;
        }
        return method;
    }

    public void parseArguments(Test test) throws ParserException {
        boolean done = false;
        LinkedList<String> args = new LinkedList<String>();
        this.getSymbol();
        do {
            if (this.symbol == Parser.Symbol.IDENTIFIER) {
                args.add(this.identifier);
                this.getSymbol();
            } else if (this.symbol == Parser.Symbol.STRING) {
                args.add(this.string);
                this.getSymbol();
            } else if (this.symbol == Parser.Symbol.RBRCT) {
                if (args.isEmpty()) {
                    this.error(8);
                }
            } else {
                this.error(8);
                this.skip(Parser.Symbol.COMMA, Parser.Symbol.IDENTIFIER);
            }
            if (this.symbol == Parser.Symbol.COMMA) {
                this.getSymbol();
                continue;
            }
            done = true;
        } while (!this.tooManyErrors() && !done);
        if (this.noErrors()) {
            test.args = args.toArray(new String[0]);
        }
    }

    public void parseTemplate(Rule rule) throws ParserException {
        QList list2;
        boolean done = false;
        QList list1 = null;
        do {
            list2 = null;
            do {
                boolean computeBaseForm;
                if (this.symbol == Parser.Symbol.DOLLAR) {
                    computeBaseForm = true;
                    this.getSymbol();
                } else {
                    computeBaseForm = false;
                }
                if (this.symbol == Parser.Symbol.IDENTIFIER) {
                    QSym sym = new QSym(this.identifier);
                    sym.computeBaseForm = computeBaseForm;
                    if (list2 == null) {
                        list2 = new QList(1);
                    }
                    list2.add(sym);
                    this.getSymbol();
                    if (this.symbol == Parser.Symbol.QMARK) {
                        this.getSymbol();
                        sym.quantifier = 1;
                        continue;
                    }
                    if (this.symbol == Parser.Symbol.STAR) {
                        this.getSymbol();
                        sym.quantifier = 2;
                        continue;
                    }
                    if (this.symbol != Parser.Symbol.PLUS) continue;
                    this.getSymbol();
                    sym.quantifier = 3;
                    continue;
                }
                this.error(3);
                this.skip(Parser.Symbol.IDENTIFIER);
            } while (!this.tooManyErrors() && this.symbol == Parser.Symbol.IDENTIFIER || this.symbol == Parser.Symbol.DOLLAR);
            if (this.symbol == Parser.Symbol.OR) {
                this.getSymbol();
                if (list1 == null) {
                    list1 = new QList(2);
                }
                if (list2.size() > 1) {
                    list1.add(list2);
                    continue;
                }
                list1.add(list2.getFirst());
                continue;
            }
            if (this.symbol != Parser.Symbol.SCOLON) continue;
            done = true;
        } while (!done && !this.tooManyErrors());
        if (list1 != null) {
            if (list2.size() > 1) {
                list1.add(list2);
            } else {
                list1.add(list2.getFirst());
            }
        }
        rule.subst = list1 == null ? list2 : list1;
    }

    @Override
    public void getSymbol() throws ParserException {
        int ch = 32;
        while (Character.isWhitespace(ch)) {
            ch = this.getNextChar();
        }
        this.scanPos = this.charCount - 1;
        if (this.isLetter(ch)) {
            this.buffer.setLength(0);
            while (this.isIdentifierChar(ch)) {
                this.buffer.append((char)ch);
                ch = this.getNextChar();
            }
            this.identifier = this.buffer.toString();
            this.symbol = Parser.Symbol.IDENTIFIER;
            if (this.noSkipChar(ch)) {
                --this.charCount;
            }
        } else if (ch == 33) {
            ch = this.getNextChar();
            this.symbol = ch == 61 ? Parser.Symbol.NEQ : (ch == 126 ? Parser.Symbol.NMATCH : Parser.Symbol.UNKNOWN);
        } else if (ch == 34) {
            this.getString();
        } else {
            this.symbol = ch == 36 ? Parser.Symbol.DOLLAR : (ch == 94 ? Parser.Symbol.CIRCMFX : (ch == -1 ? Parser.Symbol.EMPTY : (ch == 61 ? Parser.Symbol.EQ : (ch == 63 ? Parser.Symbol.QMARK : (ch == 42 ? Parser.Symbol.STAR : (ch == 43 ? Parser.Symbol.PLUS : (ch == 58 ? Parser.Symbol.COLON : (ch == 59 ? Parser.Symbol.SCOLON : (ch == 91 ? Parser.Symbol.LBRCT : (ch == 93 ? Parser.Symbol.RBRCT : (ch == 44 ? Parser.Symbol.COMMA : (ch == 124 ? Parser.Symbol.OR : (ch == 126 ? Parser.Symbol.MATCH : Parser.Symbol.UNKNOWN)))))))))))));
        }
    }

    public boolean noSkipChar(int ch) {
        return ch == 34 || ch == 36 || ch == 94 || ch == 61 || ch == 63 || ch == 42 || ch == 43 || ch == 58 || ch == 59 || ch == 91 || ch == 93 || ch == 44 || ch == 124 || ch == 126;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Template compileRules() throws ParserException {
        Rule head = this.findHead();
        Template tmp = this.compile(head);
        return tmp;
    }

    public Template compile(Rule rule) throws ParserException {
        if (rule == null) {
            return null;
        }
        LinkedList<String> stack = new LinkedList<String>();
        stack.add(rule.id);
        return this.compile(rule, stack);
    }

    public Template compile(Rule rule, LinkedList<String> stack) throws ParserException {
        Tester tester = this.tsym.get(rule.id);
        Template tmp = this.compile(rule.subst, tester, stack);
        return tmp;
    }

    public Template compile(QList subst, Tester tester, LinkedList<String> stack) throws ParserException {
        CompoundTemplate tmp = subst.type == 1 ? new AndTemplate() : new OrTemplate();
        for (Object e : subst.elements) {
            if (e instanceof QSym) {
                QSym qs = (QSym)e;
                Template t = this.compile(qs, stack);
                if (t == null) break;
                tmp.add(t);
                continue;
            }
            QList ql = (QList)e;
            tmp.add(this.compile(ql, null, stack));
        }
        tmp.setTester(tester);
        return tmp;
    }

    public Template compile(QSym qs, LinkedList<String> stack) throws ParserException {
        Template tmp;
        Rule rule = this.findRule(qs.id);
        Tester tester = this.tsym.get(qs.id);
        if (stack.contains(qs.id)) {
            this.errors.add(new ParserError(11));
            throw new ParserException();
        }
        if (rule == null) {
            tmp = new SimpleTemplate();
        } else {
            stack.add(qs.id);
            tmp = this.compile(rule, stack);
            stack.removeLast();
        }
        tmp.setQuantifier(qs.quantifier);
        tmp.setTester(tester);
        tmp.setComputeBaseForm(qs.computeBaseForm);
        tmp.setHead(this.headSymbols.contains(qs.id));
        return tmp;
    }

    public Rule findRule(String id) {
        for (Rule r : this.rules) {
            if (!r.id.equals(id)) continue;
            return r;
        }
        return null;
    }

    public Rule findHead() {
        LinkedList<Rule> head = null;
        for (Rule r1 : this.rules) {
            String sym = r1.id;
            boolean found = false;
            for (Rule r2 : this.rules) {
                QList subst = r2.subst;
                if (!subst.contains(sym)) continue;
                if (r1 == r2) {
                    this.errors.add(new ParserError(11));
                    return null;
                }
                found = true;
                break;
            }
            if (!this.noErrors() || found) continue;
            if (head == null) {
                head = new LinkedList<Rule>();
            }
            head.add(r1);
        }
        if (this.noErrors()) {
            if (head == null) {
                this.errors.add(new ParserError(11));
                return null;
            }
            if (head.size() == 1) {
                return (Rule)head.getFirst();
            }
            Rule root = new Rule("root");
            QList subst = new QList(2);
            for (Rule r : head) {
                QSym qs = new QSym(r.id);
                subst.add(qs);
            }
            root.subst = subst;
            return root;
        }
        return null;
    }
}

