/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuListener;
import termopl.AssocMenuItem;
import termopl.AssocRadioButtonMenuItem;
import termopl.Command;
import termopl.MenuSelectionListener;
import termopl.TermoPL;
import termopl.TermoPLDocument;
import termopl.TermoPLWindow;

public class MenuFactory {
    private static final int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final MenuSelectionListener menuListener = new MenuSelectionListener();

    public static JMenuBar createMenuBar(boolean isMacOS) {
        LinkedList<String> files = TermoPL.preferences.recentFiles;
        JMenuBar menuBar = new JMenuBar();
        int mnemonicKey = 0;
        if (!isMacOS) {
            mnemonicKey = 70;
        }
        JMenu menu = MenuFactory.createMenu("File", mnemonicKey);
        if (!isMacOS) {
            mnemonicKey = 78;
        }
        menu.add(MenuFactory.createMenuItem(Command.newCommand, mnemonicKey, 78, keyMask));
        if (!isMacOS) {
            mnemonicKey = 79;
        }
        menu.add(MenuFactory.createMenuItem(Command.openCommand, mnemonicKey, 79, keyMask));
        if (!isMacOS) {
            mnemonicKey = 77;
        }
        menu.add(MenuFactory.createMenuItem(Command.mergeCommand, mnemonicKey, 77, keyMask));
        if (!isMacOS) {
            mnemonicKey = 82;
        }
        JMenu submenu = MenuFactory.createMenu("Open Recent", mnemonicKey);
        for (String path : files) {
            submenu.add(MenuFactory.createOpenRecentMenuItem(path));
        }
        menu.add(submenu);
        if (!isMacOS) {
            mnemonicKey = 67;
        }
        menu.add(MenuFactory.createMenuItem(Command.closeCommand, mnemonicKey, 87, keyMask));
        if (!isMacOS) {
            mnemonicKey = 83;
        }
        menu.add(MenuFactory.createMenuItem(Command.saveCommand, mnemonicKey, 83, keyMask));
        if (!isMacOS) {
            mnemonicKey = 65;
        }
        menu.add(MenuFactory.createMenuItem(Command.saveAsCommand, mnemonicKey));
        menu.addSeparator();
        if (!isMacOS) {
            mnemonicKey = 87;
        }
        menu.add(MenuFactory.createMenuItem(Command.workspaceCommand, mnemonicKey));
        menu.addSeparator();
        if (!isMacOS) {
            mnemonicKey = 69;
        }
        menu.add(MenuFactory.createMenuItem(Command.exportCommand, mnemonicKey));
        if (!isMacOS) {
            mnemonicKey = 80;
        }
        menu.add(MenuFactory.createMenuItem(Command.exportFormsCommand, mnemonicKey));
        if (!isMacOS) {
            mnemonicKey = 84;
        }
        menu.add(MenuFactory.createMenuItem(Command.exportSentencesCommand, mnemonicKey));
        if (!isMacOS) {
            mnemonicKey = 71;
        }
        menu.add(MenuFactory.createMenuItem(Command.exportGroupsCommand, mnemonicKey));
        if (!isMacOS) {
            menu.addSeparator();
            mnemonicKey = 88;
            menu.add(MenuFactory.createMenuItem(Command.exitCommand, mnemonicKey));
        }
        menuBar.add(menu);
        if (!isMacOS) {
            mnemonicKey = 83;
        }
        menu = MenuFactory.createMenu("Search", mnemonicKey);
        if (!isMacOS) {
            mnemonicKey = 69;
        }
        menu.add(MenuFactory.createMenuItem(Command.extractCommand, mnemonicKey, 69, keyMask));
        if (!isMacOS) {
            mnemonicKey = 67;
        }
        menu.add(MenuFactory.createMenuItem(Command.compareCommand, mnemonicKey));
        menu.addSeparator();
        if (!isMacOS) {
            mnemonicKey = 83;
        }
        menu.add(MenuFactory.createMenuItem(Command.selectFilesCommand, mnemonicKey));
        if (!isMacOS) {
            mnemonicKey = 84;
        }
        menu.add(MenuFactory.createMenuItem(Command.selectContrastiveTermsCommand, mnemonicKey));
        menu.addSeparator();
        if (!isMacOS) {
            mnemonicKey = 66;
        }
        menu.add(MenuFactory.createCheckBoxMenuItem(Command.baseFormsCommand, mnemonicKey));
        if (!isMacOS) {
            mnemonicKey = 70;
        }
        menu.add(MenuFactory.createCheckBoxMenuItem(Command.collectCommand, mnemonicKey));
        if (!isMacOS) {
            mnemonicKey = 73;
        }
        menu.add(MenuFactory.createCheckBoxMenuItem(Command.indexCommand, mnemonicKey));
        if (!isMacOS) {
            menu.addSeparator();
            mnemonicKey = 80;
            menu.add(MenuFactory.createMenuItem(Command.preferencesCommand, mnemonicKey));
        }
        menuBar.add(menu);
        if (!isMacOS) {
            mnemonicKey = 86;
        }
        menu = MenuFactory.createMenu("View", mnemonicKey);
        if (!isMacOS) {
            mnemonicKey = 70;
        }
        menu.add(MenuFactory.createMenuItem(Command.formsCommand, mnemonicKey));
        if (!isMacOS) {
            mnemonicKey = 83;
        }
        menu.add(MenuFactory.createMenuItem(Command.sentencesCommand, mnemonicKey));
        if (!isMacOS) {
            mnemonicKey = 71;
        }
        menu.add(MenuFactory.createMenuItem(Command.groupsCommand, mnemonicKey));
        menu.addSeparator();
        if (!isMacOS) {
            mnemonicKey = 73;
        }
        menu.add(MenuFactory.createMenuItem(Command.increaseCommand, mnemonicKey));
        if (!isMacOS) {
            mnemonicKey = 68;
        }
        menu.add(MenuFactory.createMenuItem(Command.decreaseCommand, mnemonicKey));
        menuBar.add(menu);
        if (!isMacOS) {
            mnemonicKey = 87;
        }
        menu = MenuFactory.createMenu("Window", mnemonicKey);
        if (!isMacOS) {
            mnemonicKey = 83;
        }
        menu.add(MenuFactory.createMenuItem(Command.showOneAll, mnemonicKey));
        if (!isMacOS) {
            mnemonicKey = 68;
        }
        submenu = MenuFactory.createMenu("Document Switch List", mnemonicKey);
        menu.add(submenu);
        menu.addSeparator();
        if (!isMacOS) {
            mnemonicKey = 84;
        }
        menu.add(MenuFactory.createMenuItem(Command.tileCommand, mnemonicKey));
        if (!isMacOS) {
            mnemonicKey = 67;
        }
        menu.add(MenuFactory.createMenuItem(Command.cascadeCommand, mnemonicKey));
        menuBar.add(menu);
        mnemonicKey = isMacOS ? 0 : 72;
        menu = MenuFactory.createMenu("Help ", mnemonicKey);
        if (!isMacOS) {
            mnemonicKey = 65;
            menu.add(MenuFactory.createMenuItem(Command.aboutCommand, mnemonicKey));
            menu.addSeparator();
        }
        mnemonicKey = isMacOS ? 0 : 77;
        menu.add(MenuFactory.createMenuItem(Command.helpCommand, mnemonicKey));
        menuBar.add(menu);
        return menuBar;
    }

    public static JMenu createMenu(String label, int mnemonicKey, MenuListener menuListener) {
        JMenu menu = new JMenu(label);
        if (menuListener != null) {
            menu.addMenuListener(menuListener);
        }
        if (mnemonicKey != 0) {
            menu.setMnemonic(mnemonicKey);
        }
        return menu;
    }

    public static JMenu createMenu(String label, int mnemonicKey) {
        return MenuFactory.createMenu(label, mnemonicKey, menuListener);
    }

    public static JMenuItem createMenuItem(Command tileCommand, int mnemonicKey) {
        JMenuItem menuItem = new JMenuItem(tileCommand);
        if (mnemonicKey != 0) {
            menuItem.setMnemonic(mnemonicKey);
        }
        return menuItem;
    }

    public static JMenuItem createMenuItem(Command command, int mnemonicKey, int acceleratorKey, int keyMask) {
        JMenuItem menuItem = MenuFactory.createMenuItem(command, mnemonicKey);
        if (acceleratorKey != 0) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(acceleratorKey, keyMask));
        }
        return menuItem;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(Command command, int mnemonicKey) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(command);
        if (mnemonicKey != 0) {
            menuItem.setMnemonic(mnemonicKey);
        }
        return menuItem;
    }

    public static AssocMenuItem createOpenRecentMenuItem(String path) {
        AbstractAction action = new AbstractAction(new File(path).getName()){

            @Override
            public void actionPerformed(ActionEvent event) {
                AssocMenuItem source = (AssocMenuItem)event.getSource();
                String path = (String)source.getAssociation();
                TermoPL.application.open(path);
            }
        };
        return new AssocMenuItem((Object)path, action);
    }

    public static AssocRadioButtonMenuItem createDocumentSwitchMenuItem(TermoPLDocument doc) {
        AbstractAction action = new AbstractAction(doc.getDocumentDisplayName()){

            @Override
            public void actionPerformed(ActionEvent event) {
                AssocRadioButtonMenuItem source = (AssocRadioButtonMenuItem)event.getSource();
                TermoPLDocument doc = (TermoPLDocument)source.getAssociation();
                TermoPL.application.bringToFront(doc);
            }
        };
        return new AssocRadioButtonMenuItem(doc, action);
    }

    public static AssocRadioButtonMenuItem createWindowMenuItem(TermoPLWindow wnd) {
        String str = wnd.getTitle();
        int i = str.indexOf(91);
        if (i > 0) {
            str = str.substring(0, i - 1);
        }
        AbstractAction action = new AbstractAction(str){

            @Override
            public void actionPerformed(ActionEvent event) {
                AssocRadioButtonMenuItem source = (AssocRadioButtonMenuItem)event.getSource();
                TermoPLWindow wnd = (TermoPLWindow)source.getAssociation();
                wnd.select();
            }
        };
        return new AssocRadioButtonMenuItem(wnd, action);
    }

    public static void removeRecentFile(String path) {
        if (TermoPL.isMacOS) {
            MenuFactory.removeRecentFileInAllFrames(path);
        } else {
            MenuFactory.removeRecentFileInMasterFrame(path);
        }
    }

    public static void removeRecentFile(JMenu menu, String path) {
        int count = menu.getItemCount();
        AssocMenuItem it = null;
        boolean found = false;
        int i = 0;
        while (i < count) {
            it = (AssocMenuItem)menu.getItem(i);
            if (((String)it.getAssociation()).equals(path)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            menu.remove(i);
        }
    }

    public static void removeRecentFileInMasterFrame(String path) {
        MenuFactory.removeRecentFile(MenuFactory.getRecentFileMenu(TermoPL.mainWindow.getJMenuBar()), path);
    }

    public static void removeRecentFileInAllFrames(String path) {
        MenuFactory.removeRecentFileInMasterFrame(path);
        for (TermoPLDocument document : TermoPL.documents) {
            for (TermoPLWindow window : document.getWindows()) {
                JFrame frame = (JFrame)((Object)window);
                MenuFactory.removeRecentFile(MenuFactory.getRecentFileMenu(frame.getJMenuBar()), path);
            }
        }
    }

    public static void updateRecentFiles(String path) {
        if (TermoPL.isMacOS) {
            MenuFactory.updateRecentFilesInAllFrames(path);
        } else {
            MenuFactory.updateRecentFilesInMasterFrame(path);
        }
    }

    public static void updateRecentFiles(JMenu menu, String path) {
        int count = menu.getItemCount();
        AssocMenuItem it = null;
        boolean found = false;
        int i = 0;
        while (i < count) {
            it = (AssocMenuItem)menu.getItem(i);
            if (((String)it.getAssociation()).equals(path)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            menu.remove(i);
            menu.insert(it, 0);
        } else {
            if (count >= 5) {
                menu.remove(count - 1);
            }
            it = MenuFactory.createOpenRecentMenuItem(path);
            menu.insert(it, 0);
        }
    }

    public static void updateRecentFilesInMasterFrame(String path) {
        MenuFactory.updateRecentFiles(MenuFactory.getRecentFileMenu(TermoPL.mainWindow.getJMenuBar()), path);
    }

    public static void updateRecentFilesInAllFrames(String path) {
        MenuFactory.updateRecentFilesInMasterFrame(path);
        for (TermoPLDocument document : TermoPL.documents) {
            for (TermoPLWindow window : document.getWindows()) {
                JFrame frame = (JFrame)((Object)window);
                MenuFactory.updateRecentFiles(MenuFactory.getRecentFileMenu(frame.getJMenuBar()), path);
            }
        }
    }

    public static void addToDocumentSwitchMenu(TermoPLDocument doc) {
        if (TermoPL.isMacOS) {
            MenuFactory.addToDocumentSwitchMenuInAllFrames(doc);
        } else {
            MenuFactory.addToDocumentSwitchMenuInMasterFrame(doc);
        }
    }

    public static void addToDocumentSwitchMenu(JMenu menu, TermoPLDocument doc) {
        AssocRadioButtonMenuItem it = MenuFactory.createDocumentSwitchMenuItem(doc);
        menu.add(it);
    }

    public static void addToDocumentSwitchMenuInMasterFrame(TermoPLDocument doc) {
        MenuFactory.addToDocumentSwitchMenu(MenuFactory.getDocumentSwitchMenu(TermoPL.mainWindow.getJMenuBar()), doc);
    }

    public static void addToDocumentSwitchMenuInAllFrames(TermoPLDocument doc) {
        MenuFactory.addToDocumentSwitchMenuInMasterFrame(doc);
        for (TermoPLDocument document : TermoPL.documents) {
            for (TermoPLWindow window : document.getWindows()) {
                JFrame frame = (JFrame)((Object)window);
                MenuFactory.addToDocumentSwitchMenu(MenuFactory.getDocumentSwitchMenu(frame.getJMenuBar()), doc);
            }
        }
    }

    public static void removeFromDocumentSwitchMenu(TermoPLDocument doc) {
        if (TermoPL.isMacOS) {
            MenuFactory.removeFromDocumentSwitchMenuInAllFrames(doc);
        } else {
            MenuFactory.removeFromDocumentSwitchMenuInMasterFrame(doc);
        }
    }

    public static void removeFromDocumentSwitchMenu(JMenu menu, TermoPLDocument doc) {
        int count = menu.getItemCount();
        AssocRadioButtonMenuItem it = null;
        boolean found = false;
        int i = 0;
        while (i < count) {
            it = (AssocRadioButtonMenuItem)menu.getItem(i);
            if (((TermoPLDocument)it.getAssociation()).equals(doc)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            menu.remove(i);
        }
    }

    public static void removeFromDocumentSwitchMenuInMasterFrame(TermoPLDocument doc) {
        MenuFactory.removeFromDocumentSwitchMenu(MenuFactory.getDocumentSwitchMenu(TermoPL.mainWindow.getJMenuBar()), doc);
    }

    public static void removeFromDocumentSwitchMenuInAllFrames(TermoPLDocument doc) {
        MenuFactory.removeFromDocumentSwitchMenuInMasterFrame(doc);
        for (TermoPLDocument document : TermoPL.documents) {
            for (TermoPLWindow window : document.getWindows()) {
                JFrame frame = (JFrame)((Object)window);
                MenuFactory.removeFromDocumentSwitchMenu(MenuFactory.getDocumentSwitchMenu(frame.getJMenuBar()), doc);
            }
        }
    }

    public static void resetSelection(TermoPLDocument doc, TermoPLWindow wnd) {
        if (TermoPL.isMacOS) {
            MenuFactory.resetSelection(doc, wnd, ((JFrame)((Object)wnd)).getJMenuBar());
        } else {
            MenuFactory.resetSelection(doc, wnd, TermoPL.mainWindow.getJMenuBar());
        }
    }

    public static void resetSelection(TermoPLDocument doc, TermoPLWindow wnd, JMenuBar mbar) {
        AssocRadioButtonMenuItem it;
        int i;
        JMenu menu = MenuFactory.getWindowMenu(mbar);
        int count = menu.getItemCount();
        if (count > 5) {
            i = 6;
            while (i < count) {
                it.setSelected((it = (AssocRadioButtonMenuItem)menu.getItem(i)).getAssociation() == wnd);
                ++i;
            }
        }
        menu = MenuFactory.getDocumentSwitchMenu(mbar);
        count = menu.getItemCount();
        i = 0;
        while (i < count) {
            it.setSelected((it = (AssocRadioButtonMenuItem)menu.getItem(i)).getAssociation() == doc);
            ++i;
        }
    }

    public static void addToWindowMenu(JMenu menu, TermoPLWindow wnd) {
        AssocRadioButtonMenuItem it = MenuFactory.createWindowMenuItem(wnd);
        int count = menu.getItemCount();
        if (count == 5) {
            menu.addSeparator();
        }
        menu.add(it);
    }

    public static void resetWindowMenu(TermoPLDocument doc) {
        MenuFactory.resetWindowMenu(MenuFactory.getWindowMenu(TermoPL.mainWindow.getJMenuBar()), doc);
    }

    public static void resetWindowMenu(TermoPLDocument doc, TermoPLWindow wnd) {
        MenuFactory.resetWindowMenu(MenuFactory.getWindowMenu(((JFrame)((Object)wnd)).getJMenuBar()), doc);
    }

    public static void resetWindowMenu(JMenu menu, TermoPLDocument doc) {
        int count = menu.getItemCount() - 5;
        if (count > 0) {
            int i = 0;
            while (i < count) {
                menu.remove(5);
                ++i;
            }
        }
        for (TermoPLWindow window : doc.getWindows()) {
            MenuFactory.addToWindowMenu(menu, window);
        }
    }

    public static JMenu getRecentFileMenu(JMenuBar mbar) {
        return (JMenu)mbar.getMenu(0).getItem(3);
    }

    public static JMenu getDocumentSwitchMenu(JMenuBar mbar) {
        return (JMenu)mbar.getMenu(3).getItem(1);
    }

    public static JMenu getWindowMenu(JMenuBar mbar) {
        return mbar.getMenu(3);
    }
}

