/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import termopl.Token;

public class Tagset {
    public static final int UNDEFINED_TYPE = -1;
    public static final int CATEGORY_BY_POSITION = 0;
    public static final int CATEGORY_BY_VALUE = 1;
    public static final int POS_TAG = 2;
    public static final String DEAULT_DELIMITER = ":";
    private HashSet<String> categories;
    private HashMap<String, String> catByValue;
    private HashMap<String, HashMap<String, Integer>> catByPosition;
    private HashMap<String, Integer> defaultCategories;
    private HashMap<String, String> definitions;
    private String delim;
    private int type;

    public Tagset() {
        this(-1);
        this.delim = DEAULT_DELIMITER;
    }

    public Tagset(int type) {
        this.type = type;
        this.delim = DEAULT_DELIMITER;
        this.categories = new HashSet();
        this.definitions = new HashMap();
        this.defaultCategories = null;
    }

    public static Tagset createDefaultTagset() {
        Tagset tagset = new Tagset(1);
        tagset.addDefaultCategories();
        return tagset;
    }

    public void addDefaultCategories() {
        this.addCategory("number", "sg", "pl");
        this.addCategory("case", "nom", "gen", "dat", "acc", "inst", "loc", "voc");
        this.addCategory("gender", "m1", "m2", "m3", "f", "n");
        this.addCategory("sgender", "pt", "ncol", "col");
        this.addCategory("person", "pri", "sec", "ter");
        this.addCategory("degree", "pos", "com", "sup");
        this.addCategory("aspect", "imperf", "perf");
        this.addCategory("negation", "aff", "neg");
        this.addCategory("accent", "akc", "nakc");
        this.addCategory("pprep", "praep", "npraep");
        this.addCategory("accom", "congr", "rec");
        this.addCategory("aggl", "nagl", "agl");
        this.addCategory("vocality", "wok", "nwok");
        this.addCategory("fstop", "pun", "npun");
        this.definitions.put("agreement", "number,case,gender");
    }

    public void addCategory(String cat, String ... values) {
        if (this.catByValue == null) {
            this.catByValue = new HashMap();
        }
        this.categories.add(cat);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            this.catByValue.put(val, cat);
            ++n2;
        }
    }

    public void addCategory(String cat, List<String> values) {
        if (this.catByValue == null) {
            this.catByValue = new HashMap();
        }
        this.categories.add(cat);
        for (String val : values) {
            this.catByValue.put(val, cat);
        }
    }

    public void addCategoriesToClass(String cls, String ... clist) {
        if (this.catByPosition == null) {
            this.catByPosition = new HashMap();
        }
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        int i = 0;
        while (i < clist.length) {
            this.categories.add(clist[i]);
            index.put(clist[i], i + 1);
            ++i;
        }
        this.catByPosition.put(cls, index);
    }

    public void addCategoriesToClass(String cls, List<String> clist) {
        if (this.catByPosition == null) {
            this.catByPosition = new HashMap();
        }
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        int i = 0;
        for (String cat : clist) {
            this.categories.add(cat);
            index.put(cat, ++i);
        }
        this.catByPosition.put(cls, index);
    }

    public void setDefaultCategories(List<String> clist) {
        this.defaultCategories = new HashMap();
        int i = 0;
        while (i < clist.size()) {
            String cat = clist.get(i);
            this.categories.add(cat);
            this.defaultCategories.put(cat, i + 1);
            ++i;
        }
    }

    public boolean isCategoryDefined(String cat) {
        this.categories.contains(cat);
        return false;
    }

    public void addDefinition(String symbol, String definition) {
        this.definitions.put(symbol, definition);
    }

    public String getDefinition(String symbol) {
        if (this.definitions.containsKey(symbol)) {
            return this.definitions.get(symbol);
        }
        return null;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setDelimiter(String delim) {
        this.delim = delim;
    }

    public String getDelimiter() {
        return this.delim;
    }

    public HashSet<String> getCategories() {
        return this.categories;
    }

    public HashMap<String, HashMap<String, Integer>> getCategoriesByPositions() {
        return this.catByPosition;
    }

    public HashMap<String, String> getCategoriesByValues() {
        return this.catByValue;
    }

    public String getPos(String tag) {
        return this.getPos(tag.split(this.delim));
    }

    public String getPos(String[] tag) {
        return tag[0];
    }

    public String getCategory(Token token, String cat) {
        return this.getCategory(token.getTag(this), cat);
    }

    public String getCategory(String tag, String cat) {
        return this.getCategory(tag.split(this.delim), cat);
    }

    public String getCategory(String[] tag, String cat) {
        if (tag != null && tag.length > 1) {
            if (this.type == 1) {
                if (this.catByValue != null) {
                    int i = 1;
                    while (i < tag.length) {
                        String val = tag[i];
                        String c = this.catByValue.get(val);
                        if (cat.equals(c)) {
                            return val;
                        }
                        ++i;
                    }
                }
            } else if (this.type == 0) {
                int i;
                String pos = tag[0];
                HashMap<String, Integer> index = null;
                if (this.catByPosition != null && this.catByPosition.containsKey(pos)) {
                    index = this.catByPosition.get(pos);
                }
                if (index == null) {
                    index = this.defaultCategories;
                }
                if (index != null && index.containsKey(cat) && (i = index.get(cat).intValue()) > 0 && i < tag.length) {
                    return tag[i];
                }
            }
        }
        return null;
    }
}

