/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import desktophandler.DesktopHandler;
import eawthandler.EAWTHandler;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractSequentialList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import termopl.About;
import termopl.BatchParameters;
import termopl.Command;
import termopl.Commander;
import termopl.DefaultMasterFrame;
import termopl.LanguageInfo;
import termopl.MacMasterFrame;
import termopl.MasterFrame;
import termopl.MenuFactory;
import termopl.Options;
import termopl.Preferences;
import termopl.Term;
import termopl.TermoPLDocument;
import termopl.TermoPLWindow;
import termopl.WindowUtils;
import termopl.WndLocation;
import termopl.Workspace;

public class TermoPL
extends Commander {
    public static final int MAX_RECENT_FILES = 5;
    public static final FileNameExtensionFilter TRM_FILTER = new FileNameExtensionFilter("Terms files", "trm");
    public static TermoPL application;
    public static String appLocation;
    public static boolean isMacOS;
    public static boolean isWindows;
    public static boolean batchMode;
    public static boolean showOne;
    public static boolean blockExit;
    public static MasterFrame mainWindow;
    public static JFrame dialogOwner;
    public static TermoPLDocument hiddenDocument;
    public static Preferences preferences;
    public static LinkedList<TermoPLDocument> documents;
    public static LinkedList<TermoPLWindow> zorder;
    public static HashMap<String, Term> cterms;
    public static LinkedHashMap<String, LanguageInfo> languages;
    public static int nameCounter;

    static {
        isMacOS = false;
        isWindows = false;
        batchMode = false;
        showOne = false;
        blockExit = false;
        mainWindow = null;
        dialogOwner = null;
        hiddenDocument = null;
        nameCounter = 0;
    }

    public TermoPL() {
        application = this;
        appLocation = this.getApplicationDir();
        this.initApplication();
        if (!batchMode) {
            this.initGUI();
        }
    }

    public void initApplication() {
        preferences = Preferences.createPreferences(!batchMode);
        documents = new LinkedList();
    }

    public void initGUI() {
        String str = System.getProperty("os.name");
        this.initLanguages();
        zorder = new LinkedList();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (str != null && str.contains("Mac OS X")) {
            str = System.getProperty("java.version");
            if (str.startsWith("1.8")) {
                new EAWTHandler(){

                    @Override
                    public void handleQuitRequest() {
                        TermoPL.this.exit();
                    }

                    @Override
                    public void handleAboutRequest() {
                        TermoPL.this.about();
                    }

                    @Override
                    public void handlePreferencesRequest() {
                        TermoPL.this.handlePreferences();
                    }
                };
            } else {
                new DesktopHandler(){

                    @Override
                    public void handleQuitRequest() {
                        TermoPL.this.exit();
                    }

                    @Override
                    public void handleAboutRequest() {
                        TermoPL.this.about();
                    }

                    @Override
                    public void handlePreferencesRequest() {
                        TermoPL.this.handlePreferences();
                    }
                };
            }
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            isMacOS = true;
            isWindows = false;
            mainWindow = new MacMasterFrame();
        } else {
            isMacOS = false;
            if (str.contains("Windows")) {
                isWindows = true;
            }
            mainWindow = new DefaultMasterFrame();
            dialogOwner = mainWindow;
        }
        this.setMainFrameBounds();
        Commander.setCommander(this);
        mainWindow.setVisible(true);
    }

    public void initLanguages() {
        Object list;
        File dir = new File(String.valueOf(appLocation) + File.separator + "languages");
        HashMap<String, String> map = new HashMap<String, String>();
        if (dir.exists()) {
            list = dir.listFiles();
            File[] fileArray = list;
            int n = ((File[])list).length;
            int n2 = 0;
            while (n2 < n) {
                File name;
                File f = fileArray[n2];
                if (f.isDirectory() && (name = new File(f.getAbsoluteFile() + File.separator + "name")).exists()) {
                    String[] info;
                    String line;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), "UTF8"));
                        line = reader.readLine();
                        line = line.trim();
                        reader.close();
                    }
                    catch (IOException exception) {
                        line = null;
                        exception.printStackTrace();
                    }
                    if (line != null && (info = line.split("\t")).length == 2) {
                        map.put(info[0], info[1]);
                    }
                }
                ++n2;
            }
        }
        if (!map.containsKey("pl")) {
            map.put("pl", "Polish");
        }
        list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        languages = new LinkedHashMap();
        Iterator iterator = ((AbstractSequentialList)list).iterator();
        while (iterator.hasNext()) {
            Map.Entry e = (Map.Entry)iterator.next();
            languages.put((String)e.getKey(), new LanguageInfo((String)e.getKey(), (String)e.getValue()));
        }
        if (TermoPL.preferences.language != null && !languages.containsKey(TermoPL.preferences.language)) {
            TermoPL.preferences.language = null;
        }
    }

    public void setMainFrameBounds() {
        if (isMacOS) {
            mainWindow.setSize(0, 0);
            mainWindow.setLocation(-1, -1);
        } else {
            Rectangle rect = preferences.getBounds(0);
            if (rect.width == 0) {
                rect = WindowUtils.getScreenRect();
            }
            WindowUtils.setBoundsRelativeToScreen(mainWindow, rect, true);
        }
    }

    public void startBatchProcessing(BatchParameters bp) {
        LinkedList<File> sourceFiles = null;
        LinkedList<File> trmFiles = null;
        TermoPLDocument doc = null;
        File[] fileArray = TermoPL.collectFiles(bp.inputFiles);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().endsWith(".trm")) {
                if (trmFiles == null) {
                    trmFiles = new LinkedList<File>();
                }
                trmFiles.add(f);
            } else {
                if (sourceFiles == null) {
                    sourceFiles = new LinkedList<File>();
                }
                sourceFiles.add(f);
            }
            ++n2;
        }
        if (trmFiles != null) {
            for (File f : trmFiles) {
                if (doc == null) {
                    this.open(f);
                    if (documents.size() <= 0) continue;
                    doc = documents.getLast();
                    continue;
                }
                doc.merge(f);
            }
        }
        if (sourceFiles != null) {
            if (doc == null) {
                String[] files = new String[sourceFiles.size()];
                int i = 0;
                for (File f : sourceFiles) {
                    files[i++] = f.getPath();
                }
                bp.inputFiles = files;
                doc = new TermoPLDocument(this, bp);
                doc.startBatchProcessing();
            } else {
                doc.addNewResults(sourceFiles.toArray(new File[0]));
            }
        }
        if (doc != null) {
            if (bp.output != null) {
                doc.save(new File(bp.output));
            }
            if (bp.export != null) {
                doc.export(new File(bp.export), 1);
            }
            if (bp.exportForms != null) {
                doc.export(new File(bp.exportForms), 2);
            }
            if (bp.exportSentences != null) {
                doc.export(new File(bp.exportSentences), 3);
            }
            if (bp.exportGroups != null) {
                doc.export(new File(bp.exportGroups), 4);
            }
            doc.waitForSaveThreadsToFinish();
        }
    }

    @Override
    public void executeCommand(int commandID, int modifiers) {
        switch (commandID) {
            case 1: {
                this.createNewDocument();
                break;
            }
            case 2: {
                this.open();
                break;
            }
            case 7: {
                this.selectWorkspace();
                break;
            }
            case 15: {
                TermoPL.selectContrastiveCorpus();
                break;
            }
            case 16: {
                TermoPL.preferences.calculateBaseForms = !TermoPL.preferences.calculateBaseForms;
                preferences.setModified(true);
                break;
            }
            case 17: {
                TermoPL.preferences.collectAllForms = !TermoPL.preferences.collectAllForms;
                preferences.setModified(true);
                break;
            }
            case 18: {
                TermoPL.preferences.makeIndex = !TermoPL.preferences.makeIndex;
                preferences.setModified(true);
                break;
            }
            case 19: {
                this.changePreferences();
                break;
            }
            case 23: {
                this.increaseFont();
                break;
            }
            case 24: {
                this.decreaseFont();
                break;
            }
            case 25: {
                this.showOneAll();
                break;
            }
            case 26: {
                this.tile();
                break;
            }
            case 27: {
                this.cascade();
                break;
            }
            case 29: {
                this.about();
                break;
            }
            case 30: {
                this.help();
                break;
            }
            case 28: {
                this.exit();
                break;
            }
            default: {
                super.executeCommand(commandID, modifiers);
            }
        }
    }

    @Override
    public void findMenuStatus(JMenu menu) {
    }

    @Override
    public void findCommandStatus(JMenuItem item) {
        Command command = (Command)item.getAction();
        switch (command.getCommandID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: {
                item.setEnabled(false);
                break;
            }
            case 15: 
            case 16: {
                item.setSelected(TermoPL.preferences.calculateBaseForms);
                item.setEnabled(!TermoPL.preferences.useCustomTagset);
                break;
            }
            case 17: {
                item.setSelected(TermoPL.preferences.collectAllForms);
                break;
            }
            case 18: {
                item.setSelected(TermoPL.preferences.makeIndex);
                break;
            }
            case 23: {
                item.setEnabled(TermoPL.preferences.fontSize < 15);
                break;
            }
            case 24: {
                item.setEnabled(TermoPL.preferences.fontSize > 11);
                break;
            }
            case 25: {
                if (showOne) {
                    item.setText("Show All Documents");
                    break;
                }
                item.setText("Show One Document");
                break;
            }
            case 26: 
            case 27: {
                int n = 0;
                for (TermoPLDocument doc : documents) {
                    for (TermoPLWindow w : doc.getWindows()) {
                        if (!((Component)((Object)w)).isVisible()) continue;
                        ++n;
                    }
                }
                item.setEnabled(n > 1);
                break;
            }
            default: {
                super.findCommandStatus(item);
            }
        }
    }

    public void createNewDocument() {
        Commander cmd;
        if (showOne && (cmd = Commander.getCommander()) instanceof TermoPLDocument) {
            this.hideDocument((TermoPLDocument)cmd);
        }
        TermoPLDocument doc = new TermoPLDocument(this);
        documents.add(doc);
        MenuFactory.addToDocumentSwitchMenu(doc);
        MenuFactory.resetSelection(doc, zorder.getFirst());
        doc.selectFiles();
    }

    public void open() {
        File file;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Open");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(TRM_FILTER);
        if (TermoPL.preferences.filePath != null && (file = new File(TermoPL.preferences.filePath)).exists()) {
            chooser.setCurrentDirectory(file);
        }
        if (chooser.showOpenDialog(dialogOwner) == 0) {
            file = chooser.getSelectedFile();
            TermoPL.preferences.filePath = file.getParentFile().getPath();
            this.open(file);
        }
    }

    public void open(String path) {
        File file = new File(path);
        if (file.exists()) {
            this.open(file);
        } else if (batchMode) {
            System.out.println("File " + file.getName() + " does not exist.");
        } else {
            this.removeRecentFile(path);
            JOptionPane.showMessageDialog(dialogOwner, "File " + file.getName() + " does not exist.", "Error", 0);
        }
    }

    public void open(File file) {
        Commander cmd;
        if (!batchMode && showOne && (cmd = Commander.getCommander()) instanceof TermoPLDocument) {
            hiddenDocument = (TermoPLDocument)cmd;
            this.hideDocument(hiddenDocument);
        }
        new TermoPLDocument(this, file);
    }

    public void finishOpening(TermoPLDocument doc) {
        String path = doc.getPath();
        if (doc.isLoaded()) {
            documents.add(doc);
            if (!batchMode) {
                this.updateRecentFiles(path);
                MenuFactory.addToDocumentSwitchMenu(doc);
                MenuFactory.resetSelection(doc, zorder.getFirst());
            }
        } else if (!batchMode) {
            if (doc.isCorrupted()) {
                this.removeRecentFile(path);
            } else {
                this.updateRecentFiles(path);
            }
            if (showOne && hiddenDocument != null) {
                this.showDocument(hiddenDocument);
            }
        }
        hiddenDocument = null;
    }

    public void selectWorkspace() {
        Workspace workspace = new Workspace(TermoPL.preferences.workSpace);
        int res = workspace.doDialog();
        if (res == 1) {
            TermoPL.preferences.workSpace = TermoPL.preferences.filePath = workspace.getCurrentWorkspace();
            preferences.setModified(true);
        }
        workspace.dispose();
    }

    public void closeDocument(TermoPLDocument doc) {
        documents.remove(doc);
        if (!batchMode) {
            MenuFactory.removeFromDocumentSwitchMenu(doc);
            if (documents.isEmpty()) {
                Commander.setCommander(this);
            } else if (showOne && !documents.isEmpty()) {
                TermoPLWindow wnd = zorder.getFirst();
                TermoPLDocument d = wnd.getDocument();
                this.showDocument(d);
            }
        }
    }

    public void removeRecentFile(String path) {
        TermoPL.preferences.recentFiles.remove(path);
        preferences.setModified(true);
        MenuFactory.removeRecentFile(path);
    }

    public void updateRecentFiles(String path) {
        TermoPL.preferences.recentFiles.remove(path);
        TermoPL.preferences.recentFiles.addFirst(path);
        preferences.setModified(true);
        if (TermoPL.preferences.recentFiles.size() > 5) {
            TermoPL.preferences.recentFiles.removeLast();
        }
        MenuFactory.updateRecentFiles(path);
    }

    public void handlePreferences() {
        Commander.getCommander().executeCommand(19, 0);
    }

    public void changePreferences() {
        Options options = new Options(preferences);
        options.doDialog();
        options.dispose();
        if (preferences.isModified()) {
            preferences.save();
        }
    }

    public void about() {
        About about = new About();
        about.doDialog();
    }

    public void help() {
        if (Desktop.isDesktopSupported()) {
            try {
                File manual = new File("TermoPL-user-manual.pdf");
                if (manual.exists()) {
                    Desktop.getDesktop().open(manual);
                } else {
                    JOptionPane.showMessageDialog(dialogOwner, "TermoPL user manual is missing.", "File not found", 0);
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(dialogOwner, "No application registered for PDFs.", "Error", 0);
            }
        }
    }

    public void increaseFont() {
        ++TermoPL.preferences.fontSize;
        this.changeFontSize();
    }

    public void decreaseFont() {
        --TermoPL.preferences.fontSize;
        this.changeFontSize();
    }

    public void changeFontSize() {
        Font f;
        TermoPL.preferences.plainFont = f = TermoPL.preferences.plainFont.deriveFont((float)TermoPL.preferences.fontSize);
        TermoPL.preferences.boldFont = f = TermoPL.preferences.boldFont.deriveFont((float)TermoPL.preferences.fontSize);
        for (TermoPLDocument doc : documents) {
            doc.changeFontSize();
        }
        preferences.setModified(true);
    }

    public void showDocument(TermoPLDocument doc) {
        TermoPLWindow[] ws = TermoPL.zorder(doc).toArray(new TermoPLWindow[0]);
        int i = ws.length - 1;
        while (i >= 0) {
            if (ws[i].getDocument() == doc) {
                ws[i].select();
            }
            --i;
        }
    }

    public void hideDocument(TermoPLDocument doc) {
        TermoPLWindow[] ws;
        TermoPLWindow[] termoPLWindowArray = ws = TermoPL.zorder(doc).toArray(new TermoPLWindow[0]);
        int n = ws.length;
        int n2 = 0;
        while (n2 < n) {
            TermoPLWindow wnd = termoPLWindowArray[n2];
            if (wnd.getDocument() == doc) {
                wnd.setVisible(false);
            }
            ++n2;
        }
    }

    public void bringToFront(TermoPLDocument doc) {
        TermoPLDocument d;
        Commander cmd;
        if (showOne && (cmd = Commander.getCommander()) instanceof TermoPLDocument && (d = (TermoPLDocument)cmd) != doc) {
            this.hideDocument(d);
        }
        this.showDocument(doc);
    }

    public void showOneAll() {
        block3: {
            TermoPLWindow[] ws;
            block4: {
                boolean bl = showOne = !showOne;
                if (zorder.size() <= 0) break block3;
                ws = zorder.toArray(new TermoPLWindow[0]);
                if (!showOne) break block4;
                if (Commander.getCommander() == this) break block3;
                TermoPLDocument doc = (TermoPLDocument)Commander.getCommander();
                TermoPLWindow[] termoPLWindowArray = ws;
                int n = ws.length;
                int n2 = 0;
                while (n2 < n) {
                    TermoPLWindow wnd = termoPLWindowArray[n2];
                    if (wnd.getDocument() != doc) {
                        wnd.setVisible(false);
                    }
                    ++n2;
                }
                break block3;
            }
            int i = ws.length - 1;
            while (i >= 0) {
                ws[i].setVisible(true);
                --i;
            }
        }
    }

    public void exit() {
        if (!documents.isEmpty()) {
            TermoPLDocument[] docs;
            TermoPLDocument[] termoPLDocumentArray = docs = documents.toArray(new TermoPLDocument[0]);
            int n = docs.length;
            int n2 = 0;
            while (n2 < n) {
                TermoPLDocument d = termoPLDocumentArray[n2];
                d.close();
                ++n2;
            }
        }
        if (documents.isEmpty()) {
            Rectangle rect = preferences.getBounds(0);
            if (!mainWindow.getBounds().equals(rect)) {
                preferences.setBounds(0, mainWindow.getBounds());
                preferences.setModified(true);
            }
            if (preferences.isModified()) {
                preferences.save();
            }
            System.exit(0);
        }
    }

    public void tile() {
        WndLocation.tile();
    }

    public void cascade() {
        WndLocation.cascade();
    }

    public static void changeZOrder(TermoPLWindow wnd) {
        zorder.remove(wnd);
        zorder.addFirst(wnd);
    }

    public static LinkedList<TermoPLWindow> zorder(TermoPLDocument doc) {
        LinkedList<TermoPLWindow> zo = new LinkedList<TermoPLWindow>();
        for (TermoPLWindow wnd : zorder) {
            if (wnd.getDocument() != doc) continue;
            zo.add(wnd);
        }
        return zo;
    }

    public static File[] collectFiles(File[] selected) {
        if (selected == null) {
            return null;
        }
        LinkedList<File> files = new LinkedList<File>();
        File[] fileArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                File[] list = TermoPL.collectFiles(f.listFiles());
                if (list != null) {
                    File[] fileArray2 = list;
                    int n3 = list.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File e = fileArray2[n4];
                        files.add(e);
                        ++n4;
                    }
                }
            } else {
                files.add(f);
            }
            ++n2;
        }
        if (files.isEmpty()) {
            return null;
        }
        return files.toArray(new File[0]);
    }

    public static File[] collectFiles(String[] selected) {
        if (selected == null) {
            return null;
        }
        LinkedList<File> files = new LinkedList<File>();
        String[] stringArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File f = new File(path);
            if (f.exists()) {
                if (f.isDirectory()) {
                    File[] list = TermoPL.collectFiles(f.listFiles());
                    if (list != null) {
                        File[] fileArray = list;
                        int n3 = list.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File e = fileArray[n4];
                            files.add(e);
                            ++n4;
                        }
                    }
                } else {
                    files.add(f);
                }
            } else {
                System.out.println("File does not exist -- " + path);
            }
            ++n2;
        }
        if (files.isEmpty()) {
            return null;
        }
        return files.toArray(new File[0]);
    }

    public static String selectContrastiveCorpus() {
        return TermoPL.selectContrastiveCorpus(dialogOwner);
    }

    public static String selectContrastiveCorpus(Component owner) {
        File file;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select Contrastive Corpus");
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(TRM_FILTER);
        chooser.setMultiSelectionEnabled(false);
        if (TermoPL.preferences.filePath != null && (file = new File(TermoPL.preferences.filePath)).exists()) {
            chooser.setCurrentDirectory(file);
        }
        if (chooser.showOpenDialog(owner) == 0) {
            file = chooser.getSelectedFile();
            TermoPL.preferences.filePath = file.getParentFile().getPath();
            preferences.setModified(true);
            return file.getPath();
        }
        return null;
    }

    public static TermoPL getApplication() {
        return application;
    }

    public static String getFileName(String path) {
        return TermoPL.getFileName(new File(path));
    }

    public static String getFileName(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return name;
        }
        if (index == 0) {
            return name.substring(1);
        }
        return name.substring(0, index);
    }

    public static String getDisplayName(String docName) {
        boolean found = false;
        for (TermoPLDocument doc : documents) {
            if (!doc.getDocumentName().equals(docName)) continue;
            found = true;
            break;
        }
        if (found) {
            return String.valueOf(docName) + " - [" + ++nameCounter + "]";
        }
        return docName;
    }

    public String getApplicationDir() {
        File file = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        return file.getParent();
    }

    public static void main(String[] args) {
        batchMode = args.length > 0;
        TermoPL te = new TermoPL();
        BatchParameters bp = null;
        if (batchMode) {
            bp = new BatchParameters(args);
            if (!bp.ok) {
                System.out.println(bp.error);
                System.exit(1);
            }
        }
        if (batchMode && bp.ok) {
            te.startBatchProcessing(bp);
        }
    }
}

