/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.io.Serializable;
import termopl.Tagset;

public class Token
implements Serializable {
    public static final Token nullToken = new Token();
    public String form;
    public String lemma;
    public String ctag;
    public String[] tag;
    public char ner;
    public boolean spaceAfter;

    public Token() {
        this.form = null;
        this.lemma = null;
        this.ctag = null;
        this.tag = null;
        this.ner = (char)79;
        this.spaceAfter = true;
    }

    public Token(String form, String lemma, String ctag) {
        this.form = form.trim();
        this.lemma = lemma.trim();
        this.ctag = ctag;
        this.tag = null;
        this.ner = (char)79;
        this.spaceAfter = true;
    }

    public Token(String form, String lemma, String ctag, boolean spaceAfter) {
        this.form = form.trim();
        this.lemma = lemma.trim();
        this.ctag = ctag;
        this.tag = null;
        this.ner = (char)79;
        this.spaceAfter = spaceAfter;
    }

    public String getPOS(Tagset tagset) {
        if (this.ctag == null) {
            return null;
        }
        if (this.tag == null) {
            this.tag = this.ctag.split(tagset.getDelimiter());
        }
        return this.tag[0];
    }

    public String[] getTag(Tagset tagset) {
        if (this.ctag == null) {
            return null;
        }
        if (this.tag == null) {
            this.tag = this.ctag.split(tagset.getDelimiter());
        }
        return this.tag;
    }

    public boolean stop() {
        return this.form == null && this.lemma == null && this.ctag == null;
    }

    public boolean skip() {
        return this.ctag == null;
    }

    public void markAsSkipToken() {
        this.ctag = null;
        this.tag = null;
    }

    public String toString() {
        return String.valueOf(this.form) + " " + this.lemma + " " + this.ctag;
    }
}

