/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import termopl.LexicalRelation;
import termopl.LexicalUnit;
import termopl.Synset;
import termopl.SynsetRelation;
import termopl.TermoPLDocument;
import termopl.WordReplacement;

public class WordNet {
    public static final String SP_GENERAL_ENTITY_SIZE_LIMIT = "jdk.xml.maxGeneralEntitySizeLimit";
    public static final String SP_TOTAL_ENTITY_SIZE_LIMIT = "jdk.xml.totalEntitySizeLimit";
    public static HashMap<String, WordNet> wordNets = new HashMap();
    public static final String NOUN = "rzeczownik";
    public static final String ADJECTIVE = "przymiotnik";
    public static final String VERB = "czasownik";
    public static final String ADVERB = "przys\u0142\u00f3wek";
    public static final int MAXDEPTH = 1;
    public static final int EXACT = 0;
    public static final int SYNONYMY = 1;
    public static final int HIPERONYMY = 11;
    private File input;
    private HashMap<String, LinkedList<LexicalUnit>> words;
    private HashMap<Integer, LexicalUnit> wordIndex;
    private HashMap<Integer, Synset> synsetIndex;
    private HashMap<Integer, LinkedList<LexicalRelation>> lexicalRelationIndex;
    private HashMap<Integer, LinkedList<SynsetRelation>> synsetRelationIndex;
    private LinkedList<Synset> synsets;
    private LinkedList<LexicalRelation> lexicalRelations;
    private LinkedList<SynsetRelation> synsetRelations;
    private RelationTypes lexRelationTypes;
    private RelationTypes synsetRelationTypes;
    private Synset currentSynset;
    private ArrayList<Integer> unitIDs;
    private boolean unitIDStarted;
    private boolean ignorePWN;

    public WordNet(File input, boolean ignorePWN) {
        this.input = input;
        this.ignorePWN = ignorePWN;
        this.currentSynset = null;
        this.unitIDs = null;
        this.unitIDStarted = false;
        this.lexRelationTypes = new RelationTypes();
        this.lexRelationTypes.setRelationTypes(51, 52, 61, 62, 63, 141, 142, 148, 149, 169, 242, 244);
        this.synsetRelationTypes = new RelationTypes();
        this.synsetRelationTypes.setRelationTypes(10, 11, 108);
    }

    public WordNet(File input) {
        this(input, true);
    }

    public static WordNet getWordNet(String wordNetPath) {
        return wordNets.get(wordNetPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WordNet createWordNet(TermoPLDocument doc, String wordNetPath) {
        String string = wordNetPath;
        synchronized (string) {
            WordNet wdn;
            block5: {
                wdn = WordNet.getWordNet(wordNetPath);
                if (wdn != null) break block5;
                File f = new File(wordNetPath);
                if (f.exists()) {
                    wdn = new WordNet(f);
                    wdn.load(doc);
                    wordNets.put(wordNetPath, wdn);
                    return wdn;
                }
                return null;
            }
            return wdn;
        }
    }

    public LinkedList<WordReplacement> getRelatedWords(String w, String pos) {
        LinkedList<LexicalUnit> lexUnits = this.words.get(w);
        if (lexUnits != null) {
            LinkedList<WordReplacement> relatedWords = new LinkedList<WordReplacement>();
            for (LexicalUnit lu : lexUnits) {
                if (!lu.pos.equals(pos)) continue;
                for (Synset s : this.synsets) {
                    boolean found = false;
                    int[] nArray = s.lexUnits;
                    int n = s.lexUnits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int id = nArray[n2];
                        if (id == lu.id) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) continue;
                    this.getLexUnitsFromSynset(s, w, relatedWords);
                    this.getLexicalyRelated(lu, w, relatedWords);
                    this.getSynsetRelated(s, w, 0, relatedWords);
                }
            }
            return relatedWords;
        }
        return null;
    }

    public void getLexUnitsFromSynset(Synset synset, String w, LinkedList<WordReplacement> relatedWords) {
        int[] nArray = synset.lexUnits;
        int n = synset.lexUnits.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            String name = this.wordIndex.get((Object)Integer.valueOf((int)id)).name;
            if (!name.equals(w)) {
                WordReplacement.addReplacement(w, name, 1, relatedWords);
            }
            ++n2;
        }
    }

    public void getLexicalyRelated(LexicalUnit lexUnit, String w, LinkedList<WordReplacement> relatedWords) {
        LinkedList<LexicalRelation> lexRelations = this.lexicalRelationIndex.get(lexUnit.id);
        if (lexRelations != null) {
            for (LexicalRelation r : lexRelations) {
                LexicalUnit lu = lexUnit.id == r.child ? this.wordIndex.get(r.parent) : this.wordIndex.get(r.child);
                String name = lu.name;
                if (name.equals(w)) continue;
                WordReplacement.addReplacement(w, name, r.relation, relatedWords);
            }
        }
    }

    public void getSynsetRelated(Synset synset, String w, int depth, LinkedList<WordReplacement> relatedWords) {
        LinkedList<SynsetRelation> synsetRelations = this.synsetRelationIndex.get(synset.id);
        if (synsetRelations != null) {
            for (SynsetRelation r : synsetRelations) {
                Synset s = this.synsetIndex.get(r.parent);
                int[] nArray = s.lexUnits;
                int n = s.lexUnits.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    LexicalUnit lu = this.wordIndex.get(id);
                    String name = lu.name;
                    if (!name.equals(w)) {
                        WordReplacement.addReplacement(w, name, r.relation, relatedWords);
                    }
                    ++n2;
                }
            }
        }
    }

    public void load(TermoPLDocument doc) {
        System.setProperty(SP_GENERAL_ENTITY_SIZE_LIMIT, "0");
        System.setProperty(SP_TOTAL_ENTITY_SIZE_LIMIT, "0");
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        this.words = new HashMap();
        this.wordIndex = new HashMap();
        this.synsetIndex = new HashMap();
        this.synsets = new LinkedList();
        this.lexicalRelations = new LinkedList();
        this.synsetRelations = new LinkedList();
        try {
            XMLEventReader reader = inputFactory.createXMLEventReader(new FileInputStream(this.input));
            while (reader.hasNext() && !doc.isCancelled()) {
                XMLEvent event = reader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        StartElement startElement = (StartElement)event;
                        String elementName = startElement.getName().getLocalPart();
                        if (elementName.equals("lexical-unit")) {
                            this.parseLexicalUnit(startElement);
                            break;
                        }
                        if (elementName.equals("synset")) {
                            this.parseSynset(startElement);
                            break;
                        }
                        if (elementName.equals("unit-id")) {
                            this.parseUnitID(startElement);
                            break;
                        }
                        if (elementName.equals("lexicalrelations")) {
                            this.parseLexicalRelations(startElement);
                            break;
                        }
                        if (!elementName.equals("synsetrelations")) break;
                        this.parseSynsetRelations(startElement);
                        break;
                    }
                    case 2: {
                        EndElement endElement = (EndElement)event;
                        String elementName = endElement.getName().getLocalPart();
                        if (elementName.equals("synset")) {
                            int[] lexUnits;
                            if (this.currentSynset != null && (lexUnits = new int[this.unitIDs.size()]).length > 0) {
                                int i = 0;
                                while (i < lexUnits.length) {
                                    lexUnits[i] = this.unitIDs.get(i);
                                    ++i;
                                }
                                this.currentSynset.lexUnits = lexUnits;
                                this.synsets.add(this.currentSynset);
                                this.synsetIndex.put(this.currentSynset.id, this.currentSynset);
                            }
                            this.unitIDs = null;
                            this.currentSynset = null;
                            break;
                        }
                        if (!elementName.equals("unit-id")) break;
                        this.unitIDStarted = false;
                        break;
                    }
                    case 4: {
                        Characters characters = (Characters)event;
                        if (!this.unitIDStarted) break;
                        this.readCharacters(characters);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.clearProperty(SP_GENERAL_ENTITY_SIZE_LIMIT);
        System.clearProperty(SP_TOTAL_ENTITY_SIZE_LIMIT);
    }

    public void parseLexicalUnit(StartElement element) {
        LexicalUnit unit = new LexicalUnit();
        Iterator<Attribute> it = element.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            String name = attr.getName().getLocalPart();
            if (name.equals("id")) {
                unit.id = Integer.parseInt(attr.getValue());
                continue;
            }
            if (name.equals("name")) {
                unit.name = attr.getValue();
                continue;
            }
            if (!name.equals("pos")) continue;
            unit.pos = attr.getValue();
        }
        if (!this.ignorePWN || !unit.pos.endsWith("pwn")) {
            LinkedList<LexicalUnit> lexUnits = this.words.get(unit.name);
            if (lexUnits == null) {
                lexUnits = new LinkedList();
                this.words.put(unit.name, lexUnits);
            }
            lexUnits.add(unit);
            this.wordIndex.put(unit.id, unit);
        }
    }

    public void parseSynset(StartElement element) {
        Synset synset = new Synset();
        Iterator<Attribute> it = element.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            String name = attr.getName().getLocalPart();
            if (!name.equals("id")) continue;
            synset.id = Integer.parseInt(attr.getValue());
        }
        this.currentSynset = synset;
        this.unitIDs = new ArrayList();
    }

    public void parseUnitID(StartElement element) {
        this.unitIDStarted = true;
    }

    public void parseLexicalRelations(StartElement element) {
        LexicalRelation relation = new LexicalRelation();
        boolean addToIndex = false;
        Iterator<Attribute> it = element.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            String name = attr.getName().getLocalPart();
            if (name.equals("parent")) {
                relation.parent = Integer.parseInt(attr.getValue());
                continue;
            }
            if (name.equals("child")) {
                relation.child = Integer.parseInt(attr.getValue());
                continue;
            }
            if (!name.equals("relation")) continue;
            relation.relation = Integer.parseInt(attr.getValue());
        }
        if (this.ignorePWN) {
            if (this.wordIndex.get(relation.parent) != null && this.wordIndex.get(relation.child) != null && this.lexRelationTypes.contains(relation.relation)) {
                this.lexicalRelations.add(relation);
                addToIndex = true;
            }
        } else if (this.lexRelationTypes.contains(relation.relation)) {
            this.lexicalRelations.add(relation);
            addToIndex = true;
        }
        if (addToIndex) {
            LinkedList<LexicalRelation> lexRelations;
            if (this.lexicalRelationIndex == null) {
                this.lexicalRelationIndex = new HashMap();
            }
            if ((lexRelations = this.lexicalRelationIndex.get(relation.child)) == null) {
                lexRelations = new LinkedList();
                this.lexicalRelationIndex.put(relation.child, lexRelations);
            }
            lexRelations.add(relation);
            lexRelations = this.lexicalRelationIndex.get(relation.parent);
            if (lexRelations == null) {
                lexRelations = new LinkedList();
                this.lexicalRelationIndex.put(relation.parent, lexRelations);
            }
            lexRelations.add(relation);
        }
    }

    public void parseSynsetRelations(StartElement element) {
        SynsetRelation relation = new SynsetRelation();
        boolean addToIndex = false;
        Iterator<Attribute> it = element.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            String name = attr.getName().getLocalPart();
            if (name.equals("parent")) {
                relation.parent = Integer.parseInt(attr.getValue());
                continue;
            }
            if (name.equals("child")) {
                relation.child = Integer.parseInt(attr.getValue());
                continue;
            }
            if (!name.equals("relation")) continue;
            relation.relation = Integer.parseInt(attr.getValue());
        }
        if (this.ignorePWN) {
            if (this.synsetIndex.get(relation.parent) != null && this.synsetIndex.get(relation.child) != null && this.synsetRelationTypes.contains(relation.relation)) {
                this.synsetRelations.add(relation);
                addToIndex = true;
            }
        } else if (this.synsetRelationTypes.contains(relation.relation)) {
            this.synsetRelations.add(relation);
            addToIndex = true;
        }
        if (addToIndex) {
            LinkedList<SynsetRelation> synsetRelations;
            if (this.synsetRelationIndex == null) {
                this.synsetRelationIndex = new HashMap();
            }
            if ((synsetRelations = this.synsetRelationIndex.get(relation.child)) == null) {
                synsetRelations = new LinkedList();
                this.synsetRelationIndex.put(relation.child, synsetRelations);
            }
            synsetRelations.add(relation);
        }
    }

    public void readCharacters(Characters characters) {
        String data;
        if (!characters.isIgnorableWhiteSpace() && !characters.isWhiteSpace() && (data = characters.getData()).length() != 0) {
            Integer id = Integer.parseInt(data);
            if (this.ignorePWN) {
                if (this.wordIndex.get(id) != null) {
                    this.unitIDs.add(id);
                }
            } else {
                this.unitIDs.add(id);
            }
        }
    }

    public static boolean isSynonymic(int relType) {
        if (relType < 0) {
            relType = -relType;
        }
        return relType == 1 || relType == 169;
    }

    public static String getName(int relType) {
        switch (relType) {
            case 1: {
                return "synonymy";
            }
            case 10: {
                return "hyponymy";
            }
            case 11: {
                return "hyperonymy";
            }
            case 51: {
                return "characterized by feature|state";
            }
            case 52: {
                return "feature|state";
            }
            case 108: {
                return "fuzzynymy";
            }
            case 148: {
                return "similarity";
            }
            case 149: {
                return "description";
            }
            case 242: {
                return "role: material";
            }
            case 61: 
            case 62: 
            case 63: 
            case 141: 
            case 142: 
            case 169: 
            case 244: {
                return "inter-paradigmatic synonymy";
            }
        }
        return "?";
    }

    private class RelationTypes {
        private HashSet<Integer> relationTypes = null;

        public boolean contains(int rel) {
            if (this.relationTypes == null) {
                return true;
            }
            return this.relationTypes.contains(rel);
        }

        public void setRelationTypes(int ... types) {
            this.relationTypes = null;
            this.addRelationTypes(types);
        }

        public void addRelationTypes(int ... types) {
            if (this.relationTypes == null) {
                this.relationTypes = new HashSet();
            }
            int i = 0;
            while (i < types.length) {
                this.relationTypes.add(types[i]);
                ++i;
            }
        }
    }
}

