/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.io.Serializable;
import java.util.LinkedList;

public class WordReplacement
implements Serializable {
    public String word;
    public String expression;
    public LinkedList<Integer> relTypes;

    public WordReplacement(String word, String expression) {
        this.word = word;
        this.expression = expression;
        this.relTypes = null;
    }

    public WordReplacement(String word, String expression, int relType) {
        this.word = word;
        this.expression = expression;
        this.relTypes = null;
        this.add(relType);
    }

    public WordReplacement(String word, String expression, LinkedList<Integer> types) {
        this.word = word;
        this.expression = expression;
        this.relTypes = types;
    }

    public void add(int relType) {
        if (relType != 0) {
            if (this.relTypes == null) {
                this.relTypes = new LinkedList();
                this.relTypes.add(relType);
            } else if (!this.relTypes.contains(relType)) {
                this.relTypes.add(relType);
            }
        }
    }

    public void addAll(LinkedList<Integer> types) {
        for (Integer relType : types) {
            this.add(relType);
        }
    }

    public int length() {
        if (this.expression.contains(" ")) {
            return this.expression.split(" ").length;
        }
        return 1;
    }

    public static void addReplacement(String word, String expr, int relType, LinkedList<WordReplacement> relatedWords) {
        if (relType != 0) {
            for (WordReplacement wr : relatedWords) {
                if (!word.equals(wr.word) || !expr.equals(wr.expression)) continue;
                wr.add(relType);
                return;
            }
        }
        relatedWords.add(new WordReplacement(word, expr, relType));
    }

    public static void addReplacement(String word, String expr, LinkedList<Integer> types, LinkedList<WordReplacement> relatedWords) {
        for (WordReplacement wr : relatedWords) {
            if (!word.equals(wr.word) || !expr.equals(wr.expression)) continue;
            wr.addAll(types);
            return;
        }
        relatedWords.add(new WordReplacement(word, expr, types));
    }

    public static LinkedList<String> words(LinkedList<WordReplacement> relatedWords) {
        LinkedList<String> words = new LinkedList<String>();
        if (relatedWords != null) {
            for (WordReplacement wr : relatedWords) {
                if (wr.expression.contains(" ")) {
                    String[] str;
                    String[] stringArray = str = wr.expression.split(" ");
                    int n = str.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        words.add(s);
                        ++n2;
                    }
                    continue;
                }
                words.add(wr.expression);
            }
        }
        return words;
    }
}

