/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import termopl.LanguageInfo;

public class LangCombo
extends JComboBox<LanguageInfo> {
    private Font plain = this.getFont();
    private Font italic = this.plain.deriveFont(2);
    private Color comboNormal = UIManager.getColor("ComboBox.foreground");
    private Color comboGrayedOut = UIManager.getColor("ComboBox.disabledForeground");

    public LangCombo() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (LangCombo.this.getSelectedIndex() == 0) {
                    LangCombo.this.setFont(LangCombo.this.italic);
                    LangCombo.this.setForeground(LangCombo.this.comboGrayedOut);
                } else {
                    LangCombo.this.setFont(LangCombo.this.plain);
                    LangCombo.this.setForeground(LangCombo.this.comboNormal);
                }
            }
        });
    }

    @Override
    public void addItem(LanguageInfo languageInfo) {
        super.addItem(languageInfo);
        this.setRenderer(new LangRenderer());
    }

    private class LangRenderer
    extends JLabel
    implements ListCellRenderer<LanguageInfo> {
        private Border cellBorder = BorderFactory.createEmptyBorder(2, 8, 2, 0);
        private JLabel selectLabel = new JLabel("Select...");

        @Override
        public Component getListCellRendererComponent(JList<? extends LanguageInfo> list, LanguageInfo value, int index, boolean isSelected, boolean cellHasFocus) {
            Color color;
            JLabel label = this;
            if (value.getName() == null && value.getLanguageCode() == null) {
                label = this.selectLabel;
                label.setFont(LangCombo.this.italic);
                color = LangCombo.this.comboGrayedOut;
            } else {
                label.setText(value.getName());
                label.setFont(LangCombo.this.plain);
                color = LangCombo.this.comboNormal;
            }
            label.setBorder(this.cellBorder);
            label.setIconTextGap(8);
            label.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            label.setForeground(isSelected ? list.getSelectionForeground() : color);
            label.setOpaque(true);
            return label;
        }
    }
}

