/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import termopl.Parser;
import termopl.ParserException;
import termopl.Tagset;

public class TParser
extends Parser {
    private File tagsetFile;
    private Tagset tagset;

    public TParser(File file, Object owner) {
        super(owner);
        this.tagsetFile = file;
    }

    @Override
    public void parse() {
        this.tagset = new Tagset();
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.tagsetFile), "UTF8"));
            this.getSymbol();
            if (this.symbol == Parser.Symbol.IDENTIFIER) {
                this.identifier = this.identifier.toLowerCase();
                if (this.identifier.equals("tag")) {
                    this.getSymbol();
                    if (this.symbol == Parser.Symbol.EQ) {
                        this.getSymbol();
                        if (this.symbol == Parser.Symbol.IDENTIFIER) {
                            if (this.identifier.toLowerCase().equals("pos")) {
                                this.tagset.setType(2);
                            } else {
                                this.error(24);
                                this.skip(Parser.Symbol.LANGLE);
                            }
                        }
                    } else {
                        this.error(18);
                        this.skip(Parser.Symbol.LANGLE);
                    }
                } else if (this.identifier.equals("delimiter")) {
                    this.getSymbol();
                    if (this.symbol == Parser.Symbol.EQ) {
                        this.getSymbol();
                        if (this.symbol == Parser.Symbol.STRING) {
                            if (this.string.isEmpty()) {
                                this.tagset.setDelimiter("(?!^)");
                            } else {
                                this.tagset.setDelimiter(this.string);
                            }
                        } else {
                            this.error(8);
                            this.skip(Parser.Symbol.LANGLE);
                        }
                    } else {
                        this.error(18);
                        this.skip(Parser.Symbol.LANGLE);
                    }
                } else {
                    this.error(19);
                    this.skip(Parser.Symbol.LANGLE);
                }
                this.getSymbol();
            }
            if (this.tagset.getType() != 2) {
                if (this.symbol == Parser.Symbol.LANGLE) {
                    this.getSymbol();
                    if (this.symbol == Parser.Symbol.IDENTIFIER) {
                        if (!this.identifier.equals("categories")) {
                            this.error(20);
                            this.skip(Parser.Symbol.LANGLE);
                        } else {
                            this.getSymbol();
                            if (this.symbol == Parser.Symbol.IDENTIFIER) {
                                if (!this.identifier.equals("by")) {
                                    this.error(21);
                                    this.skip(Parser.Symbol.LANGLE);
                                } else {
                                    this.getSymbol();
                                    if (this.symbol == Parser.Symbol.IDENTIFIER) {
                                        if (this.identifier.equals("positions")) {
                                            this.getSymbol();
                                            if (this.symbol == Parser.Symbol.RANGLE) {
                                                this.parseCategoriesByPositions();
                                            } else {
                                                this.error(17);
                                                this.skip(Parser.Symbol.LANGLE);
                                            }
                                        } else if (this.identifier.equals("values")) {
                                            this.getSymbol();
                                            if (this.symbol == Parser.Symbol.RANGLE) {
                                                this.parseCategoriesByValues();
                                            } else {
                                                this.error(17);
                                                this.skip(Parser.Symbol.LANGLE);
                                            }
                                        } else {
                                            this.error(22);
                                            this.skip(Parser.Symbol.LANGLE);
                                        }
                                    } else {
                                        this.error(22);
                                        this.skip(Parser.Symbol.LANGLE);
                                    }
                                }
                            } else {
                                this.error(21);
                                this.skip(Parser.Symbol.LANGLE);
                            }
                        }
                    } else {
                        this.error(20);
                        this.skip(Parser.Symbol.LANGLE);
                    }
                } else {
                    this.error(16);
                    this.skip(Parser.Symbol.LANGLE);
                }
                if (this.symbol == Parser.Symbol.LANGLE) {
                    this.getSymbol();
                    if (this.symbol == Parser.Symbol.IDENTIFIER) {
                        if (!this.identifier.equals("definitions")) {
                            this.error(23);
                            this.skip(Parser.Symbol.EMPTY);
                        } else {
                            this.getSymbol();
                            if (this.symbol == Parser.Symbol.RANGLE) {
                                this.parseDefinitions();
                            } else {
                                this.error(17);
                                this.skip(Parser.Symbol.EMPTY);
                            }
                        }
                    } else {
                        this.error(23);
                        this.skip(Parser.Symbol.EMPTY);
                    }
                }
                this.getSymbol();
                if (this.symbol != Parser.Symbol.EMPTY) {
                    this.error(29);
                }
            } else if (this.symbol != Parser.Symbol.EMPTY) {
                this.error(29);
            }
        }
        catch (Exception exception) {
            try {
                this.error(exception.getStackTrace().toString());
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
        if (!this.noErrors()) {
            this.tagset = null;
        }
        this.reportErrors();
    }

    public void parseCategoriesByPositions() throws ParserException {
        LinkedList<String> list = new LinkedList<String>();
        LinkedList<String> clsList = new LinkedList<String>();
        String cls = null;
        Parser.Symbol prev = Parser.Symbol.EMPTY;
        this.tagset.setType(0);
        this.getSymbol();
        while (!this.tooManyErrors() && this.symbol != Parser.Symbol.LANGLE && this.symbol != Parser.Symbol.EMPTY) {
            if (this.symbol == Parser.Symbol.IDENTIFIER) {
                if (prev == Parser.Symbol.IDENTIFIER) {
                    if (list.isEmpty()) {
                        this.error(5);
                    } else {
                        if (cls == null) {
                            this.tagset.setDefaultCategories(list);
                        } else {
                            this.tagset.addCategoriesToClass(cls, list);
                        }
                        cls = null;
                        list = new LinkedList();
                        list.add(this.identifier);
                    }
                } else {
                    list.add(this.identifier);
                }
            } else if (this.symbol == Parser.Symbol.COMMA) {
                if (prev != Parser.Symbol.IDENTIFIER) {
                    this.error(14);
                    this.skip(Parser.Symbol.IDENTIFIER, Parser.Symbol.LANGLE);
                }
            } else if (this.symbol == Parser.Symbol.COLON) {
                if (prev != Parser.Symbol.IDENTIFIER) {
                    this.error(14);
                    this.skip(Parser.Symbol.IDENTIFIER, Parser.Symbol.LANGLE);
                } else {
                    cls = list.removeLast();
                    if (clsList.contains(cls)) {
                        this.error(12);
                    }
                    clsList.add(cls);
                }
            } else {
                this.error(14);
                this.skip(Parser.Symbol.IDENTIFIER, Parser.Symbol.LANGLE);
            }
            prev = this.symbol;
            this.getSymbol();
        }
        if (!list.isEmpty()) {
            if (cls == null) {
                this.tagset.setDefaultCategories(list);
            } else {
                this.tagset.addCategoriesToClass(cls, list);
            }
        }
        if (this.tagset.getCategories().isEmpty()) {
            this.error(25);
        }
    }

    public void parseCategoriesByValues() throws ParserException {
        LinkedList<String> list = new LinkedList<String>();
        String cat = null;
        Parser.Symbol prev = Parser.Symbol.EMPTY;
        boolean mustBeColon = false;
        this.tagset.setType(1);
        this.getSymbol();
        while (!this.tooManyErrors() && this.symbol != Parser.Symbol.LANGLE && this.symbol != Parser.Symbol.EMPTY) {
            if (mustBeColon) {
                mustBeColon = false;
                if (this.symbol != Parser.Symbol.COLON) {
                    this.error(15);
                }
            } else if (this.symbol == Parser.Symbol.IDENTIFIER) {
                if (cat == null) {
                    cat = this.identifier;
                    mustBeColon = true;
                } else if (prev == Parser.Symbol.IDENTIFIER) {
                    if (this.tagset.isCategoryDefined(this.identifier)) {
                        this.error(26);
                    }
                    this.tagset.addCategory(cat, list);
                    list = new LinkedList();
                    cat = this.identifier;
                    mustBeColon = true;
                } else {
                    list.add(this.identifier);
                }
            } else if (this.symbol == Parser.Symbol.COMMA) {
                if (prev != Parser.Symbol.IDENTIFIER) {
                    this.error(14);
                    this.skip(Parser.Symbol.IDENTIFIER, Parser.Symbol.LANGLE);
                }
            } else if (this.symbol == Parser.Symbol.COLON) {
                if (prev != Parser.Symbol.IDENTIFIER) {
                    this.error(14);
                    this.skip(Parser.Symbol.IDENTIFIER, Parser.Symbol.LANGLE);
                }
            } else {
                this.error(14);
                this.skip(Parser.Symbol.IDENTIFIER, Parser.Symbol.LANGLE);
            }
            prev = this.symbol;
            this.getSymbol();
        }
        if (!list.isEmpty()) {
            this.tagset.addCategory(cat, list);
        }
        if (this.tagset.getCategories().isEmpty()) {
            this.error(25);
        }
    }

    public void parseDefinitions() throws ParserException {
        String list = "";
        String sym = null;
        Parser.Symbol prev = Parser.Symbol.EMPTY;
        boolean mustBeEQ = false;
        this.getSymbol();
        while (!this.tooManyErrors() && this.symbol != Parser.Symbol.LANGLE && this.symbol != Parser.Symbol.EMPTY) {
            if (mustBeEQ) {
                mustBeEQ = false;
                if (this.symbol != Parser.Symbol.EQ) {
                    this.error(18);
                }
            } else if (this.symbol == Parser.Symbol.IDENTIFIER) {
                if (sym == null) {
                    sym = this.identifier;
                    mustBeEQ = true;
                } else if (prev == Parser.Symbol.IDENTIFIER) {
                    this.tagset.addDefinition(sym, list);
                    list = "";
                    sym = this.identifier;
                    mustBeEQ = true;
                } else {
                    list = list.isEmpty() ? this.identifier : String.valueOf(list) + "," + this.identifier;
                }
            } else if (this.symbol == Parser.Symbol.COMMA) {
                if (prev != Parser.Symbol.IDENTIFIER) {
                    this.error(14);
                    this.skip(Parser.Symbol.IDENTIFIER, Parser.Symbol.LANGLE);
                }
            } else if (this.symbol == Parser.Symbol.EQ) {
                if (prev != Parser.Symbol.IDENTIFIER) {
                    this.error(14);
                    this.skip(Parser.Symbol.IDENTIFIER, Parser.Symbol.LANGLE);
                }
            } else {
                this.error(14);
                this.skip(Parser.Symbol.IDENTIFIER, Parser.Symbol.LANGLE);
            }
            prev = this.symbol;
            this.getSymbol();
        }
        if (!list.isEmpty()) {
            this.tagset.addDefinition(sym, list);
        }
    }

    @Override
    public void getSymbol() throws ParserException {
        int ch = 32;
        while (Character.isWhitespace(ch)) {
            ch = this.getNextChar();
        }
        this.scanPos = this.charCount - 1;
        if (Character.isLetter(ch)) {
            this.buffer.setLength(0);
            while (this.isIdentifierChar(ch)) {
                this.buffer.append((char)ch);
                ch = this.getNextChar();
            }
            this.identifier = this.buffer.toString();
            this.symbol = Parser.Symbol.IDENTIFIER;
            if (this.noSkipChar(ch)) {
                --this.charCount;
            }
        } else if (ch == 34) {
            this.getString();
        } else {
            this.symbol = ch == 60 ? Parser.Symbol.LANGLE : (ch == 62 ? Parser.Symbol.RANGLE : (ch == 44 ? Parser.Symbol.COMMA : (ch == 58 ? Parser.Symbol.COLON : (ch == 61 ? Parser.Symbol.EQ : (ch == -1 ? Parser.Symbol.EMPTY : Parser.Symbol.UNKNOWN)))));
        }
    }

    public boolean noSkipChar(int ch) {
        return ch == 34 || ch == 60 || ch == 62 || ch == 44 || ch == 58 || ch == 61;
    }

    public Tagset getTagset() {
        return this.tagset;
    }
}

