/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import termopl.Pair;
import termopl.Term;
import termopl.WordReplacement;

public class TermEx
extends Term {
    public String id;
    private LinkedList<String> parents;
    private LinkedList<String> children;
    private LinkedList<String> equivTerms;
    private LinkedList<Pair<String, LinkedList<WordReplacement>>> relatedTerms;

    public TermEx(String str, int len) {
        super(str, len);
        this.id = str;
        this.equivTerms = null;
        this.children = null;
        this.parents = null;
        this.relatedTerms = null;
    }

    public void addChild(TermEx child, HashMap<String, Term> termMap) {
        if (child != this) {
            if (this.equivalent(child)) {
                this.addEquivalentTerm(child, termMap);
            } else {
                if (this.children == null) {
                    this.children = new LinkedList();
                }
                if (child.parents == null) {
                    child.parents = new LinkedList();
                }
                if (!this.children.contains(child.id)) {
                    this.children.add(child.id);
                    child.parents.add(this.id);
                }
            }
        }
    }

    public boolean removeChild(TermEx child) {
        if (this.children != null && this.children.remove(child.id)) {
            child.parents.remove(this.id);
            return true;
        }
        return false;
    }

    public boolean equivalent(TermEx term) {
        String[] ph2;
        if (this.len != term.len) {
            return false;
        }
        LinkedList<String> ph1 = new LinkedList<String>(Arrays.asList(this.str.split(" ")));
        String[] stringArray = ph2 = term.str.split(" ");
        int n = ph2.length;
        int n2 = 0;
        while (n2 < n) {
            String s2 = stringArray[n2];
            if (!ph1.remove(s2)) {
                return false;
            }
            ++n2;
        }
        return ph1.isEmpty();
    }

    public void addEquivalentTerm(TermEx term, HashMap<String, Term> termMap) {
        if (term != this) {
            if (this.equivTerms == null) {
                this.equivTerms = new LinkedList();
                this.equivTerms.add(this.id);
            }
            if (term.equivTerms != null) {
                for (String e : term.equivTerms) {
                    if (this.equivTerms.contains(e)) continue;
                    TermEx t = (TermEx)termMap.get(e);
                    this.equivTerms.add(e);
                    t.equivTerms = this.equivTerms;
                }
            } else if (!this.equivTerms.contains(term.id)) {
                this.equivTerms.add(term.id);
                term.equivTerms = this.equivTerms;
            }
            for (String e : this.equivTerms) {
                if (e == this.id || this.parents == null) continue;
                for (String s : this.parents) {
                    TermEx p = (TermEx)termMap.get(s);
                    TermEx t = (TermEx)termMap.get(e);
                    p.removeChild(t);
                }
            }
            this.removeDescendant(this, termMap);
        }
    }

    public void relateWith(TermEx term, LinkedList<WordReplacement> replacements) {
        this.addRelatedTerm(term, replacements);
        LinkedList<WordReplacement> newReplacements = new LinkedList<WordReplacement>();
        for (WordReplacement wr : replacements) {
            WordReplacement newWR = new WordReplacement(wr.word, wr.expression);
            if (wr.relTypes != null) {
                for (Integer relType : wr.relTypes) {
                    newWR.add(-relType.intValue());
                }
            }
            newReplacements.add(newWR);
        }
        term.addRelatedTerm(this, newReplacements);
    }

    public void addRelatedTerm(TermEx term, LinkedList<WordReplacement> replacements) {
        if (this.relatedTerms == null) {
            this.relatedTerms = new LinkedList();
        }
        if (!TermEx.containedInRelated(term, this.relatedTerms)) {
            this.relatedTerms.add(new Pair<String, LinkedList<WordReplacement>>(term.id, replacements));
        }
    }

    public boolean isDescendant(TermEx term, HashMap<String, Term> termMap) {
        if (term == this) {
            return true;
        }
        if (this.equivTerms != null) {
            for (String t : this.equivTerms) {
                if (term.id != t) continue;
                return true;
            }
        }
        if (this.children != null) {
            for (String c : this.children) {
                TermEx t = (TermEx)termMap.get(c);
                if (!t.isDescendant(term, termMap)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void removeDescendant(TermEx term, HashMap<String, Term> termMap) {
        if (this.children != null) {
            this.removeChild(term);
            if (this.equivTerms != null) {
                for (String e : this.equivTerms) {
                    TermEx t = (TermEx)termMap.get(e);
                    if (t.children == null) continue;
                    t.children.remove(term.id);
                }
            }
        }
    }

    public LinkedList<String> collectParents(HashMap<String, Term> termMap) {
        if (this.equivTerms == null) {
            return this.parents;
        }
        LinkedList<String> allParents = new LinkedList<String>();
        for (String e : this.equivTerms) {
            TermEx t = (TermEx)termMap.get(e);
            LinkedList<String> plist = t.getParents();
            if (plist == null) continue;
            for (String p : plist) {
                if (allParents.contains(p)) continue;
                allParents.add(p);
            }
        }
        return allParents;
    }

    public LinkedList<String> collectChildren(HashMap<String, Term> termMap) {
        LinkedList<String> allChildren = new LinkedList();
        if (this.equivTerms == null) {
            allChildren = this.children;
        } else {
            allChildren = new LinkedList();
            for (String e : this.equivTerms) {
                TermEx t = (TermEx)termMap.get(e);
                LinkedList<String> clist = t.getChildren();
                if (clist == null) continue;
                for (String c : clist) {
                    TermEx tc = (TermEx)termMap.get(c);
                    if (tc.equivTerms != null) {
                        boolean found = false;
                        for (String ec : tc.equivTerms) {
                            if (!allChildren.contains(ec)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        allChildren.add(c);
                        continue;
                    }
                    if (allChildren.contains(c)) continue;
                    allChildren.add(c);
                }
            }
        }
        return allChildren;
    }

    public LinkedList<Pair<String, LinkedList<WordReplacement>>> collectRelated(HashMap<String, Term> termMap) {
        if (this.equivTerms == null) {
            return this.relatedTerms;
        }
        LinkedList<Pair<String, LinkedList<WordReplacement>>> allRelated = new LinkedList<Pair<String, LinkedList<WordReplacement>>>();
        for (String e : this.equivTerms) {
            TermEx t = (TermEx)termMap.get(e);
            LinkedList<Pair<String, LinkedList<WordReplacement>>> rlist = t.getRelatedTerms();
            if (rlist == null) continue;
            for (Pair pair : rlist) {
                if (this.contains(allRelated, pair)) continue;
                allRelated.add(pair);
            }
        }
        return allRelated;
    }

    public boolean contains(LinkedList<Pair<String, LinkedList<WordReplacement>>> list, Pair<String, LinkedList<WordReplacement>> e) {
        for (Pair pair : list) {
            if (pair.first != e.first) continue;
            return true;
        }
        return false;
    }

    public LinkedList<String> getParents() {
        return this.parents;
    }

    public LinkedList<String> getChildren() {
        return this.children;
    }

    public LinkedList<String> getEquivalentTerms() {
        return this.equivTerms;
    }

    public LinkedList<Pair<String, LinkedList<WordReplacement>>> getRelatedTerms() {
        return this.relatedTerms;
    }

    public void clean() {
        this.equivTerms = null;
        this.children = null;
        this.parents = null;
        this.relatedTerms = null;
    }

    public static boolean containedInRelated(TermEx term, LinkedList<Pair<String, LinkedList<WordReplacement>>> relatedTerms) {
        if (relatedTerms == null) {
            return false;
        }
        for (Pair pair : relatedTerms) {
            if (pair.first != term.id) continue;
            return true;
        }
        return false;
    }
}

