/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import pl.sgjp.morfeusz.Morfeusz;
import pl.sgjp.morfeusz.MorphInterpretation;
import termopl.BaseFormGuesser;
import termopl.BatchParameters;
import termopl.Command;
import termopl.Commander;
import termopl.CommonTerm;
import termopl.CorpusReader;
import termopl.DocFreq;
import termopl.ExtractorEngine;
import termopl.FileDescr;
import termopl.Form;
import termopl.FormsView;
import termopl.GParser;
import termopl.GroupsView;
import termopl.MatchedToken;
import termopl.MenuFactory;
import termopl.Morph;
import termopl.MultiWordToken;
import termopl.Options;
import termopl.PParser;
import termopl.Pair;
import termopl.Preferences;
import termopl.SaveFileChooser;
import termopl.SelectedFiles;
import termopl.SentenceRef;
import termopl.SentenceRefEx;
import termopl.SentencesView;
import termopl.TParser;
import termopl.Tagset;
import termopl.Template;
import termopl.Term;
import termopl.TermEx;
import termopl.TermReplacement;
import termopl.TermoPL;
import termopl.TermoPLDefaultWindow;
import termopl.TermoPLMacWindow;
import termopl.TermoPLWindow;
import termopl.TermsView;
import termopl.Token;
import termopl.UDToken;
import termopl.WindowUtils;
import termopl.WordNet;
import termopl.WordReplacement;
import termopl.Workspace;

public class TermoPLDocument
extends Commander {
    public static final String[] EXTRACT_OPTIONS = new String[]{"All Selected", "Recently selected", "None"};
    public static final int MAX_TERM_QUEUE_SIZE = 512;
    public static final int MAX_THREADS = Runtime.getRuntime().availableProcessors();
    public static final int TERMS_WINDOW = 1;
    public static final int FORMS_WINDOW = 2;
    public static final int SENTENCES_WINDOW = 3;
    public static final int GROUPS_WINDOW = 4;
    public static final int EXPORT_RESULTS = 1;
    public static final int EXPORT_FORMS = 2;
    public static final int EXPORT_SENTENCES = 3;
    public static final int EXPORT_GROUPS = 4;
    public static final int SAVE_THREAD = 0;
    public static final int EXPORT_RESULTS_THREAD = 1;
    public static final int EXPORT_FORMS_THREAD = 2;
    public static final int EXPORT_SENTENCES_THREAD = 3;
    public static final int EXPORT_GROUPS_THREAD = 4;
    public static final int MAX_SAVE_THREADS = 5;
    private static final Term DUMMY_TERM = new Term();
    public static int newCounter = 0;
    private LinkedList<TermoPLWindow> windows;
    private TermsView termsView;
    private FormsView formsView;
    private SentencesView sentencesView;
    private GroupsView groupsView;
    private ColumnSorter sorter;
    private BlockingQueue<Term> termQueue;
    private CountDownLatch countDown;
    private ExtractorEngine extractor;
    private BaseFormGuesser baseFormGuesser;
    private File input;
    private BatchParameters bp;
    private Preferences preferences;
    private File[] selectedFiles;
    private File[] oldFiles;
    private File[] newFiles;
    private Term[] terms;
    private LinkedList<FileDescr> analyzedFiles;
    private HashMap<String, Term> cterms;
    private String corpusName;
    private String docName;
    private String docDisplayName;
    private int tableSize;
    private int nsentences;
    private int ntokens;
    private int nterms;
    private int rebuild;
    private int acceptDET;
    private boolean loaded;
    private boolean modified;
    private boolean cancelled;
    private boolean corrupted;
    private boolean formsCollected;
    private boolean sentencesIndexed;
    private boolean reuseTaggedFiles;
    private boolean searching;
    private transient HashMap<String, Term> termMap;
    private transient HashMap<String, LinkedList<TermEx>> termIndex;
    private transient HashMap<String, LinkedList<WordReplacement>> wordIndex;
    private transient WordNet wordNet;
    private transient Morfeusz morfeusz;
    private transient Thread[] saveThreads;
    private transient boolean interrupted;
    public AbstractAction selectAction = new AbstractAction("Select"){

        @Override
        public void actionPerformed(ActionEvent e) {
            TermoPLDocument.this.selectFiles();
        }
    };
    public AbstractAction extractAction = new AbstractAction("Extract"){

        @Override
        public void actionPerformed(ActionEvent e) {
            TermoPLDocument.this.extract();
        }
    };
    public AbstractAction compareAction = new AbstractAction("Compare"){

        @Override
        public void actionPerformed(ActionEvent e) {
            TermoPLDocument.this.compare();
        }
    };

    public TermoPLDocument(TermoPL superCommander) {
        super(superCommander);
        this.input = null;
        this.bp = null;
        this.preferences = (Preferences)TermoPL.preferences.clone();
        this.sorter = new ColumnSorter();
        this.windows = new LinkedList();
        this.termsView = null;
        this.formsView = null;
        this.sentencesView = null;
        this.groupsView = null;
        this.selectedFiles = null;
        this.oldFiles = null;
        this.newFiles = null;
        this.analyzedFiles = null;
        this.terms = null;
        this.termMap = null;
        this.cterms = TermoPL.cterms;
        this.termIndex = null;
        this.wordNet = null;
        this.morfeusz = null;
        this.saveThreads = new Thread[5];
        this.extractor = null;
        this.baseFormGuesser = null;
        this.corpusName = null;
        this.docDisplayName = this.docName = "New " + ++newCounter;
        this.tableSize = 0;
        this.nsentences = 0;
        this.ntokens = 0;
        this.nterms = 0;
        this.rebuild = 0;
        this.acceptDET = -1;
        this.loaded = true;
        this.modified = false;
        this.cancelled = false;
        this.interrupted = false;
        this.corrupted = false;
        this.formsCollected = false;
        this.sentencesIndexed = false;
        this.reuseTaggedFiles = this.preferences.reuseTaggedFiles;
        this.searching = false;
        this.createWindow(1);
    }

    public TermoPLDocument(TermoPL superCommander, File file) {
        super(superCommander);
        this.input = file;
        this.bp = null;
        this.preferences = TermoPL.preferences;
        this.sorter = new ColumnSorter();
        this.windows = new LinkedList();
        this.termsView = null;
        this.formsView = null;
        this.sentencesView = null;
        this.groupsView = null;
        this.selectedFiles = null;
        this.oldFiles = null;
        this.newFiles = null;
        this.analyzedFiles = null;
        this.terms = null;
        this.termMap = null;
        this.cterms = null;
        this.termIndex = null;
        this.wordNet = null;
        this.morfeusz = null;
        this.saveThreads = new Thread[5];
        this.extractor = null;
        this.baseFormGuesser = null;
        this.docName = this.input.getName();
        this.docDisplayName = TermoPL.getDisplayName(this.docName);
        this.tableSize = 0;
        this.rebuild = 0;
        this.acceptDET = -1;
        this.loaded = false;
        this.modified = false;
        this.cancelled = false;
        this.interrupted = false;
        this.corrupted = false;
        this.formsCollected = false;
        this.sentencesIndexed = false;
        this.reuseTaggedFiles = this.preferences.reuseTaggedFiles;
        this.searching = false;
        if (!TermoPL.batchMode) {
            this.createWindow(1);
            this.termsView.setAccessory(null);
            this.termsView.showProgress(true);
            this.termsView.pleaseWait();
        }
        LoadThread loadThread = new LoadThread(this.input);
        loadThread.start();
        if (TermoPL.batchMode) {
            try {
                loadThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public TermoPLDocument(TermoPL superCommander, BatchParameters bp) {
        super(superCommander);
        this.input = null;
        this.bp = bp;
        this.preferences = TermoPL.preferences;
        this.sorter = new ColumnSorter();
        this.windows = null;
        this.termsView = null;
        this.formsView = null;
        this.sentencesView = null;
        this.groupsView = null;
        this.selectedFiles = null;
        this.oldFiles = null;
        this.newFiles = null;
        this.analyzedFiles = null;
        this.terms = null;
        this.termMap = null;
        this.cterms = null;
        this.termIndex = null;
        this.wordNet = null;
        this.morfeusz = null;
        this.saveThreads = new Thread[5];
        this.extractor = null;
        this.baseFormGuesser = null;
        this.corpusName = TermoPL.getFileName(bp.inputFiles[0]);
        this.docName = null;
        this.docDisplayName = null;
        this.tableSize = 0;
        this.rebuild = 0;
        this.acceptDET = -1;
        this.loaded = true;
        this.modified = false;
        this.cancelled = false;
        this.interrupted = false;
        this.corrupted = false;
        this.formsCollected = false;
        this.sentencesIndexed = false;
        this.reuseTaggedFiles = this.preferences.reuseTaggedFiles;
        this.searching = false;
    }

    public void finishLoading() {
        if (!TermoPL.batchMode) {
            int n;
            if (this.isLoaded()) {
                boolean missing = false;
                File[] fileArray = this.selectedFiles;
                int n2 = this.selectedFiles.length;
                n = 0;
                while (n < n2) {
                    File f = fileArray[n];
                    if (!f.exists()) {
                        missing = true;
                        break;
                    }
                    ++n;
                }
                if (missing) {
                    this.selectFiles();
                }
                if (this.termsView != null) {
                    if (this.preferences.extract) {
                        this.termsView.setWarning("Extract terms.");
                        this.termsView.setAccessory(this.extractAction);
                    } else if (this.preferences.compare) {
                        this.termsView.setWarning("Compare terms.");
                        this.termsView.setAccessory(this.compareAction);
                    }
                }
            }
            if (this.terms != null && this.terms[0] instanceof TermEx) {
                this.termMap = new HashMap();
                Term[] termArray = this.terms;
                n = this.terms.length;
                int n3 = 0;
                while (n3 < n) {
                    Term t = termArray[n3];
                    TermEx tex = (TermEx)t;
                    this.termMap.put(tex.id, t);
                    ++n3;
                }
            }
        }
    }

    public String getCorpusName() {
        return this.corpusName;
    }

    public String getDocumentName() {
        return this.docName;
    }

    public String getDocumentDisplayName() {
        return this.docDisplayName;
    }

    public String getPath() {
        if (this.input != null) {
            return this.input.getPath();
        }
        return null;
    }

    public void waitForSaveThreadsToFinish() {
        Thread[] threadArray = this.saveThreads;
        int n = this.saveThreads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread th = threadArray[n2];
            if (th != null) {
                try {
                    th.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startBatchProcessing() {
        Object tmp;
        String[] bf;
        String[] line;
        BufferedReader reader;
        block93: {
            block95: {
                int i;
                if (this.bp.wrk == null) {
                    this.preferences.workSpace = "";
                } else {
                    if (this.bp.wrk.endsWith(File.separator) && (i = this.bp.wrk.lastIndexOf(File.separator)) > 0) {
                        this.bp.wrk = this.bp.wrk.substring(0, this.bp.wrk.length() - File.separator.length());
                    }
                    this.preferences.workSpace = this.bp.wrk;
                }
                if (this.bp.wdn != null) {
                    if (this.bp.wdn.endsWith(File.separator) && (i = this.bp.wdn.lastIndexOf(File.separator)) > 0) {
                        this.bp.wdn = this.bp.wdn.substring(0, this.bp.wdn.length() - File.separator.length());
                    }
                    this.preferences.wordNetPath = this.bp.wdn;
                    this.preferences.makeGroups = true;
                    this.preferences.useWordNet = true;
                }
                if (this.bp.inputFiles == null) {
                    System.out.println("No input");
                    return;
                }
                this.setSelectedFiles(this.bp.inputFiles);
                if (this.bp.comp != null) {
                    File file = new File(this.bp.comp);
                    if (!file.exists()) {
                        System.out.println(this.fileDoesNotExist(this.bp.comp));
                        return;
                    }
                    this.cterms = this.loadContrastiveTerms(file);
                    if (this.cterms == null) {
                        System.out.println("Can't read comparative data");
                        return;
                    }
                    this.preferences.applyContrastiveRanking = true;
                }
                this.preferences.reuseTaggedFiles = false;
                if (this.bp.sw != null) {
                    if (this.bp.sw != null) {
                        LinkedList<String[]> sw = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.bp.sw), "UTF8"));
                            do {
                                if ((line = reader.readLine()) == null || (line = line.trim()).isEmpty()) continue;
                                if (sw == null) {
                                    sw = new LinkedList<String[]>();
                                }
                                if (sw.contains(line)) continue;
                                sw.add(line);
                            } while (line != null);
                            reader.close();
                            this.preferences.stopWords = sw;
                            this.preferences.checkStopWords = true;
                        }
                        catch (IOException exception) {
                            exception.printStackTrace();
                            this.preferences.stopWords = null;
                            this.preferences.checkStopWords = false;
                        }
                    } else {
                        this.preferences.stopWords = null;
                        this.preferences.checkStopWords = false;
                    }
                } else {
                    this.preferences.stopWords = null;
                    this.preferences.checkStopWords = false;
                }
                if (this.bp.cp == null) break block95;
                if (this.bp.cp != null) {
                    LinkedList<String[]> cp = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.bp.cp), "UTF8"));
                        do {
                            if ((line = reader.readLine()) == null || (line = line.trim()).isEmpty()) continue;
                            if (cp == null) {
                                cp = new LinkedList<String[]>();
                            }
                            if (cp.contains(line)) continue;
                            cp.add(line);
                        } while (line != null);
                        reader.close();
                        if (cp != null) {
                            PParser parser = new PParser((LinkedList<String>)cp, null);
                            parser.parse();
                            this.preferences.removeCompoundPreps = true;
                            this.preferences.compPreps = cp;
                            this.preferences.compoundPrepositions = parser.getTemplate();
                            break block93;
                        }
                        this.preferences.removeCompoundPreps = false;
                        this.preferences.compPreps = null;
                        this.preferences.compoundPrepositions = null;
                    }
                    catch (IOException exception) {
                        this.preferences.removeCompoundPreps = false;
                        this.preferences.compPreps = null;
                        this.preferences.compoundPrepositions = null;
                    }
                    break block93;
                } else {
                    this.preferences.removeCompoundPreps = false;
                    this.preferences.compPreps = null;
                    this.preferences.compoundPrepositions = null;
                }
                break block93;
            }
            this.preferences.removeCompoundPreps = false;
            this.preferences.compPreps = null;
            this.preferences.compoundPrepositions = null;
        }
        if (this.bp.ct != null) {
            if (this.bp.ct != null) {
                LinkedList<CommonTerm> ct = null;
                try {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.bp.ct), "UTF8"));
                    do {
                        int index;
                        if ((line = reader.readLine()) == null || (line = line.trim()).isEmpty()) continue;
                        bf = null;
                        String[] sf = null;
                        if (ct == null) {
                            ct = new LinkedList<CommonTerm>();
                        }
                        if ((index = line.indexOf("[")) < 0) {
                            sf = line;
                            bf = line;
                        } else {
                            sf = line.substring(0, index).trim();
                            bf = line.substring(index + 1).replace("]", "").trim();
                        }
                        ct.add(new CommonTerm((String)bf, (String)sf));
                    } while (line != null);
                    reader.close();
                    this.preferences.commonTerms = ct;
                    this.preferences.removeCommonTerms = true;
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    this.preferences.commonTerms = null;
                    this.preferences.removeCommonTerms = false;
                }
            } else {
                this.preferences.commonTerms = null;
                this.preferences.removeCommonTerms = false;
            }
        } else {
            this.preferences.commonTerms = null;
            this.preferences.removeCommonTerms = false;
        }
        this.preferences.language = this.bp.language != null ? this.bp.language : "pl";
        this.preferences.useUD = this.bp.method != null ? this.bp.method.equals("ud") : false;
        this.preferences.ignoreCase = this.bp.ignoreCase != null ? this.bp.ignoreCase.equals("yes") : true;
        this.preferences.detHandling = this.bp.det != null ? (this.bp.det.equals("include") ? 1 : (this.bp.det.equals("article") ? 2 : (this.bp.det.equals("exclude") ? 0 : 1))) : 1;
        if (this.bp.detRatio == -1) {
            this.preferences.detectDeterminers = false;
        } else {
            this.preferences.detectDeterminers = true;
            this.preferences.detRatio = this.bp.detRatio;
        }
        if (this.bp.tagset != null) {
            if (this.bp.tagset == null) {
                System.out.println(this.fileDoesNotExist(this.bp.tagset));
                return;
            }
            TParser parser = new TParser(new File(this.bp.tagset), null);
            parser.parse();
            tmp = parser.getTagset();
            if (tmp == null) return;
            this.preferences.useCustomTagset = true;
            this.preferences.tagset = tmp;
        } else {
            this.preferences.useCustomTagset = false;
            this.preferences.tagset = Tagset.createDefaultTagset();
        }
        if (this.bp.grammar != null) {
            if (this.bp.grammar == null) {
                System.out.println(this.fileDoesNotExist(this.bp.grammar));
                return;
            }
            GParser parser = new GParser(new File(this.bp.grammar), this.preferences.getTagset(), null);
            parser.parse();
            tmp = parser.getTemplate();
            if (tmp == null) return;
            this.preferences.useCustomGrammar = true;
            this.preferences.template = tmp;
        } else {
            this.preferences.useCustomGrammar = false;
            this.preferences.template = Template.NPP();
        }
        if (this.bp.mw > 0) {
            this.preferences.multiWordTermsOnly = true;
        }
        if (this.bp.sf > 0) {
            this.preferences.calculateBaseForms = false;
        }
        if (this.bp.nf > 0) {
            this.preferences.collectAllForms = false;
        }
        if (this.bp.exportForms != null) {
            this.preferences.collectAllForms = true;
        }
        if (this.bp.indx > 0) {
            this.preferences.makeIndex = true;
        }
        if (this.bp.group > 0) {
            this.preferences.makeGroups = true;
        }
        if (this.bp.exportSentences != null) {
            this.preferences.makeIndex = true;
        }
        if (this.preferences.makeIndex) {
            this.preferences.reuseTaggedFiles = true;
        }
        if (this.bp.srch > 0) {
            if (this.bp.srch < 4) {
                this.preferences.useNPMIMethod = true;
                this.preferences.NPMIMethod = this.bp.srch;
            } else {
                this.preferences.useNPMIMethod = false;
                this.preferences.trimFromLeftToRight = this.bp.srch != 4;
            }
        }
        if (this.bp.cntx > 0) {
            this.preferences.cntxMethod = this.bp.cntx;
        }
        if (this.bp.sort > 0) {
            int asc;
            int n = asc = this.bp.sort > 8 ? 1 : -1;
            if (this.bp.sort > 8) {
                this.bp.sort -= 8;
            }
            this.preferences.sortedColumn = this.bp.sort;
            this.preferences.sortPrefs[this.bp.sort] = asc;
        }
        if (this.bp.tr > 0) {
            this.preferences.trimResults = true;
            this.preferences.maxResults = this.bp.tr;
        }
        if (this.bp.pf >= 0) {
            this.preferences.NPMIfactor = this.bp.pf;
            this.preferences.useNPMIMethod = true;
            this.preferences.NPMIMethod = 3;
        }
        if (this.bp.cc >= 0) {
            if (this.bp.cc == 0) {
                this.preferences.applyContrastiveRanking = false;
            } else {
                this.preferences.applyContrastiveRanking = true;
                this.preferences.contrastiveRankingMethod = this.bp.cc;
                if (this.bp.cc == 4) {
                    this.preferences.useCValues = false;
                }
            }
        }
        if (this.bp.frq > 0) {
            this.preferences.useCValues = false;
        }
        if (this.bp.freq >= 0) {
            this.preferences.applyContrastiveRankingForFrequentTerms = true;
            this.preferences.minfrq = this.bp.freq;
        }
        if (this.bp.cval >= 0.0) {
            this.preferences.applyContrastiveRankingForTopRankedTerms = true;
            this.preferences.mincvalue = this.bp.cval;
        }
        if (this.bp.saveOptions != null && this.bp.saveOptions.length > 0) {
            this.preferences.saveCount = false;
            this.preferences.saveRank = false;
            this.preferences.saveSF = false;
            this.preferences.saveBF = false;
            this.preferences.saveCV = false;
            this.preferences.saveComp = false;
            this.preferences.saveLen = false;
            this.preferences.saveFreqs = false;
            this.preferences.saveFreqin = false;
            this.preferences.saveContext = false;
            bf = this.bp.saveOptions;
            int line2 = this.bp.saveOptions.length;
            int tmp2 = 0;
            while (tmp2 < line2) {
                String str = bf[tmp2];
                if (str.equals("#")) {
                    this.preferences.saveCount = true;
                } else if (str.equals("rank")) {
                    this.preferences.saveRank = true;
                } else if (str.equals("sf")) {
                    this.preferences.saveSF = true;
                } else if (str.equals("bf")) {
                    this.preferences.saveBF = true;
                } else if (str.equals("cvalue")) {
                    this.preferences.saveCV = true;
                } else if (str.equals("comp")) {
                    this.preferences.saveComp = true;
                } else if (str.equals("length")) {
                    this.preferences.saveLen = true;
                } else if (str.equals("freq_s")) {
                    this.preferences.saveFreqs = true;
                } else if (str.equals("freq_in")) {
                    this.preferences.saveFreqin = true;
                } else if (str.equals("context")) {
                    this.preferences.saveContext = true;
                }
                ++tmp2;
            }
            if (!this.preferences.saveSF && !this.preferences.saveBF) {
                if (this.preferences.calculateBaseForms) {
                    this.preferences.saveBF = true;
                } else {
                    this.preferences.saveSF = true;
                }
            }
        }
        this.extractor = new ExtractorEngine(this, this.selectedFiles);
        GroupingEngine groupingEngine = null;
        if (this.preferences.makeGroups) {
            groupingEngine = new GroupingEngine();
        }
        Finalizer finalizer = new Finalizer();
        ExtractorThread et = new ExtractorThread(this.extractor, groupingEngine, finalizer, null);
        this.terms = null;
        this.termMap = null;
        et.start();
        try {
            et.join();
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setSelectedFiles(String[] inputFiles) {
        LinkedList<File> sf = new LinkedList<File>();
        String[] stringArray = inputFiles;
        int n = inputFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            this.addSelectedFile(p, sf);
            ++n2;
        }
        if (sf.isEmpty()) {
            System.out.println("No input");
        } else {
            this.selectedFiles = sf.toArray(new File[0]);
        }
    }

    public void addSelectedFile(String p, LinkedList<File> sf) {
        String dirName;
        String fileName;
        int index = p.lastIndexOf(File.separator);
        File[] files = null;
        if (index < 0) {
            fileName = p;
            dirName = null;
        } else if (index < p.length() - 1) {
            fileName = p.substring(index + 1);
            dirName = p.substring(0, index);
        } else {
            fileName = null;
            dirName = p;
        }
        if (fileName == null) {
            File dir = new File(dirName);
            if (dir.exists()) {
                sf.add(dir);
            } else {
                System.out.println(this.fileDoesNotExist(p));
            }
        } else {
            File dir;
            if (dirName != null) {
                dir = new File(dirName);
                if (dir.exists()) {
                    files = dir.listFiles(new FileNameFilter(fileName));
                } else {
                    System.out.println(this.fileDoesNotExist(p));
                }
            } else {
                dir = new File("").getAbsoluteFile();
                files = dir.listFiles(new FileNameFilter(fileName));
            }
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    sf.add(f);
                    ++n2;
                }
            }
        }
    }

    public String fileDoesNotExist(String f) {
        return "File: '" + f + "' does not exist";
    }

    @Override
    public void executeCommand(int commandID, int modifiers) {
        switch (commandID) {
            case 3: {
                this.merge();
                break;
            }
            case 4: {
                this.close();
                break;
            }
            case 5: {
                this.save();
                break;
            }
            case 6: {
                this.saveAs();
                break;
            }
            case 7: {
                this.selectWorkspace();
                break;
            }
            case 8: {
                this.export(1);
                break;
            }
            case 9: {
                this.export(2);
                break;
            }
            case 10: {
                this.export(3);
                break;
            }
            case 11: {
                this.export(4);
                break;
            }
            case 12: {
                this.extract();
                break;
            }
            case 13: {
                this.compare();
                break;
            }
            case 14: {
                this.selectFiles();
                break;
            }
            case 15: {
                this.selectContrastiveTerms();
                break;
            }
            case 16: {
                this.preferences.calculateBaseForms = !this.preferences.calculateBaseForms;
                super.executeCommand(commandID, modifiers);
                if (this.terms != null) {
                    Thread th = new Thread(){

                        @Override
                        public void run() {
                            TermoPLDocument.this.recalculateForms();
                        }
                    };
                    th.start();
                }
                this.modified = true;
                break;
            }
            case 17: {
                super.executeCommand(commandID, modifiers);
                this.allowCollectingForms(!this.preferences.collectAllForms);
                break;
            }
            case 18: {
                super.executeCommand(commandID, modifiers);
                this.allowIndexingSentences(!this.preferences.makeIndex);
                break;
            }
            case 19: {
                this.changePreferences();
                break;
            }
            case 20: {
                if (this.formsView == null) {
                    this.createWindow(2);
                    break;
                }
                this.getWindow(2).select();
                break;
            }
            case 21: {
                if (this.sentencesView == null) {
                    this.createWindow(3);
                    break;
                }
                this.getWindow(3).select();
                break;
            }
            case 22: {
                if (this.groupsView == null) {
                    this.createWindow(4);
                    break;
                }
                this.getWindow(4).select();
                break;
            }
            default: {
                super.executeCommand(commandID, modifiers);
            }
        }
    }

    @Override
    public void findMenuStatus(JMenu menu) {
    }

    @Override
    public void findCommandStatus(JMenuItem item) {
        Command command = (Command)item.getAction();
        switch (command.getCommandID()) {
            case 4: 
            case 14: {
                item.setEnabled(!this.searching);
                break;
            }
            case 5: {
                boolean b = this.saveThreads[0] == null || !this.saveThreads[0].isAlive();
                item.setEnabled(b && this.modified && this.terms != null && !this.searching);
                break;
            }
            case 6: {
                boolean b = this.saveThreads[0] == null || !this.saveThreads[0].isAlive();
                item.setEnabled(b && this.terms != null && !this.searching);
                break;
            }
            case 8: {
                boolean b = this.saveThreads[1] == null || !this.saveThreads[1].isAlive();
                item.setEnabled(b && this.terms != null && !this.searching);
                break;
            }
            case 3: 
            case 13: {
                item.setEnabled(this.terms != null && !this.searching);
                break;
            }
            case 12: {
                item.setEnabled(this.selectedFiles != null || this.newFiles != null && !this.searching);
                break;
            }
            case 16: {
                item.setSelected(this.preferences.calculateBaseForms);
                item.setEnabled(!this.preferences.useCustomTagset && !this.searching);
                break;
            }
            case 17: {
                item.setSelected(this.preferences.collectAllForms);
                item.setEnabled(!this.searching);
                break;
            }
            case 18: {
                item.setSelected(this.preferences.makeIndex);
                item.setEnabled(!this.searching);
                break;
            }
            case 9: {
                boolean b = this.saveThreads[2] == null || !this.saveThreads[2].isAlive();
                item.setEnabled(b && this.terms != null && this.formsCollected && !this.searching);
                break;
            }
            case 20: {
                item.setEnabled(this.terms != null && this.formsCollected && !this.searching);
                break;
            }
            case 10: {
                boolean b = this.saveThreads[3] == null || !this.saveThreads[3].isAlive();
                item.setEnabled(b && this.terms != null && this.sentencesIndexed && !this.searching);
                break;
            }
            case 21: {
                item.setEnabled(this.terms != null && this.sentencesIndexed && !this.searching);
                break;
            }
            case 11: {
                boolean b = this.saveThreads[4] == null || !this.saveThreads[4].isAlive();
                item.setEnabled(b && this.terms != null && this.preferences.makeGroups && !this.searching);
                break;
            }
            case 22: {
                item.setEnabled(this.terms != null && this.preferences.makeGroups && !this.searching);
                break;
            }
            default: {
                super.findCommandStatus(item);
            }
        }
    }

    public void changePreferences() {
        Options options = new Options(this.preferences);
        int res = options.doDialog();
        boolean setinfo = true;
        options.dispose();
        if (res == 1 && this.preferences.isModified()) {
            this.modified = true;
            if (this.terms != null) {
                if (this.preferences.extract) {
                    this.rebuild = 2;
                    if (this.termsView != null) {
                        this.termsView.setWarning("Extract terms.");
                        this.termsView.setAccessory(this.extractAction);
                        setinfo = false;
                    }
                } else if (this.preferences.compare) {
                    if (this.termsView != null) {
                        this.termsView.setWarning("Compare terms.");
                        this.termsView.setAccessory(this.compareAction);
                        setinfo = false;
                    }
                } else if (this.preferences.repaint && this.cterms != null) {
                    this.applyContrastiveRanking();
                    if (this.termsView != null) {
                        this.termsView.setInfo(this.getStat());
                    }
                }
                if (this.preferences.recalculate) {
                    this.calculate(this.preferences.cntxMethod);
                }
                if (!this.preferences.applyContrastiveRanking && this.termsView != null) {
                    if (setinfo) {
                        this.termsView.setInfo(this.getStat());
                    }
                    this.termsView.refreshColumns();
                }
            }
            if (this.termsView != null) {
                this.termsView.repaint();
            }
            this.preferences.save();
        }
    }

    public void extract() {
        int i;
        File[] searchFiles = null;
        int s = 0;
        if (this.rebuild == 0) {
            this.rebuild = 2;
        } else if (this.rebuild == 1) {
            if (this.selectedFiles == null) {
                searchFiles = this.newFiles;
            } else {
                int res = JOptionPane.showOptionDialog(TermoPL.dialogOwner, "You may choose to run extraction process from scratch,\nor augment the current list of terms using the recently\nselected files only.\n\nWhich set of files are you going to use for term extraction?", "Select source for term extraction", 1, 3, null, EXTRACT_OPTIONS, EXTRACT_OPTIONS[1]);
                if (res == 2) {
                    return;
                }
                if (res == 1) {
                    searchFiles = this.newFiles;
                } else {
                    this.rebuild = 2;
                }
            }
            this.acceptDET = -1;
        }
        if (this.rebuild == 2) {
            if (this.oldFiles != null) {
                s += this.oldFiles.length;
            }
            if (this.newFiles != null) {
                s += this.newFiles.length;
            }
            searchFiles = new File[s];
            s = 0;
            if (this.oldFiles != null) {
                i = 0;
                while (i < this.oldFiles.length) {
                    searchFiles[s++] = this.oldFiles[i];
                    ++i;
                }
            }
            if (this.newFiles != null) {
                i = 0;
                while (i < this.newFiles.length) {
                    searchFiles[s++] = this.newFiles[i];
                    ++i;
                }
            }
            this.terms = null;
            this.nsentences = 0;
            this.ntokens = 0;
            this.nterms = 0;
            this.acceptDET = -1;
        }
        if (this.preferences.makeGroups) {
            if (this.terms != null) {
                Term[] termArray = this.terms;
                int n = this.terms.length;
                int n2 = 0;
                while (n2 < n) {
                    Term t = termArray[n2];
                    t.str = this.calcSimplifiedForm(t);
                    ++n2;
                }
                if (this.terms[0] instanceof TermEx) {
                    termArray = this.terms;
                    n = this.terms.length;
                    n2 = 0;
                    while (n2 < n) {
                        Term t = termArray[n2];
                        ((TermEx)t).clean();
                        ++n2;
                    }
                } else {
                    int i2 = 0;
                    while (i2 < this.terms.length) {
                        this.terms[i2] = new TermEx(this.terms[i2].str, this.terms[i2].len);
                        ++i2;
                    }
                }
            }
        } else if (this.terms != null && this.terms[0] instanceof TermEx) {
            i = 0;
            while (i < this.terms.length) {
                this.terms[i] = new TermEx(this.terms[i].str, this.terms[i].len);
                ++i;
            }
        }
        ContrastiveDataLoader loader = null;
        Finalizer finalizer = new Finalizer();
        this.modified = true;
        this.cancelled = false;
        this.interrupted = false;
        this.extractor = new ExtractorEngine(this, searchFiles);
        this.formsCollected = false;
        this.sentencesIndexed = false;
        if (this.preferences.applyContrastiveRanking && this.cterms == null) {
            if (this.preferences.contrastiveDataPath == null) {
                this.preferences.contrastiveDataPath = TermoPL.selectContrastiveCorpus();
            }
            if (this.preferences.contrastiveDataPath != null) {
                loader = new ContrastiveDataLoader(this.preferences.contrastiveDataPath);
            }
        }
        if (this.termsView != null) {
            if (this.rebuild == 2) {
                this.termsView.resetResults();
                this.termsView.clearSearch();
            }
            this.termsView.setAccessory(null);
            this.termsView.showProgress(true);
        }
        if (this.formsView != null) {
            this.formsView.reset();
        }
        if (this.sentencesView != null) {
            this.sentencesView.reset();
        }
        if (this.groupsView != null) {
            this.groupsView.reset();
        }
        System.gc();
        GroupingEngine groupingEngine = null;
        if (this.preferences.makeGroups) {
            groupingEngine = new GroupingEngine();
        }
        ExtractorThread et = new ExtractorThread(this.extractor, groupingEngine, finalizer, loader);
        et.start();
    }

    public void makeGroups() {
        int col = this.preferences.sortedColumn;
        int sortPref = this.preferences.sortPrefs[5];
        this.preferences.sortedColumn = 5;
        this.preferences.sortPrefs[5] = 1;
        this.sortTable();
        this.preferences.sortedColumn = col;
        this.preferences.sortPrefs[5] = sortPref;
        this.mapWordsToTerms();
        this.makeHierarchy();
        if (this.preferences.useWordNet && this.preferences.language.equals("pl") && !this.isCancelled()) {
            this.initBaseFormGuesser();
            this.analizeTermsWithWordnet();
        }
        this.termIndex = null;
        this.baseFormGuesser = null;
    }

    public void makeHierarchy() {
        int i = 0;
        float progress = 0.0f;
        this.changeProgress(6);
        this.report(progress);
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            if (this.isCancelled()) break;
            TermEx termEx = (TermEx)term;
            LinkedList<TermEx> simTerms = this.termsWithSimilarHead(termEx);
            if (simTerms != null) {
                this.createTermHierarchy(termEx, simTerms);
            }
            if (++i % 250 == 0) {
                progress = (float)i / (float)this.terms.length;
                this.report(progress);
            }
            ++n2;
        }
        this.report(1.0f);
    }

    public void mapWordsToTerms() {
        this.termIndex = new HashMap();
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            String[] words;
            Term term = termArray[n2];
            String[] stringArray = words = term.str.split(" ");
            int n3 = words.length;
            int n4 = 0;
            while (n4 < n3) {
                String w = stringArray[n4];
                LinkedList<TermEx> list = this.termIndex.get(w);
                if (list == null) {
                    list = new LinkedList();
                    list.add((TermEx)term);
                    this.termIndex.put(w, list);
                } else {
                    list.add((TermEx)term);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public LinkedList<TermEx> termsWithSimilarHead(TermEx term) {
        String[] head = (String[])this.getHeadPhrase((Term)term).second;
        LinkedList<TermEx> simTerms = null;
        String[] stringArray = head;
        int n = head.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            LinkedList<TermEx> hrel = new LinkedList<TermEx>();
            LinkedList<TermEx> sub = null;
            LinkedList<TermEx> related = this.termIndex.get(str);
            if (related != null) {
                hrel.addAll(related);
                hrel.remove(term);
                block1: for (TermEx t : hrel) {
                    String[] hp;
                    if (term.len >= t.len || (hp = (String[])this.getHeadPhrase((Term)t).second) == null) continue;
                    String[] stringArray2 = hp;
                    int n3 = hp.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray2[n4];
                        if (s.equals(str)) {
                            if (sub == null) {
                                sub = new LinkedList<TermEx>();
                            }
                            sub.add(t);
                            continue block1;
                        }
                        ++n4;
                    }
                }
                if (sub == null) {
                    simTerms = null;
                    break;
                }
                if (simTerms == null) {
                    simTerms = sub;
                } else {
                    ListIterator it = simTerms.listIterator();
                    while (it.hasNext()) {
                        TermEx t = (TermEx)it.next();
                        if (sub.contains(t)) continue;
                        it.remove();
                    }
                }
            }
            ++n2;
        }
        return simTerms;
    }

    public void createTermHierarchy(TermEx term, LinkedList<TermEx> simTerms) {
        for (TermEx t : simTerms) {
            this.addTermToHierarchy(t, term);
        }
    }

    public boolean addTermToHierarchy(TermEx term, TermEx parent) {
        if (this.isLessSpecific(parent, term)) {
            LinkedList<String> children = parent.getChildren();
            boolean found = false;
            if (children != null) {
                children = new LinkedList<String>(children);
                for (String t : children) {
                    if (!this.addTermToHierarchy(term, (TermEx)this.termMap.get(t))) continue;
                    found = true;
                }
            }
            if (!found) {
                parent.addChild(term, this.termMap);
            }
            return true;
        }
        return false;
    }

    public boolean isLessSpecific(TermEx t1, TermEx t2) {
        String[] ph1 = t1.str.split(" ");
        String[] ph2 = t2.str.split(" ");
        if (this.contains(ph2, ph1)) {
            Pair<String, String[]> p1 = this.getHeadPhrase(t1);
            Pair<String, String[]> p2 = this.getHeadPhrase(t2);
            String[] h2 = (String[])p2.second;
            String[] h1 = (String[])p1.second;
            if (this.contains(h2, h1)) {
                String s1 = (String)p1.first;
                String s2 = (String)p2.first;
                if (s1 != null && s1.equals(s2)) {
                    TermEx cntx1 = this.getContextTerm(t1);
                    TermEx cntx2 = this.getContextTerm(t2);
                    if (cntx1 == null && cntx2 == null) {
                        return true;
                    }
                    if (cntx1 == null) {
                        return true;
                    }
                    if (cntx2 == null) {
                        return false;
                    }
                    return this.isLessSpecific(cntx1, cntx2);
                }
            }
        }
        return false;
    }

    public boolean contains(String[] t1, String[] t2) {
        if (t1 == null) {
            return false;
        }
        if (t2 == null) {
            return true;
        }
        if (t1.length < t2.length) {
            return false;
        }
        LinkedList<String> list = new LinkedList<String>(Arrays.asList(t1));
        String[] stringArray = t2;
        int n = t2.length;
        int n2 = 0;
        while (n2 < n) {
            String s2 = stringArray[n2];
            if (!list.remove(s2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean same(String[] t1, String[] t2) {
        if (t1 == null && t2 == null) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        if (t1.length != t2.length) {
            return false;
        }
        LinkedList<String> list = new LinkedList<String>(Arrays.asList(t1));
        String[] stringArray = t2;
        int n = t2.length;
        int n2 = 0;
        while (n2 < n) {
            String s2 = stringArray[n2];
            list.remove(s2);
            ++n2;
        }
        return list.isEmpty();
    }

    public Pair<String, String[]> getPhrase(Term t, int type) {
        Form frm = t.getForms().getFirst();
        LinkedList<String> ph = new LinkedList<String>();
        String w = null;
        String h = null;
        int prevIndex = -1;
        boolean headfound = false;
        for (MatchedToken mt : frm.getTokens()) {
            int index;
            if (type != 0 && (type != 1 || !mt.computeBaseForm) && (type != 2 || mt.computeBaseForm)) continue;
            Token tok = mt.token;
            if (mt.head() && type == 1) {
                headfound = true;
            }
            w = w == null ? tok.lemma : String.valueOf(w) + tok.lemma;
            if (tok instanceof UDToken) {
                index = ((UDToken)tok).index;
                if (tok.spaceAfter || index > prevIndex + 1) {
                    if (h == null && headfound) {
                        h = w;
                    }
                    ph.add(w);
                    w = null;
                    headfound = false;
                }
                prevIndex = index;
                continue;
            }
            if (tok instanceof MultiWordToken) {
                index = ((MultiWordToken)tok).getTokens().getLast().index;
                if (tok.spaceAfter || index > prevIndex + 1) {
                    if (h == null && headfound) {
                        h = w;
                    }
                    ph.add(w);
                    w = null;
                    headfound = false;
                }
                prevIndex = index;
                continue;
            }
            if (!tok.spaceAfter) continue;
            if (h == null && headfound) {
                h = w;
            }
            ph.add(w);
            w = null;
            headfound = false;
        }
        if (w != null) {
            ph.add(w);
        }
        if (ph.size() > 0) {
            return new Pair<Object, String[]>(h, ph.toArray(new String[0]));
        }
        return null;
    }

    public String[] getTags(Term t) {
        Form frm = t.getForms().getFirst();
        LinkedList<String> tags = new LinkedList<String>();
        for (MatchedToken mt : frm.getTokens()) {
            Token tok = mt.token;
            if (!this.preferences.useCustomTagset && tok.ctag.equals("adja") && !tok.form.equals("-")) continue;
            tags.add(tok.ctag);
        }
        if (tags.size() > 0) {
            return tags.toArray(new String[0]);
        }
        return null;
    }

    public String[] getPhrase(Term t) {
        Pair<String, String[]> p = this.getPhrase(t, 0);
        if (p != null) {
            return (String[])p.second;
        }
        return null;
    }

    public Pair<String, String[]> getHeadPhrase(Term t) {
        return this.getPhrase(t, 1);
    }

    public String[] getContextPhrase(Term t) {
        Pair<String, String[]> p = this.getPhrase(t, 2);
        if (p != null) {
            return (String[])p.second;
        }
        return null;
    }

    public TermEx getContextTerm(Term t) {
        String[] cntx = this.getContextPhrase(t);
        if (cntx == null) {
            return null;
        }
        return this.getTerm(cntx, 0, cntx.length);
    }

    public TermEx getTerm(String[] words, int start, int end) {
        if (start == end) {
            return null;
        }
        String str = "";
        int i = start;
        while (i < end) {
            str = String.valueOf(str) + words[i] + " ";
            ++i;
        }
        Term t = this.termMap.get(str = str.trim());
        if (t == null) {
            t = this.getTerm(words, start + 1, end);
        }
        if (t == null) {
            t = this.getTerm(words, start, end - 1);
        }
        return (TermEx)t;
    }

    public void initBaseFormGuesser() {
        this.baseFormGuesser = this.preferences.language.equals("pl") && !this.preferences.useCustomTagset ? new BaseFormGuesser(this.preferences.tagset) : new BaseFormGuesser();
    }

    public void analizeTermsWithWordnet() {
        int i = 0;
        float progress = 0.0f;
        this.wordNet = WordNet.getWordNet(this.preferences.wordNetPath);
        if (this.wordNet == null) {
            this.changeProgress(7);
            this.wordNet = WordNet.createWordNet(this, this.preferences.wordNetPath);
        }
        if (this.wordNet != null) {
            this.morfeusz = Morph.getAnalyzer();
            this.wordIndex = new HashMap();
            this.changeProgress(8);
            this.report(progress);
            Term[] termArray = this.terms;
            int n = this.terms.length;
            int n2 = 0;
            while (n2 < n) {
                Term t = termArray[n2];
                if (this.isCancelled()) break;
                this.analyzeWithWordnet((TermEx)t);
                if (++i % 1000 == 0) {
                    progress = (float)i / (float)this.terms.length;
                    this.report(progress);
                    System.gc();
                }
                ++n2;
            }
            this.report(1.0f);
            this.wordNet = null;
            this.morfeusz = null;
            this.wordIndex = null;
            System.gc();
        }
    }

    public void analyzeWithWordnet(TermEx term) {
        String[] ph = this.getPhrase(term);
        if (ph != null) {
            String[] tags = this.getTags(term);
            String[] wdn = new String[ph.length];
            LinkedList[] wordReplacements = new LinkedList[ph.length];
            boolean makeReplacements = false;
            int i = 0;
            while (i < ph.length) {
                wdn[i] = ph[i];
                if (tags[i].startsWith("subst")) {
                    tags[i] = "rzeczownik";
                } else if (tags[i].startsWith("adj")) {
                    tags[i] = "przymiotnik";
                } else if (tags[i].startsWith("adv")) {
                    tags[i] = "przys\u0142\u00f3wek";
                } else if (tags[i].startsWith("fin")) {
                    tags[i] = "czasownik";
                } else if (tags[i].startsWith("praet")) {
                    tags[i] = "czasownik";
                } else if (tags[i].startsWith("impt")) {
                    tags[i] = "czasownik";
                } else if (tags[i].startsWith("imps")) {
                    tags[i] = "czasownik";
                } else if (tags[i].startsWith("inf")) {
                    tags[i] = "czasownik";
                } else if (tags[i].startsWith("ger")) {
                    wdn[i] = this.baseFormGuesser.nominalForm(ph[i], tags[i]);
                    tags[i] = "rzeczownik";
                } else if (tags[i].startsWith("ppas")) {
                    wdn[i] = this.baseFormGuesser.nominalForm(ph[i], tags[i]);
                    tags[i] = "przymiotnik";
                } else if (tags[i].startsWith("pact")) {
                    wdn[i] = this.baseFormGuesser.nominalForm(ph[i], tags[i]);
                    tags[i] = "przymiotnik";
                } else {
                    tags[i] = null;
                }
                ++i;
            }
            i = 0;
            while (i < ph.length) {
                if (tags[i] != null) {
                    String key = String.valueOf(ph[i]) + "_" + tags[i];
                    LinkedList<WordReplacement> substList = this.wordIndex.get(key);
                    if (substList == null) {
                        wordReplacements[i] = substList = this.getWordReplacements(ph[i], wdn[i], tags[i]);
                        if (substList == null) {
                            substList = new LinkedList();
                        } else {
                            substList.add(new WordReplacement(ph[i], ph[i], 0));
                        }
                        this.wordIndex.put(key, substList);
                    } else {
                        wordReplacements[i] = substList.isEmpty() ? null : substList;
                    }
                } else {
                    wordReplacements[i] = null;
                }
                ++i;
            }
            LinkedList[] linkedListArray = wordReplacements;
            int n = wordReplacements.length;
            int n2 = 0;
            while (n2 < n) {
                LinkedList list = linkedListArray[n2];
                if (list != null) {
                    makeReplacements = true;
                    break;
                }
                ++n2;
            }
            if (makeReplacements) {
                i = 0;
                while (i < ph.length) {
                    if (wordReplacements[i] == null) {
                        wordReplacements[i] = new LinkedList();
                        wordReplacements[i].add(new WordReplacement(ph[i], ph[i], 0));
                    }
                    ++i;
                }
                LinkedList<TermReplacement> relatedTerms = this.findRelatedTerms(term, ph, wordReplacements);
                if (relatedTerms != null) {
                    this.associate(term, relatedTerms);
                }
            }
        }
    }

    public LinkedList<WordReplacement> getWordReplacements(String word, String wordNetForm, String tag) {
        LinkedList<WordReplacement> substList = null;
        LinkedList<WordReplacement> related = this.wordNet.getRelatedWords(wordNetForm, tag);
        if (related != null) {
            for (WordReplacement item : related) {
                String[] expr = item.expression.split(" ");
                LinkedList<LinkedList<String>> nodes = null;
                String[] stringArray = expr;
                int n = expr.length;
                int n2 = 0;
                while (n2 < n) {
                    String w = stringArray[n2];
                    LinkedList<String> lemmas = this.getLemmas(w);
                    if (lemmas == null) {
                        nodes = null;
                        break;
                    }
                    if (nodes == null) {
                        nodes = new LinkedList<LinkedList<String>>();
                    }
                    nodes.add(lemmas);
                    ++n2;
                }
                if (nodes == null) continue;
                LinkedList<WordReplacement> list = new LinkedList<WordReplacement>();
                LinkedList<String> lemmas = this.cartesianProduct(nodes);
                for (String lemma : lemmas) {
                    if (lemma.equals(word)) continue;
                    WordReplacement.addReplacement(word, lemma, item.relTypes, list);
                }
                if (list.isEmpty()) continue;
                if (substList == null) {
                    substList = list;
                    continue;
                }
                substList.addAll(list);
            }
        }
        return substList;
    }

    public LinkedList<String> getLemmas(String word) {
        List<MorphInterpretation> interps = this.morfeusz.analyseAsList(word);
        LinkedList<String> lemmas = this.getLemmas(0, interps);
        ListIterator it = lemmas.listIterator();
        while (it.hasNext()) {
            String lemma = (String)it.next();
            if (this.termIndex.containsKey(lemma)) continue;
            it.remove();
        }
        return lemmas;
    }

    public LinkedList<String> getLemmas(int start, List<MorphInterpretation> interps) {
        int end = -1;
        LinkedList<String> lemmas = new LinkedList<String>();
        LinkedList<String> list = new LinkedList<String>();
        Tagset tagset = this.preferences.tagset;
        for (MorphInterpretation interp : interps) {
            int s = interp.getStartNode();
            int e = interp.getEndNode();
            if (s == start) {
                String tag;
                String pos;
                if (e > end) {
                    if (end > 0) {
                        lemmas.addAll(this.combine(list, this.getLemmas(end, interps)));
                        list = new LinkedList();
                    }
                    end = e;
                }
                if (!(pos = tagset.getPos(tag = interp.getTag(this.morfeusz))).equals("subst") && !pos.equals("ger") && !pos.equals("adj") && !pos.equals("ppas") && !pos.equals("pact") || !tag.contains("nom")) continue;
                String lemma = interp.getLemma();
                String[] str = lemma.split(":");
                if (str.length > 0) {
                    lemma = str[0];
                }
                if (list.contains(lemma)) continue;
                list.add(lemma);
                continue;
            }
            if (s > start) break;
        }
        if (!list.isEmpty()) {
            lemmas.addAll(this.combine(list, this.getLemmas(end, interps)));
        }
        return lemmas;
    }

    public LinkedList<String> combine(LinkedList<String> list1, LinkedList<String> list2) {
        if (list2.isEmpty()) {
            return list1;
        }
        if (list1.isEmpty()) {
            return list2;
        }
        LinkedList<String> result = new LinkedList<String>();
        for (String s1 : list1) {
            for (String s2 : list2) {
                result.add(String.valueOf(s1) + s2);
            }
        }
        return result;
    }

    public LinkedList<TermReplacement> findRelatedTerms(TermEx term, String[] words, LinkedList<WordReplacement>[] substList) {
        LinkedList<TermReplacement> related = this.findRelatedTerms(0, substList.length, substList);
        if (related != null) {
            related = this.filterTerms(term, related);
        }
        return related;
    }

    public LinkedList<TermReplacement> findRelatedTerms(int i, int n, LinkedList<WordReplacement>[] substList) {
        LinkedList<TermReplacement> list1 = new LinkedList<TermReplacement>();
        for (WordReplacement r : substList[i]) {
            String[] expr = r.expression.split(" ");
            HashSet<TermEx> set = new HashSet<TermEx>();
            String[] stringArray = expr;
            int n2 = expr.length;
            int n3 = 0;
            while (n3 < n2) {
                String w = stringArray[n3];
                LinkedList<TermEx> l = this.termIndex.get(w);
                if (l != null) {
                    if (set.isEmpty()) {
                        set.addAll(l);
                    } else {
                        set.retainAll(l);
                        if (set.isEmpty()) break;
                    }
                }
                ++n3;
            }
            if (set.isEmpty()) continue;
            LinkedList<WordReplacement> wr = new LinkedList<WordReplacement>();
            wr.add(r);
            TermReplacement tr = new TermReplacement(set, wr);
            list1.add(tr);
        }
        if (list1.isEmpty()) {
            return null;
        }
        if (i < n - 1) {
            LinkedList<TermReplacement> list2 = this.findRelatedTerms(i + 1, n, substList);
            if (list2 != null) {
                LinkedList<TermReplacement> related = new LinkedList<TermReplacement>();
                for (TermReplacement tr1 : list1) {
                    for (TermReplacement tr2 : list2) {
                        HashSet<TermEx> set = new HashSet<TermEx>(tr1.terms);
                        set.retainAll(tr2.terms);
                        if (set.isEmpty()) continue;
                        LinkedList<WordReplacement> wr = new LinkedList<WordReplacement>(tr1.replacements);
                        wr.addAll(tr2.replacements);
                        TermReplacement tr = new TermReplacement(set, wr);
                        related.add(tr);
                    }
                }
                if (related.isEmpty()) {
                    return null;
                }
                return related;
            }
            return null;
        }
        return list1;
    }

    public LinkedList<String> cartesianProduct(LinkedList<LinkedList<String>> sets) {
        if (sets.isEmpty()) {
            return null;
        }
        if (sets.size() == 1) {
            return sets.getFirst();
        }
        LinkedList<String> first = sets.removeFirst();
        LinkedList<String> product = new LinkedList<String>();
        LinkedList<String> cp = this.cartesianProduct(sets);
        for (String s1 : first) {
            for (String s2 : cp) {
                product.add(String.valueOf(s1) + " " + s2);
            }
        }
        return product;
    }

    public LinkedList<TermReplacement> filterTerms(TermEx term, LinkedList<TermReplacement> relatedTerms) {
        ListIterator it = relatedTerms.listIterator();
        while (it.hasNext()) {
            TermReplacement tr = (TermReplacement)it.next();
            HashSet<TermEx> s = new HashSet<TermEx>();
            for (TermEx t : tr.terms) {
                boolean remove = false;
                if (t == term) {
                    remove = true;
                } else if (tr.length() != t.len) {
                    remove = true;
                } else if (term.len > 1) {
                    LinkedList<String> words1 = new LinkedList<String>(Arrays.asList(t.str.split(" ")));
                    LinkedList<String> words2 = tr.words();
                    for (String w : words2) {
                        words1.remove(w);
                    }
                    if (!words1.isEmpty()) {
                        remove = true;
                    } else if (!this.compatible(term, t, tr.replacements)) {
                        remove = true;
                    }
                }
                if (remove) continue;
                s.add(t);
            }
            if (s.isEmpty()) {
                it.remove();
                continue;
            }
            tr.terms = s;
        }
        if (relatedTerms.isEmpty()) {
            return null;
        }
        return relatedTerms;
    }

    public boolean compatible(TermEx term1, TermEx term2, LinkedList<WordReplacement> replacements) {
        Pair<String, String[]> p1 = this.getHeadPhrase(term1);
        Pair<String, String[]> p2 = this.getHeadPhrase(term2);
        String[] hp1 = (String[])p1.second;
        String[] hp2 = (String[])p2.second;
        boolean same = false;
        if (hp1 == null || hp2 == null) {
            return false;
        }
        String[] ph = term1.str.split(" ");
        String t1 = (String)p1.first;
        String t2 = (String)p2.first;
        if (t1 == null || t2 == null) {
            return false;
        }
        if ((t1 = this.getWordReplacement(t1, ph, replacements)) == null) {
            return false;
        }
        same = t1.equals(t2) ? true : (t1.contains(" ") ? this.contains(t1.split(" "), t2.split(" ")) : false);
        if (same) {
            if (hp1.length == hp2.length) {
                String[] rhp = WordReplacement.words(this.getReplacementsForNested(ph, hp1, replacements)).toArray(new String[0]);
                if (this.same(rhp, hp2)) {
                    TermEx cntx1 = this.getContextTerm(term1);
                    TermEx cntx2 = this.getContextTerm(term2);
                    if (cntx1 == null && cntx2 == null) {
                        return true;
                    }
                    if (cntx1 == null || cntx2 == null) {
                        return false;
                    }
                    replacements = this.getReplacementsForNested(ph, cntx1.str.split(" "), replacements);
                    return this.compatible(cntx1, cntx2, replacements);
                }
            } else {
                String[] rhp = WordReplacement.words(this.getReplacementsForNested(ph, hp1, replacements)).toArray(new String[0]);
                if (hp1.length < hp2.length) {
                    TermEx cntx1 = term1;
                    while (this.contains(hp2, rhp)) {
                        if ((cntx1 = this.getContextTerm(cntx1)) == null) {
                            return false;
                        }
                        String[] hc = (String[])this.getHeadPhrase((Term)cntx1).second;
                        if (hc == null) {
                            return false;
                        }
                        hc = WordReplacement.words(this.getReplacementsForNested(ph, hc, replacements)).toArray(new String[0]);
                        int n = rhp.length;
                        rhp = Arrays.copyOf(rhp, n + hc.length);
                        int i = 0;
                        while (i < hc.length) {
                            rhp[i + n] = hc[i];
                            ++i;
                        }
                        if (!this.same(hp2, rhp)) continue;
                        same = true;
                        break;
                    }
                    if (same) {
                        cntx1 = this.getContextTerm(cntx1);
                        TermEx cntx2 = this.getContextTerm(term2);
                        if (cntx1 == null && cntx2 == null) {
                            return true;
                        }
                        if (cntx1 == null || cntx2 == null) {
                            return false;
                        }
                        replacements = this.getReplacementsForNested(ph, cntx1.str.split(" "), replacements);
                        return this.compatible(cntx1, cntx2, replacements);
                    }
                } else {
                    TermEx cntx2 = term2;
                    while (this.contains(rhp, hp2)) {
                        if ((cntx2 = this.getContextTerm(cntx2)) == null) {
                            return false;
                        }
                        String[] hc = (String[])this.getHeadPhrase((Term)cntx2).second;
                        if (hc == null) {
                            return false;
                        }
                        int n = hp2.length;
                        hp2 = Arrays.copyOf(hp2, n + hc.length);
                        int i = 0;
                        while (i < hc.length) {
                            hp2[i + n] = hc[i];
                            ++i;
                        }
                        if (!this.same(hp2, rhp)) continue;
                        same = true;
                        break;
                    }
                    if (same) {
                        TermEx cntx1 = this.getContextTerm(term1);
                        cntx2 = this.getContextTerm(cntx2);
                        if (cntx1 == null && cntx2 == null) {
                            return true;
                        }
                        if (cntx1 == null || cntx2 == null) {
                            return false;
                        }
                        replacements = this.getReplacementsForNested(ph, cntx1.str.split(" "), replacements);
                        return this.compatible(cntx1, cntx2, replacements);
                    }
                }
            }
        }
        return false;
    }

    public String getWordReplacement(String word, String[] phrase, LinkedList<WordReplacement> replacements) {
        if (replacements != null) {
            ListIterator it = replacements.listIterator();
            String[] stringArray = phrase;
            int n = phrase.length;
            int n2 = 0;
            while (n2 < n) {
                String w = stringArray[n2];
                String r = ((WordReplacement)it.next()).expression;
                if (w.equals(word)) {
                    return r;
                }
                ++n2;
            }
        }
        return null;
    }

    public LinkedList<WordReplacement> getReplacementsForNested(String[] term, String[] nested, LinkedList<WordReplacement> replacements) {
        LinkedList<WordReplacement> list = null;
        int j = 0;
        int i = 0;
        while (i < term.length) {
            j = 0;
            while (j < nested.length) {
                if (!term[i + j].equals(nested[j])) break;
                ++j;
            }
            if (j == nested.length) break;
            ++i;
        }
        if (j == nested.length) {
            list = new LinkedList<WordReplacement>();
            j = 0;
            for (WordReplacement wr : replacements) {
                if (j >= i) {
                    list.add(wr);
                }
                if (list.size() == nested.length) break;
                ++j;
            }
        }
        return list;
    }

    public void associate(TermEx term, LinkedList<TermReplacement> relatedTerms) {
        for (TermReplacement tr : relatedTerms) {
            boolean synonym = true;
            if (term.len > 1) {
                for (WordReplacement wr : tr.replacements) {
                    if (wr.relTypes == null) continue;
                    for (Integer relType : wr.relTypes) {
                        if (WordNet.isSynonymic(relType)) continue;
                        synonym = false;
                    }
                }
            } else {
                synonym = false;
            }
            for (TermEx t : tr.terms) {
                if (synonym) {
                    if (this.areSynonyms(t, term)) continue;
                    term.addEquivalentTerm(t, this.termMap);
                    continue;
                }
                if (this.areRelated(t, term)) continue;
                term.relateWith(t, tr.replacements);
            }
        }
    }

    public boolean areSynonyms(TermEx term1, TermEx term2) {
        if (term1 == term2) {
            return true;
        }
        LinkedList<String> children = term2.getChildren();
        if (children != null) {
            for (String c : children) {
                TermEx t = (TermEx)this.termMap.get(c);
                if (!this.areRelated(term1, t)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean areRelated(TermEx term1, TermEx term2) {
        LinkedList<String> equivalent;
        if (term1 == term2) {
            return true;
        }
        LinkedList<String> children = term2.getChildren();
        if (children != null) {
            for (String c : children) {
                TermEx t = (TermEx)this.termMap.get(c);
                if (!this.areRelated(term1, t)) continue;
                return true;
            }
        }
        if ((equivalent = term2.getEquivalentTerms()) != null && equivalent.contains(term1.id)) {
            return true;
        }
        return TermEx.containedInRelated(term1, term2.getRelatedTerms());
    }

    public void addNewResults(File[] newFiles) {
        Finalizer finalizer = new Finalizer();
        this.modified = true;
        this.cancelled = false;
        this.interrupted = false;
        this.rebuild = 2;
        this.extractor = new ExtractorEngine(this, newFiles);
        this.formsCollected = false;
        this.sentencesIndexed = false;
        System.gc();
        GroupingEngine groupingEngine = null;
        if (this.preferences.makeGroups) {
            groupingEngine = new GroupingEngine();
        }
        ExtractorThread et = new ExtractorThread(this.extractor, groupingEngine, finalizer, null);
        et.start();
        if (TermoPL.batchMode) {
            try {
                et.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void calculate(int cntxMethod) {
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            term.calc(cntxMethod);
            ++n2;
        }
    }

    public HashMap<String, Term> loadContrastiveTerms(File file) {
        HashMap<String, Term> newCTerms = null;
        if (file.getName().toLowerCase().endsWith(".trm")) {
            try {
                ObjectInputStream is = new ObjectInputStream(new FileInputStream(file));
                newCTerms = this.loadContrastiveTerms(is);
                is.close();
            }
            catch (Exception exception) {
                if (TermoPL.batchMode) {
                    System.out.println("Error occured while reading contrastive data.");
                } else {
                    JOptionPane.showMessageDialog(TermoPL.dialogOwner, "Error occured while reading contrastive data.", "Error", 0);
                }
                newCTerms = null;
            }
        } else {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                newCTerms = this.loadContrastiveTerms(reader);
                reader.close();
            }
            catch (IOException exception) {
                newCTerms = null;
            }
        }
        return newCTerms;
    }

    public HashMap<String, Term> loadContrastiveTerms(BufferedReader reader) throws IOException {
        HashMap<String, Term> newCTerms = new HashMap<String, Term>();
        boolean done = false;
        do {
            String line;
            if ((line = reader.readLine()) == null) {
                done = true;
                continue;
            }
            if ((line = line.trim().replace(",", ".")).isEmpty()) {
                done = true;
                continue;
            }
            String[] s = line.split("\t");
            Term t = new Term();
            try {
                if (s.length == 3) {
                    t.str = s[0];
                    t.cvalue = Double.parseDouble(s[1]);
                    t.freq_s = Integer.parseInt(s[2]);
                    t.contrast = 0.0;
                } else if (s.length == 8) {
                    Integer.parseInt(s[0]);
                    t.rank = Integer.parseInt(s[1]);
                    t.str = s[2];
                    t.cvalue = Double.parseDouble(s[3]);
                    t.contrast = 0.0;
                    t.len = Integer.parseInt(s[4]);
                    t.freq_s = Integer.parseInt(s[5]);
                    t.freq_in = Integer.parseInt(s[6]);
                    t.lk = Integer.parseInt(s[7]);
                } else if (s.length == 9) {
                    Integer.parseInt(s[0]);
                    t.rank = Integer.parseInt(s[1]);
                    t.str = s[2];
                    if (s[3].startsWith("[")) {
                        t.cvalue = Double.parseDouble(s[4]);
                        t.contrast = 0.0;
                    } else {
                        t.cvalue = Double.parseDouble(s[3]);
                        t.contrast = 0.0;
                    }
                    t.len = Integer.parseInt(s[5]);
                    t.freq_s = Integer.parseInt(s[6]);
                    t.freq_in = Integer.parseInt(s[7]);
                    t.lk = Integer.parseInt(s[8]);
                } else {
                    if (s.length != 10) break;
                    Integer.parseInt(s[0]);
                    t.rank = Integer.parseInt(s[1]);
                    t.str = s[2];
                    t.cvalue = Double.parseDouble(s[4]);
                    t.contrast = 0.0;
                    t.len = Integer.parseInt(s[6]);
                    t.freq_s = Integer.parseInt(s[7]);
                    t.freq_in = Integer.parseInt(s[8]);
                    t.lk = Integer.parseInt(s[9]);
                }
                newCTerms.put(t.str, t);
            }
            catch (Exception exception) {
                if (TermoPL.batchMode) {
                    System.out.println("Error occured while reading contrastive data.");
                    break;
                }
                JOptionPane.showMessageDialog(TermoPL.dialogOwner, "Error occured while reading contrastive data.", "Error", 0);
                break;
            }
        } while (!done && !this.cancelled);
        if (!done || this.cancelled) {
            newCTerms = null;
        }
        return newCTerms;
    }

    public HashMap<String, Term> loadContrastiveTerms(ObjectInputStream is) throws Exception {
        is.readBoolean();
        is.readBoolean();
        is.readInt();
        is.readInt();
        int nterms = is.readInt();
        is.readInt();
        is.readInt();
        is.readObject();
        is.readObject();
        is.readObject();
        is.readObject();
        is.readObject();
        is.readObject();
        HashMap<String, Term> newCTerms = new HashMap<String, Term>(nterms);
        int i = 0;
        while (i < nterms && !this.cancelled) {
            Term t = (Term)is.readObject();
            String str = this.calcSimplifiedForm(t);
            newCTerms.put(str, t);
            ++i;
        }
        if (this.cancelled) {
            newCTerms = null;
        }
        is.close();
        return newCTerms;
    }

    public void cancel() {
        this.cancelled = true;
        if (this.extractor != null) {
            this.extractor.cancel();
        }
        if (this.loaded) {
            if (this.termsView != null) {
                this.termsView.showProgress(false);
                this.termsView.setWarning("Cancelled.");
                this.termsView.setAccessory(this.extractAction);
            }
            if (this.formsView != null) {
                this.formsView.reset();
            }
            if (this.sentencesView != null) {
                this.sentencesView.reset();
            }
            if (this.groupsView != null) {
                this.groupsView.reset();
            }
        }
    }

    public void interrupt() {
        this.interrupted = true;
        if (this.extractor != null) {
            this.extractor.cancel();
        }
        if (this.loaded) {
            if (this.termsView != null) {
                this.termsView.showProgress(false);
            }
            if (this.formsView != null) {
                this.formsView.reset();
            }
            if (this.sentencesView != null) {
                this.sentencesView.reset();
            }
            if (this.groupsView != null) {
                this.groupsView.reset();
            }
        }
    }

    public void trim(boolean trimResults, boolean multiWordTermsOnly, boolean filterResults) {
        if (this.preferences.trimResults != trimResults) {
            TermoPL.preferences.trimResults = this.preferences.trimResults = trimResults;
            TermoPL.preferences.setModified(true);
        }
        if (this.preferences.multiWordTermsOnly != multiWordTermsOnly) {
            TermoPL.preferences.multiWordTermsOnly = this.preferences.multiWordTermsOnly = multiWordTermsOnly;
            TermoPL.preferences.setModified(true);
        }
        if (this.preferences.filterResults != filterResults) {
            TermoPL.preferences.filterResults = this.preferences.filterResults = filterResults;
            TermoPL.preferences.setModified(true);
        }
        if (this.terms != null) {
            String str;
            int tsize = this.terms.length;
            String string = str = this.termsView != null ? this.termsView.getSearchString() : "";
            if (filterResults && !str.equals("")) {
                tsize = this.trimMismatched(tsize);
            }
            if (multiWordTermsOnly) {
                tsize = this.trimTermsByLength(tsize);
            }
            if (trimResults) {
                tsize = this.trimLowRanked(tsize);
            }
            this.tableSize = tsize;
            this.sortTable(0, this.tableSize);
            if (this.termsView != null) {
                this.termsView.resetResults();
                this.termsView.resetSearch();
            }
            System.gc();
        }
    }

    public int trimMismatched(int tsize) {
        int i = 0;
        while (i < tsize) {
            if (!this.terms[i].isMatching()) {
                int j = i + 1;
                boolean found = false;
                while (j < tsize) {
                    if (this.terms[j].isMatching()) {
                        Term x = this.terms[j];
                        this.terms[j] = this.terms[i];
                        this.terms[i] = x;
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) break;
            }
            ++i;
        }
        tsize = i;
        return tsize;
    }

    public int trimTermsByLength(int tsize) {
        int i = 0;
        while (i < tsize) {
            if (this.terms[i].len < this.preferences.minLength || this.preferences.maxLength > 0 && this.terms[i].len > this.preferences.maxLength) {
                int j = i + 1;
                boolean found = false;
                while (j < tsize) {
                    if (this.terms[j].len >= this.preferences.minLength && (this.preferences.maxLength < 0 || this.terms[j].len <= this.preferences.maxLength)) {
                        Term x = this.terms[j];
                        this.terms[j] = this.terms[i];
                        this.terms[i] = x;
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) break;
            }
            ++i;
        }
        tsize = i;
        return tsize;
    }

    public int trimLowRanked(int tsize) {
        int sc = this.preferences.sortedColumn;
        this.preferences.sortedColumn = 1;
        int sp = this.preferences.sortPrefs[1];
        this.preferences.sortPrefs[1] = 1;
        Arrays.sort(this.terms, 0, tsize, this.sorter);
        int r = 0;
        int n = 0;
        int m = 0;
        int i = 0;
        i = 0;
        while (i < tsize) {
            Term t = this.terms[i];
            if (t.rank > r) {
                if (m >= this.preferences.maxResults) break;
                r = t.rank;
                ++m;
            }
            ++n;
            ++i;
        }
        tsize = n;
        this.preferences.sortPrefs[1] = sp;
        this.preferences.sortedColumn = sc;
        return tsize;
    }

    public void selectFiles() {
        this.addNewSourceFiles();
        switch (this.rebuild) {
            case 0: {
                if (this.termsView == null) break;
                this.termsView.setInfo(this.getStat());
                break;
            }
            case 1: 
            case 2: {
                if (this.newFiles != null) {
                    TermoPL.preferences.filePath = this.preferences.filePath = this.newFiles[0].getParentFile().getPath();
                    TermoPL.preferences.setModified(true);
                }
                if (this.termsView == null) break;
                this.termsView.setWarning("Extract terms.");
                this.termsView.setAccessory(this.extractAction);
                break;
            }
            case 3: {
                if (this.termsView == null) break;
                this.termsView.setWarning("No file selected for term extraction.");
                this.termsView.setAccessory(this.selectAction);
            }
        }
    }

    public File[] selectSourceFiles() {
        File file;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select File(s)");
        chooser.setFileSelectionMode(2);
        chooser.setApproveButtonText("Select");
        chooser.setApproveButtonMnemonic('S');
        chooser.setMultiSelectionEnabled(true);
        if (this.termsView != null) {
            this.termsView.setAccessory(null);
        }
        if (this.preferences.filePath != null && (file = new File(this.preferences.filePath)).exists()) {
            chooser.setCurrentDirectory(file);
        }
        if (chooser.showOpenDialog(TermoPL.dialogOwner) == 0) {
            return TermoPL.collectFiles(chooser.getSelectedFiles());
        }
        return null;
    }

    public void addNewSourceFiles() {
        SelectedFiles sf = new SelectedFiles(this);
        int res = sf.doDialog();
        if (res == 1) {
            this.corpusName = sf.getCorpusName();
            this.newFiles = sf.getNewFiles();
            this.oldFiles = sf.getOldFiles();
            this.rebuild = sf.rebuild();
            this.reuseTaggedFiles = sf.reuse();
            if (this.preferences.reuseTaggedFiles != this.reuseTaggedFiles) {
                this.preferences.reuseTaggedFiles = this.reuseTaggedFiles;
                if (!this.reuseTaggedFiles) {
                    this.preferences.makeIndex = false;
                    TermoPL.preferences.makeIndex = false;
                }
                TermoPL.preferences.reuseTaggedFiles = this.reuseTaggedFiles;
                TermoPL.preferences.save();
            }
        } else if (this.selectedFiles == null) {
            this.rebuild = 3;
        }
        sf.dispose();
    }

    public void selectContrastiveTerms() {
        String path = TermoPL.selectContrastiveCorpus();
        if (path != null) {
            this.preferences.contrastiveDataPath = path;
            if (this.termsView != null && this.preferences.applyContrastiveRanking) {
                this.termsView.setInfo("Compare terms.");
                this.termsView.setAccessory(this.compareAction);
            }
        }
    }

    public void compare() {
        boolean load = false;
        ContrastiveDataLoader loader = null;
        this.cancelled = false;
        this.preferences.applyContrastiveRanking = true;
        if (this.cterms == null) {
            if (this.preferences.contrastiveDataPath == null) {
                this.selectContrastiveTerms();
            }
            if (this.preferences.contrastiveDataPath != null) {
                load = true;
            }
        } else if (this.preferences.reloadContrastiveTerms) {
            load = true;
        }
        if (load) {
            if (this.termsView != null) {
                this.termsView.setAccessory(null);
                this.termsView.showProgress(true);
            }
            loader = new ContrastiveDataLoader(this.preferences.contrastiveDataPath);
        }
        CompareThread ct = new CompareThread(loader);
        ct.start();
    }

    public void finishCompare() {
        if (this.preferences.sortedColumn == 4) {
            Arrays.sort(this.terms, 0, this.tableSize, this.sorter);
        }
        if (this.termsView != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TermoPLDocument.this.termsView.setInfo(TermoPLDocument.this.getStat());
                    TermoPLDocument.this.termsView.setAccessory(null);
                    TermoPLDocument.this.termsView.showProgress(false);
                    TermoPLDocument.this.termsView.refreshColumns();
                }
            });
        }
        this.preferences.compare = false;
        this.preferences.reloadContrastiveTerms = false;
        this.preferences.repaint = false;
        this.modified = true;
    }

    public void merge() {
        File file;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Merge");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(TermoPL.TRM_FILTER);
        chooser.setApproveButtonText("Merge");
        chooser.setApproveButtonMnemonic('M');
        chooser.setApproveButtonToolTipText("Merge terms from selected file");
        if (this.preferences.filePath != null && (file = new File(this.preferences.filePath)).exists()) {
            chooser.setCurrentDirectory(file);
        }
        if (chooser.showOpenDialog(TermoPL.dialogOwner) == 0) {
            file = chooser.getSelectedFile();
            TermoPL.preferences.filePath = this.preferences.filePath = file.getParentFile().getPath();
            TermoPL.preferences.setModified(true);
            this.merge(file);
        }
    }

    public void merge(File file) {
        MergeThread mt = new MergeThread(file);
        if (this.termsView != null) {
            this.termsView.showProgress(true);
            this.termsView.changeProgress(3);
        }
        if (this.groupsView != null) {
            this.close(this.getWindow(4));
        }
        mt.start();
        if (TermoPL.batchMode) {
            try {
                mt.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void finalizeMerge() {
        if (this.termsView != null) {
            this.termsView.showProgress(false);
            this.termsView.setInfo(this.getStat());
            this.termsView.resetResults();
        }
    }

    public void allowCollectingForms(boolean f) {
        this.preferences.collectAllForms = f;
        if (this.preferences.collectAllForms) {
            if (this.termsView != null) {
                this.termsView.setWarning("Extract terms.");
                this.termsView.setAccessory(this.extractAction);
            }
        } else {
            TermoPLWindow wnd = this.getWindow(2);
            if (wnd != null) {
                wnd.close();
            }
            if (this.terms != null) {
                Term[] termArray = this.terms;
                int n = this.terms.length;
                int n2 = 0;
                while (n2 < n) {
                    Term t = termArray[n2];
                    t.trimForms();
                    ++n2;
                }
            }
            this.formsCollected = false;
        }
        this.modified = true;
    }

    public void allowIndexingSentences(boolean f) {
        this.preferences.makeIndex = f;
        if (this.preferences.makeIndex) {
            if (this.termsView != null) {
                this.termsView.setWarning("Extract terms.");
                this.termsView.setAccessory(this.extractAction);
            }
        } else {
            TermoPLWindow wnd = this.getWindow(3);
            if (wnd != null) {
                wnd.close();
            }
            if (this.terms != null) {
                Term[] termArray = this.terms;
                int n = this.terms.length;
                int n2 = 0;
                while (n2 < n) {
                    Term t = termArray[n2];
                    t.trimIndex();
                    ++n2;
                }
            }
            this.sentencesIndexed = false;
        }
        this.modified = true;
    }

    public boolean allowClose() {
        if (this.terms != null && this.modified) {
            int answer = JOptionPane.showConfirmDialog(TermoPL.dialogOwner, "Term set '" + this.getDocumentDisplayName() + "' has been modified.\n" + "Do you want to accept the changes?", "Term set modification", 1, 2);
            if (answer == 0) {
                this.save();
                return !this.modified;
            }
            return answer == 1;
        }
        return true;
    }

    public boolean allowClose(TermoPLWindow wnd) {
        boolean ok = true;
        if (wnd.getID() == 1) {
            ok = this.allowClose();
        }
        return ok;
    }

    public void close() {
        if (this.allowClose()) {
            this.waitForSaveThreadsToFinish();
            this.remove();
        }
    }

    public void close(TermoPLWindow wnd) {
        if (wnd.getID() == 1) {
            this.close();
        } else {
            this.remove(wnd);
        }
    }

    public void remove() {
        while (!this.windows.isEmpty()) {
            TermoPLWindow wnd = this.windows.removeFirst();
            this.remove(wnd);
        }
        TermoPL.application.closeDocument(this);
        System.gc();
    }

    public void remove(TermoPLWindow wnd) {
        switch (wnd.getID()) {
            case 1: {
                this.termsView = null;
                break;
            }
            case 2: {
                this.formsView = null;
                break;
            }
            case 3: {
                this.sentencesView = null;
                break;
            }
            case 4: {
                this.groupsView = null;
            }
        }
        this.windows.remove(wnd);
        TermoPL.zorder.remove(wnd);
        wnd.destroySelf();
    }

    public void save() {
        if (this.input == null || !this.input.getName().equals(String.valueOf(this.getOutputName()) + ".trm")) {
            this.saveAs();
        } else {
            this.save(this.input);
        }
    }

    public void saveAs() {
        File file;
        SaveFileChooser chooser = new SaveFileChooser();
        String name = String.valueOf(this.getOutputName()) + ".trm";
        chooser.setDialogTitle("Save");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(TermoPL.TRM_FILTER);
        chooser.setSelectedFile(new File(name));
        if (this.preferences.filePath != null && (file = new File(this.preferences.filePath)).exists()) {
            chooser.setCurrentDirectory(file);
        }
        if (chooser.showSaveDialog(TermoPL.dialogOwner) == 0) {
            file = chooser.getSelectedFile();
            MenuFactory.removeFromDocumentSwitchMenu(this);
            this.input = file;
            name = file.getName();
            this.docDisplayName = TermoPL.getDisplayName(name);
            this.docName = name;
            TermoPL.preferences.filePath = this.preferences.filePath = file.getParentFile().getPath();
            TermoPL.preferences.setModified(true);
            TermoPL.application.updateRecentFiles(file.getPath());
            MenuFactory.addToDocumentSwitchMenu(this);
            this.changeTitles();
            this.save(file);
        }
    }

    public void save(File file) {
        SaveThread saveThread = new SaveThread(file);
        if (!TermoPL.batchMode && this.termsView != null) {
            this.termsView.setAccessory(null);
            this.termsView.showProgress(true, false);
            this.termsView.pleaseWait();
        }
        this.saveThreads[0] = saveThread;
        saveThread.start();
    }

    public void save(ObjectOutputStream output) throws IOException {
        File f;
        int i;
        Object ftable;
        output.writeBoolean(this.formsCollected);
        output.writeBoolean(this.sentencesIndexed);
        output.writeInt(this.nsentences);
        output.writeInt(this.ntokens);
        output.writeInt(this.nterms);
        int ncterms = this.cterms == null ? 0 : this.cterms.size();
        output.writeInt(ncterms);
        output.writeInt(this.rebuild);
        output.writeObject(this.corpusName);
        this.preferences.save(output);
        if (this.selectedFiles == null) {
            output.writeObject(this.selectedFiles);
        } else {
            ftable = new String[this.selectedFiles.length];
            i = 0;
            while (i < this.selectedFiles.length) {
                f = this.selectedFiles[i];
                ftable[i] = this.preferences.getRelativizedPath(this.preferences.workSpace, f.getAbsolutePath(), "WORKSPACE");
                ++i;
            }
            output.writeObject(ftable);
        }
        if (this.newFiles == null) {
            output.writeObject(this.newFiles);
        } else {
            ftable = new String[this.newFiles.length];
            i = 0;
            while (i < this.newFiles.length) {
                f = this.newFiles[i];
                ftable[i] = this.preferences.getRelativizedPath(this.preferences.workSpace, f.getAbsolutePath(), "WORKSPACE");
                ++i;
            }
            output.writeObject(ftable);
        }
        if (this.oldFiles == null) {
            output.writeObject(this.oldFiles);
        } else {
            ftable = new String[this.oldFiles.length];
            i = 0;
            while (i < this.oldFiles.length) {
                f = this.oldFiles[i];
                ftable[i] = this.preferences.getRelativizedPath(this.preferences.workSpace, f.getAbsolutePath(), "WORKSPACE");
                ++i;
            }
            output.writeObject(ftable);
        }
        if (this.analyzedFiles == null) {
            output.writeObject(null);
        } else {
            ftable = new ArrayList(this.analyzedFiles.size());
            for (FileDescr fd : this.analyzedFiles) {
                ((ArrayList)ftable).add(new Pair<String, Integer>(this.preferences.getRelativizedPath(this.preferences.workSpace, fd.file.getAbsolutePath(), "WORKSPACE"), fd.type));
            }
            try {
                output.writeObject(ftable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.terms != null) {
            Term[] termArray = this.terms;
            int n = this.terms.length;
            int n2 = 0;
            while (n2 < n) {
                Term t = termArray[n2];
                output.writeObject(t);
                ++n2;
            }
        }
        if (this.cterms != null) {
            for (Map.Entry<String, Term> entry : this.cterms.entrySet()) {
                output.writeObject(entry.getKey());
                output.writeObject(entry.getValue());
            }
        }
        output.flush();
        output.close();
        this.modified = false;
    }

    public void selectWorkspace() {
        String newWorkSpace;
        Workspace workspace = new Workspace(this.preferences.workSpace);
        int res = workspace.doDialog();
        if (res == 1 && !(newWorkSpace = workspace.getCurrentWorkspace()).equals(this.preferences.workSpace)) {
            TermoPL.preferences.workSpace = TermoPL.preferences.filePath = (this.preferences.workSpace = (this.preferences.filePath = workspace.getCurrentWorkspace()));
            TermoPL.preferences.setModified(true);
            this.modified = true;
        }
        workspace.dispose();
    }

    public void export(int exportType) {
        File file;
        SaveFileChooser chooser = new SaveFileChooser();
        String name = this.getOutputName();
        switch (exportType) {
            case 1: {
                name = String.valueOf(name) + ".txt";
                chooser.setDialogTitle("Export Results");
                break;
            }
            case 2: {
                name = String.valueOf(name) + "_forms.txt";
                chooser.setDialogTitle("Export Forms");
                break;
            }
            case 3: {
                name = String.valueOf(name) + "_sentences.txt";
                chooser.setDialogTitle("Export Sentences");
                break;
            }
            case 4: {
                name = String.valueOf(name) + "_groups.xml";
                chooser.setDialogTitle("Export Term Groups");
            }
        }
        chooser.setSelectedFile(new File(name));
        chooser.setApproveButtonText("Export");
        chooser.setApproveButtonMnemonic('E');
        if (this.preferences.filePath != null && (file = new File(this.preferences.filePath)).exists()) {
            chooser.setCurrentDirectory(file);
        }
        if (chooser.showSaveDialog(TermoPL.dialogOwner) == 0) {
            file = chooser.getSelectedFile();
            TermoPL.preferences.filePath = this.preferences.filePath = file.getParentFile().getPath();
            TermoPL.preferences.setModified(true);
            this.export(file, exportType);
        }
    }

    public void export(File file, int exportType) {
        try {
            PrintWriter pw = new PrintWriter(file, "UTF8");
            ExportThread exportThread = new ExportThread(pw, exportType);
            if (!TermoPL.batchMode && this.termsView != null) {
                this.termsView.setAccessory(null);
                this.termsView.showProgress(true, false);
                this.termsView.pleaseWait();
            }
            switch (exportType) {
                case 1: {
                    this.saveThreads[1] = exportThread;
                    break;
                }
                case 2: {
                    this.saveThreads[2] = exportThread;
                    break;
                }
                case 3: {
                    this.saveThreads[3] = exportThread;
                    break;
                }
                case 4: {
                    this.saveThreads[4] = exportThread;
                }
            }
            exportThread.start();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void export(PrintWriter pw, int exportType) {
        switch (exportType) {
            case 1: {
                this.exportResults(pw);
                break;
            }
            case 2: {
                this.exportForms(pw);
                break;
            }
            case 3: {
                this.exportSentences(pw);
                break;
            }
            case 4: {
                this.exportGroups(pw);
            }
        }
        pw.flush();
        pw.close();
    }

    public void exportResults(PrintWriter pw) {
        BaseFormGuesser guesser = null;
        if (this.preferences.saveBF && !this.preferences.calculateBaseForms) {
            guesser = this.preferences.useUD ? new BaseFormGuesser() : new BaseFormGuesser(this.preferences.tagset);
        }
        int i = 0;
        while (i < this.tableSize) {
            Term t = this.terms[i];
            boolean addTab = false;
            if (this.preferences.saveCount) {
                pw.print(i + 1);
                addTab = true;
            }
            if (this.preferences.saveRank) {
                if (addTab) {
                    pw.print("\t");
                }
                pw.print(t.rank);
                addTab = true;
            }
            if (this.preferences.saveSF) {
                if (addTab) {
                    pw.print("\t");
                }
                if (this.preferences.calculateBaseForms) {
                    pw.print(this.calcSimplifiedForm(t));
                } else {
                    pw.print(t.str);
                }
                addTab = true;
            }
            if (this.preferences.saveBF) {
                if (addTab) {
                    pw.print("\t");
                }
                if (this.preferences.saveSF) {
                    pw.print("[");
                }
                if (this.preferences.calculateBaseForms) {
                    pw.print(t.str);
                } else {
                    pw.print(guesser.calcBaseForm(t));
                }
                if (this.preferences.saveSF) {
                    pw.print("]");
                }
                addTab = true;
            }
            if (this.preferences.saveCV) {
                if (addTab) {
                    pw.print("\t");
                }
                pw.print(t.cvalue);
                addTab = true;
            }
            if (this.preferences.saveComp && this.preferences.applyContrastiveRanking && this.cterms != null) {
                if (addTab) {
                    pw.print("\t");
                }
                pw.print(t.contrast);
                addTab = true;
            }
            if (this.preferences.saveLen) {
                if (addTab) {
                    pw.print("\t");
                }
                pw.print(t.len);
                addTab = true;
            }
            if (this.preferences.saveFreqs) {
                if (addTab) {
                    pw.print("\t");
                }
                pw.print(t.freq_s);
                addTab = true;
            }
            if (this.preferences.saveFreqin) {
                if (addTab) {
                    pw.print("\t");
                }
                pw.print(t.freq_in);
                addTab = true;
            }
            if (this.preferences.saveContext) {
                if (addTab) {
                    pw.print("\t");
                }
                pw.print(t.lk);
            }
            pw.println();
            ++i;
        }
    }

    public void exportForms(PrintWriter pw) {
        int i = 0;
        while (i < this.tableSize) {
            Term t = this.terms[i];
            boolean appendSep = false;
            pw.print("[");
            pw.print(t.str);
            pw.println("]");
            pw.println();
            if (t.getForms() != null) {
                for (Form f : t.getForms()) {
                    String str = f.toString();
                    if (appendSep) {
                        pw.print(", ");
                    }
                    pw.print(str);
                    appendSep = true;
                }
                pw.println();
                pw.println();
            }
            ++i;
        }
    }

    public void exportSentences(PrintWriter pw) {
        RandomAccessFile source = null;
        File sourceFile = null;
        int i = 0;
        while (i < this.tableSize) {
            Term t = this.terms[i];
            pw.print("[");
            pw.print(t.str);
            pw.println("]");
            pw.println();
            long pos = -1L;
            long oldPos = -1L;
            int fileID = -1;
            int oldFileID = -1;
            if (t.getSentenceRef() != null) {
                for (SentenceRef ref : t.getSentenceRef()) {
                    if (ref instanceof SentenceRefEx) {
                        fileID = ((SentenceRefEx)ref).fileID;
                    }
                    if ((pos = ref.start) == oldPos && fileID == oldFileID) continue;
                    LinkedList<Token> sentence = null;
                    LinkedList mwtList = null;
                    FileDescr fd = this.getAnalyzedFile(ref.getFileID());
                    oldPos = pos;
                    oldFileID = fileID;
                    try {
                        if (sourceFile != fd.file) {
                            sourceFile = fd.file;
                            source = new RandomAccessFile(sourceFile, "r");
                        }
                        Pair<LinkedList<Token>, LinkedList<MultiWordToken>> pair = CorpusReader.getSentence(source, fd.type, ref.start, ref.len);
                        sentence = (LinkedList<Token>)pair.first;
                        mwtList = (LinkedList)pair.second;
                        if (mwtList != null) {
                            sentence = CorpusReader.replaceMWT((LinkedList<? extends Token>)sentence, mwtList);
                        }
                        boolean appendSpace = false;
                        for (Token tok : sentence) {
                            if (appendSpace) {
                                pw.print(" ");
                            }
                            pw.print(tok.form);
                            appendSpace = tok.spaceAfter;
                        }
                        pw.println();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(0);
                    }
                }
                pw.println();
            }
            ++i;
        }
    }

    public void exportGroups(PrintWriter pw) {
        pw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        pw.write("<term_list>\n");
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            TermEx t = (TermEx)term;
            this.exportTerm(t, pw);
            ++n2;
        }
        pw.write("</term-list>\n");
    }

    public void exportTerm(TermEx term, PrintWriter pw) {
        pw.write("\t<term id=\"" + this.toXML(term.id) + "\" name=\"" + this.toXML(term.str) + "\">\n");
        this.exportEquivalentTerms(term, pw);
        this.exportTerms(term.collectParents(this.termMap), "parent", pw);
        this.exportTerms(term.collectChildren(this.termMap), "child", pw);
        this.exportRelated(term, pw);
        pw.write("\t</term>\n");
    }

    public void exportEquivalentTerms(TermEx term, PrintWriter pw) {
        LinkedList<String> equiv = term.getEquivalentTerms();
        if (equiv != null) {
            for (String e : equiv) {
                if (e == term.id) continue;
                pw.write("\t\t<eq id=\"" + e + "\"/>\n");
            }
        }
    }

    public void exportTerms(LinkedList<String> terms, String elementName, PrintWriter pw) {
        if (terms != null) {
            for (String t : terms) {
                pw.write("\t\t<" + elementName + " id=\"" + this.toXML(t) + "\"/>\n");
            }
        }
    }

    public void exportRelated(TermEx term, PrintWriter pw) {
        LinkedList<Pair<String, LinkedList<WordReplacement>>> related = term.collectRelated(this.termMap);
        if (related != null) {
            for (Pair pair : related) {
                pw.write("\t\t<rel id=\"" + (String)pair.first + "\">\n");
                for (WordReplacement wr : (LinkedList)pair.second) {
                    LinkedList<Integer> relTypes = wr.relTypes;
                    if (relTypes == null) {
                        pw.write("\t\t\t<nosubst/>\n");
                        continue;
                    }
                    String repl = relTypes.getFirst() < 0 ? wr.expression : wr.word;
                    pw.write("\t\t\t<subst word=\"" + this.toXML(wr.word) + "\" expr=\"" + this.toXML(wr.expression) + "\" replaced=\"" + this.toXML(repl) + "\">\n");
                    for (Integer type : relTypes) {
                        if (type < 0) {
                            type = -type.intValue();
                        }
                        pw.write("\t\t\t\t<reltype id=\"" + type + "\" name=\"" + this.toXML(WordNet.getName(type)) + "\"/>\n");
                    }
                    pw.write("\t\t\t</subst>\n");
                }
                pw.write("\t\t</rel>\n");
            }
        }
    }

    public String toXML(String str) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            Character ch = Character.valueOf(str.charAt(i));
            if (ch.charValue() == '&') {
                buffer.append("&amp;");
            } else if (ch.charValue() == '<') {
                buffer.append("&lt;");
            } else if (ch.charValue() == '>') {
                buffer.append("&gt;");
            } else if (ch.charValue() == '\'') {
                buffer.append("&apos;");
            } else if (ch.charValue() == '\"') {
                buffer.append("&quot;");
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getOutputName() {
        String contrastiveCorpusName = null;
        if (this.cterms != null) {
            contrastiveCorpusName = TermoPL.getFileName(this.preferences.contrastiveDataPath);
        }
        return this.getOutputName(this.corpusName, contrastiveCorpusName);
    }

    public String getOutputName(String corpusName, String contrastiveCorpusName) {
        String name = "";
        if (this.preferences.applyContrastiveRanking && this.cterms != null) {
            name = "comp_";
        }
        if (this.preferences.trimResults) {
            name = String.valueOf(name) + "top_ranked_";
        }
        if (this.preferences.multiWordTermsOnly) {
            name = String.valueOf(name) + "multi-word_terms_";
        }
        name = String.valueOf(name) + corpusName;
        name = this.preferences.useUD ? String.valueOf(name) + "_UD" : (this.preferences.useNPMIMethod ? String.valueOf(name) + "_NPMI" + this.preferences.NPMIMethod : String.valueOf(name) + "_NONPMI");
        if (this.preferences.applyContrastiveRanking && this.cterms != null) {
            name = String.valueOf(name) + "_vs_" + contrastiveCorpusName + "_";
            switch (this.preferences.contrastiveRankingMethod) {
                case 1: {
                    name = String.valueOf(name) + "LL";
                    break;
                }
                case 2: {
                    name = String.valueOf(name) + "TFITF";
                    break;
                }
                case 3: {
                    name = String.valueOf(name) + "CSmw";
                    break;
                }
                case 4: {
                    name = String.valueOf(name) + "TW";
                }
            }
        }
        return name;
    }

    public void createWindow(int ID) {
        String title;
        JPanel view;
        switch (ID) {
            case 1: {
                view = this.termsView = new TermsView(this);
                title = "Terms";
                break;
            }
            case 2: {
                this.formsView = new FormsView(this);
                view = this.formsView;
                title = "Forms";
                break;
            }
            case 3: {
                this.sentencesView = new SentencesView(this);
                view = this.sentencesView;
                title = "Sentences";
                break;
            }
            case 4: {
                this.groupsView = new GroupsView(this);
                view = this.groupsView;
                title = "Related Term Groups";
                break;
            }
            default: {
                title = "";
                view = null;
            }
        }
        Container wnd = TermoPL.isMacOS ? new TermoPLMacWindow(this, ID, view) : new TermoPLDefaultWindow(this, ID, view);
        wnd.setTitle(String.valueOf(title) + " [" + this.getDocumentDisplayName() + "]");
        this.windows.add((TermoPLWindow)((Object)wnd));
        TermoPL.zorder.add((TermoPLWindow)((Object)wnd));
        this.setWindowBounds((TermoPLWindow)((Object)wnd));
        ((Component)wnd).setVisible(true);
    }

    public void setWindowBounds(TermoPLWindow wnd) {
        Rectangle rect = this.preferences.getBounds(wnd.getID());
        if (rect.width == 0) {
            Rectangle r = TermoPL.isMacOS ? WindowUtils.getScreenRect() : WindowUtils.getDesktopRect();
            switch (wnd.getID()) {
                case 1: {
                    rect.width = wnd.getPreferredSize().width;
                    rect.height = (int)(0.9 * r.getHeight());
                    break;
                }
                case 2: {
                    rect.width = 400;
                    rect.height = 200;
                    break;
                }
                case 3: 
                case 4: {
                    rect.width = (int)(0.5 * r.getWidth());
                    rect.height = (int)(0.9 * r.getHeight());
                }
            }
            wnd.setBounds(rect);
            if (TermoPL.isMacOS) {
                WindowUtils.centerOnScreen((Component)((Object)wnd));
            } else {
                WindowUtils.centerOnDesktop((Component)((Object)wnd));
            }
        } else {
            wnd.setBounds(rect);
        }
    }

    public TermoPLWindow getWindow(int ID) {
        for (TermoPLWindow wnd : this.windows) {
            if (wnd.getID() != ID) continue;
            return wnd;
        }
        return null;
    }

    public LinkedList<TermoPLWindow> getWindows() {
        return this.windows;
    }

    public void changeTitles() {
        for (TermoPLWindow wnd : this.windows) {
            String title = wnd.getTitle();
            int i = title.indexOf(91);
            title = String.valueOf(title.substring(0, i)) + "[" + this.getDocumentDisplayName() + "]";
            wnd.setTitle(title);
        }
    }

    public String getStat() {
        String stat = "<html><b>Corpus name:</b> " + this.corpusName + "; " + "<b>Sentences:</b> " + this.nsentences + "; " + "<b>Tokens:</b> " + this.ntokens + "; " + "<b>Terms:</b> " + this.nterms;
        if (this.preferences.applyContrastiveRanking && this.cterms != null) {
            stat = String.valueOf(stat) + "; <b>Compared with:</b> " + TermoPL.getFileName(this.preferences.contrastiveDataPath);
        }
        stat = String.valueOf(stat) + "</html>";
        return stat;
    }

    public void prepareTable() {
        int rank = 1;
        int sc = this.preferences.sortedColumn;
        int s = this.preferences.sortPrefs[3];
        double lastValue = -1.0;
        if (!TermoPL.batchMode && this.termsView != null) {
            this.termsView.finalize();
        }
        this.preferences.sortedColumn = 3;
        this.preferences.sortPrefs[3] = -1;
        this.sortTable();
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            term.rank = rank++;
            if (lastValue >= 0.0 && term.cvalue < lastValue) {
                ++term.rank;
            }
            lastValue = term.cvalue;
            ++n2;
        }
        this.preferences.sortedColumn = sc;
        this.preferences.sortPrefs[3] = s;
        if (this.termsView != null) {
            String str = this.termsView.getSearchString();
            this.termsView.setSearchString("");
            this.termsView.search(str);
        }
        this.trim(this.preferences.trimResults, this.preferences.multiWordTermsOnly, this.preferences.filterResults);
    }

    public void showResults() {
        if (this.termsView != null) {
            this.termsView.showProgress(false);
            if (this.cancelled) {
                this.termsView.setWarning("Cancelled.");
                this.termsView.setAccessory(this.extractAction);
            } else if (this.nterms > 0) {
                this.termsView.setInfo(this.getStat());
                this.termsView.resetResults();
            } else {
                this.termsView.setWarning("No terms found.");
                this.termsView.setAccessory(null);
            }
        }
    }

    public void setCTerms(boolean calcSimplifiedForms) {
        if (this.cterms != null) {
            Term[] termArray = this.terms;
            int n = this.terms.length;
            int n2 = 0;
            while (n2 < n) {
                Term t = termArray[n2];
                String str = calcSimplifiedForms ? this.calcSimplifiedForm(t) : t.str;
                t.setCTerm(this.cterms.get(str));
                ++n2;
            }
        }
    }

    public void applyContrastiveRanking() {
        if (this.cterms != null) {
            double s = 0.0;
            double S = 0.0;
            boolean useCValues = this.preferences.contrastiveRankingMethod == 4 ? false : this.preferences.useCValues;
            Term[] termArray = this.terms;
            int n = this.terms.length;
            int n2 = 0;
            while (n2 < n) {
                Term t = termArray[n2];
                t.setStatus((byte)-1);
                s += useCValues ? t.cvalue : (double)t.freq_s;
                ++n2;
            }
            for (Term t : this.cterms.values()) {
                S += useCValues ? t.cvalue : (double)t.freq_s;
            }
            switch (this.preferences.contrastiveRankingMethod) {
                case 1: {
                    this.computeLL(s, S, !this.preferences.useCValues);
                    break;
                }
                case 2: {
                    this.computeTFITF(s, S, !this.preferences.useCValues);
                    break;
                }
                case 3: {
                    this.computeCSmw(s, S, !this.preferences.useCValues);
                    break;
                }
                case 4: {
                    this.computeTW(s, S);
                }
            }
        }
    }

    public void computeLL(double s, double S, boolean useFrq) {
        Term t;
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            t = termArray[n2];
            Term ct = t.getCTerm();
            double F = ct == null ? 0.0 : (useFrq ? (double)ct.freq_s : ct.cvalue);
            t.contrast = F;
            if (this.preferences.applyContrastiveRankingForTopRankedTerms && t.cvalue <= this.preferences.mincvalue || this.preferences.applyContrastiveRankingForFrequentTerms && t.freq_s <= this.preferences.minfrq) {
                t.setStatus((byte)10);
            }
            ++n2;
        }
        termArray = this.terms;
        n = this.terms.length;
        n2 = 0;
        while (n2 < n) {
            t = termArray[n2];
            if (t.getStatus() != 10) {
                double r1 = useFrq ? (double)t.freq_s : t.cvalue;
                double r2 = t.contrast;
                double Ef = s * (r1 + r2) / (s + S);
                double EF = S * (r1 + r2) / (s + S);
                t.contrast = r1 == 0.0 && r2 == 0.0 ? 0.0 : (r1 == 0.0 || r2 == 0.0 ? Double.NEGATIVE_INFINITY : 2.0 * (r1 * Math.log10(r1 / Ef) + r2 * Math.log10(r2 / EF)));
                r1 = 100000.0 * r1 / s;
                if ((r2 = 100000.0 * r2 / S) == 0.0) {
                    t.setStatus((byte)11);
                } else {
                    t.setStatus(this.getStatus(r1, r2));
                }
            } else {
                t.contrast = 0.0;
            }
            ++n2;
        }
    }

    public void computeTFITF(double s, double S, boolean useFrq) {
        Term t;
        double N = s;
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            t = termArray[n2];
            Term ct = t.getCTerm();
            double F = ct == null ? 0.0 : (useFrq ? (double)ct.freq_s : ct.cvalue);
            t.contrast = F;
            N += F;
            if (this.preferences.applyContrastiveRankingForTopRankedTerms && t.cvalue <= this.preferences.mincvalue || this.preferences.applyContrastiveRankingForFrequentTerms && t.freq_s <= this.preferences.minfrq) {
                t.setStatus((byte)10);
            }
            ++n2;
        }
        termArray = this.terms;
        n = this.terms.length;
        n2 = 0;
        while (n2 < n) {
            t = termArray[n2];
            if (t.getStatus() != 10) {
                double r1 = useFrq ? (double)t.freq_s : t.cvalue;
                double r2 = t.contrast;
                t.contrast = r1 == 0.0 ? Double.NEGATIVE_INFINITY : Math.log10(r1) * Math.log10(N / (r1 + r2));
                r1 = 100000.0 * r1 / s;
                if ((r2 = 100000.0 * r2 / S) == 0.0) {
                    t.setStatus((byte)11);
                } else {
                    t.setStatus(this.getStatus(r1, r2));
                }
            } else {
                t.contrast = 0.0;
            }
            ++n2;
        }
    }

    public void computeCSmw(double s, double S, boolean useFrq) {
        Term t;
        double N = 0.0;
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            t = termArray[n2];
            Term ct = t.getCTerm();
            double F = ct == null ? 0.0 : (useFrq ? (double)ct.freq_s : ct.cvalue);
            t.contrast = F;
            N += F;
            if (this.preferences.applyContrastiveRankingForTopRankedTerms && t.cvalue <= this.preferences.mincvalue || this.preferences.applyContrastiveRankingForFrequentTerms && t.freq_s <= this.preferences.minfrq) {
                t.setStatus((byte)10);
            }
            ++n2;
        }
        termArray = this.terms;
        n = this.terms.length;
        n2 = 0;
        while (n2 < n) {
            t = termArray[n2];
            if (t.getStatus() != 10) {
                double r1 = useFrq ? (double)t.freq_s : t.cvalue;
                double r2 = t.contrast;
                t.contrast = r1 == 0.0 ? Double.NEGATIVE_INFINITY : (r2 == 0.0 ? Double.POSITIVE_INFINITY : Math.log10(Math.log10(r1) * N * r1 / r2));
                r1 = 100000.0 * r1 / s;
                if ((r2 = 100000.0 * r2 / S) == 0.0) {
                    t.setStatus((byte)11);
                } else {
                    t.setStatus(this.getStatus(r1, r2));
                }
            } else {
                t.contrast = 0.0;
            }
            ++n2;
        }
    }

    public void computeTW(double s, double S) {
        Term[] termArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            Term ct = t.getCTerm();
            double F = ct == null ? 0.0 : (double)ct.freq_s;
            t.contrast = F;
            if (this.preferences.applyContrastiveRankingForTopRankedTerms && t.cvalue <= this.preferences.mincvalue || this.preferences.applyContrastiveRankingForFrequentTerms && t.freq_s <= this.preferences.minfrq) {
                t.setStatus((byte)10);
            } else {
                double r1 = t.freq_s;
                double r2 = F;
                r1 = 100000.0 * r1 / s;
                if ((r2 = 100000.0 * r2 / S) == 0.0) {
                    t.setStatus((byte)11);
                } else {
                    t.setStatus(this.getStatus(r1, r2));
                }
            }
            ++n2;
        }
        double[] DCArray = new double[this.terms.length];
        double maxDC = 0.0;
        int i = 0;
        Term[] termArray2 = this.terms;
        int n3 = this.terms.length;
        int n4 = 0;
        while (n4 < n3) {
            Term t = termArray2[n4];
            double freqt = 0.0;
            double DC = 0.0;
            for (DocFreq dc : t.getDocFreq()) {
                freqt += (double)dc.freq;
            }
            for (DocFreq dc : t.getDocFreq()) {
                double pt = (double)dc.freq / freqt;
                DC += pt * Math.log10(pt);
            }
            DC = -DC;
            DCArray[i++] = DC;
            if (maxDC < DC) {
                maxDC = DC;
            }
            ++n4;
        }
        i = 0;
        if (maxDC == 0.0) {
            maxDC = 1.0;
        }
        termArray2 = this.terms;
        n3 = this.terms.length;
        n4 = 0;
        while (n4 < n3) {
            Term t = termArray2[n4];
            double p = (double)t.freq_s / s;
            double P = t.contrast / S;
            double DR = p / Math.max(p, P);
            t.contrast = this.preferences.alpha * DR + this.preferences.beta * DCArray[i++] / maxDC;
            ++n4;
        }
    }

    public byte getStatus(double f, double F) {
        double result = f >= F ? f / F : -F / f;
        if (result < -9.0) {
            return 0;
        }
        if (result >= -9.0 && result < -7.0) {
            return 1;
        }
        if (result >= -7.0 && result < -5.0) {
            return 2;
        }
        if (result >= -5.0 && result < -3.0) {
            return 3;
        }
        if (result >= -3.0 && result < -1.0) {
            return 4;
        }
        if (result >= 1.0 && result < 3.0) {
            return 5;
        }
        if (result >= 3.0 && result < 5.0) {
            return 6;
        }
        if (result >= 5.0 && result < 7.0) {
            return 7;
        }
        if (result >= 7.0 && result < 9.0) {
            return 8;
        }
        return 9;
    }

    public String calcBaseForm(Term t, BaseFormGuesser guesser) {
        return guesser.calcBaseForm(t);
    }

    public void calculateBaseForms() {
        if (this.extractor == null && this.termsView != null) {
            this.termsView.showProgress(true);
        }
        this.changeProgress(5);
        this.termQueue = new ArrayBlockingQueue<Term>(512);
        this.countDown = new CountDownLatch(MAX_THREADS + 1);
        ProcessTerms th = new ProcessTerms();
        th.start();
        Thread[] bft = new Thread[MAX_THREADS];
        int i = 0;
        while (i < MAX_THREADS) {
            bft[i] = new BaseFormThread();
            ++i;
        }
        i = 0;
        while (i < MAX_THREADS) {
            bft[i].start();
            ++i;
        }
        try {
            this.countDown.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.extractor == null && this.termsView != null) {
            this.termsView.showProgress(false);
        }
        if (this.termsView != null) {
            this.termsView.search();
        }
    }

    public String calcSimplifiedForm(Term t) {
        Form f = t.getForms().getFirst();
        StringBuffer buffer = new StringBuffer();
        Token prev = null;
        int index = 1;
        int prevIndex = -1;
        for (MatchedToken mt : f.getTokens()) {
            Token tok = mt.token;
            if (prev != null) {
                index = tok instanceof UDToken ? ((UDToken)tok).index : (tok instanceof MultiWordToken ? ((MultiWordToken)tok).endToken() : prevIndex + 1);
                if (prev.spaceAfter || index > prevIndex + 1) {
                    buffer.append(" ");
                    buffer.append(tok.lemma);
                } else {
                    buffer.append(tok.lemma);
                }
            } else {
                buffer.append(tok.lemma);
            }
            prev = tok;
            prevIndex = index;
        }
        return buffer.toString();
    }

    public void calculateSimplifiedForms() {
        this.changeProgress(5);
        this.termQueue = new ArrayBlockingQueue<Term>(512);
        this.countDown = new CountDownLatch(MAX_THREADS + 1);
        Thread th = new ProcessTerms();
        th.start();
        int i = 0;
        while (i < MAX_THREADS) {
            th = new SimplifiedFormThread();
            th.start();
            ++i;
        }
        try {
            this.countDown.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.termsView != null) {
            this.termsView.search();
        }
    }

    public void recalculateForms() {
        if (this.termsView != null) {
            this.termsView.showProgress(true, false);
        }
        if (this.preferences.calculateBaseForms) {
            this.calculateBaseForms();
        } else {
            this.calculateSimplifiedForms();
        }
        if (this.preferences.sortedColumn == 2) {
            Arrays.sort(this.terms, 0, this.tableSize, this.sorter);
        }
        if (this.termsView != null) {
            this.termsView.showProgress(false);
        }
    }

    public void sortTable() {
        Arrays.sort(this.terms, this.sorter);
    }

    public void sortTable(int first, int num) {
        Arrays.sort(this.terms, first, num, this.sorter);
    }

    public void sortTable(int column) {
        if (this.preferences.sortedColumn == column) {
            this.preferences.sortPrefs[column] = -this.preferences.sortPrefs[column];
        } else {
            this.preferences.sortedColumn = column;
        }
        TermoPL.preferences.sortedColumn = this.preferences.sortedColumn;
        TermoPL.preferences.setModified(true);
        this.sortTable(0, this.tableSize);
    }

    public void changeProgress(int type) {
        if (!TermoPL.batchMode && this.termsView != null) {
            this.termsView.changeProgress(type);
        }
    }

    public void reportTagging(String fName) {
        if (!TermoPL.batchMode && this.termsView != null) {
            this.termsView.reportTagging(fName);
        }
    }

    public void reportPreprocessing(String fName) {
        if (!TermoPL.batchMode && this.termsView != null) {
            this.termsView.reportPreprocessing(fName);
        }
    }

    public void report(String fName, int count) {
        if (!TermoPL.batchMode && this.termsView != null) {
            this.termsView.report(fName, count);
        }
    }

    public void report(int count, float progress) {
        if (!TermoPL.batchMode && this.termsView != null) {
            this.termsView.report(count, progress);
        }
    }

    public void report(int processed, int max, float value) {
        if (!TermoPL.batchMode && this.termsView != null) {
            this.termsView.report(processed, max, value);
        }
    }

    public void report(float value) {
        if (!TermoPL.batchMode && this.termsView != null) {
            this.termsView.report(value);
        }
    }

    public void setAcceptDET(int f) {
        this.acceptDET = f;
    }

    public int acceptDET() {
        if (this.preferences.useUD) {
            return this.acceptDET;
        }
        return -1;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public File[] getSelectedFiles() {
        return this.selectedFiles;
    }

    public File[] getOldFiles() {
        return this.oldFiles;
    }

    public File[] getNewFiles() {
        return this.newFiles;
    }

    public LinkedList<FileDescr> getAnalyzedFiles() {
        return this.analyzedFiles;
    }

    public FileDescr getAnalyzedFile(int fileID) {
        FileDescr descr = this.analyzedFiles.get(fileID);
        if (descr.type == -1) {
            descr = new FileDescr(new File(String.valueOf(descr.file.getPath()) + ".trm"), 3);
        }
        return descr;
    }

    public Set<String> getStopWords() {
        if (this.preferences.checkStopWords && this.preferences.stopWords != null) {
            if (this.preferences.stopWordSet == null) {
                this.preferences.stopWordSet = new HashSet<String>();
                this.preferences.stopWordSet.addAll(this.preferences.stopWords);
            }
            return this.preferences.stopWordSet;
        }
        return null;
    }

    public Set<String> getCommonTerms() {
        if (this.preferences.removeCommonTerms && this.preferences.commonTerms != null) {
            if (this.preferences.commonTermSet == null) {
                this.preferences.commonTermSet = new HashSet<String>();
                for (CommonTerm ct : this.preferences.commonTerms) {
                    this.preferences.commonTermSet.add(ct.sf);
                }
            }
            return this.preferences.commonTermSet;
        }
        return null;
    }

    public Template getCompoundPrepositions() {
        if (this.preferences.removeCompoundPreps) {
            return this.preferences.compoundPrepositions;
        }
        return null;
    }

    public Template getSearchTemplate() {
        return this.preferences.template;
    }

    public boolean useDocID() {
        return this.preferences.applyContrastiveRanking && this.preferences.contrastiveRankingMethod == 4;
    }

    public int changeDocID(int docNumber) {
        if (this.useDocID()) {
            return docNumber + 1;
        }
        return docNumber;
    }

    public Term[] getTerms() {
        return this.terms;
    }

    public HashMap<String, Term> getTermMap() {
        return this.termMap;
    }

    public HashMap<String, Term> getCTerms() {
        return this.cterms;
    }

    public int getTableSize() {
        return this.tableSize;
    }

    public TermsView getTermsView() {
        return this.termsView;
    }

    public FormsView getFormsView() {
        return this.formsView;
    }

    public SentencesView getSentencesView() {
        return this.sentencesView;
    }

    public GroupsView getGroupsView() {
        return this.groupsView;
    }

    public void changeFontSize() {
        if (this.termsView != null) {
            this.termsView.changeFontSize();
        }
        if (this.formsView != null) {
            this.formsView.changeFontSize();
        }
        if (this.sentencesView != null) {
            this.sentencesView.changeFontSize();
        }
        if (this.groupsView != null) {
            this.groupsView.changeFontSize();
        }
    }

    private class BaseFormThread
    extends Thread {
        private BaseFormGuesser baseFormGuesser;

        public BaseFormThread() {
            this.baseFormGuesser = ((TermoPLDocument)TermoPLDocument.this).preferences.language.equals("pl") && !((TermoPLDocument)TermoPLDocument.this).preferences.useCustomTagset ? new BaseFormGuesser(((TermoPLDocument)TermoPLDocument.this).preferences.tagset) : new BaseFormGuesser();
        }

        @Override
        public void run() {
            boolean done = false;
            try {
                while (!done) {
                    Term term = (Term)TermoPLDocument.this.termQueue.take();
                    if (term == DUMMY_TERM) {
                        TermoPLDocument.this.termQueue.put(term);
                        done = true;
                        continue;
                    }
                    term.str = TermoPLDocument.this.calcBaseForm(term, this.baseFormGuesser);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TermoPLDocument.this.countDown.countDown();
        }
    }

    private class ColumnSorter
    implements Comparator<Term> {
        private Collator collator = Collator.getInstance(new Locale("pl", "PL"));

        private ColumnSorter() {
        }

        @Override
        public int compare(Term t1, Term t2) {
            switch (((TermoPLDocument)TermoPLDocument.this).preferences.sortedColumn) {
                case 1: {
                    return ((TermoPLDocument)TermoPLDocument.this).preferences.sortPrefs[((TermoPLDocument)TermoPLDocument.this).preferences.sortedColumn] * (t1.rank - t2.rank);
                }
                case 2: {
                    return ((TermoPLDocument)TermoPLDocument.this).preferences.sortPrefs[((TermoPLDocument)TermoPLDocument.this).preferences.sortedColumn] * this.collator.compare(t1.str, t2.str);
                }
                case 3: {
                    return ((TermoPLDocument)TermoPLDocument.this).preferences.sortPrefs[((TermoPLDocument)TermoPLDocument.this).preferences.sortedColumn] * (int)Math.signum(t1.cvalue - t2.cvalue);
                }
                case 4: {
                    return ((TermoPLDocument)TermoPLDocument.this).preferences.sortPrefs[((TermoPLDocument)TermoPLDocument.this).preferences.sortedColumn] * (int)Math.signum(t1.contrast - t2.contrast);
                }
                case 5: {
                    return ((TermoPLDocument)TermoPLDocument.this).preferences.sortPrefs[((TermoPLDocument)TermoPLDocument.this).preferences.sortedColumn] * (t1.len - t2.len);
                }
                case 6: {
                    return ((TermoPLDocument)TermoPLDocument.this).preferences.sortPrefs[((TermoPLDocument)TermoPLDocument.this).preferences.sortedColumn] * (t1.freq_s - t2.freq_s);
                }
                case 7: {
                    return ((TermoPLDocument)TermoPLDocument.this).preferences.sortPrefs[((TermoPLDocument)TermoPLDocument.this).preferences.sortedColumn] * (t1.freq_in - t2.freq_in);
                }
                case 8: {
                    return ((TermoPLDocument)TermoPLDocument.this).preferences.sortPrefs[((TermoPLDocument)TermoPLDocument.this).preferences.sortedColumn] * (t1.lk - t2.lk);
                }
            }
            return 0;
        }
    }

    private class CompareThread
    extends Thread {
        private ContrastiveDataLoader loader;

        public CompareThread(ContrastiveDataLoader loader) {
            this.loader = loader;
        }

        @Override
        public void run() {
            if (this.loader != null) {
                this.loader.start();
                try {
                    this.loader.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (TermoPLDocument.this.cterms != null) {
                TermoPLDocument.this.setCTerms(((TermoPLDocument)TermoPLDocument.this).preferences.calculateBaseForms);
                TermoPLDocument.this.applyContrastiveRanking();
            }
            TermoPLDocument.this.finishCompare();
        }
    }

    private class ContrastiveDataLoader
    extends Thread {
        private File input;

        public ContrastiveDataLoader(String path) {
            this.input = new File(path);
        }

        @Override
        public void run() {
            HashMap<String, Term> newCTerms = null;
            TermoPLDocument.this.changeProgress(0);
            newCTerms = TermoPLDocument.this.loadContrastiveTerms(this.input);
            if (newCTerms != null) {
                TermoPLDocument.this.cterms = newCTerms;
            }
        }
    }

    private class ExportThread
    extends Thread {
        private PrintWriter pw;
        private int exportType;

        public ExportThread(PrintWriter pw, int exportType) {
            this.pw = pw;
            this.exportType = exportType;
        }

        @Override
        public void run() {
            TermoPLDocument.this.export(this.pw, this.exportType);
            if (TermoPLDocument.this.termsView != null) {
                TermoPLDocument.this.termsView.showProgress(false);
            }
        }
    }

    private class ExtractorThread
    extends Thread {
        private ExtractorEngine extractor;
        private GroupingEngine groupingEngine;
        private Finalizer finalizer;
        private ContrastiveDataLoader loader;

        public ExtractorThread(ExtractorEngine extractor, GroupingEngine groupingEngine, Finalizer finalizer, ContrastiveDataLoader loader) {
            this.extractor = extractor;
            this.groupingEngine = groupingEngine;
            this.finalizer = finalizer;
            this.loader = loader;
        }

        @Override
        public void run() {
            TermoPLDocument.this.searching = true;
            if (this.loader != null) {
                this.loader.start();
                try {
                    this.loader.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!TermoPLDocument.this.cancelled) {
                this.extractor.start();
            }
            try {
                this.extractor.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!TermoPLDocument.this.cancelled && !TermoPLDocument.this.interrupted) {
                TermoPLDocument.this.termMap = this.extractor.getTermMap();
                TermoPLDocument.this.terms = this.extractor.getTerms();
                TermoPLDocument.this.nterms = this.extractor.getNumberOfTerms();
                if (this.groupingEngine != null) {
                    this.groupingEngine.start();
                    try {
                        this.groupingEngine.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.finalizer.start();
            if (TermoPL.batchMode) {
                try {
                    this.finalizer.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class FileNameFilter
    implements FilenameFilter {
        private String namePattern;

        public FileNameFilter(String namePattern) {
            namePattern = namePattern.replace(".", "\\.");
            namePattern = namePattern.replace("?", ".");
            this.namePattern = namePattern = namePattern.replace("*", ".*");
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.matches(this.namePattern);
        }
    }

    private class Finalizer
    extends Thread {
        private Finalizer() {
        }

        @Override
        public void run() {
            if (!TermoPLDocument.this.cancelled && !TermoPLDocument.this.interrupted) {
                TermoPLDocument termoPLDocument = TermoPLDocument.this;
                termoPLDocument.nsentences = termoPLDocument.nsentences + TermoPLDocument.this.extractor.getNumberOfSentences();
                TermoPLDocument termoPLDocument2 = TermoPLDocument.this;
                termoPLDocument2.ntokens = termoPLDocument2.ntokens + TermoPLDocument.this.extractor.getNumberOfTokens();
                LinkedList<FileDescr> aFiles = TermoPLDocument.this.extractor.getAnalyzedFiles();
                TermoPLDocument.this.formsCollected = ((TermoPLDocument)TermoPLDocument.this).preferences.collectAllForms;
                TermoPLDocument.this.sentencesIndexed = ((TermoPLDocument)TermoPLDocument.this).preferences.makeIndex;
                if (TermoPLDocument.this.terms != null) {
                    TermoPLDocument.this.tableSize = TermoPLDocument.this.nterms;
                    TermoPLDocument.this.calculate(((TermoPLDocument)TermoPLDocument.this).preferences.cntxMethod);
                    if (((TermoPLDocument)TermoPLDocument.this).preferences.applyContrastiveRanking && TermoPLDocument.this.cterms != null) {
                        TermoPLDocument.this.setCTerms(false);
                        TermoPLDocument.this.applyContrastiveRanking();
                    }
                    if (((TermoPLDocument)TermoPLDocument.this).preferences.calculateBaseForms) {
                        TermoPLDocument.this.calculateBaseForms();
                    }
                    if (!TermoPLDocument.this.cancelled) {
                        TermoPLDocument.this.prepareTable();
                    } else {
                        TermoPLDocument.this.termMap = null;
                        TermoPLDocument.this.terms = null;
                        TermoPLDocument.this.tableSize = 0;
                    }
                } else {
                    TermoPLDocument.this.tableSize = 0;
                }
                if (TermoPLDocument.this.rebuild == 1) {
                    TermoPLDocument.this.analyzedFiles.addAll(aFiles);
                } else {
                    TermoPLDocument.this.analyzedFiles = aFiles;
                }
                TermoPLDocument.this.selectedFiles = new File[TermoPLDocument.this.analyzedFiles.size()];
                int i = 0;
                for (FileDescr fd : TermoPLDocument.this.analyzedFiles) {
                    ((TermoPLDocument)TermoPLDocument.this).selectedFiles[i++] = fd.file;
                }
                TermoPLDocument.this.oldFiles = TermoPLDocument.this.selectedFiles;
                TermoPLDocument.this.newFiles = null;
                TermoPLDocument.this.rebuild = 0;
            } else {
                TermoPLDocument.this.terms = null;
                TermoPLDocument.this.tableSize = 0;
                TermoPLDocument.this.termMap = null;
            }
            if (TermoPLDocument.this.terms != null && !(TermoPLDocument.this.terms[0] instanceof TermEx)) {
                TermoPLDocument.this.termMap = null;
            }
            TermoPLDocument.this.extractor = null;
            ((TermoPLDocument)TermoPLDocument.this).preferences.extract = false;
            ((TermoPLDocument)TermoPLDocument.this).preferences.compare = false;
            ((TermoPLDocument)TermoPLDocument.this).preferences.reloadContrastiveTerms = false;
            ((TermoPLDocument)TermoPLDocument.this).preferences.repaint = false;
            TermoPLDocument.this.showResults();
            TermoPLDocument.this.searching = false;
        }
    }

    private class GroupingEngine
    extends Thread {
        private GroupingEngine() {
        }

        @Override
        public void run() {
            TermoPLDocument.this.makeGroups();
        }
    }

    private class LoadThread
    extends Thread {
        private File input;

        public LoadThread(File input) {
            this.input = input;
        }

        @Override
        public void run() {
            this.load(this.input);
        }

        public void load(File input) {
            try {
                int i;
                TermoPLDocument.this.cancelled = false;
                ObjectInputStream is = new ObjectInputStream(new FileInputStream(input));
                TermoPLDocument.this.formsCollected = is.readBoolean();
                TermoPLDocument.this.sentencesIndexed = is.readBoolean();
                TermoPLDocument.this.nsentences = is.readInt();
                TermoPLDocument.this.ntokens = is.readInt();
                TermoPLDocument.this.nterms = is.readInt();
                int ncterms = is.readInt();
                TermoPLDocument.this.rebuild = is.readInt();
                TermoPLDocument.this.corpusName = (String)is.readObject();
                TermoPLDocument.this.preferences = (Preferences)is.readObject();
                ((TermoPLDocument)TermoPLDocument.this).preferences.workSpace = TermoPL.preferences.workSpace;
                TermoPLDocument.this.preferences.finalizeCreate(true);
                String[] ftable = (String[])is.readObject();
                if (ftable == null) {
                    TermoPLDocument.this.selectedFiles = null;
                } else {
                    TermoPLDocument.this.selectedFiles = new File[ftable.length];
                    i = 0;
                    while (i < ftable.length) {
                        ((TermoPLDocument)TermoPLDocument.this).selectedFiles[i] = new File(TermoPLDocument.this.preferences.resolvePath(ftable[i]));
                        ++i;
                    }
                }
                ftable = (String[])is.readObject();
                if (ftable == null) {
                    TermoPLDocument.this.newFiles = null;
                } else {
                    TermoPLDocument.this.newFiles = new File[ftable.length];
                    i = 0;
                    while (i < ftable.length) {
                        ((TermoPLDocument)TermoPLDocument.this).newFiles[i] = new File(TermoPLDocument.this.preferences.resolvePath(ftable[i]));
                        ++i;
                    }
                }
                ftable = (String[])is.readObject();
                if (ftable == null) {
                    TermoPLDocument.this.oldFiles = null;
                } else {
                    TermoPLDocument.this.oldFiles = new File[ftable.length];
                    i = 0;
                    while (i < ftable.length) {
                        ((TermoPLDocument)TermoPLDocument.this).oldFiles[i] = new File(TermoPLDocument.this.preferences.resolvePath(ftable[i]));
                        ++i;
                    }
                }
                ArrayList aFiles = (ArrayList)is.readObject();
                if (aFiles == null) {
                    TermoPLDocument.this.analyzedFiles = null;
                } else {
                    TermoPLDocument.this.analyzedFiles = new LinkedList();
                    for (Pair pair : aFiles) {
                        TermoPLDocument.this.analyzedFiles.add(new FileDescr(new File(TermoPLDocument.this.preferences.resolvePath((String)pair.first)), (Integer)pair.second));
                    }
                }
                if (!TermoPLDocument.this.cancelled) {
                    if (TermoPLDocument.this.nterms == 0) {
                        TermoPLDocument.this.terms = null;
                    } else {
                        TermoPLDocument.this.terms = new Term[TermoPLDocument.this.nterms];
                        int i2 = 0;
                        while (i2 < TermoPLDocument.this.nterms && !TermoPLDocument.this.cancelled) {
                            ((TermoPLDocument)TermoPLDocument.this).terms[i2] = (Term)is.readObject();
                            ++i2;
                        }
                    }
                }
                if (!TermoPLDocument.this.cancelled) {
                    if (ncterms == 0) {
                        TermoPLDocument.this.cterms = null;
                    } else {
                        TermoPLDocument.this.cterms = new HashMap(ncterms);
                        int i3 = 0;
                        while (i3 < ncterms && !TermoPLDocument.this.cancelled) {
                            String str = (String)is.readObject();
                            Term t = (Term)is.readObject();
                            TermoPLDocument.this.cterms.put(str, t);
                            ++i3;
                        }
                    }
                }
                if (!TermoPLDocument.this.cancelled) {
                    TermoPLDocument.this.preferences.finalizeCreate(true);
                    if (TermoPLDocument.this.termsView != null) {
                        TermoPLDocument.this.termsView.finishCreate();
                    }
                }
                is.close();
                if (TermoPLDocument.this.cancelled) {
                    TermoPLDocument.this.remove();
                } else {
                    TermoPLDocument.this.trim(((TermoPLDocument)TermoPLDocument.this).preferences.trimResults, ((TermoPLDocument)TermoPLDocument.this).preferences.multiWordTermsOnly, ((TermoPLDocument)TermoPLDocument.this).preferences.filterResults);
                    if (TermoPLDocument.this.termsView != null) {
                        TermoPLDocument.this.termsView.resetResults();
                        TermoPLDocument.this.termsView.showProgress(false);
                        switch (TermoPLDocument.this.rebuild) {
                            case 0: {
                                TermoPLDocument.this.termsView.setInfo(TermoPLDocument.this.getStat());
                                break;
                            }
                            case 1: 
                            case 2: {
                                TermoPLDocument.this.termsView.setWarning("Extract terms.");
                                TermoPLDocument.this.termsView.setAccessory(TermoPLDocument.this.extractAction);
                                break;
                            }
                            case 3: {
                                TermoPLDocument.this.termsView.setWarning("No file selected for term extraction.");
                                TermoPLDocument.this.termsView.setAccessory(TermoPLDocument.this.selectAction);
                            }
                        }
                    }
                    TermoPLDocument.this.loaded = true;
                }
            }
            catch (Exception exception) {
                TermoPLDocument.this.corrupted = true;
                TermoPLDocument.this.remove();
                if (TermoPL.batchMode) {
                    System.out.println("File has wrong format or is corrupted -- " + input.getPath());
                }
                JOptionPane.showMessageDialog(TermoPL.dialogOwner, "File has wrong format or is corrupted.", "Error", 0);
            }
            TermoPLDocument.this.finishLoading();
            TermoPL.application.finishOpening(TermoPLDocument.this);
        }
    }

    private class MergeThread
    extends Thread {
        private File file;
        private boolean discardGroups;

        public MergeThread(File file) {
            this.file = file;
            TermoPLDocument.this.termMap = new HashMap();
            this.discardGroups = false;
        }

        @Override
        public void run() {
            boolean bf = ((TermoPLDocument)TermoPLDocument.this).preferences.calculateBaseForms;
            TermoPLDocument.this.corrupted = false;
            TermoPLDocument.this.cancelled = false;
            Term[] termArray = TermoPLDocument.this.terms;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term t = termArray[n2];
                if (t instanceof TermEx) {
                    this.discardGroups = true;
                }
                if (TermoPLDocument.this.cancelled) break;
                String key = bf ? TermoPLDocument.this.calcSimplifiedForm(t) : t.str;
                TermoPLDocument.this.termMap.put(key, t);
                ++n2;
            }
            if (!TermoPLDocument.this.cancelled) {
                this.merge();
            }
        }

        public void merge() {
            BaseFormGuesser guesser = null;
            int snt = 0;
            int tok = 0;
            int trm = 0;
            try {
                int n;
                int n2;
                File[] fileArray;
                String rf;
                Object f;
                int n3;
                int n4;
                Object[] objectArray;
                ObjectInputStream is = new ObjectInputStream(new FileInputStream(this.file));
                is.readBoolean();
                is.readBoolean();
                snt = is.readInt();
                tok = is.readInt();
                trm = is.readInt();
                is.readInt();
                is.readInt();
                is.readObject();
                Preferences prefs = (Preferences)is.readObject();
                String[] files = (String[])is.readObject();
                LinkedList<Object> fileList = new LinkedList<Object>();
                if (TermoPLDocument.this.selectedFiles != null) {
                    objectArray = TermoPLDocument.this.selectedFiles;
                    n4 = objectArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        Object sf = objectArray[n3];
                        fileList.add(sf);
                        ++n3;
                    }
                }
                if (files != null) {
                    objectArray = files;
                    n4 = files.length;
                    n3 = 0;
                    while (n3 < n4) {
                        f = objectArray[n3];
                        rf = prefs.resolvePath((String)f);
                        if (TermoPLDocument.this.selectedFiles != null) {
                            fileArray = TermoPLDocument.this.selectedFiles;
                            n2 = fileArray.length;
                            n = 0;
                            while (n < n2) {
                                File sf = fileArray[n];
                                if (!rf.equals(sf.getAbsolutePath())) {
                                    fileList.add(new File(rf));
                                }
                                ++n;
                            }
                        } else {
                            fileList.add(new File(rf));
                        }
                        ++n3;
                    }
                }
                if (fileList.isEmpty()) {
                    TermoPLDocument.this.selectedFiles = null;
                } else {
                    TermoPLDocument.this.selectedFiles = fileList.toArray(new File[0]);
                }
                files = (String[])is.readObject();
                fileList = new LinkedList();
                if (TermoPLDocument.this.newFiles != null) {
                    objectArray = TermoPLDocument.this.newFiles;
                    n4 = objectArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        Object nf = objectArray[n3];
                        fileList.add(nf);
                        ++n3;
                    }
                }
                if (files != null) {
                    objectArray = files;
                    n4 = files.length;
                    n3 = 0;
                    while (n3 < n4) {
                        f = objectArray[n3];
                        rf = prefs.resolvePath((String)f);
                        if (TermoPLDocument.this.newFiles != null) {
                            fileArray = TermoPLDocument.this.newFiles;
                            n2 = fileArray.length;
                            n = 0;
                            while (n < n2) {
                                File nf = fileArray[n];
                                if (!rf.equals(nf.getAbsolutePath())) {
                                    fileList.add(new File(rf));
                                }
                                ++n;
                            }
                        } else {
                            fileList.add(new File(rf));
                        }
                        ++n3;
                    }
                }
                if (fileList.isEmpty()) {
                    TermoPLDocument.this.newFiles = null;
                } else {
                    TermoPLDocument.this.newFiles = fileList.toArray(new File[0]);
                }
                files = (String[])is.readObject();
                fileList = new LinkedList();
                if (TermoPLDocument.this.oldFiles != null) {
                    objectArray = TermoPLDocument.this.oldFiles;
                    n4 = objectArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        Object of = objectArray[n3];
                        fileList.add(of);
                        ++n3;
                    }
                }
                if (files != null) {
                    objectArray = files;
                    n4 = files.length;
                    n3 = 0;
                    while (n3 < n4) {
                        f = objectArray[n3];
                        rf = prefs.resolvePath((String)f);
                        if (TermoPLDocument.this.oldFiles != null) {
                            fileArray = TermoPLDocument.this.oldFiles;
                            n2 = fileArray.length;
                            n = 0;
                            while (n < n2) {
                                File of = fileArray[n];
                                if (!rf.equals(of.getAbsolutePath())) {
                                    fileList.add(new File(rf));
                                }
                                ++n;
                            }
                        } else {
                            fileList.add(new File(rf));
                        }
                        ++n3;
                    }
                }
                if (fileList.isEmpty()) {
                    TermoPLDocument.this.oldFiles = null;
                } else {
                    TermoPLDocument.this.oldFiles = fileList.toArray(new File[0]);
                }
                ArrayList af = (ArrayList)is.readObject();
                boolean bf = prefs.calculateBaseForms;
                TermoPLDocument.this.allowCollectingForms(((TermoPLDocument)TermoPLDocument.this).preferences.collectAllForms && prefs.collectAllForms);
                TermoPLDocument.this.allowIndexingSentences(((TermoPLDocument)TermoPLDocument.this).preferences.makeIndex && prefs.makeIndex);
                int maxcount = trm / 10;
                int count = 0;
                int i = 0;
                while (i < trm && !TermoPLDocument.this.cancelled) {
                    String key;
                    Term t = (Term)is.readObject();
                    String string = key = bf ? TermoPLDocument.this.calcSimplifiedForm(t) : t.str;
                    if (t instanceof TermEx) {
                        this.discardGroups = true;
                    }
                    if (((TermoPLDocument)TermoPLDocument.this).preferences.calculateBaseForms && !bf) {
                        if (guesser == null) {
                            guesser = ((TermoPLDocument)TermoPLDocument.this).preferences.useUD ? new BaseFormGuesser() : new BaseFormGuesser(((TermoPLDocument)TermoPLDocument.this).preferences.tagset);
                        }
                        t.str = TermoPLDocument.this.calcBaseForm(t, guesser);
                    } else if (!((TermoPLDocument)TermoPLDocument.this).preferences.calculateBaseForms && bf) {
                        t.str = key;
                    }
                    Term term = (Term)TermoPLDocument.this.termMap.get(key);
                    if (term == null) {
                        TermoPLDocument.this.termMap.put(key, t);
                    } else {
                        term.addContexts(t.getContexts());
                        if (((TermoPLDocument)TermoPLDocument.this).preferences.collectAllForms) {
                            term.addForms(t.getForms(), ((TermoPLDocument)TermoPLDocument.this).preferences.collectAllForms);
                        } else {
                            term.registerForms(t);
                        }
                        if (((TermoPLDocument)TermoPLDocument.this).preferences.makeIndex) {
                            term.addSentenceRef(t.getSentenceRef(), TermoPLDocument.this.analyzedFiles.size());
                        }
                        term.addDocFreq(t.getDocFreq());
                    }
                    if (++count >= maxcount) {
                        count = 0;
                        if (TermoPLDocument.this.termsView != null) {
                            TermoPLDocument.this.termsView.report((float)i / (float)trm);
                        }
                    }
                    ++i;
                }
                if (TermoPLDocument.this.termsView != null) {
                    TermoPLDocument.this.termsView.report(1.0f);
                }
                is.close();
                if (!TermoPLDocument.this.cancelled) {
                    TermoPLDocument.this.terms = TermoPLDocument.this.termMap.values().toArray(new Term[0]);
                    if (this.discardGroups) {
                        i = 0;
                        while (i < TermoPLDocument.this.terms.length) {
                            Term t = TermoPLDocument.this.terms[i];
                            if (t instanceof TermEx) {
                                ((TermoPLDocument)TermoPLDocument.this).terms[i] = t.copy();
                            }
                            ++i;
                        }
                    }
                    TermoPLDocument.this.nterms = TermoPLDocument.this.terms.length;
                    TermoPLDocument.this.tableSize = TermoPLDocument.this.nterms;
                    TermoPLDocument termoPLDocument = TermoPLDocument.this;
                    termoPLDocument.nsentences = termoPLDocument.nsentences + snt;
                    TermoPLDocument termoPLDocument2 = TermoPLDocument.this;
                    termoPLDocument2.ntokens = termoPLDocument2.ntokens + tok;
                    TermoPLDocument.this.calculate(((TermoPLDocument)TermoPLDocument.this).preferences.cntxMethod);
                    if (((TermoPLDocument)TermoPLDocument.this).preferences.applyContrastiveRanking && TermoPLDocument.this.cterms != null) {
                        TermoPLDocument.this.setCTerms(false);
                        TermoPLDocument.this.applyContrastiveRanking();
                    }
                    TermoPLDocument.this.prepareTable();
                    for (Pair pair : af) {
                        TermoPLDocument.this.analyzedFiles.add(new FileDescr(new File(TermoPLDocument.this.preferences.resolvePath((String)pair.first)), (Integer)pair.second));
                    }
                    ((TermoPLDocument)TermoPLDocument.this).preferences.makeGroups = false;
                    TermoPLDocument.this.modified = true;
                }
            }
            catch (Exception exception) {
                TermoPLDocument.this.corrupted = true;
                if (TermoPL.batchMode) {
                    System.out.println("File has wrong format or is corrupted -- " + this.file.getPath());
                }
                JOptionPane.showMessageDialog(TermoPL.dialogOwner, "File has wrong format or is corrupted.", "Error", 0);
            }
            TermoPLDocument.this.finalizeMerge();
        }
    }

    private class ProcessTerms
    extends Thread {
        @Override
        public void run() {
            int count = 0;
            int count1 = 0;
            int count2 = 0;
            int len = TermoPLDocument.this.terms.length;
            Term[] termArray = TermoPLDocument.this.terms;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                if (TermoPLDocument.this.cancelled) break;
                try {
                    TermoPLDocument.this.termQueue.put(term);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++count;
                if (++count1 >= 1000) {
                    count1 = 0;
                    if (++count2 >= 25000) {
                        count2 = 0;
                        System.gc();
                    }
                    TermoPLDocument.this.report(count, len, (float)count / (float)len);
                }
                ++n2;
            }
            TermoPLDocument.this.report(count, len, 1.0f);
            try {
                TermoPLDocument.this.termQueue.put(DUMMY_TERM);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TermoPLDocument.this.countDown.countDown();
        }
    }

    private class SaveThread
    extends Thread {
        private File file;

        public SaveThread(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            try {
                ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(this.file));
                TermoPLDocument.this.save(output);
            }
            catch (IOException exception) {
                if (TermoPL.batchMode) {
                    System.err.println("Error occured while writing a file.");
                }
                JOptionPane.showMessageDialog(TermoPL.dialogOwner, "Error occured while writing a file.", "Error", 0);
            }
            if (TermoPLDocument.this.termsView != null) {
                TermoPLDocument.this.termsView.showProgress(false);
            }
        }
    }

    private class SimplifiedFormThread
    extends Thread {
        private SimplifiedFormThread() {
        }

        @Override
        public void run() {
            boolean done = false;
            try {
                while (!done) {
                    Term term = (Term)TermoPLDocument.this.termQueue.take();
                    if (term == DUMMY_TERM) {
                        TermoPLDocument.this.termQueue.put(term);
                        done = true;
                        continue;
                    }
                    term.str = TermoPLDocument.this.calcSimplifiedForm(term);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TermoPLDocument.this.countDown.countDown();
        }
    }
}

