/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import termopl.Commander;

public class Command
extends AbstractAction {
    public static final int NEW_COMMAND = 1;
    public static final int OPEN_COMMAND = 2;
    public static final int MERGE_COMMAND = 3;
    public static final int CLOSE_COMMAND = 4;
    public static final int SAVE_COMMAND = 5;
    public static final int SAVE_AS_COMMAND = 6;
    public static final int WORKSPACE_COMMAND = 7;
    public static final int EXPORT_COMMAND = 8;
    public static final int EXPORT_FORMS_COMMAND = 9;
    public static final int EXPORT_SENTENCES_COMMAND = 10;
    public static final int EXPORT_GROUPS_COMMAND = 11;
    public static final int EXTRACT_COMMAND = 12;
    public static final int COMPARE_COMMAND = 13;
    public static final int SELECT_FILES_COMMAND = 14;
    public static final int SELECT_CONTRASTIVE_TERMS_COMMAD = 15;
    public static final int BASE_FORMS_COMMAND = 16;
    public static final int COLLECT_COMMAND = 17;
    public static final int INDEX_COMMAND = 18;
    public static final int PREFERENCES_COMMAND = 19;
    public static final int FORMS_COMMAND = 20;
    public static final int SENTENCES_COMMAND = 21;
    public static final int GROUPS_COMMAND = 22;
    public static final int INCREASE_COMMAND = 23;
    public static final int DECREASE_COMMAND = 24;
    public static final int SHOW_ONE_ALL = 25;
    public static final int TILE_COMMAND = 26;
    public static final int CASCADE_COMMAND = 27;
    public static final int EXIT_COMMAND = 28;
    public static final int ABOUT_COMMAND = 29;
    public static final int HELP_COMMAND = 30;
    public static Command newCommand = new Command(1, "New");
    public static Command openCommand = new Command(2, "Open...");
    public static Command mergeCommand = new Command(3, "Merge...");
    public static Command closeCommand = new Command(4, "Close");
    public static Command saveCommand = new Command(5, "Save");
    public static Command saveAsCommand;
    public static Command workspaceCommand;
    public static Command exportCommand;
    public static Command exportFormsCommand;
    public static Command exportSentencesCommand;
    public static Command exportGroupsCommand;
    public static Command extractCommand;
    public static Command compareCommand;
    public static Command selectFilesCommand;
    public static Command selectContrastiveTermsCommand;
    public static Command baseFormsCommand;
    public static Command collectCommand;
    public static Command indexCommand;
    public static Command preferencesCommand;
    public static Command formsCommand;
    public static Command sentencesCommand;
    public static Command groupsCommand;
    public static Command increaseCommand;
    public static Command decreaseCommand;
    public static Command showOneAll;
    public static Command tileCommand;
    public static Command cascadeCommand;
    public static Command exitCommand;
    public static Command aboutCommand;
    public static Command helpCommand;
    private int commandID;

    static {
        workspaceCommand = new Command(7, "Workspace...");
        saveAsCommand = new Command(6, "Save As...");
        exportCommand = new Command(8, "Export...");
        exportFormsCommand = new Command(9, "Export Forms...");
        exportSentencesCommand = new Command(10, "Export Sentences...");
        exportGroupsCommand = new Command(11, "Export Term Groups...");
        extractCommand = new Command(12, "Extract");
        compareCommand = new Command(13, "Compare");
        selectFilesCommand = new Command(14, "Select File(s)...");
        selectContrastiveTermsCommand = new Command(15, "Select Contrastive Set of Terms...");
        baseFormsCommand = new Command(16, "Calculate Base Forms");
        collectCommand = new Command(17, "Collect All Analysed Forms of Terms");
        indexCommand = new Command(18, "Index Sentences with Extracted Terms");
        preferencesCommand = new Command(19, "Preferences...");
        formsCommand = new Command(20, "Forms of Selected Term");
        sentencesCommand = new Command(21, "Sentences with Selected Term");
        groupsCommand = new Command(22, "Related Term Groups");
        increaseCommand = new Command(23, "Increase Font");
        decreaseCommand = new Command(24, "Decrease Font");
        showOneAll = new Command(25, "");
        tileCommand = new Command(26, "Tile");
        cascadeCommand = new Command(27, "Cascade");
        exitCommand = new Command(28, "Exit");
        aboutCommand = new Command(29, "About TermoPL");
        helpCommand = new Command(30, "User Manual");
    }

    public Command(int commandID, String commandName) {
        super(commandName);
        this.commandID = commandID;
    }

    public Command(int commandID, String commandName, String iconFile) {
        super(commandName);
        this.setIcon(iconFile);
        this.commandID = commandID;
    }

    public Command(String commandName, String iconFile) {
        this(0, commandName, iconFile);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Commander commander;
        if (this.commandID != 0 && (commander = Commander.getCommander()) != null) {
            commander.executeCommand(this.commandID, event.getModifiers());
        }
    }

    public void setIcon(String iconFile) {
        URL url = Command.class.getResource("Images/" + iconFile);
        this.putValue("SmallIcon", new ImageIcon(url));
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public int getCommandID() {
        return this.commandID;
    }
}

