/*
 * Decompiled with CFR 0.152.
 */
package termopl;

public class ParserError {
    public static final int NO_ERROR = 0;
    public static final int ERR_EOF = 1;
    public static final int IDENTIFIER_EXPECTED = 2;
    public static final int SYMBOL_EXPECTED = 3;
    public static final int SEMICOLON_EXPECTED = 4;
    public static final int COMMA_EXPECTED = 5;
    public static final int RBRCT_EXPECTED = 6;
    public static final int END_OF_STRING_EXPECTED = 7;
    public static final int STRING_EXPECTED = 8;
    public static final int NO_RULES_DEFINED = 9;
    public static final int NO_TESTS_DEFINED = 10;
    public static final int NO_LOOPS_ALLOWED = 11;
    public static final int CLASS_DEFINED = 12;
    public static final int UNDEFINED_CLASS = 13;
    public static final int ILLEGAL_SYMBOL = 14;
    public static final int COLON_EXPECTED = 15;
    public static final int LANGLE_EXPECTED = 16;
    public static final int RANGLE_EXPECTED = 17;
    public static final int EQ_EXPECTED = 18;
    public static final int KEYWORD_TAG_DELIMITER = 19;
    public static final int KEYWORD_CATEGORIES = 20;
    public static final int KEYWORD_BY = 21;
    public static final int KEYWORD_POS_VAL = 22;
    public static final int KEYWORD_DEFINITIONS = 23;
    public static final int KEYWORD_POS = 24;
    public static final int NO_CATEGORY_DEFINED = 25;
    public static final int CATEGORY_DEFINED = 26;
    public static final int DEFINED_AS_CLASS = 27;
    public static final int DEFINED_AS_CATEGORY = 28;
    public static final int END_OF_FILE_EXPECTED = 29;
    public static final int HEAD_NON_TERMINAL = 30;
    public static final int FATAL_ERROR = 31;
    public static final int TOO_MANY_ERRORS = 32;
    public static final String[] ErrorMessages = new String[]{"No errors", "Premature end of file", "Identifier expected", "Symbol expected", "\";\" expected", "\",\" expected", "\"]\" expected", "Expecting '\"'", "String expected", "There are no rules defined", "There are no tests defined for matched tokens", "No loops are allowed (Rewriting process cannot yield to a symbol that appeared on the left hand-side of an applied rule)", "Class already defined", "Undefined class", "Illegal symbol", "\":\" expected", "\"<\" expected", "\">\" expected", "\"=\" expected", "Expecting keyword \"TAG\" or \"DELIMITER\"", "Expecting keyword \"categories\"", "Expecting keyword \"by\"", "Expecting keyword \"positions\" or \"values\"", "Expecting keyword \"definitions\"", "Expecting keyword \"pos\"", "No category was defined", "Category already defined", "Symbol already defined as class", "Symbol already defined as category", "End of file expected", "The head must be a terminal symbol", "Fatal error", "Too many errors"};
    public char[] line;
    public int error;
    public int lineNo;
    public int pos;
    public String msg;

    public ParserError(String msg) {
        this.msg = msg;
        this.error = 31;
        this.line = null;
        this.lineNo = 0;
        this.pos = 0;
    }

    public ParserError(int error) {
        this.msg = null;
        this.error = error;
        this.line = null;
        this.lineNo = 0;
        this.pos = 0;
    }

    public ParserError(int error, char[] line, int lineNo, int pos) {
        this.msg = null;
        this.error = error;
        this.line = line;
        this.lineNo = lineNo;
        this.pos = pos;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.line != null) {
            char ch;
            int i = 0;
            while (i < this.line.length) {
                ch = this.line[i];
                if (ch == '\t') {
                    buffer.append("  ");
                } else {
                    buffer.append(ch);
                }
                ++i;
            }
            buffer.append('\n');
            i = 0;
            while (i < this.pos) {
                ch = this.line[i];
                if (ch == '\t') {
                    buffer.append("  ");
                } else {
                    buffer.append(" ");
                }
                ++i;
            }
            buffer.append("^");
        }
        buffer.append(ErrorMessages[this.error]);
        return buffer.toString();
    }

    public void print() {
        if (this.line != null) {
            char ch;
            int i = 0;
            while (i < this.line.length) {
                ch = this.line[i];
                if (ch == '\t') {
                    System.out.print("  ");
                } else {
                    System.out.print(ch);
                }
                ++i;
            }
            System.out.println();
            i = 0;
            while (i < this.pos) {
                ch = this.line[i];
                if (ch == '\t') {
                    System.out.print("  ");
                } else {
                    System.out.print(" ");
                }
                ++i;
            }
            System.out.print("^");
        }
        System.out.println(ErrorMessages[this.error]);
    }
}

