/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import termopl.Preferences;
import termopl.TermoPL;

public class SentenceParser {
    private Process process;
    private String python;
    private String parser;
    private String language;
    private String input;
    private String error;

    public SentenceParser(Preferences prefs, String input) {
        this.input = input;
        this.initParser(prefs);
    }

    public void initParser(Preferences prefs) {
        this.process = null;
        this.python = prefs.pythonPath;
        this.parser = String.valueOf(TermoPL.appLocation) + File.separator + "parse.py";
        this.language = prefs.language;
        this.error = null;
        File f = new File(this.parser);
        if (!f.exists()) {
            this.error = "Can't find parser.";
        }
        if (this.python == null) {
            if (!TermoPL.batchMode) {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle("Choose Python Interpreter");
                chooser.setMultiSelectionEnabled(false);
                if (chooser.showOpenDialog(null) == 0) {
                    File interp = chooser.getSelectedFile();
                    TermoPL.preferences.pythonPath = prefs.pythonPath = (this.python = interp.getPath());
                }
            }
            if (this.python == null) {
                String e = "Python interpreted not selected.";
                this.error = this.error == null ? e : String.valueOf(this.error) + " " + e;
            }
        }
    }

    public void run() {
        String cmd = String.valueOf(this.python) + " " + this.parser + " --language=" + this.language + " " + this.input;
        Runtime r = Runtime.getRuntime();
        try {
            this.error = null;
            this.process = r.exec(cmd);
            this.process.waitFor();
        }
        catch (Exception e) {
            this.error = e.getMessage();
        }
    }

    public void cancel() {
        if (this.process != null) {
            this.process.destroyForcibly();
        }
    }

    public String getError() {
        return this.error;
    }

    public void report() {
        this.report(this.error);
    }

    public void report(String error) {
        if (TermoPL.batchMode) {
            System.out.println(error);
        } else {
            Object[] options = new Object[]{"Cancel"};
            JOptionPane.showOptionDialog(null, error, "Error", -1, 0, null, options, options[0]);
        }
    }

    public boolean isParsed() {
        File file = new File(this.input);
        String parent = file.getAbsoluteFile().getParent();
        String name = file.getName();
        if (name.indexOf(".") > 0) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        name = String.valueOf(name) + ".conllu";
        file = new File(String.valueOf(parent) + File.separator + name);
        return file.exists();
    }
}

