/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.util.Collection;

public class Chain<E> {
    private E head;
    private Chain<E> tail;

    public Chain(E element) {
        this.head = element;
        this.tail = null;
    }

    public Chain(E element, Chain<E> tail) {
        this.head = element;
        this.tail = tail;
    }

    public Chain(Collection<E> collection) {
        boolean assignHead = true;
        Chain<E> ch = null;
        for (E elem : collection) {
            if (assignHead) {
                this.head = elem;
                assignHead = false;
                continue;
            }
            if (ch == null) {
                ch = new Chain<E>(elem);
                this.tail = ch;
                continue;
            }
            ch.tail = new Chain<E>(elem);
            ch = ch.tail;
        }
    }

    public E head() {
        return this.head;
    }

    public Chain<E> tail() {
        return this.tail;
    }

    public void setHead(E element) {
        this.head = element;
    }

    public void setTail(Chain<E> tail) {
        this.tail = tail;
    }

    public int length() {
        int len = 0;
        Chain<E> t = this;
        while (t != null) {
            ++len;
            t = t.tail();
        }
        return len;
    }

    public Chain<E> skip(int n) {
        Chain<E> t = this;
        while (n > 0 && t != null) {
            --n;
            t = t.tail();
        }
        return t;
    }
}

