/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import pl.sgjp.morfeusz.Morfeusz;
import pl.sgjp.morfeusz.MorphInterpretation;
import termopl.Form;
import termopl.MatchedToken;
import termopl.Morph;
import termopl.Tagset;
import termopl.Term;
import termopl.Token;

public class BaseFormGuesser {
    private Morfeusz morfeusz;
    private Tagset tagset;

    public BaseFormGuesser() {
    }

    public BaseFormGuesser(Tagset tagset) {
        this.tagset = tagset;
        this.morfeusz = Morph.getGenerator();
    }

    public String calcBaseForm(Term term) {
        if (this.tagset == null) {
            return this.calcBaseFormFromFormsWithTAG(term.getFormsWithTAG(), term.getForms());
        }
        return this.calcBaseFormFromForms(term.getForms());
    }

    public String calcBaseFormFromForms(LinkedList<Form> forms) {
        Form form = forms.getFirst();
        LinkedList<MatchedToken> tokens = form.getTokens();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        boolean useMorfeuszOnly = forms.size() <= 1 && form.allOccurences() <= 1;
        boolean appendSpace = false;
        for (MatchedToken mt : tokens) {
            Token t = mt.token;
            if (appendSpace) {
                buffer.append(" ");
            }
            appendSpace = t.spaceAfter;
            if (mt.computeBaseForm) {
                if (useMorfeuszOnly) {
                    buffer.append(this.resolveCase(this.nominalForm(t), t.lemma));
                } else {
                    buffer.append(this.resolveCase(this.nominalForm(t, forms, i), forms, i));
                }
            } else if (useMorfeuszOnly) {
                buffer.append(t.form);
            } else {
                buffer.append(this.resolveCase(t.form, forms, i));
            }
            ++i;
        }
        return buffer.toString();
    }

    public String calcBaseFormFromFormsWithTAG(HashMap<String, Integer> forms, LinkedList<Form> list) {
        LinkedList<String> sing = null;
        LinkedList<String> nom = null;
        LinkedList<String> sing_nom = null;
        LinkedList<String> other = null;
        LinkedList<String> formList = null;
        int lcase = 0;
        int ucase = 0;
        for (String form : forms.keySet()) {
            String tag;
            boolean singular = false;
            boolean nominative = false;
            String[] frm_tag = form.split("\t");
            String string = tag = frm_tag.length > 1 ? frm_tag[1] : null;
            if (Character.isUpperCase(form.codePointAt(0))) {
                ++ucase;
            } else {
                ++lcase;
            }
            if (tag == null) continue;
            String tagl = tag.toLowerCase();
            if (tagl.contains("number=sing")) {
                singular = true;
            }
            if (tagl.contains("case=nom")) {
                nominative = true;
            }
            if (nominative) {
                if (nom == null) {
                    nom = new LinkedList<String>();
                }
                nom.add(form);
            }
            if (singular) {
                if (sing == null) {
                    sing = new LinkedList<String>();
                }
                sing.add(form);
            }
            if (nominative && singular) {
                if (sing_nom == null) {
                    sing_nom = new LinkedList();
                }
                sing_nom.add(form);
            }
            if (nominative || singular) continue;
            if (other == null) {
                other = new LinkedList<String>();
            }
            other.add(form);
        }
        String mostFreq = null;
        int max = 0;
        formList = sing_nom != null ? sing_nom : (nom != null ? nom : (sing != null ? sing : other));
        for (String form : formList) {
            int n = forms.get(form);
            if (n <= max) continue;
            mostFreq = form;
            max = n;
        }
        mostFreq = mostFreq.split("\t")[0];
        if (lcase >= ucase) {
            if (Character.isUpperCase(mostFreq.codePointAt(0))) {
                mostFreq = String.valueOf(mostFreq.substring(0, 1).toLowerCase()) + mostFreq.substring(1);
            }
        } else if (Character.isLowerCase(mostFreq.codePointAt(0))) {
            mostFreq = String.valueOf(mostFreq.substring(0, 1).toUpperCase()) + mostFreq.substring(1);
        }
        return mostFreq;
    }

    public String nominalForm(String lemma, String tag) {
        MorphInterpretation mi;
        if (!lemma.contains(" ") && (mi = this.findNominalForm(lemma, tag.split(":"), 0)) != null) {
            lemma = mi.getOrth();
        }
        return lemma;
    }

    public String nominalForm(Token token) {
        MorphInterpretation mi = this.findNominalForm(token.lemma, token.getTag(this.tagset), 0);
        if (mi != null) {
            return mi.getOrth();
        }
        return token.form;
    }

    public String nominalForm(Token token, LinkedList<Form> forms, int tokenIndex) {
        int singular = 2;
        for (Form form : forms) {
            String num = this.tagset.getCategory(form.getMatchedToken((int)tokenIndex).token, "number");
            if (num == null) {
                singular = 0;
                break;
            }
            if (!num.equals("sg")) continue;
            singular = 1;
            break;
        }
        MorphInterpretation mi = this.findNominalForm(token.lemma, token.getTag(this.tagset), singular);
        if (mi != null) {
            return mi.getOrth();
        }
        return token.form;
    }

    public MorphInterpretation findNominalForm(String lemma, String[] tag, int singular) {
        String gcase = this.tagset.getCategory(tag, "case");
        String gender = this.tagset.getCategory(tag, "gender");
        String number = this.tagset.getCategory(tag, "number");
        MorphInterpretation mi = null;
        if (gcase != null && gender != null && number != null) {
            boolean isLower = this.startsWithLowerCase(lemma);
            List<MorphInterpretation> interps = null;
            try {
                interps = this.morfeusz.generate(lemma);
            }
            catch (Exception exception) {
                interps = null;
            }
            if (interps != null && (mi = this.findNominalForm(interps, tag, singular)) == null) {
                lemma = this.changeCase(lemma, isLower);
                interps = this.morfeusz.generate(lemma);
                mi = this.findNominalForm(interps, tag, singular);
            }
        }
        return mi;
    }

    public MorphInterpretation findNominalForm(List<MorphInterpretation> interps, String[] tag, int singular) {
        MorphInterpretation mi = null;
        String pos = this.tagset.getPos(tag);
        String gender = this.tagset.getCategory(tag, "gender");
        for (MorphInterpretation i : interps) {
            String[] mtag = i.getTag(this.morfeusz).split(":");
            if (!pos.equals(this.tagset.getPos(mtag)) || !mtag[2].contains("nom") || !this.compatibleGender(mtag[3], gender)) continue;
            if (pos.equals("adj")) {
                String str = this.tagset.getCategory(tag, "degree");
                if (str == null) break;
                if (!mtag[4].contains(str)) continue;
                if (singular <= 1 && mtag[1].contains("sg") || singular == 2 && mtag[1].contains("pl")) {
                    mi = i;
                    break;
                }
                if (singular != 0) continue;
                mi = i;
                continue;
            }
            if (pos.equals("ger") || pos.equals("ppas") || pos.equals("pact")) {
                String neg = this.tagset.getCategory(tag, "negation");
                String mneg = mtag[5];
                String aspect = this.tagset.getCategory(tag, "aspect");
                String maspect = mtag[4];
                if (neg == null || aspect == null) {
                    mi = null;
                    break;
                }
                if (!maspect.contains(aspect) || !mneg.contains(neg)) continue;
                if (singular <= 1 && mtag[1].contains("sg") || singular == 2 && mtag[1].contains("pl")) {
                    mi = i;
                    break;
                }
                if (singular != 0) continue;
                mi = i;
                continue;
            }
            if (singular <= 1 && mtag[1].contains("sg") || singular == 2 && mtag[1].contains("pl")) {
                mi = i;
                break;
            }
            if (singular != 0) continue;
            mi = i;
        }
        return mi;
    }

    public String resolveCase(String form, String lemma) {
        boolean lowerCase = this.startsWithLowerCase(form);
        boolean convertToLowerCase = this.startsWithLowerCase(lemma);
        boolean allInUpperCaseF = this.allInUpperCase(form);
        boolean allInUpperCaseL = this.allInUpperCase(lemma);
        if (allInUpperCaseL && !allInUpperCaseF) {
            form = form.toUpperCase();
        }
        if (lowerCase != convertToLowerCase) {
            form = this.changeCase(form, convertToLowerCase);
        }
        return form;
    }

    public String resolveCase(String form, LinkedList<Form> forms, int tokenIndex) {
        boolean lowerCase = this.startsWithLowerCase(form);
        boolean convertToLowerCase = false;
        boolean allInUpperCase = true;
        for (Form f : forms) {
            MatchedToken mt = f.getMatchedToken(tokenIndex);
            if (mt == null) continue;
            String fx = mt.token.form;
            if (this.startsWithLowerCase(fx)) {
                convertToLowerCase = true;
                break;
            }
            if (!allInUpperCase) continue;
            allInUpperCase = this.allInUpperCase(fx);
        }
        if (convertToLowerCase) {
            allInUpperCase = false;
        }
        if (lowerCase != convertToLowerCase) {
            form = allInUpperCase ? form.toUpperCase() : (convertToLowerCase ? form.toLowerCase() : this.changeCase(form, true));
        }
        return form;
    }

    public boolean compatibleGender(String g1, String g2) {
        if (g1 == null || g2 == null) {
            return true;
        }
        if (g1.contains(g2)) {
            return true;
        }
        return g1.startsWith("p") && g2.equals("n");
    }

    public boolean allInUpperCase(String str) {
        int i = 0;
        while (i < str.length()) {
            if (Character.isLowerCase(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean startsWithLowerCase(String str) {
        return Character.isLowerCase(str.charAt(0));
    }

    public String changeCase(String str, boolean upper) {
        char ch = str.charAt(0);
        if (Character.isUpperCase(ch) && !upper) {
            ch = Character.toLowerCase(ch);
            str = String.valueOf(ch) + str.substring(1);
        } else if (Character.isLowerCase(ch) && upper) {
            ch = Character.toUpperCase(ch);
            str = String.valueOf(ch) + str.substring(1);
        }
        return str;
    }
}

