/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import termopl.DefaultMasterFrame;
import termopl.TermoPL;

public class WindowUtils {
    private static Point staggerPoint = null;
    private static final int OFFSET = 30;

    public static Rectangle getScreenRect() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        GraphicsDevice dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration conf = dev.getDefaultConfiguration();
        Insets insets = toolkit.getScreenInsets(conf);
        return new Rectangle(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
    }

    public static Rectangle getDesktopRect() {
        if (TermoPL.isMacOS) {
            return WindowUtils.getScreenRect();
        }
        return ((DefaultMasterFrame)TermoPL.mainWindow).getDesktopPane().getBounds();
    }

    public static void center(Component wnd, Rectangle rect) {
        Rectangle crect = wnd.getBounds();
        wnd.setLocation(rect.x + (rect.width - crect.width) / 2, rect.y + (rect.height - crect.height) / 2);
    }

    public static void centerOnScreen(Component wnd) {
        WindowUtils.center(wnd, WindowUtils.getScreenRect());
    }

    public static void centerOnDesktop(Component wnd) {
        WindowUtils.center(wnd, WindowUtils.getDesktopRect());
    }

    public static void resetStaggerPoint() {
        staggerPoint = null;
    }

    public static void stagger(Component wnd, Rectangle rect) {
        Rectangle crect = wnd.getBounds();
        if (staggerPoint == null) {
            staggerPoint = new Point(rect.x, rect.y);
        }
        if (WindowUtils.staggerPoint.x + crect.width > rect.x + rect.width || WindowUtils.staggerPoint.y + crect.height > rect.y + rect.height) {
            staggerPoint.setLocation(rect.x, rect.y);
        }
        wnd.setLocation(staggerPoint);
        staggerPoint.setLocation(WindowUtils.staggerPoint.x + 30, WindowUtils.staggerPoint.y + 30);
    }

    public static void staggerOnScreen(Component wnd) {
        WindowUtils.stagger(wnd, WindowUtils.getScreenRect());
    }

    public static void staggerOnDesktop(Component wnd) {
        WindowUtils.stagger(wnd, WindowUtils.getDesktopRect());
    }

    public static boolean isVisible(Component wnd, Rectangle rect) {
        Rectangle crect = wnd.getBounds();
        return crect.x < rect.x + rect.width - 30 && crect.y < rect.y + rect.height - 30 && rect.x < crect.x + crect.width - 30 && rect.y < crect.y + crect.height - 30;
    }

    public static boolean isVisibleOnScreen(Component wnd) {
        return WindowUtils.isVisible(wnd, WindowUtils.getScreenRect());
    }

    public static boolean isVisibleOnDesktop(Component wnd) {
        return WindowUtils.isVisible(wnd, WindowUtils.getDesktopRect());
    }

    public static void reveal(Component wnd, Rectangle rect) {
        Rectangle crect = wnd.getBounds();
        if (crect.x + crect.width > rect.x + rect.width) {
            crect.x = rect.x + rect.width - crect.width;
        }
        if (crect.y + crect.height > rect.y + rect.height) {
            crect.y = rect.y + rect.height - crect.height;
        }
        if (crect.x < rect.x) {
            crect.x = rect.x;
        }
        if (crect.y < rect.y) {
            crect.y = rect.y;
        }
        wnd.setLocation(crect.x, crect.y);
    }

    public static void revealOnScreen(Component wnd) {
        WindowUtils.reveal(wnd, WindowUtils.getScreenRect());
    }

    public static void revealOnDesktop(Component wnd) {
        WindowUtils.reveal(wnd, WindowUtils.getDesktopRect());
    }

    public static void resizeToFit(Component wnd, Rectangle rect) {
    }

    public static void resizeToFitScreen(Component wnd) {
        WindowUtils.resizeToFit(wnd, WindowUtils.getScreenRect());
    }

    public static void resizeToFitDesktop(Component wnd) {
        WindowUtils.resizeToFit(wnd, WindowUtils.getDesktopRect());
    }

    public static void setCalculatedBounds(Component wnd, Rectangle bounds) {
        Dimension min = wnd.getMinimumSize();
        Dimension max = wnd.getMaximumSize();
        Rectangle rect = WindowUtils.getDesktopRect();
        int width = 2 * rect.width / 3;
        int height = 2 * rect.height / 3;
        if (width < 400) {
            width = 400;
        }
        if (height < 300) {
            height = 300;
        }
        if (min.width != 0 && width < min.width) {
            width = min.width;
        }
        if (max.width != 0 && width > max.width) {
            width = max.width;
        }
        if (min.height != 0 && height < min.height) {
            height = min.height;
        }
        if (max.height != 0 && height > max.height) {
            height = max.height;
        }
        bounds.setSize(width, height);
        wnd.setBounds(bounds);
    }

    public static void setBoundsRelativeToScreen(Component wnd, Rectangle bounds, boolean center) {
        if (!bounds.isEmpty()) {
            wnd.setBounds(bounds);
            if (!WindowUtils.isVisibleOnScreen(wnd)) {
                WindowUtils.revealOnScreen(wnd);
            }
        } else {
            WindowUtils.setCalculatedBounds(wnd, bounds);
            if (center) {
                WindowUtils.centerOnScreen(wnd);
            } else {
                WindowUtils.staggerOnScreen(wnd);
            }
        }
    }

    public static void setBoundsRelativeToDesktop(Component wnd, Rectangle bounds, boolean center) {
        if (!bounds.isEmpty()) {
            wnd.setBounds(bounds);
            if (!WindowUtils.isVisibleOnDesktop(wnd)) {
                WindowUtils.revealOnDesktop(wnd);
            }
        } else {
            WindowUtils.setCalculatedBounds(wnd, bounds);
            if (center) {
                WindowUtils.centerOnDesktop(wnd);
            } else {
                WindowUtils.staggerOnDesktop(wnd);
            }
        }
    }
}

