/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import termopl.Preferences;
import termopl.TermoPL;

public class BatchParameters {
    public static final String BADOPTION = "Bad option: ";
    public static final String[] SOPTIONS = new String[]{"#", "rank", "sf", "bf", "cvalue", "comp", "length", "freq_s", "freq_in", "context"};
    public String error = null;
    public String output = null;
    public String wrk = null;
    public String wdn = null;
    public String export = null;
    public String exportForms = null;
    public String exportSentences = null;
    public String exportGroups = null;
    public String config = null;
    public String comp = null;
    public String language = null;
    public String method = null;
    public String ignoreCase = null;
    public String tagset = null;
    public String grammar = null;
    public String python = null;
    public String det = null;
    public String sw = null;
    public String cp = null;
    public String ct = null;
    public String[] inputFiles = null;
    public String[] saveOptions = null;
    public byte mw = (byte)-1;
    public byte sf = (byte)-1;
    public byte nf = (byte)-1;
    public byte indx = (byte)-1;
    public byte frq = (byte)-1;
    public byte srch = (byte)-1;
    public byte cntx = (byte)-1;
    public byte group = (byte)-1;
    public byte cc = (byte)-1;
    public int sort = -1;
    public int tr = -1;
    public int pf = -1;
    public int freq = -1;
    public int detRatio = -1;
    public double cval = -1.0;
    public boolean ok = true;

    public BatchParameters(String[] args) {
        this.init(args);
    }

    private void init(String[] args) {
        int i = 0;
        int j = 0;
        boolean readFiles = false;
        while (this.ok && i < args.length) {
            String str = args[i];
            if (readFiles) {
                this.inputFiles[j++] = str;
                ++i;
                continue;
            }
            if (str.startsWith("-")) {
                if (str.equals("-out")) {
                    this.output = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-wrk")) {
                    this.wrk = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-wdn")) {
                    this.wdn = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-exp")) {
                    this.export = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-expf")) {
                    this.exportForms = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-exps")) {
                    this.exportSentences = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-expg")) {
                    this.exportGroups = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-conf")) {
                    this.config = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-comp")) {
                    this.comp = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-sw")) {
                    this.sw = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-SW")) {
                    this.sw = String.valueOf(TermoPL.appLocation) + File.separator + "termopl_sw.txt";
                    ++i;
                    continue;
                }
                if (str.equals("-cp")) {
                    this.cp = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-CP")) {
                    this.cp = String.valueOf(TermoPL.appLocation) + File.separator + "termopl_cp.txt";
                    ++i;
                    continue;
                }
                if (str.equals("-ct")) {
                    this.ct = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-CT")) {
                    this.ct = String.valueOf(TermoPL.appLocation) + File.separator + "termopl_ct.txt";
                    ++i;
                    continue;
                }
                if (str.equals("-lang")) {
                    this.language = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-method")) {
                    this.method = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-ignc")) {
                    this.ignoreCase = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-det")) {
                    this.det = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-tagset")) {
                    this.tagset = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-grammar")) {
                    this.grammar = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-python")) {
                    this.python = args[++i];
                    ++i;
                    continue;
                }
                if (str.equals("-mw")) {
                    ++i;
                    this.mw = 1;
                    continue;
                }
                if (str.equals("-sf")) {
                    ++i;
                    this.sf = 1;
                    continue;
                }
                if (str.equals("-nf")) {
                    ++i;
                    this.nf = 1;
                    continue;
                }
                if (str.equals("-indx")) {
                    ++i;
                    this.indx = 1;
                    continue;
                }
                if (str.equals("-group")) {
                    ++i;
                    this.group = 1;
                    continue;
                }
                if (str.equals("-srch")) {
                    str = args[++i].toLowerCase();
                    ++i;
                    if (str.equals("npmi1")) {
                        this.srch = 1;
                        continue;
                    }
                    if (str.equals("npmi2")) {
                        this.srch = (byte)2;
                        continue;
                    }
                    if (str.equals("npmi3")) {
                        this.srch = (byte)3;
                        continue;
                    }
                    if (str.equals("nonpmi1")) {
                        this.srch = (byte)4;
                        continue;
                    }
                    if (str.equals("nonpmi2")) {
                        this.srch = (byte)5;
                        continue;
                    }
                    this.error = "Bad option: -srch " + str;
                    this.ok = false;
                    continue;
                }
                if (str.equals("-cntx")) {
                    str = args[++i];
                    ++i;
                    if (str.equals("1")) {
                        this.cntx = 1;
                        continue;
                    }
                    if (str.equals("2")) {
                        this.cntx = (byte)2;
                        continue;
                    }
                    if (str.equals("3")) {
                        this.cntx = (byte)3;
                        continue;
                    }
                    this.error = "Bad option: -cntx " + str;
                    this.ok = false;
                    continue;
                }
                if (str.equals("-SORT") || str.equals("-sort")) {
                    String cmd = str;
                    boolean asc = str.equals("-sort");
                    str = args[++i].toLowerCase();
                    ++i;
                    if (str.equals("rank")) {
                        this.sort = 1;
                    } else if (str.equals("term")) {
                        this.sort = 2;
                    } else if (str.equals("cvalue")) {
                        this.sort = 3;
                    } else if (str.equals("comp")) {
                        this.sort = 4;
                    } else if (str.equals("length")) {
                        this.sort = 5;
                    } else if (str.equals("freq_s")) {
                        this.sort = 6;
                    } else if (str.equals("freq_in")) {
                        this.sort = 7;
                    } else if (str.equals("context")) {
                        this.sort = 8;
                    } else {
                        this.error = BADOPTION + cmd + " " + str;
                        this.ok = false;
                    }
                    if (!this.ok || !asc) continue;
                    this.sort += 8;
                    continue;
                }
                if (str.equals("-tr")) {
                    str = args[++i];
                    ++i;
                    try {
                        this.tr = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {
                        this.error = "Bad option: -tr " + str;
                        this.ok = false;
                    }
                    continue;
                }
                if (str.equals("-pf")) {
                    str = args[++i];
                    ++i;
                    try {
                        this.pf = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {
                        this.error = "Bad option: -pf " + str;
                        this.ok = false;
                    }
                    continue;
                }
                if (str.equals("-cc")) {
                    str = args[++i].toLowerCase();
                    ++i;
                    if (str.equals("no")) {
                        this.cc = 0;
                        continue;
                    }
                    if (str.equals("ll")) {
                        this.cc = 1;
                        continue;
                    }
                    if (str.equals("tfitf")) {
                        this.cc = (byte)2;
                        continue;
                    }
                    if (str.equals("csmw")) {
                        this.cc = (byte)3;
                        continue;
                    }
                    if (str.equals("tw")) {
                        this.cc = (byte)4;
                        continue;
                    }
                    this.error = "Bad option: -cc " + str;
                    this.ok = false;
                    continue;
                }
                if (str.equals("-frq")) {
                    ++i;
                    this.frq = 1;
                    continue;
                }
                if (str.equals("-freq")) {
                    str = args[++i].toLowerCase();
                    ++i;
                    try {
                        this.freq = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {
                        this.error = "Bad option: -freq " + str;
                        this.ok = false;
                    }
                    continue;
                }
                if (str.equals("-detr")) {
                    str = args[++i].toLowerCase();
                    ++i;
                    try {
                        this.detRatio = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {
                        this.error = "Bad option: -freq " + str;
                        this.ok = false;
                    }
                    continue;
                }
                if (str.equals("-cval")) {
                    str = args[++i].toLowerCase();
                    ++i;
                    try {
                        this.cval = Double.parseDouble(str);
                    }
                    catch (NumberFormatException e) {
                        this.error = "Bad option: -cval " + str;
                        this.ok = false;
                    }
                    continue;
                }
                if (str.equals("-save")) {
                    str = args[++i].toLowerCase().trim();
                    ++i;
                    this.saveOptions = str.split(" ");
                    this.checkSaveOptions();
                    continue;
                }
                this.error = BADOPTION + str;
                this.ok = false;
                continue;
            }
            readFiles = true;
            this.inputFiles = new String[args.length - i];
            this.inputFiles[j++] = str;
            ++i;
        }
        if (this.ok) {
            File file;
            if (this.config == null) {
                this.config = String.valueOf(TermoPL.appLocation) + File.separator + "termopl_conf.txt";
                file = new File(this.config);
                if (!file.exists()) {
                    this.config = null;
                }
            } else {
                this.config = Preferences.resolveFilePath(this.wrk, this.config);
                file = new File(this.config);
                if (!file.exists()) {
                    this.error = "Configuration file '" + this.config + "' does not exist";
                    this.ok = false;
                    this.config = null;
                }
            }
            if (this.config != null) {
                this.readConfig(this.config);
            }
        }
        if (this.ok && this.output == null && this.export == null && this.exportForms == null && this.exportSentences == null && this.exportGroups == null) {
            this.error = "No output is specified";
            this.ok = false;
        }
        if (this.ok) {
            if (this.inputFiles != null) {
                i = 0;
                while (i < this.inputFiles.length) {
                    this.inputFiles[i] = Preferences.resolveFilePath(this.wrk, this.inputFiles[i]);
                    ++i;
                }
            }
            if (this.output != null) {
                this.output = Preferences.resolveFilePath(this.wrk, this.output);
            }
            if (this.export != null) {
                this.export = Preferences.resolveFilePath(this.wrk, this.export);
            }
            if (this.exportForms != null) {
                this.exportForms = Preferences.resolveFilePath(this.wrk, this.exportForms);
            }
            if (this.exportSentences != null) {
                this.exportSentences = Preferences.resolveFilePath(this.wrk, this.exportSentences);
            }
            if (this.exportGroups != null) {
                this.exportGroups = Preferences.resolveFilePath(this.wrk, this.exportGroups);
            }
            if (this.comp != null) {
                this.comp = Preferences.resolveFilePath(this.wrk, this.comp);
            }
            if (this.sw != null) {
                this.sw = Preferences.resolveFilePath(this.wrk, this.sw);
            }
            if (this.cp != null) {
                this.cp = Preferences.resolveFilePath(this.wrk, this.cp);
            }
            if (this.ct != null) {
                this.ct = Preferences.resolveFilePath(this.wrk, this.ct);
            }
            if (this.tagset != null) {
                this.tagset = Preferences.resolveFilePath(this.wrk, this.tagset);
            }
            if (this.grammar != null) {
                this.grammar = Preferences.resolveFilePath(this.wrk, this.grammar);
            }
        }
    }

    public void readConfig(String config) {
        File file = new File(config);
        Pattern pat = Pattern.compile("(-[A-Za-z]+)\\s+(.*)");
        LinkedList<String> batchInput = null;
        boolean initInputFiles = false;
        boolean initOutput = false;
        boolean initExport = false;
        boolean initExportForms = false;
        boolean initExportSentences = false;
        boolean initExportGroups = false;
        boolean initComp = false;
        boolean initSW = false;
        boolean initCP = false;
        boolean initCT = false;
        boolean initTagset = false;
        boolean initGrammar = false;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            do {
                if ((line = reader.readLine()) == null) continue;
                if ((line = line.trim()).equals("-SW")) {
                    if (this.sw != null) continue;
                    initSW = true;
                    this.sw = String.valueOf(TermoPL.appLocation) + File.separator + "termopl_sw.txt";
                    continue;
                }
                if (line.equals("-CP")) {
                    if (this.cp != null) continue;
                    initCP = true;
                    this.cp = String.valueOf(TermoPL.appLocation) + File.separator + "termopl_cp.txt";
                    continue;
                }
                if (line.equals("-CT")) {
                    if (this.ct != null) continue;
                    initCT = true;
                    this.ct = String.valueOf(TermoPL.appLocation) + File.separator + "termopl_ct.txt";
                    continue;
                }
                if (line.equals("-mw")) {
                    this.mw = 1;
                    continue;
                }
                if (line.equals("-sf")) {
                    this.sf = 1;
                    continue;
                }
                if (line.equals("-nf")) {
                    this.nf = 1;
                    continue;
                }
                if (line.equals("-frq")) {
                    this.frq = 1;
                    continue;
                }
                if (line.equals("-indx")) {
                    this.indx = 1;
                    continue;
                }
                if (line.equals("-group")) {
                    this.group = 1;
                    continue;
                }
                Matcher matcher = pat.matcher(line);
                if (matcher.matches()) {
                    int xi;
                    int xb;
                    String name = matcher.group(1);
                    String arg = matcher.group(2);
                    if (name.equals("-in")) {
                        if (this.inputFiles != null) continue;
                        if (!initInputFiles) {
                            initInputFiles = true;
                            batchInput = new LinkedList<String>();
                        }
                        batchInput.add(arg);
                        continue;
                    }
                    if (name.equals("-out")) {
                        if (this.output != null) continue;
                        initOutput = true;
                        this.output = arg;
                        continue;
                    }
                    if (name.equals("-wrk")) {
                        if (this.wrk != null) continue;
                        this.wrk = arg;
                        continue;
                    }
                    if (name.equals("-wdn")) {
                        if (this.wdn != null) continue;
                        this.wdn = arg;
                        continue;
                    }
                    if (name.equals("-exp")) {
                        if (this.export != null) continue;
                        initExport = true;
                        this.export = arg;
                        continue;
                    }
                    if (name.equals("-expf")) {
                        if (this.exportForms != null) continue;
                        initExportForms = true;
                        this.exportForms = arg;
                        continue;
                    }
                    if (name.equals("-exps")) {
                        if (this.exportSentences != null) continue;
                        initExportSentences = true;
                        this.exportSentences = arg;
                        continue;
                    }
                    if (name.equals("-expg")) {
                        if (this.exportGroups != null) continue;
                        initExportGroups = true;
                        this.exportGroups = arg;
                        continue;
                    }
                    if (name.equals("-comp")) {
                        if (this.comp != null) continue;
                        initComp = true;
                        this.comp = arg;
                        continue;
                    }
                    if (name.equals("-sw")) {
                        if (this.sw != null) continue;
                        initSW = true;
                        this.sw = arg;
                        continue;
                    }
                    if (name.equals("-cp")) {
                        if (this.cp != null) continue;
                        initCP = true;
                        this.cp = arg;
                        continue;
                    }
                    if (name.equals("-ct")) {
                        if (this.ct != null) continue;
                        initCT = true;
                        this.ct = arg;
                        continue;
                    }
                    if (name.equals("-tagset")) {
                        if (this.tagset != null) continue;
                        initTagset = true;
                        this.tagset = arg;
                        continue;
                    }
                    if (name.equals("-grammar")) {
                        if (this.grammar != null) continue;
                        initGrammar = true;
                        this.grammar = arg;
                        continue;
                    }
                    if (name.equals("-python")) {
                        if (this.python != null) continue;
                        this.python = arg;
                        continue;
                    }
                    if (name.equals("-lang")) {
                        this.language = arg.toLowerCase();
                        continue;
                    }
                    if (name.equals("-method")) {
                        this.method = arg.toLowerCase();
                        continue;
                    }
                    if (name.equals("-ignc")) {
                        this.ignoreCase = arg.toLowerCase();
                        continue;
                    }
                    if (name.equals("-det")) {
                        this.det = arg.toLowerCase();
                        continue;
                    }
                    if (name.equals("-srch")) {
                        arg = arg.toLowerCase();
                        xb = -1;
                        if (arg.equals("npmi1")) {
                            xb = 1;
                        } else if (arg.equals("npmi2")) {
                            xb = 2;
                        } else if (arg.equals("npmi3")) {
                            xb = 3;
                        } else if (arg.equals("nonpmi1")) {
                            xb = 4;
                        } else if (arg.equals("nonpmi2")) {
                            xb = 5;
                        } else {
                            this.error = BADOPTION + line;
                            this.ok = false;
                        }
                        if (this.srch != -1) continue;
                        this.srch = (byte)xb;
                        continue;
                    }
                    if (name.equals("-cntx")) {
                        arg = arg.toLowerCase();
                        xb = -1;
                        if (arg.equals("1")) {
                            xb = 1;
                        } else if (arg.equals("2")) {
                            xb = 2;
                        } else if (arg.equals("3")) {
                            xb = 3;
                        } else {
                            this.error = BADOPTION + line;
                            this.ok = false;
                        }
                        if (this.cntx != -1) continue;
                        this.cntx = (byte)xb;
                        continue;
                    }
                    if (name.equals("-SORT") || name.equals("-sort")) {
                        boolean asc = name.equals("-sort");
                        xi = -1;
                        if (arg.equals("rank")) {
                            xi = 1;
                        } else if (arg.equals("term")) {
                            xi = 2;
                        } else if (arg.equals("cvalue")) {
                            xi = 3;
                        } else if (arg.equals("comp")) {
                            xi = 4;
                        } else if (arg.equals("length")) {
                            xi = 5;
                        } else if (arg.equals("freq_s")) {
                            xi = 6;
                        } else if (arg.equals("freq_in")) {
                            xi = 7;
                        } else if (arg.equals("context")) {
                            xi = 8;
                        } else {
                            this.error = BADOPTION + line;
                            this.ok = false;
                        }
                        if (!this.ok) continue;
                        if (asc) {
                            xi += 8;
                        }
                        if (this.sort != -1) continue;
                        this.sort = xi;
                        continue;
                    }
                    if (name.equals("-tr")) {
                        xi = -1;
                        try {
                            xi = Integer.parseInt(arg);
                        }
                        catch (NumberFormatException e) {
                            this.error = BADOPTION + line;
                            this.ok = false;
                        }
                        if (this.tr != -1) continue;
                        this.tr = xi;
                        continue;
                    }
                    if (name.equals("-pf")) {
                        xi = -1;
                        try {
                            xi = Integer.parseInt(arg);
                        }
                        catch (NumberFormatException e) {
                            this.error = BADOPTION + line;
                            this.ok = false;
                        }
                        if (this.pf != -1) continue;
                        this.pf = xi;
                        continue;
                    }
                    if (name.equals("-cc")) {
                        xb = -1;
                        if ((arg = arg.toLowerCase()).equals("no")) {
                            this.cc = 0;
                        } else if (arg.equals("ll")) {
                            this.cc = 1;
                        } else if (arg.equals("tfitf")) {
                            this.cc = (byte)2;
                        } else if (arg.equals("csmw")) {
                            this.cc = (byte)3;
                        } else if (arg.equals("tw")) {
                            this.cc = (byte)4;
                        } else {
                            this.error = BADOPTION + line;
                            this.ok = false;
                        }
                        if (this.cc != -1) continue;
                        this.cc = (byte)xb;
                        continue;
                    }
                    if (name.equals("-freq")) {
                        xi = -1;
                        try {
                            xi = Integer.parseInt(arg);
                        }
                        catch (NumberFormatException e) {
                            this.error = BADOPTION + line;
                            this.ok = false;
                        }
                        if (this.freq != -1) continue;
                        this.freq = xi;
                        continue;
                    }
                    if (name.equals("-detr")) {
                        xi = -1;
                        try {
                            xi = Integer.parseInt(arg);
                        }
                        catch (NumberFormatException e) {
                            this.error = BADOPTION + line;
                            this.ok = false;
                        }
                        if (this.detRatio != -1) continue;
                        this.detRatio = xi;
                        continue;
                    }
                    if (name.equals("-cval")) {
                        double xd = -1.0;
                        try {
                            xd = Double.parseDouble(arg);
                        }
                        catch (NumberFormatException e) {
                            this.error = BADOPTION + line;
                            this.ok = false;
                        }
                        if (this.cval != -1.0) continue;
                        this.cval = xd;
                        continue;
                    }
                    if (name.equals("-save")) {
                        arg = arg.trim();
                        this.saveOptions = arg.split(" ");
                        this.checkSaveOptions();
                        continue;
                    }
                    this.error = "Unknown option: " + name;
                    this.ok = false;
                    continue;
                }
                this.error = "Bad configuration file: '" + line + "'";
                this.ok = false;
            } while (this.ok && line != null);
            reader.close();
            if (this.ok) {
                if (initInputFiles) {
                    this.inputFiles = batchInput.toArray(new String[0]);
                    int i = 0;
                    while (i < this.inputFiles.length) {
                        this.inputFiles[i] = Preferences.resolveFilePath(this.wrk, this.inputFiles[i]);
                        ++i;
                    }
                }
                if (initOutput) {
                    this.output = Preferences.resolveFilePath(this.wrk, this.output);
                }
                if (initExport) {
                    this.export = Preferences.resolveFilePath(this.wrk, this.export);
                }
                if (initExportForms) {
                    this.exportForms = Preferences.resolveFilePath(this.wrk, this.exportForms);
                }
                if (initExportSentences) {
                    this.exportSentences = Preferences.resolveFilePath(this.wrk, this.exportSentences);
                }
                if (initExportGroups) {
                    this.exportGroups = Preferences.resolveFilePath(this.wrk, this.exportGroups);
                }
                if (initComp) {
                    this.comp = Preferences.resolveFilePath(this.wrk, this.comp);
                }
                if (initSW) {
                    this.sw = Preferences.resolveFilePath(this.wrk, this.sw);
                }
                if (initCP) {
                    this.cp = Preferences.resolveFilePath(this.wrk, this.cp);
                }
                if (initCT) {
                    this.ct = Preferences.resolveFilePath(this.wrk, this.ct);
                }
                if (initTagset) {
                    this.tagset = Preferences.resolveFilePath(this.wrk, this.tagset);
                }
                if (initGrammar) {
                    this.grammar = Preferences.resolveFilePath(this.wrk, this.grammar);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ok = false;
        }
    }

    public void checkSaveOptions() {
        if (this.saveOptions == null || this.saveOptions.length == 0) {
            this.error = "Save options not specified";
            this.ok = false;
        } else {
            String[] stringArray = this.saveOptions;
            int n = this.saveOptions.length;
            int n2 = 0;
            while (n2 < n) {
                String so = stringArray[n2];
                boolean found = false;
                String[] stringArray2 = SOPTIONS;
                int n3 = SOPTIONS.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray2[n4];
                    if (s.equals(so)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    this.error = "Unknown save option: " + so;
                    this.ok = false;
                }
                ++n2;
            }
        }
    }
}

