/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.io.Serializable;
import java.util.List;
import pl.sgjp.morfeusz.Morfeusz;
import pl.sgjp.morfeusz.MorfeuszUsage;
import pl.sgjp.morfeusz.MorphInterpretation;
import termopl.Term;

public class CommonTerm
implements Serializable {
    private static final long serialVersionUID = -3160688595209534380L;
    private static Morfeusz morfeusz = null;
    public String bf;
    public String sf;

    public CommonTerm() {
        this.sf = "";
        this.bf = "";
    }

    public CommonTerm(String bf, String sf) {
        this.bf = bf;
        this.sf = sf;
        if (sf.isEmpty()) {
            this.sf = this.createSimplifiedForm(bf);
        }
    }

    public int hashCode() {
        return this.bf.hashCode() + this.sf.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Term) {
            String s1 = ((CommonTerm)obj).bf;
            String s2 = ((CommonTerm)obj).sf;
            return s1.equals(this.bf) && s2.equals(this.sf);
        }
        return false;
    }

    public String createSimplifiedForm(String bf) {
        if (morfeusz == null) {
            morfeusz = Morfeusz.createInstance(MorfeuszUsage.ANALYSE_ONLY);
        }
        List<MorphInterpretation> interps = morfeusz.analyseAsList(bf);
        int n = -1;
        String sf = "";
        for (MorphInterpretation mi : interps) {
            String lemma;
            int index;
            if (mi.getStartNode() == n) continue;
            n = mi.getStartNode();
            if (!sf.isEmpty()) {
                sf = String.valueOf(sf) + " ";
            }
            if ((index = (lemma = mi.getLemma()).indexOf(":")) > 0) {
                lemma = lemma.substring(0, index);
            }
            sf = String.valueOf(sf) + lemma;
        }
        return sf;
    }
}

