/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import termopl.CommonResources;
import termopl.InfoPanel;
import termopl.Pair;
import termopl.TermEx;
import termopl.TermoPL;
import termopl.TermoPLDocument;
import termopl.TermsView;
import termopl.WordNet;
import termopl.WordReplacement;

public class GroupsView
extends JPanel {
    private static final int ROOT = 0;
    private static final int PARENT = 1;
    private static final int CHILD = 2;
    private TermoPLDocument doc;
    private TermComparator comp;
    private SimpleComparator simpleComp;
    private JSplitPane splitPane;
    private HierarchyPanel hierarchyPanel;
    private RelatedPanel relatedPanel;
    private InfoPanel infoPanel;
    private JLabel relatedLabel;

    public GroupsView(TermoPLDocument document) {
        this.doc = document;
        this.comp = new TermComparator();
        this.simpleComp = new SimpleComparator();
        this.setLayout(new BorderLayout());
        this.arrangeComponents();
        TermsView tv = this.doc.getTermsView();
        if (tv != null) {
            this.setData((TermEx)tv.getSelectedTerm());
        }
    }

    public void arrangeComponents() {
        this.hierarchyPanel = new HierarchyPanel();
        JScrollPane sp = new JScrollPane(this.hierarchyPanel);
        sp.getViewport().setBackground(CommonResources.LIGHT_GRAY);
        sp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, -1, 0, -1), BorderFactory.createLineBorder(Color.lightGray)));
        if (this.doc.getPreferences().useWordNet) {
            JPanel container = new JPanel(new BorderLayout());
            this.relatedLabel = new JLabel();
            this.relatedLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, -1, -1, -1), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray), BorderFactory.createEmptyBorder(2, 4, 2, 4))));
            container.add((Component)this.relatedLabel, "North");
            this.splitPane = new JSplitPane(0);
            this.splitPane.setDividerSize(6);
            this.splitPane.setBorder(BorderFactory.createEmptyBorder());
            this.splitPane.setTopComponent(sp);
            this.relatedPanel = new RelatedPanel();
            sp = new JScrollPane(this.relatedPanel);
            sp.getViewport().setBackground(CommonResources.LIGHT_GRAY);
            sp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, -1, 0, -1), BorderFactory.createLineBorder(Color.lightGray)));
            container.add((Component)sp, "Center");
            this.splitPane.setBottomComponent(container);
            this.add((Component)this.splitPane, "Center");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GroupsView.this.splitPane.setDividerLocation(0.75);
                }
            });
        } else {
            this.relatedPanel = null;
            this.splitPane = null;
            this.add((Component)sp, "Center");
        }
        this.infoPanel = new InfoPanel();
        this.add((Component)this.infoPanel, "South");
    }

    public void requestData(TermEx term) {
        TermsView tv = this.doc.getTermsView();
        if (tv != null) {
            tv.setSelectedTerm(term);
        }
    }

    public void setData(TermEx term) {
        this.hierarchyPanel.setData(term);
        if (this.relatedPanel != null) {
            this.relatedPanel.setData(term);
        }
        if (term != null) {
            this.infoPanel.setInfo("Term: " + term.str);
        } else {
            this.infoPanel.setWarning("Term is not selected.");
        }
    }

    public void sort(LinkedList<String> terms, boolean simple) {
        if (simple) {
            Collections.sort(terms, this.simpleComp);
        } else {
            Collections.sort(terms, this.comp);
        }
    }

    public void reset() {
        this.setData(null);
    }

    public void changeFontSize() {
        this.hierarchyPanel.changeFont();
        if (this.relatedPanel != null) {
            this.relatedPanel.changeFont();
        }
        this.invalidate();
        this.repaint();
    }

    private class ArrowPanel
    extends JPanel {
        public ArrowPanel() {
            FontMetrics fm = this.getFontMetrics(TermoPL.preferences.boldFont);
            Dimension dim = new Dimension(32, fm.getHeight() + 5);
            this.setPreferredSize(dim);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            int y = this.getHeight() / 2;
            Polygon arrowHead = new Polygon();
            g.setColor(Color.gray);
            g.drawLine(0, y, 32, y);
            arrowHead.addPoint(0, y);
            arrowHead.addPoint(8, y - 4);
            arrowHead.addPoint(6, y);
            arrowHead.addPoint(8, y + 4);
            g.fill(arrowHead);
        }
    }

    private class HierarchyPanel
    extends JPanel {
        private TreeNode root;
        private int offsetY;
        private int maxWidth;

        public HierarchyPanel() {
            super(null);
        }

        public void setData(TermEx term) {
            this.setVisible(false);
            this.removeAll();
            this.maxWidth = 0;
            this.offsetY = 0;
            if (term != null) {
                this.arrangeNodes(term);
            } else {
                this.root = null;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HierarchyPanel.this.scrollRectToVisible(CommonResources.nullRect);
                    HierarchyPanel.this.calcSize();
                    HierarchyPanel.this.revalidate();
                    HierarchyPanel.this.repaint();
                }
            });
            this.setVisible(true);
        }

        public void changeFont() {
            if (this.root != null) {
                TermEx term = this.root.term;
                this.setData(term);
            }
        }

        public void arrangeNodes(TermEx term) {
            this.offsetY = 16;
            this.arrangeNodes(null, term);
        }

        public void arrangeNodes(TreeNode parent, TermEx child) {
            TreeNode p;
            LinkedList<String> eq;
            boolean found;
            TermEx term;
            LinkedList<TermEx> visited;
            int y;
            int x;
            TreeNode node = new TreeNode(child, parent == null ? 0 : 2);
            LinkedList<String> children = child.collectChildren(GroupsView.this.doc.getTermMap());
            LinkedList<String> parents = child.collectParents(GroupsView.this.doc.getTermMap());
            this.add(node);
            if (parents != null) {
                GroupsView.this.sort(parents, false);
            }
            Dimension dim = node.getPreferredSize();
            node.setBounds(16, this.offsetY, dim.width, dim.height);
            int dy = dim.height;
            if (parent == null) {
                this.root = node;
                if (this.maxWidth < dim.width + 16) {
                    this.maxWidth = dim.width + 16;
                }
                if (parents != null) {
                    ArrowPanel ap = new ArrowPanel();
                    x = node.getX() + node.getWidth();
                    y = node.getY();
                    this.add(ap);
                    dim = ap.getPreferredSize();
                    ap.setBounds(x, y, dim.width, dim.height);
                    x += dim.width;
                    visited = new LinkedList();
                    for (String t : parents) {
                        term = (TermEx)GroupsView.this.doc.getTermMap().get(t);
                        found = false;
                        for (TermEx v : visited) {
                            eq = v.getEquivalentTerms();
                            if (eq == null || !eq.contains(t)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        p = new TreeNode(term, 1);
                        this.add(p);
                        dim = p.getPreferredSize();
                        p.setBounds(x, y, dim.width, dim.height);
                        if (dy < dim.height) {
                            dy = dim.height;
                        }
                        x += dim.width + 4;
                        visited.add(term);
                    }
                    if (this.maxWidth < x) {
                        this.maxWidth = x;
                    }
                }
            } else {
                boolean drawArrow = true;
                parent.addChild(node);
                x = node.getX() + node.getWidth();
                y = node.getY();
                visited = new LinkedList<TermEx>();
                if (parents != null) {
                    for (String t : parents) {
                        term = (TermEx)GroupsView.this.doc.getTermMap().get(t);
                        found = false;
                        for (TermEx v : visited) {
                            eq = v.getEquivalentTerms();
                            if (eq == null || !eq.contains(t)) continue;
                            found = true;
                            break;
                        }
                        if (this.root.term.isDescendant(term, GroupsView.this.doc.getTermMap()) || found) continue;
                        if (drawArrow) {
                            ArrowPanel ap = new ArrowPanel();
                            this.add(ap);
                            dim = ap.getPreferredSize();
                            ap.setBounds(x, y, dim.width, dim.height);
                            x += dim.width;
                            drawArrow = false;
                        }
                        p = new TreeNode(term, 1);
                        this.add(p);
                        dim = p.getPreferredSize();
                        if (dy < dim.height) {
                            dy = dim.height;
                        }
                        p.setBounds(x, y, dim.width, dim.height);
                        x += dim.width + 4;
                        visited.add(term);
                    }
                }
                if (this.maxWidth < x) {
                    this.maxWidth = x;
                }
            }
            this.offsetY = node.getY() + dy + 8;
            if (children != null) {
                GroupsView.this.sort(children, false);
                for (String t : children) {
                    TermEx term2 = (TermEx)GroupsView.this.doc.getTermMap().get(t);
                    this.arrangeNodes(node, term2);
                }
            }
        }

        public void calcSize() {
            this.setPreferredSize(new Dimension(this.maxWidth + 16, this.offsetY + 8));
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paintComponent(g);
            if (this.root != null) {
                g.setColor(Color.gray);
                this.root.drawEdges(g);
            }
        }

        private class TreeNode
        extends JPanel {
            private TermEx term;
            private int type;
            private LinkedList<TreeNode> children;

            public TreeNode(TermEx term, int type) {
                super(new GridLayout(0, 1));
                this.children = new LinkedList();
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, -1, 0), BorderFactory.createLineBorder(Color.lightGray)));
                this.term = term;
                this.type = type;
                this.arrangeComponents();
            }

            public void arrangeComponents() {
                LinkedList<String> equiv = this.term.getEquivalentTerms();
                String skipID = null;
                boolean addType = true;
                if (this.type == 0) {
                    this.addLabel(this.term, TermoPL.preferences.boldFont, this.type);
                    skipID = this.term.id;
                    addType = false;
                } else if (equiv == null) {
                    this.addLabel(this.term, TermoPL.preferences.boldFont, this.type);
                }
                if (equiv != null) {
                    GroupsView.this.sort(equiv, true);
                    for (String e : equiv) {
                        if (e == skipID) continue;
                        if (addType) {
                            this.addLabel((TermEx)GroupsView.this.doc.getTermMap().get(e), TermoPL.preferences.boldFont, this.type);
                            addType = false;
                            continue;
                        }
                        this.addLabel((TermEx)GroupsView.this.doc.getTermMap().get(e));
                    }
                }
            }

            public void addLabel(TermEx term) {
                TLabel label = new TLabel(term);
                this.add(label);
            }

            public void addLabel(TermEx term, Font font, int type) {
                Color color;
                switch (type) {
                    case 0: {
                        color = CommonResources.LIGHT_BLUE;
                        break;
                    }
                    case 1: {
                        color = CommonResources.PALE_ORANGE;
                        break;
                    }
                    case 2: {
                        color = CommonResources.LIGHT_GREEN;
                        break;
                    }
                    default: {
                        color = CommonResources.CREAM;
                    }
                }
                TLabel label = new TLabel(term, font, color);
                this.add(label);
            }

            public void addChild(TreeNode node) {
                Dimension dim = node.getPreferredSize();
                this.children.add(node);
                node.setBounds(this.getX() + 32, HierarchyPanel.this.offsetY, dim.width, dim.height);
                HierarchyPanel hierarchyPanel = HierarchyPanel.this;
                hierarchyPanel.offsetY = hierarchyPanel.offsetY + (dim.height + 8);
                if (HierarchyPanel.this.maxWidth < this.getX() + dim.width + 32) {
                    HierarchyPanel.this.maxWidth = this.getX() + dim.width + 32;
                }
            }

            public void drawEdges(Graphics2D graphics) {
                for (TreeNode tn : this.children) {
                    this.drawEdgeToChild(tn, graphics);
                    tn.drawEdges(graphics);
                }
            }

            public void drawEdgeToChild(TreeNode tn, Graphics2D graphics) {
                int x1 = this.getX() + 8;
                int y1 = this.getY() + this.getHeight();
                int x2 = tn.getX();
                int y2 = tn.getY() + tn.getHeight() / 2;
                Polygon arrowHead = new Polygon();
                graphics.drawLine(x1, y1, x1, y2 - 8);
                graphics.drawArc(x1, y2 - 16, 16, 16, -90, -90);
                graphics.drawLine(x1 + 8, y2, x2, y2);
                arrowHead.addPoint(x2, y2);
                arrowHead.addPoint(x2 - 8, y2 + 4);
                arrowHead.addPoint(x2 - 6, y2);
                arrowHead.addPoint(x2 - 8, y2 - 4);
                graphics.fill(arrowHead);
            }
        }
    }

    private class RelatedPanel
    extends JPanel {
        private TermEx term;
        private LinkedList<ReplacementsPanel> components;

        public RelatedPanel() {
            super(new GridBagLayout());
        }

        public void setData(TermEx term) {
            this.setVisible(false);
            this.term = term;
            this.removeAll();
            this.components = new LinkedList();
            this.installRelated();
            if (term != null) {
                LinkedList<String> equiv = term.getEquivalentTerms();
                StringBuffer buffer = new StringBuffer();
                buffer.append("Terms related to: ");
                buffer.append("'");
                buffer.append(term.str);
                buffer.append("'");
                if (equiv != null) {
                    for (String e : equiv) {
                        if (e == term.id) continue;
                        TermEx t = (TermEx)GroupsView.this.doc.getTermMap().get(e);
                        buffer.append(" & ");
                        buffer.append("'");
                        buffer.append(t.str);
                        buffer.append("'");
                    }
                }
                GroupsView.this.relatedLabel.setText(buffer.toString());
            } else {
                GroupsView.this.relatedLabel.setText("Related terms");
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RelatedPanel.this.doLayout();
                    RelatedPanel.this.revalidate();
                    RelatedPanel.this.repaint();
                }
            });
            this.setVisible(true);
        }

        public void changeFont() {
            this.doLayout();
            this.revalidate();
            this.repaint();
        }

        public void installRelated() {
            if (this.term != null) {
                LinkedList<Pair<String, LinkedList<WordReplacement>>> relatedTerms = this.term.collectRelated(GroupsView.this.doc.getTermMap());
                GridBagConstraints constr = new GridBagConstraints();
                constr.anchor = 18;
                constr.fill = 2;
                constr.weightx = 1.0;
                constr.weighty = 0.0;
                constr.gridx = 0;
                constr.gridy = 0;
                if (relatedTerms != null) {
                    Color color = Color.white;
                    for (Pair pair : relatedTerms) {
                        ReplacementsPanel panel = new ReplacementsPanel(pair);
                        panel.setBackground(color);
                        color = color == Color.white ? CommonResources.VLIGHT_BLUE : Color.white;
                        this.add((Component)panel, constr);
                        this.components.add(panel);
                        ++constr.gridy;
                    }
                }
                constr.fill = 3;
                constr.weighty = 1.0;
                this.add(Box.createGlue(), constr);
            }
        }

        @Override
        public void doLayout() {
            this.calcSize();
            super.doLayout();
        }

        public void calcSize() {
            for (ReplacementsPanel p : this.components) {
                p.calcSize();
            }
        }

        private class ReplacementsPanel
        extends JPanel {
            private Pair<String, LinkedList<WordReplacement>> replacements;

            public ReplacementsPanel(final Pair<String, LinkedList<WordReplacement>> replacements) {
                this.replacements = replacements;
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, -1, 0, -1), BorderFactory.createLineBorder(Color.lightGray)));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent event) {
                        if (event.getClickCount() > 1) {
                            TermEx t = (TermEx)GroupsView.this.doc.getTermMap().get(replacements.first);
                            GroupsView.this.requestData(t);
                        }
                    }
                });
            }

            public void calcSize() {
                Graphics graphics = this.getGraphics();
                Graphics2D g = (Graphics2D)graphics;
                double fx = 4.0;
                int y = 2;
                int w = this.getWidth() - 4;
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics.setColor(Color.black);
                graphics.setFont(TermoPL.preferences.boldFont);
                FontMetrics fm = graphics.getFontMetrics();
                TermEx t = (TermEx)GroupsView.this.doc.getTermMap().get(this.replacements.first);
                String str = String.valueOf(t.str) + ":";
                fx += fm.getStringBounds(str, g).getWidth() + 16.0;
                graphics.setFont(TermoPL.preferences.plainFont);
                boolean app = false;
                for (WordReplacement wr : (LinkedList)this.replacements.second) {
                    double fdx;
                    if (wr.relTypes == null) continue;
                    boolean reversed = wr.relTypes.getFirst() < 0;
                    if (app) {
                        str = "; ";
                        fdx = fm.getStringBounds(str, g).getWidth();
                        if (fx + fdx > (double)w) {
                            fx = 32.0;
                            y += fm.getHeight();
                        }
                        fx += fdx;
                    } else {
                        app = true;
                    }
                    fdx = fm.getStringBounds(wr.word, g).getWidth();
                    if (fx + fdx > (double)w) {
                        fx = 32.0;
                        y += fm.getHeight();
                    }
                    if ((fx += fdx) + (fdx = fm.getStringBounds(str = reversed ? " \u2190 " : " \u2192 ", g).getWidth()) > (double)w) {
                        fx = 32.0;
                        y += fm.getHeight();
                    }
                    if ((fx += fdx) + (fdx = fm.getStringBounds(wr.expression, g).getWidth()) > (double)w) {
                        fx = 32.0;
                        y += fm.getHeight();
                    }
                    fx += fdx;
                    int i = 0;
                    ListIterator it = wr.relTypes.listIterator();
                    while (it.hasNext()) {
                        int relType = (Integer)it.next();
                        if (i > 0) {
                            str = ", ";
                            fdx = fm.getStringBounds(str, g).getWidth();
                            if (fx + fdx > (double)w) {
                                fx = 32.0;
                                y += fm.getHeight();
                            }
                            fx += fdx;
                            str = "";
                        } else {
                            str = "[";
                        }
                        if (relType < 0) {
                            relType = -relType;
                        }
                        str = WordNet.getName(relType);
                        if (i == wr.relTypes.size() - 1) {
                            str = String.valueOf(str) + "]";
                        }
                        if (fx + (fdx = fm.getStringBounds(str, g).getWidth()) > (double)w) {
                            fx = 32.0;
                            y += fm.getHeight();
                        }
                        fx += fdx;
                        ++i;
                    }
                }
                this.setPreferredSize(new Dimension(0, (y += fm.getHeight()) + 2));
            }

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D g = (Graphics2D)graphics;
                double fx = 4.0;
                int y = 2;
                int w = this.getWidth() - 4;
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics.setColor(Color.black);
                graphics.setFont(TermoPL.preferences.boldFont);
                FontMetrics fm = graphics.getFontMetrics();
                TermEx t = (TermEx)GroupsView.this.doc.getTermMap().get(this.replacements.first);
                String str = String.valueOf(t.str) + ":";
                g.drawString(str, (int)fx, y + fm.getAscent());
                fx += fm.getStringBounds(str, g).getWidth() + 16.0;
                graphics.setFont(TermoPL.preferences.plainFont);
                boolean app = false;
                for (WordReplacement wr : (LinkedList)this.replacements.second) {
                    double fdx;
                    if (wr.relTypes == null) continue;
                    boolean reversed = wr.relTypes.getFirst() < 0;
                    if (app) {
                        str = "; ";
                        fdx = fm.getStringBounds(str, g).getWidth();
                        if (fx + fdx > (double)w) {
                            fx = 32.0;
                            y += fm.getHeight();
                        }
                        g.drawString(str, (int)fx, y + fm.getAscent());
                        fx += fdx;
                    } else {
                        app = true;
                    }
                    fdx = fm.getStringBounds(wr.word, g).getWidth();
                    if (fx + fdx > (double)w) {
                        fx = 32.0;
                        y += fm.getHeight();
                    }
                    g.drawString(wr.word, (int)fx, y + fm.getAscent());
                    fx += fdx;
                    str = reversed ? " \u2190 " : " \u2192 ";
                    fdx = fm.getStringBounds(str, g).getWidth();
                    if (fx + fdx > (double)w) {
                        fx = 32.0;
                        y += fm.getHeight();
                    }
                    g.drawString(str, (int)fx, y + fm.getAscent());
                    fx += fdx;
                    fdx = fm.getStringBounds(wr.expression, g).getWidth();
                    if (fx + fdx > (double)w) {
                        fx = 32.0;
                        y += fm.getHeight();
                    }
                    g.drawString(wr.expression, (int)fx, y + fm.getAscent());
                    fx += fdx;
                    int i = 0;
                    ListIterator it = wr.relTypes.listIterator();
                    while (it.hasNext()) {
                        int relType = (Integer)it.next();
                        if (i > 0) {
                            str = ", ";
                            fdx = fm.getStringBounds(str, g).getWidth();
                            if (fx + fdx > (double)w) {
                                fx = 32.0;
                                y += fm.getHeight();
                            }
                            g.drawString(str, (int)fx, y + fm.getAscent());
                            fx += fdx;
                            str = "";
                        } else {
                            str = "[";
                        }
                        if (relType < 0) {
                            relType = -relType;
                        }
                        str = String.valueOf(str) + WordNet.getName(relType);
                        if (i == wr.relTypes.size() - 1) {
                            str = String.valueOf(str) + "]";
                        }
                        if (fx + (fdx = fm.getStringBounds(str, g).getWidth()) > (double)w) {
                            fx = 32.0;
                            y += fm.getHeight();
                        }
                        g.drawString(str, (int)fx, y + fm.getAscent());
                        fx += fdx;
                        ++i;
                    }
                }
            }
        }
    }

    private class SimpleComparator
    implements Comparator<String> {
        private SimpleComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            double v1 = ((GroupsView)GroupsView.this).doc.getTermMap().get((Object)s1).cvalue;
            double v2 = ((GroupsView)GroupsView.this).doc.getTermMap().get((Object)s2).cvalue;
            if (v1 < v2) {
                return 1;
            }
            if (v1 > v2) {
                return -1;
            }
            return 0;
        }
    }

    private class TLabel
    extends JLabel {
        private TermEx term;

        public TLabel() {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, -1, 0, -1), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray), BorderFactory.createEmptyBorder(2, 4, 2, 4))));
            this.setOpaque(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() > 1) {
                        GroupsView.this.requestData(TLabel.this.term);
                    } else if (GroupsView.this.relatedPanel != null) {
                        GroupsView.this.relatedPanel.setData(TLabel.this.term);
                    }
                }
            });
        }

        public TLabel(TermEx term) {
            this(term, TermoPL.preferences.plainFont, CommonResources.CREAM);
        }

        public TLabel(TermEx term, Font font, Color background) {
            this();
            this.term = term;
            this.setText(term.str);
            this.setFont(font);
            this.setBackground(background);
        }
    }

    private class TermComparator
    implements Comparator<String> {
        private TermComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            double v2;
            TermEx t;
            double v1;
            TermEx t1 = (TermEx)GroupsView.this.doc.getTermMap().get(s1);
            TermEx t2 = (TermEx)GroupsView.this.doc.getTermMap().get(s2);
            if (t1.getEquivalentTerms() == null) {
                v1 = t1.cvalue;
            } else {
                v1 = 0.0;
                for (String s : t1.getEquivalentTerms()) {
                    t = (TermEx)GroupsView.this.doc.getTermMap().get(s);
                    if (!(t.cvalue > v1)) continue;
                    v1 = t.cvalue;
                }
            }
            if (t2.getEquivalentTerms() == null) {
                v2 = t2.cvalue;
            } else {
                v2 = 0.0;
                for (String s : t2.getEquivalentTerms()) {
                    t = (TermEx)GroupsView.this.doc.getTermMap().get(s);
                    if (!(t.cvalue > v2)) continue;
                    v2 = t.cvalue;
                }
            }
            if (v1 < v2) {
                return 1;
            }
            if (v1 > v2) {
                return -1;
            }
            return 0;
        }
    }
}

