/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import termopl.CommonResources;
import termopl.CorpusReader;
import termopl.FileDescr;
import termopl.InfoPanel;
import termopl.MatchedToken;
import termopl.MultiWordToken;
import termopl.Pair;
import termopl.SentenceRef;
import termopl.SentenceRefEx;
import termopl.Term;
import termopl.TermoPL;
import termopl.TermoPLDocument;
import termopl.TermsView;
import termopl.Token;
import termopl.UDToken;

public class SentencesView
extends JPanel {
    private TermoPLDocument doc;
    private JScrollPane sp;
    private Content content;
    private InfoPanel infoPanel;
    private Term term;

    public SentencesView(TermoPLDocument document) {
        this.doc = document;
        this.setLayout(new BorderLayout());
        this.arrangeComponents();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TermsView tv = SentencesView.this.doc.getTermsView();
                if (tv != null) {
                    SentencesView.this.setData(tv.getSelectedTerm());
                }
            }
        });
    }

    public void arrangeComponents() {
        this.content = new Content();
        this.infoPanel = new InfoPanel();
        this.sp = new JScrollPane(this.content);
        this.sp.getViewport().setBackground(CommonResources.LIGHT_GRAY);
        this.sp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, -1, 0, -1), BorderFactory.createLineBorder(Color.lightGray)));
        this.add((Component)this.sp, "Center");
        this.add((Component)this.infoPanel, "South");
    }

    public void setData(Term term) {
        this.term = term;
        this.content.calcSize();
        this.content.invalidate();
        this.scrollRectToVisible(CommonResources.nullRect);
        this.repaint();
        if (term != null) {
            int n = 0;
            int fileID = -1;
            int oldFileID = -1;
            long pos = -1L;
            long oldPos = -1L;
            for (SentenceRef r : term.getSentenceRef()) {
                if (r instanceof SentenceRefEx) {
                    fileID = ((SentenceRefEx)r).fileID;
                }
                if ((pos = r.start) != oldPos || fileID != oldFileID) {
                    ++n;
                }
                oldFileID = fileID;
                oldPos = pos;
            }
            this.infoPanel.setInfo("Sentences found: " + n + ".");
        } else {
            this.infoPanel.setWarning("Term is not selected.");
        }
    }

    public void reset() {
        this.setData(null);
    }

    public void changeFontSize() {
        this.content.calcSize();
        this.invalidate();
        this.repaint();
    }

    private class Content
    extends JPanel {
        private RandomAccessFile source = null;
        private File sourceFile = null;
        private int indent = 0;
        private int[] lineCount;

        public Content() {
            this.setBackground(CommonResources.LIGHT_GRAY);
        }

        @Override
        public void setSize(int w, int h) {
            super.setSize(w, h);
            this.calcSize();
        }

        public void calcSize() {
            int n = 0;
            if (SentencesView.this.term != null) {
                Graphics graphics = this.getGraphics();
                Graphics2D g = (Graphics2D)graphics;
                LinkedList<SentenceRef> sref = SentencesView.this.term.getSentenceRef();
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                int i = 0;
                long oldPos = -1L;
                long pos = -1L;
                int oldFileID = -1;
                int fileID = -1;
                for (SentenceRef r : sref) {
                    if (r instanceof SentenceRefEx) {
                        fileID = ((SentenceRefEx)r).fileID;
                    }
                    if ((pos = r.start) == oldPos && fileID == oldFileID) continue;
                    ++i;
                }
                this.lineCount = new int[i];
                double f = Math.log10(i);
                i = f < 1.0 ? 1 : (int)f + 1;
                FontMetrics fm = graphics.getFontMetrics(TermoPL.preferences.plainFont);
                this.indent = i * fm.charWidth('0') + 8;
                graphics.setFont(TermoPL.preferences.boldFont);
                fm = graphics.getFontMetrics();
                int h = fm.getHeight();
                i = 0;
                oldPos = -1L;
                pos = -1L;
                oldFileID = -1;
                fileID = -1;
                LinkedList<Integer> positions = new LinkedList<Integer>();
                LinkedList sentence = null;
                byte[] termBounds = null;
                for (SentenceRef r : sref) {
                    if (r instanceof SentenceRefEx) {
                        fileID = ((SentenceRefEx)r).fileID;
                    }
                    if ((pos = r.start) == oldPos && fileID == oldFileID) continue;
                    LinkedList mwtList = null;
                    FileDescr fd = SentencesView.this.doc.getAnalyzedFile(r.getFileID());
                    oldPos = pos;
                    oldFileID = fileID;
                    if (!positions.isEmpty()) {
                        termBounds = this.getTermBounds(sentence, SentencesView.this.term, positions);
                        positions = new LinkedList();
                        n += this.calcSentenceSize(graphics, i, sentence, termBounds);
                        ++i;
                    }
                    try {
                        if (this.sourceFile != fd.file) {
                            this.sourceFile = fd.file;
                            this.source = new RandomAccessFile(this.sourceFile, "r");
                        }
                        Pair<LinkedList<Token>, LinkedList<MultiWordToken>> pair = CorpusReader.getSentence(this.source, fd.type, r.start, r.len);
                        sentence = (LinkedList)pair.first;
                        mwtList = (LinkedList)pair.second;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (mwtList != null) {
                        sentence = CorpusReader.replaceMWT(sentence, mwtList);
                    }
                    if (r.index == 0) {
                        termBounds = this.getTermBounds(sentence, SentencesView.this.term);
                        n += this.calcSentenceSize(graphics, i, sentence, termBounds);
                        ++i;
                        continue;
                    }
                    positions.add(r.index);
                }
                if (!positions.isEmpty()) {
                    termBounds = this.getTermBounds(sentence, SentencesView.this.term, positions);
                    n += this.calcSentenceSize(graphics, i, sentence, termBounds);
                }
                this.setPreferredSize(new Dimension(0, n * h));
            } else {
                this.lineCount = null;
                this.indent = 0;
                this.setPreferredSize(new Dimension(0, 0));
            }
        }

        public int calcSentenceSize(Graphics graphics, int n, LinkedList<Token> sentence, byte[] termBounds) {
            graphics.setFont(TermoPL.preferences.plainFont);
            FontMetrics fm = graphics.getFontMetrics();
            int s = 0;
            int x = this.indent + 4;
            int w = this.getWidth() - this.indent - 8;
            boolean appendSpace = false;
            int index = 0;
            for (Token t : sentence) {
                if (appendSpace) {
                    x += fm.stringWidth(" ");
                }
                switch (termBounds[index]) {
                    case 0: 
                    case 1: {
                        graphics.setFont(TermoPL.preferences.plainFont);
                        break;
                    }
                    default: {
                        graphics.setFont(TermoPL.preferences.boldFont);
                    }
                }
                fm = graphics.getFontMetrics();
                int dx = fm.stringWidth(t.form);
                if (x + dx > w) {
                    x = this.indent + 4;
                    ++s;
                }
                x += dx;
                appendSpace = t.spaceAfter;
                ++index;
            }
            this.lineCount[n] = s + 1;
            return this.lineCount[n];
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (SentencesView.this.term != null) {
                this.paintElements(g, SentencesView.this.term);
            }
        }

        public void paintElements(Graphics graphics, Term term) {
            Rectangle bounds = graphics.getClipBounds();
            LinkedList<SentenceRef> sref = term.getSentenceRef();
            graphics.setFont(TermoPL.preferences.boldFont);
            FontMetrics fm = graphics.getFontMetrics();
            int h = fm.getHeight();
            int index = 0;
            int n = 0;
            int i = 0;
            int y = 0;
            long oldPos = -1L;
            long pos = -1L;
            int oldFileID = -1;
            int fileID = -1;
            for (SentenceRef r : sref) {
                if (r instanceof SentenceRefEx) {
                    fileID = ((SentenceRefEx)r).fileID;
                }
                if ((pos = r.start) != oldPos || fileID != oldFileID) {
                    index = n;
                    if (y + h * this.lineCount[i] > bounds.y) break;
                    y += h * this.lineCount[i];
                    oldPos = pos;
                    oldFileID = fileID;
                    ++i;
                }
                ++n;
            }
            oldPos = -1L;
            pos = -1L;
            oldFileID = -1;
            fileID = -1;
            int Y = bounds.y + bounds.height;
            LinkedList<Integer> positions = new LinkedList<Integer>();
            LinkedList sentence = null;
            ListIterator<SentenceRef> it = sref.listIterator(index);
            byte[] termBounds = null;
            while (it.hasNext()) {
                SentenceRef r = it.next();
                if (r instanceof SentenceRefEx) {
                    fileID = ((SentenceRefEx)r).fileID;
                }
                if ((pos = r.start) != oldPos || fileID != oldFileID) {
                    oldPos = pos;
                    oldFileID = fileID;
                    LinkedList mwtList = null;
                    FileDescr fd = SentencesView.this.doc.getAnalyzedFile(r.getFileID());
                    oldPos = pos;
                    oldFileID = fileID;
                    if (!positions.isEmpty()) {
                        termBounds = this.getTermBounds(sentence, term, positions);
                        positions = new LinkedList();
                        y = this.drawSentence(graphics, 0, y, i + 1, sentence, termBounds);
                        graphics.setColor(CommonResources.LIGHT_GRAY);
                        graphics.drawLine(0, y - 1, this.getWidth(), y - 1);
                        ++i;
                    }
                    try {
                        if (this.sourceFile != fd.file) {
                            this.sourceFile = fd.file;
                            this.source = new RandomAccessFile(this.sourceFile, "r");
                        }
                        Pair<LinkedList<Token>, LinkedList<MultiWordToken>> pair = CorpusReader.getSentence(this.source, fd.type, r.start, r.len);
                        sentence = (LinkedList)pair.first;
                        mwtList = (LinkedList)pair.second;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (mwtList != null) {
                        sentence = CorpusReader.replaceMWT(sentence, mwtList);
                    }
                    if (r.index == 0) {
                        termBounds = this.getTermBounds(sentence, term);
                        y = this.drawSentence(graphics, 0, y, i + 1, sentence, termBounds);
                        graphics.setColor(CommonResources.LIGHT_GRAY);
                        graphics.drawLine(0, y - 1, this.getWidth(), y - 1);
                        ++i;
                    }
                }
                if (r.index > 0) {
                    positions.add(r.index);
                }
                if (y >= Y) break;
            }
            if (y < Y && !positions.isEmpty()) {
                termBounds = this.getTermBounds(sentence, term, positions);
                y = this.drawSentence(graphics, 0, y, i + 1, sentence, termBounds);
                graphics.setColor(CommonResources.LIGHT_GRAY);
                graphics.drawLine(0, y - 1, this.getWidth(), y - 1);
            }
            graphics.setColor(Color.lightGray);
            graphics.drawLine(this.indent, bounds.y, this.indent, Y);
        }

        public byte[] getTermBounds(LinkedList<Token> sentence, Term term) {
            byte[] bounds = new byte[sentence.size()];
            LinkedList<MatchedToken> mtokens = term.getForms().getFirst().getTokens();
            ListIterator siterator = sentence.listIterator();
            Token[] termTokens = new Token[mtokens.size()];
            int i = 0;
            int n = 0;
            int index = 0;
            int s = -1;
            int e = -1;
            for (MatchedToken mt : mtokens) {
                termTokens[i++] = mt.token;
            }
            i = 0;
            while (i < bounds.length) {
                bounds[i] = 0;
                ++i;
            }
            while (siterator.hasNext()) {
                Token t1 = (Token)siterator.next();
                Token t2 = termTokens[n];
                if (t1.lemma.equals(t2.lemma)) {
                    if (s == -1) {
                        s = e = index;
                    } else {
                        ++e;
                    }
                    if (n == termTokens.length - 1) {
                        n = 0;
                        i = s;
                        while (i <= e) {
                            bounds[i] = 2;
                            ++i;
                        }
                        e = -1;
                        s = -1;
                    } else {
                        ++n;
                    }
                } else {
                    n = 0;
                    e = -1;
                    s = -1;
                }
                ++index;
            }
            return bounds;
        }

        public byte[] getTermBounds(LinkedList<Token> sentence, Term term, LinkedList<Integer> positions) {
            byte[] bounds = new byte[sentence.size()];
            ListIterator siterator = sentence.listIterator();
            int i = 0;
            while (i < bounds.length) {
                bounds[i] = 0;
                ++i;
            }
            i = 0;
            Iterator iterator = positions.iterator();
            block1: while (iterator.hasNext()) {
                int pos = (Integer)iterator.next();
                LinkedList<MatchedToken> mtokens = term.getForms().getFirst().getTokens();
                while (siterator.hasNext()) {
                    Token st = (Token)siterator.next();
                    int index = st instanceof UDToken ? ((UDToken)st).index : (st instanceof MultiWordToken ? ((MultiWordToken)st).startToken() : -1);
                    if (index == pos) {
                        ListIterator miterator = mtokens.listIterator();
                        bounds[i++] = 2;
                        miterator.next();
                        if (!miterator.hasNext()) continue block1;
                        Token t1 = ((MatchedToken)miterator.next()).token;
                        while (siterator.hasNext()) {
                            Token t2 = (Token)siterator.next();
                            if (t1.lemma.equals(t2.lemma)) {
                                bounds[i] = 2;
                                if (!miterator.hasNext()) {
                                    ++i;
                                    break;
                                }
                                t1 = ((MatchedToken)miterator.next()).token;
                            } else {
                                bounds[i] = 1;
                            }
                            ++i;
                        }
                        if (miterator.hasNext()) continue;
                        continue block1;
                    }
                    ++i;
                }
            }
            return bounds;
        }

        public int drawSentence(Graphics graphics, int x, int y, int n, LinkedList<Token> sentence, byte[] termBounds) {
            String str = String.valueOf(n);
            graphics.setFont(TermoPL.preferences.boldFont);
            FontMetrics fm = graphics.getFontMetrics();
            int h = fm.getHeight();
            int a = fm.getAscent();
            Color c = n % 2 == 0 ? CommonResources.VLIGHT_BLUE : Color.white;
            graphics.setColor(c);
            graphics.fillRect(0, y, this.getWidth(), h);
            Color c0 = Color.black;
            graphics.setColor(c0);
            graphics.setFont(TermoPL.preferences.plainFont);
            fm = graphics.getFontMetrics();
            int w = fm.stringWidth(str);
            w = (this.indent - w) / 2;
            graphics.drawString(str, w, y + a);
            x = this.indent + 4;
            w = this.getWidth() - this.indent - 8;
            boolean appendSpace = false;
            int index = 0;
            for (Token t : sentence) {
                int dx;
                if (appendSpace) {
                    dx = fm.stringWidth(" ");
                    x += dx;
                }
                appendSpace = t.spaceAfter;
                switch (termBounds[index]) {
                    case 0: 
                    case 1: {
                        graphics.setFont(TermoPL.preferences.plainFont);
                        break;
                    }
                    default: {
                        graphics.setFont(TermoPL.preferences.boldFont);
                    }
                }
                fm = graphics.getFontMetrics();
                dx = fm.stringWidth(t.form);
                if (x + dx > w) {
                    x = this.indent + 4;
                    graphics.setColor(c);
                    graphics.fillRect(0, y += h, this.getWidth(), h);
                    graphics.setColor(c0);
                }
                switch (termBounds[index]) {
                    case 0: {
                        graphics.setColor(Color.black);
                        break;
                    }
                    case 1: {
                        graphics.setColor(Color.blue);
                        break;
                    }
                    default: {
                        graphics.setColor(Color.red);
                    }
                }
                graphics.drawString(t.form, x, y + a);
                x += dx;
                ++index;
            }
            return y + h;
        }
    }
}

