/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import pl.sgjp.morfeusz.Morfeusz;
import pl.sgjp.morfeusz.MorphInterpretation;
import pl.sgjp.morfeusz.WhitespaceHandling;
import termopl.Morph;
import termopl.TermoPL;

public class Tagger {
    private Morfeusz morfeusz = Morph.getAnalyzer();
    private File input;
    private File output;

    public Tagger(File input, File output) {
        this.morfeusz.setWhitespaceHandling(WhitespaceHandling.APPEND_WHITESPACES);
        this.input = input;
        this.output = output;
    }

    public void run() {
        String cmd;
        String err = null;
        File dir = new File(String.valueOf(TermoPL.appLocation) + File.separator + "concraft-pl");
        if (dir.exists()) {
            File file;
            String path = String.valueOf(dir.getAbsolutePath()) + File.separator + "concraft-pl";
            if (TermoPL.isWindows) {
                path = String.valueOf(path) + ".exe";
            }
            if ((file = new File(path)).exists()) {
                File[] models = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("concraft-pl-model") && name.endsWith(".gz");
                    }
                });
                if (models.length > 0) {
                    cmd = String.valueOf(file.getAbsolutePath()) + " tag " + models[0].getAbsolutePath();
                } else {
                    cmd = null;
                    err = "Can't find a model for tagging.";
                }
            } else {
                cmd = null;
                err = "Can't find a tagger";
            }
        } else {
            cmd = null;
            err = "Can't find a tagger";
        }
        if (err == null) {
            try {
                File tmp1 = File.createTempFile("termopl", null);
                File tmp2 = File.createTempFile("termopl", null);
                tmp1.deleteOnExit();
                tmp2.deleteOnExit();
                cmd = String.valueOf(cmd) + " -i " + tmp1.getAbsolutePath() + " -o " + tmp2.getAbsolutePath();
                this.prepareInput(this.input, tmp1);
                this.tag(cmd);
                this.prepareOutput(tmp2, this.output);
                tmp1.delete();
                tmp2.delete();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.out.println(err);
        }
    }

    public void prepareInput(File in, File out) {
        try {
            BufferedReader textReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in), "UTF8"));
            PrintWriter pw = new PrintWriter(out, "UTF8");
            StringBuffer buffer = new StringBuffer();
            String line = textReader.readLine();
            while (line != null) {
                if (line.trim().isEmpty()) {
                    this.saveParagraph(buffer, pw);
                } else {
                    if (buffer.length() > 0) {
                        buffer.append(' ');
                    }
                    buffer.append(line);
                }
                line = textReader.readLine();
            }
            this.saveParagraph(buffer, pw);
            pw.flush();
            pw.close();
            textReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveParagraph(StringBuffer buffer, PrintWriter pw) {
        if (buffer.length() > 0) {
            String par = buffer.toString();
            List<MorphInterpretation> interps = this.morfeusz.analyseAsList(par);
            LinkedList<Integer> npsNodes = new LinkedList<Integer>();
            for (MorphInterpretation mi : interps) {
                int endNode;
                String orth = mi.getOrth();
                int startNode = mi.getStartNode();
                boolean nps = npsNodes.contains(startNode);
                if (orth.equals(orth.trim()) && !npsNodes.contains(endNode = mi.getEndNode())) {
                    npsNodes.addFirst(endNode);
                }
                this.saveInterp(mi, nps, pw);
            }
            pw.print('\n');
            buffer.setLength(0);
        }
    }

    public void saveInterp(MorphInterpretation interp, boolean nps, PrintWriter pw) {
        int startNode = interp.getStartNode();
        int endNode = interp.getEndNode();
        String orth = interp.getOrth().trim();
        String lemma = interp.getLemma();
        String tag = interp.getTag(this.morfeusz);
        if (!lemma.equals(":")) {
            lemma = lemma.split(":")[0];
        }
        if (tag.contains(".")) {
            LinkedList<String> tags = this.splitTag(tag);
            for (String t : tags) {
                this.saveInterp(pw, startNode, endNode, orth, lemma, t, nps);
            }
        } else {
            this.saveInterp(pw, startNode, endNode, orth, lemma, tag, nps);
        }
    }

    public void saveInterp(PrintWriter pw, int startNode, int endNode, String orth, String lemma, String tag, boolean nps) {
        pw.print(startNode);
        pw.print('\t');
        pw.print(endNode);
        pw.print('\t');
        pw.print(orth);
        pw.print('\t');
        pw.print(lemma);
        pw.print('\t');
        pw.print(tag);
        pw.print('\t');
        pw.print('\t');
        pw.print('\t');
        pw.print("0.000");
        pw.print('\t');
        pw.print('\t');
        pw.print('\t');
        if (nps) {
            pw.print("nps");
        }
        pw.print('\n');
    }

    public LinkedList<String> splitTag(String tag) {
        LinkedList<String> tags = new LinkedList<String>();
        String[] cats = tag.split(":");
        this.splitTag(tags, "", cats, 0);
        return tags;
    }

    public void splitTag(LinkedList<String> tags, String tag, String[] cats, int index) {
        if (index < cats.length) {
            if (cats[index].contains(".")) {
                String[] markers;
                String[] stringArray = markers = cats[index].split("\\.");
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    String m = stringArray[n2];
                    if (tag.isEmpty()) {
                        this.splitTag(tags, m, cats, index + 1);
                    } else {
                        this.splitTag(tags, String.valueOf(tag) + ":" + m, cats, index + 1);
                    }
                    ++n2;
                }
            } else if (tag.isEmpty()) {
                this.splitTag(tags, cats[index], cats, index + 1);
            } else {
                this.splitTag(tags, String.valueOf(tag) + ":" + cats[index], cats, index + 1);
            }
        } else {
            tags.add(tag);
        }
    }

    public void prepareOutput(File in, File out) {
        try {
            BufferedReader textReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in), "UTF8"));
            PrintWriter pw = new PrintWriter(out, "UTF8");
            String startNode = "";
            String endNode = "";
            String line = textReader.readLine();
            while (line != null) {
                String[] cols;
                if (!(line.trim().isEmpty() || (cols = line.split("\t")).length != 12 || !cols[11].equals("disamb") || cols[0].equals(startNode) && cols[1].equals(endNode))) {
                    startNode = cols[0];
                    endNode = cols[1];
                    pw.print(cols[2]);
                    pw.print('\t');
                    pw.print(cols[3]);
                    pw.print('\t');
                    pw.print(cols[4]);
                    if (cols[10].equals("nps")) {
                        pw.print('\t');
                        pw.print("nps");
                    }
                    pw.println();
                    if (cols[9].equals("eos")) {
                        pw.println("eos");
                    }
                }
                line = textReader.readLine();
            }
            pw.flush();
            pw.close();
            textReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void tag(String cmd) {
        Runtime r = Runtime.getRuntime();
        try {
            Process p = r.exec(cmd);
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

