/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.LinkedList;
import termopl.TermoPL;
import termopl.TermoPLWindow;
import termopl.WindowUtils;

public class WndLocation {
    public int left;
    public int top;
    public float penalty;
    public static WndLocation bestLocation = null;

    public WndLocation(int left, int top, float penalty) {
        this.left = left;
        this.top = top;
        this.penalty = penalty;
    }

    public static boolean check(float[] f1, float[] f2) {
        float p2;
        float p1 = WndLocation.calcPenalty(f1);
        return p1 <= (p2 = WndLocation.calcPenalty(f2));
    }

    public static float calcPenalty(float[] f) {
        float penalty = 0.0f;
        int i = 0;
        while (i < f.length) {
            penalty = f[i] > 0.9f ? (penalty += 4.0f * f[i]) : (f[i] > 0.8f ? (penalty += 3.5f * f[i]) : (f[i] > 0.7f ? (penalty += 3.0f * f[i]) : (f[i] > 0.6f ? (penalty += 2.5f * f[i]) : (f[i] > 0.5f ? (penalty += 2.0f * f[i]) : (f[i] > 0.4f ? (penalty += 1.5f * f[i]) : (penalty += f[i]))))));
            ++i;
        }
        return penalty;
    }

    public static void cascade() {
        LinkedList<TermoPLWindow> list = TermoPL.zorder;
        if (list.size() > 1) {
            WindowUtils.resetStaggerPoint();
            for (TermoPLWindow wnd : list) {
                if (!wnd.isVisible()) continue;
                WindowUtils.staggerOnDesktop((Component)((Object)wnd));
            }
        }
    }

    public static void tile() {
        LinkedList<TermoPLWindow> list = TermoPL.zorder;
        if (list.size() > 1) {
            LinkedList<TermoPLWindow> moved = new LinkedList<TermoPLWindow>();
            for (TermoPLWindow wnd : list) {
                if (!wnd.isVisible()) continue;
                if (moved.size() > 0) {
                    for (TermoPLWindow w : moved) {
                        WndLocation.findPosition(wnd, w);
                    }
                    WndLocation loc = WndLocation.findBestLocation();
                    wnd.setLocation(loc.left, loc.top);
                    bestLocation = null;
                } else {
                    WindowUtils.resetStaggerPoint();
                    WindowUtils.staggerOnDesktop((Component)((Object)wnd));
                }
                moved.add(wnd);
            }
        }
    }

    public static void findPosition(TermoPLWindow frame, TermoPLWindow neighbour) {
        Rectangle nr = neighbour.getBounds();
        Rectangle fr = frame.getBounds();
        Rectangle dr = WindowUtils.getDesktopRect();
        int x = nr.x - fr.width - 1;
        if (x < dr.x) {
            x = dr.x;
        }
        WndLocation.findPosition(frame, x, nr.y);
        int y = nr.y - fr.height - 1;
        if (y < dr.y) {
            y = dr.y;
        }
        WndLocation.findPosition(frame, nr.x, y);
        WndLocation.findPosition(frame, nr.x + nr.width + 1, nr.y);
        WndLocation.findPosition(frame, nr.x, nr.y + nr.height + 1);
    }

    public static void findPosition(TermoPLWindow frame, int x, int y) {
        LinkedList<TermoPLWindow> list = TermoPL.zorder;
        if (list.size() > 0) {
            Rectangle rect = frame.getBounds();
            int size = 0;
            rect.setLocation(x, y);
            WndLocation.reveal(rect, WindowUtils.getDesktopRect());
            for (TermoPLWindow wnd : list) {
                if (!wnd.isVisible()) continue;
                if (wnd == frame) break;
                ++size;
            }
            if (size > 0) {
                float[] intersections = new float[size];
                int i = 0;
                for (TermoPLWindow wnd : list) {
                    if (!wnd.isVisible()) continue;
                    if (wnd == frame) break;
                    Rectangle r = wnd.getBounds();
                    Rectangle intersect = r.intersection(rect);
                    intersections[i++] = intersect.isEmpty() ? 0.0f : (float)(intersect.width * intersect.height) / (float)(r.width * r.height);
                }
                WndLocation.checkLocation(rect.x, rect.y, WndLocation.calcPenalty(intersections));
            }
        }
    }

    public static void checkLocation(int x, int y, float penalty) {
        if (bestLocation == null) {
            bestLocation = new WndLocation(x, y, penalty);
        } else if ((WndLocation.bestLocation.left != x || WndLocation.bestLocation.top != y) && penalty < WndLocation.bestLocation.penalty) {
            bestLocation = new WndLocation(x, y, penalty);
        }
    }

    public static void reveal(Rectangle rect, Rectangle desktop) {
        if (rect.x + rect.width > desktop.x + desktop.width) {
            rect.x = desktop.x + desktop.width - rect.width;
        }
        if (rect.y + rect.height > desktop.y + desktop.height) {
            rect.y = desktop.y + desktop.height - rect.height;
        }
        if (rect.x < desktop.x) {
            rect.x = desktop.x;
        }
        if (rect.y < desktop.y) {
            rect.y = desktop.y;
        }
    }

    public static WndLocation findBestLocation() {
        return bestLocation;
    }
}

