/*
 * Decompiled with CFR 0.152.
 */
package desktophandler;

import java.awt.Desktop;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;

public abstract class DesktopHandler {
    public DesktopHandler() {
        Desktop desktop = Desktop.getDesktop();
        desktop.setQuitHandler(new QuitHandler(){

            public void handleQuitRequestWith(QuitEvent e, QuitResponse qr) {
                qr.cancelQuit();
                DesktopHandler.this.handleQuitRequest();
            }
        });
        desktop.setAboutHandler(new AboutHandler(){

            public void handleAbout(AboutEvent e) {
                DesktopHandler.this.handleAboutRequest();
            }
        });
        desktop.setPreferencesHandler(new PreferencesHandler(){

            public void handlePreferences(PreferencesEvent e) {
                DesktopHandler.this.handlePreferencesRequest();
            }
        });
    }

    public abstract void handleQuitRequest();

    public abstract void handleAboutRequest();

    public abstract void handlePreferencesRequest();
}

