/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import termopl.CommonResources;
import termopl.CommonTerm;
import termopl.ErrorViewer;
import termopl.FlagCombo;
import termopl.GParser;
import termopl.LanguageInfo;
import termopl.PParser;
import termopl.PictButton;
import termopl.Preferences;
import termopl.SaveFileChooser;
import termopl.TParser;
import termopl.Tagset;
import termopl.Template;
import termopl.TermoPL;

public class Options
extends JPanel {
    public static final int OK = 1;
    private static final String BUILT_IN = "built-in";
    private static final String INFO1 = "<html>Find all places where the phrase can be divided according to the grammar rules.</html>";
    private static final String INFO2 = "<html>Always divide the phrase at the weakest connection point indicated by the lowest NPMI value. Continue this process for the resulting subphrases even if they do not conform to the grammar rules.</html>";
    private static final String INFO3 = "<html>Try to divide the phrase into subphrases so as to at least one of them safisfies the grammar rules. Choose the weakest possible connection point according to NPMI value to do the split. Continue this process for the resulting subphrases. If the phrase cannot be split in such a way, use Method 1.</html>";
    private static final String INFO4 = "<html>Try to divide the phrase into subphrases so as to at least one of them safisfies the grammar rules. Prefer cases where both phrases obtained after splitting are accepted by the given grammar. This preference is expressed by the 'Preference factor'. Choose the weakest possible connection point according to NPMI value to do the split. Continue this process for the resulting subphrases. If the phrase cannot be split in such a way, use Method 2.</html>";
    private static final String INFO5 = "<html>Take the maximum from the number of different left and right contexts of a term.</html>";
    private static final String INFO6 = "<html>Take the number of different contexts of a term. Do not discriminate between left and right contexts. </html>";
    private static final String INFO7 = "<html>Take the number of different pairs of left and right contexts of a term.</html>";
    private static final String INFO8 = "<html>Take the number of different left contexts.</html>";
    private static final String INFO9 = "<html>Generate subsequent phrases by trimming out the leftmost word.</html>";
    private static final String INF10 = "<html>det/noun is the ratio of the number of 'det' relations to the number of nouns in the analyzed texts, expressed as a percentage.</html>";
    private Preferences prefs;
    private LinkedList<String> sw;
    private LinkedList<String> cp;
    private LinkedList<CommonTerm> ct;
    private String tagsetPath;
    private String grammarPath;
    private String wordNetPath;
    private String contrastiveDataPath;
    private String language;
    private File tagsetFile;
    private File grammarFile;
    private Tagset tagset;
    private Template template;
    private JDialog dialog;
    private JTabbedPane tabbedPane;
    private JTabbedPane innerTabbedPane;
    private StopWordsPanel stopWordsPanel;
    private CompPrepPanel compPrepPanel;
    private CommonTermsPanel commonTermsPanel;
    private GrammarPanel grammarPanel;
    private SearchPanel searchPanel;
    private ComparePanel comparePanel;
    private ExportPanel exportPanel;
    private JTable swTable;
    private JTable cpTable;
    private JTable ctTable;
    private FlagCombo languageCombo;
    private JCheckBox applyContrastiveRanking;
    private JCheckBox topRankedOnly;
    private JCheckBox frequentOnly;
    private JCheckBox useCValues;
    private JCheckBox NPMI;
    private JCheckBox leftToRight;
    private JCheckBox makeGroups;
    private JCheckBox useWordNet;
    private JCheckBox checkSW;
    private JCheckBox removeCP;
    private JCheckBox removeCT;
    private JCheckBox mergeSW;
    private JCheckBox mergeCP;
    private JCheckBox mergeCT;
    private JCheckBox showSimplifiedForms;
    private JCheckBox countBox;
    private JCheckBox rankBox;
    private JCheckBox sfBox;
    private JCheckBox bfBox;
    private JCheckBox cvalueBox;
    private JCheckBox compBox;
    private JCheckBox lenBox;
    private JCheckBox freqsBox;
    private JCheckBox freqinBox;
    private JCheckBox contextBox;
    private JCheckBox detectDeterminers;
    private JRadioButton UDButton;
    private JRadioButton shallowGButton;
    private JRadioButton standardTagsetButton;
    private JRadioButton customTagsetButton;
    private JRadioButton standardGrammarButton;
    private JRadioButton customGrammarButton;
    private JRadioButton LLButton;
    private JRadioButton TFITFButton;
    private JRadioButton CSmwButton;
    private JRadioButton TWButton;
    private JRadioButton method1Button;
    private JRadioButton method2Button;
    private JRadioButton method3Button;
    private JRadioButton cntxMethod1Button;
    private JRadioButton cntxMethod2Button;
    private JRadioButton cntxMethod3Button;
    private JRadioButton includeDeterminers;
    private JRadioButton includeArticles;
    private JRadioButton excludeDeterminers;
    private JButton okButton;
    private JButton cancelButton;
    private JButton loadSWButton;
    private JButton saveSWButton;
    private JButton clearSWButton;
    private JButton loadCPButton;
    private JButton saveCPButton;
    private JButton clearCPButton;
    private JButton loadCTButton;
    private JButton saveCTButton;
    private JButton clearCTButton;
    private JButton changeTagset;
    private JButton changeGrammar;
    private JButton selectContrastiveData;
    private JButton selectAllButton;
    private JButton selectCCButton;
    private JButton changeWordNetButton;
    private JButton clearButton;
    private PictButton addSWButton;
    private PictButton removeSWButton;
    private PictButton addCPButton;
    private PictButton removeCPButton;
    private PictButton addCTButton;
    private PictButton removeCTButton;
    private JTextField mincvalue;
    private JTextField minfrq;
    private JTextField alpha;
    private JTextField beta;
    private JTextField factor;
    private JTextField detRatio;
    private JLabel tagsetName;
    private JLabel grammarName;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JLabel info1;
    private JLabel info2;
    private JLabel info3;
    private JLabel wordNetFile;
    private JLabel contrastiveDataLabel;
    private JLabel contrastiveDataName;
    private JLabel TWLabel;
    private JLabel DRLabel;
    private JLabel DCLabel;
    private Component sepBox;
    private int answer;

    public Options(Preferences prefs) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.prefs = prefs;
        this.sw = prefs.stopWords;
        if (this.sw != null) {
            this.sw = (LinkedList)this.sw.clone();
        }
        this.cp = prefs.compPreps;
        if (this.cp != null) {
            this.cp = (LinkedList)this.cp.clone();
        }
        this.ct = prefs.commonTerms;
        if (this.ct != null) {
            this.ct = (LinkedList)this.ct.clone();
        }
        this.contrastiveDataPath = prefs.contrastiveDataPath;
        this.tagsetPath = prefs.tagsetPath;
        this.grammarPath = prefs.grammarPath;
        this.wordNetPath = prefs.wordNetPath;
        this.tagset = prefs.tagset;
        this.template = prefs.template;
        this.tagsetFile = this.tagsetPath == null ? null : new File(this.tagsetPath);
        this.grammarFile = this.grammarPath == null ? null : new File(this.grammarPath);
        this.language = prefs.language;
        this.arrangeComponents();
    }

    public void arrangeComponents() {
        Box hbox = Box.createHorizontalBox();
        hbox.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        this.tabbedPane = new JTabbedPane();
        this.innerTabbedPane = new JTabbedPane();
        this.tabbedPane.setFocusable(false);
        this.innerTabbedPane.setFocusable(false);
        this.stopWordsPanel = new StopWordsPanel();
        this.innerTabbedPane.addTab("Stop Words", this.stopWordsPanel);
        this.compPrepPanel = new CompPrepPanel();
        this.innerTabbedPane.addTab("Compound Prepositions", this.compPrepPanel);
        this.commonTermsPanel = new CommonTermsPanel();
        this.innerTabbedPane.addTab("Common Terms", this.commonTermsPanel);
        this.tabbedPane.addTab("Filters", this.innerTabbedPane);
        this.grammarPanel = new GrammarPanel();
        this.tabbedPane.addTab("Method", this.grammarPanel);
        this.searchPanel = new SearchPanel();
        this.tabbedPane.addTab("Search Parameters", this.searchPanel);
        this.comparePanel = new ComparePanel();
        this.tabbedPane.addTab("Compare", this.comparePanel);
        this.exportPanel = new ExportPanel();
        this.tabbedPane.addTab("Export", this.exportPanel);
        this.add((Component)this.tabbedPane, "Center");
        hbox.add(Box.createHorizontalGlue());
        this.cancelButton = new JButton("Cancel");
        hbox.add(this.cancelButton);
        hbox.add(Box.createHorizontalStrut(16));
        this.okButton = new JButton("OK");
        hbox.add(this.okButton);
        Dimension dim = this.cancelButton.getPreferredSize();
        this.okButton.setPreferredSize(dim);
        this.add((Component)hbox, "South");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean ok = Options.this.swTable.isEditing() ? Options.this.swTable.getCellEditor().stopCellEditing() : (Options.this.cpTable.isEditing() ? Options.this.cpTable.getCellEditor().stopCellEditing() : (Options.this.ctTable.isEditing() ? Options.this.ctTable.getCellEditor().stopCellEditing() : true));
                if (ok) {
                    Options.this.answer = 1;
                    Options.this.savePreferences();
                    Options.this.dialog.setVisible(false);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Options.this.dialog.setVisible(false);
            }
        });
    }

    public void savePreferences() {
        String str;
        int m;
        Preferences tprefs = TermoPL.preferences;
        this.prefs.reloadContrastiveTerms = false;
        this.prefs.repaint = false;
        this.prefs.compare = false;
        this.prefs.extract = false;
        boolean f = this.applyContrastiveRanking.isSelected();
        if (f != this.prefs.applyContrastiveRanking) {
            tprefs.applyContrastiveRanking = this.prefs.applyContrastiveRanking = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (f) {
                this.prefs.compare = true;
            }
        }
        if ((f = this.topRankedOnly.isSelected()) != this.prefs.applyContrastiveRankingForTopRankedTerms) {
            tprefs.applyContrastiveRankingForTopRankedTerms = this.prefs.applyContrastiveRankingForTopRankedTerms = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.repaint = true;
        }
        if ((f = this.frequentOnly.isSelected()) != this.prefs.applyContrastiveRankingForFrequentTerms) {
            tprefs.applyContrastiveRankingForFrequentTerms = this.prefs.applyContrastiveRankingForFrequentTerms = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.repaint = true;
        }
        if ((f = this.useCValues.isSelected()) != this.prefs.useCValues) {
            tprefs.useCValues = this.prefs.useCValues = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (this.prefs.applyContrastiveRanking) {
                this.prefs.compare = true;
            }
        }
        if ((f = this.NPMI.isSelected()) != this.prefs.useNPMIMethod) {
            tprefs.useNPMIMethod = this.prefs.useNPMIMethod = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.extract = true;
        }
        if ((f = this.leftToRight.isSelected()) != this.prefs.trimFromLeftToRight) {
            tprefs.trimFromLeftToRight = this.prefs.trimFromLeftToRight = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (!this.prefs.useNPMIMethod) {
                this.prefs.extract = true;
            }
        }
        if ((m = this.includeDeterminers.isSelected() ? 1 : (this.includeArticles.isSelected() ? 2 : 3)) != this.prefs.detHandling) {
            tprefs.detHandling = this.prefs.detHandling = m;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.extract = true;
        }
        if ((f = this.detectDeterminers.isSelected()) != this.prefs.detectDeterminers) {
            tprefs.detectDeterminers = this.prefs.detectDeterminers = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (this.prefs.detHandling == 1) {
                this.prefs.extract = true;
            }
        }
        if ((f = this.checkSW.isSelected()) != this.prefs.checkStopWords) {
            tprefs.checkStopWords = this.prefs.checkStopWords = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.extract = true;
        }
        if ((f = this.mergeSW.isSelected()) != this.prefs.mergeSW) {
            tprefs.mergeSW = this.prefs.mergeSW = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((f = this.removeCP.isSelected()) != this.prefs.removeCompoundPreps) {
            tprefs.removeCompoundPreps = this.prefs.removeCompoundPreps = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.extract = true;
        }
        if ((f = this.mergeCP.isSelected()) != this.prefs.mergeCP) {
            tprefs.mergeCP = this.prefs.mergeCP = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((f = this.removeCT.isSelected()) != this.prefs.removeCommonTerms) {
            tprefs.removeCommonTerms = this.prefs.removeCommonTerms = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.extract = true;
        }
        if ((f = this.mergeCT.isSelected()) != this.prefs.mergeCT) {
            tprefs.mergeCT = this.prefs.mergeCT = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((f = this.showSimplifiedForms.isSelected()) != this.prefs.showSimplifiedForms) {
            tprefs.showSimplifiedForms = this.prefs.showSimplifiedForms = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((str = ((LanguageInfo)this.languageCombo.getSelectedItem()).getLanguageCode()) == null && this.prefs.language != null || str != null && !str.equals(this.prefs.language)) {
            tprefs.language = this.prefs.language = str;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.extract = true;
        }
        if ((f = this.UDButton.isSelected()) != this.prefs.useUD) {
            tprefs.useUD = this.prefs.useUD = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.extract = true;
        }
        if ((f = this.customTagsetButton.isSelected()) != this.prefs.useCustomTagset) {
            tprefs.tagset = this.prefs.tagset = this.tagset;
            tprefs.template = this.prefs.template = this.template;
            tprefs.useCustomTagset = this.prefs.useCustomTagset = f;
            if (f) {
                this.prefs.calculateBaseForms = false;
                tprefs.calculateBaseForms = false;
            }
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.extract = true;
        }
        if ((f = this.customGrammarButton.isSelected()) != this.prefs.useCustomGrammar) {
            tprefs.tagset = this.prefs.tagset = this.tagset;
            tprefs.template = this.prefs.template = this.template;
            tprefs.useCustomGrammar = this.prefs.useCustomGrammar = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.extract = true;
        }
        if ((f = this.makeGroups.isSelected()) != this.prefs.makeGroups) {
            tprefs.makeGroups = this.prefs.makeGroups = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (f) {
                this.prefs.extract = true;
            }
        }
        if ((f = this.useWordNet.isSelected()) != this.prefs.useWordNet) {
            tprefs.useWordNet = this.prefs.useWordNet = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (this.prefs.makeGroups) {
                this.prefs.extract = true;
            }
        }
        if ((m = this.LLButton.isSelected() ? 1 : (this.TFITFButton.isSelected() ? 2 : (this.CSmwButton.isSelected() ? 3 : 4))) != this.prefs.contrastiveRankingMethod) {
            tprefs.contrastiveRankingMethod = this.prefs.contrastiveRankingMethod = m;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.compare = true;
        }
        if ((m = this.method1Button.isSelected() ? 1 : (this.method2Button.isSelected() ? 2 : 3)) != this.prefs.NPMIMethod) {
            tprefs.NPMIMethod = this.prefs.NPMIMethod = m;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (this.prefs.useNPMIMethod) {
                this.prefs.extract = true;
            }
        }
        if ((m = this.cntxMethod1Button.isSelected() ? 1 : (this.cntxMethod2Button.isSelected() ? 2 : 3)) != this.prefs.cntxMethod) {
            tprefs.cntxMethod = this.prefs.cntxMethod = m;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.recalculate = true;
        }
        if (!(f = this.compareLists(this.prefs.stopWords, this.sw))) {
            tprefs.stopWords = this.prefs.stopWords = this.sw;
            this.prefs.stopWordSet = null;
            tprefs.stopWordSet = null;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.extract = true;
        }
        if (!(f = this.compareLists(this.prefs.compPreps, this.cp))) {
            tprefs.compPreps = this.prefs.compPreps = this.cp;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (this.cp != null) {
                PParser parser = new PParser(this.cp, (Object)this.dialog);
                parser.parse();
                tprefs.compoundPrepositions = this.prefs.compoundPrepositions = parser.getTemplate();
            } else {
                this.prefs.compoundPrepositions = null;
                tprefs.compoundPrepositions = null;
            }
        }
        if (!(f = this.compareLists(this.prefs.commonTerms, this.ct))) {
            tprefs.commonTerms = this.prefs.commonTerms = this.ct;
            this.prefs.commonTermSet = null;
            tprefs.commonTermSet = null;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.extract = true;
        }
        if (this.tagsetPath != null && !this.tagsetPath.equals(this.prefs.tagsetPath)) {
            tprefs.tagsetPath = this.prefs.tagsetPath = this.tagsetPath;
            tprefs.tagset = this.prefs.tagset = this.tagset;
            tprefs.template = this.prefs.template = this.template;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (this.prefs.useCustomTagset) {
                this.prefs.extract = true;
            }
        }
        if (this.grammarPath != null && !this.grammarPath.equals(this.prefs.grammarPath)) {
            tprefs.grammarPath = this.prefs.grammarPath = this.grammarPath;
            tprefs.tagset = this.prefs.tagset = this.tagset;
            tprefs.template = this.prefs.template = this.template;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (this.prefs.useCustomGrammar) {
                this.prefs.extract = true;
            }
        }
        if (this.contrastiveDataPath != null && !this.contrastiveDataPath.equals(this.prefs.contrastiveDataPath)) {
            tprefs.contrastiveDataPath = this.prefs.contrastiveDataPath = this.contrastiveDataPath;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (this.prefs.applyContrastiveRanking) {
                this.prefs.compare = true;
            }
        }
        if (this.wordNetPath != null && !this.wordNetPath.equals(this.prefs.wordNetPath)) {
            tprefs.wordNetPath = this.prefs.wordNetPath = this.wordNetPath;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (this.prefs.makeGroups && this.prefs.useWordNet) {
                this.prefs.extract = true;
            }
        }
        this.prefs.tagset = this.tagset;
        this.prefs.template = this.template;
        double x = Double.parseDouble(this.mincvalue.getText());
        if (x != this.prefs.mincvalue) {
            tprefs.mincvalue = this.prefs.mincvalue = x;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.repaint = true;
        }
        if ((x = Double.parseDouble(this.alpha.getText())) != this.prefs.alpha) {
            tprefs.alpha = this.prefs.alpha = x;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.compare = true;
        }
        if ((x = Double.parseDouble(this.beta.getText())) != this.prefs.beta) {
            tprefs.beta = this.prefs.beta = x;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.compare = true;
        }
        if ((m = Integer.parseInt(this.minfrq.getText())) != this.prefs.minfrq) {
            tprefs.minfrq = this.prefs.minfrq = m;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            this.prefs.repaint = true;
        }
        if ((m = Integer.parseInt(this.factor.getText())) != this.prefs.NPMIfactor) {
            tprefs.NPMIfactor = this.prefs.NPMIfactor = m;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (this.prefs.useNPMIMethod && this.prefs.NPMIMethod == 3) {
                this.prefs.extract = true;
            }
        }
        if ((m = Integer.parseInt(this.detRatio.getText())) != this.prefs.detRatio) {
            tprefs.detRatio = this.prefs.detRatio = m;
            tprefs.setModified(true);
            this.prefs.setModified(true);
            if (this.prefs.detHandling == 1 && this.prefs.detectDeterminers) {
                this.prefs.extract = true;
            }
        }
        if ((f = this.countBox.isSelected()) != this.prefs.saveCount) {
            tprefs.saveCount = this.prefs.saveCount = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((f = this.rankBox.isSelected()) != this.prefs.saveRank) {
            tprefs.saveRank = this.prefs.saveRank = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((f = this.sfBox.isSelected()) != this.prefs.saveSF) {
            tprefs.saveSF = this.prefs.saveSF = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((f = this.bfBox.isSelected()) != this.prefs.saveBF) {
            tprefs.saveBF = this.prefs.saveBF = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((f = this.cvalueBox.isSelected()) != this.prefs.saveCV) {
            tprefs.saveCV = this.prefs.saveCV = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((f = this.compBox.isSelected()) != this.prefs.saveComp) {
            tprefs.saveComp = this.prefs.saveComp = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((f = this.lenBox.isSelected()) != this.prefs.saveLen) {
            tprefs.saveLen = this.prefs.saveLen = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((f = this.freqsBox.isSelected()) != this.prefs.saveFreqs) {
            tprefs.saveFreqs = this.prefs.saveFreqs = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((f = this.freqinBox.isSelected()) != this.prefs.saveFreqin) {
            tprefs.saveFreqin = this.prefs.saveFreqin = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
        if ((f = this.contextBox.isSelected()) != this.prefs.saveContext) {
            tprefs.saveContext = this.prefs.saveContext = f;
            tprefs.setModified(true);
            this.prefs.setModified(true);
        }
    }

    public boolean compareLists(LinkedList<?> list1, LinkedList<?> list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 != null && list2 != null) {
            if (list1.size() == list2.size()) {
                return list1.containsAll(list2);
            }
            return false;
        }
        return false;
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public int doDialog() {
        this.answer = -1;
        this.dialog = new JDialog(TermoPL.dialogOwner);
        this.dialog.setModal(true);
        this.dialog.setDefaultCloseOperation(1);
        this.dialog.setTitle("Options");
        this.dialog.setResizable(false);
        this.dialog.getContentPane().add(this);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(TermoPL.dialogOwner);
        this.dialog.setVisible(true);
        return this.answer;
    }

    private class CommonTermsPanel
    extends JPanel {
        public CommonTermsPanel() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
            this.arrangeComponents();
        }

        public void arrangeComponents() {
            Box hbox = Box.createHorizontalBox();
            Options.this.removeCT = new JCheckBox("Remove common terms:");
            hbox.add(Options.this.removeCT);
            hbox.add(Box.createHorizontalGlue());
            this.add((Component)hbox, "North");
            Options.this.ctTable = new JTable();
            Options.this.ctTable.setModel(new SWCPCTTableModel(Options.this.ctTable));
            Options.this.ctTable.setShowHorizontalLines(false);
            Options.this.ctTable.setShowVerticalLines(false);
            Options.this.ctTable.setCellSelectionEnabled(true);
            Options.this.ctTable.setTableHeader(null);
            TableColumnModel columnModel = Options.this.ctTable.getColumnModel();
            TableColumn column = columnModel.getColumn(0);
            column.setCellRenderer(new RowRenderer());
            column.setCellEditor(new SWCPCTTableEditor(Options.this.ctTable));
            JScrollPane sp = new JScrollPane(Options.this.ctTable);
            sp.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            this.add((Component)sp, "Center");
            Box vbox = Box.createVerticalBox();
            vbox.add(Box.createVerticalStrut(2));
            hbox = Box.createHorizontalBox();
            Options.this.addCTButton = new PictButton("plus.png", true);
            Options.this.addCTButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            hbox.add(Options.this.addCTButton);
            Options.this.removeCTButton = new PictButton("minus.png", true);
            Options.this.removeCTButton.setEnabled(false);
            Options.this.removeCTButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            hbox.add(Options.this.removeCTButton);
            hbox.add(Box.createHorizontalGlue());
            Options.this.showSimplifiedForms = new JCheckBox("Show simplified forms");
            Options.this.showSimplifiedForms.setSelected(((Options)Options.this).prefs.showSimplifiedForms);
            hbox.add(Options.this.showSimplifiedForms);
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(8));
            hbox = Box.createHorizontalBox();
            JLabel label = new JLabel(" and merge ");
            Options.this.loadCTButton = new JButton("Load...");
            Options.this.mergeCT = new JCheckBox();
            Options.this.mergeCT.setSelected(((Options)Options.this).prefs.mergeCT);
            Options.this.saveCTButton = new JButton("Save...");
            Options.this.clearCTButton = new JButton("Clear");
            hbox.add(Options.this.loadCTButton);
            hbox.add(label);
            hbox.add(Options.this.mergeCT);
            hbox.add(Box.createHorizontalStrut(8));
            hbox.add(Options.this.saveCTButton);
            hbox.add(Box.createHorizontalStrut(8));
            hbox.add(Box.createHorizontalGlue());
            hbox.add(Options.this.clearCTButton);
            vbox.add(hbox);
            this.add((Component)vbox, "South");
            Options.this.ctTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    int row = Options.this.ctTable.getSelectedRow();
                    Options.this.removeCTButton.setEnabled(row >= 0);
                }
            });
            Options.this.addCTButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean ok = Options.this.ctTable.isEditing() ? Options.this.ctTable.getCellEditor().stopCellEditing() : true;
                    if (ok) {
                        SWCPCTTableModel model = (SWCPCTTableModel)Options.this.ctTable.getModel();
                        if (Options.this.ct == null) {
                            Options.this.ct = new LinkedList();
                        }
                        int row = Options.this.ct.size();
                        Options.this.ct.add(new CommonTerm());
                        model.fireTableRowsInserted(row, row);
                        Options.this.ctTable.scrollRectToVisible(Options.this.ctTable.getCellRect(row, 0, true));
                        Options.this.ctTable.editCellAt(row, 0);
                        Options.this.clearCTButton.setEnabled(Options.this.ct != null);
                        Options.this.saveCTButton.setEnabled(Options.this.ct != null);
                    }
                }
            });
            Options.this.removeCTButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SWCPCTTableModel model = (SWCPCTTableModel)Options.this.ctTable.getModel();
                    int[] rows = Options.this.ctTable.getSelectedRows();
                    if (rows != null) {
                        int i = 0;
                        while (i < rows.length) {
                            Options.this.ct.remove(rows[i] - i);
                            if (Options.this.ct.size() == 0) {
                                Options.this.ct = null;
                            }
                            ++i;
                        }
                        model.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
                    }
                    Options.this.clearSWButton.setEnabled(Options.this.ct != null);
                    Options.this.saveSWButton.setEnabled(Options.this.ct != null);
                }
            });
            Options.this.loadCTButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean ok;
                    if (Options.this.ctTable.isEditing()) {
                        if (Options.this.mergeCT.isSelected()) {
                            ok = Options.this.ctTable.getCellEditor().stopCellEditing();
                        } else {
                            Options.this.ctTable.getCellEditor().cancelCellEditing();
                            ok = true;
                        }
                    } else {
                        ok = true;
                    }
                    if (ok) {
                        JFileChooser chooser = new JFileChooser();
                        chooser.setDialogTitle("Load Common Terms");
                        chooser.setMultiSelectionEnabled(false);
                        if (chooser.showOpenDialog(Options.this) == 0) {
                            File file = chooser.getSelectedFile();
                            try {
                                String line;
                                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                                if (!Options.this.mergeSW.isSelected()) {
                                    Options.this.ct = null;
                                }
                                do {
                                    int index;
                                    if ((line = reader.readLine()) == null || (line = line.trim()).isEmpty()) continue;
                                    String bf = null;
                                    String sf = null;
                                    if (Options.this.ct == null) {
                                        Options.this.ct = new LinkedList();
                                    }
                                    if ((index = line.indexOf("[")) < 0) {
                                        sf = line;
                                        bf = line;
                                    } else {
                                        sf = line.substring(0, index).trim();
                                        bf = line.substring(index + 1).replace("]", "").trim();
                                    }
                                    Options.this.ct.add(new CommonTerm(bf, sf));
                                } while (line != null);
                                reader.close();
                            }
                            catch (IOException exception) {
                                ErrorViewer viewer = new ErrorViewer(Options.this.dialog);
                                viewer.showError(exception.toString());
                            }
                            SWCPCTTableModel model = (SWCPCTTableModel)Options.this.ctTable.getModel();
                            model.fireTableDataChanged();
                        }
                    }
                    Options.this.clearCTButton.setEnabled(Options.this.ct != null);
                    Options.this.saveCTButton.setEnabled(Options.this.ct != null);
                }
            });
            Options.this.saveCTButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean ok = Options.this.ctTable.isEditing() ? Options.this.ctTable.getCellEditor().stopCellEditing() : true;
                    if (ok) {
                        SaveFileChooser chooser = new SaveFileChooser();
                        chooser.setDialogTitle("Save Common Terms");
                        chooser.setSelectedFile(new File("CommonTerms.txt"));
                        if (chooser.showSaveDialog(Options.this) == 0) {
                            File file = chooser.getSelectedFile();
                            try {
                                PrintWriter pw = new PrintWriter(file, "UTF8");
                                if (Options.this.ct != null) {
                                    for (CommonTerm t : Options.this.ct) {
                                        pw.print(t.sf);
                                        pw.print("\t");
                                        pw.println("[" + t.bf + "]");
                                    }
                                }
                                pw.flush();
                                pw.close();
                            }
                            catch (FileNotFoundException e) {
                                ErrorViewer viewer = new ErrorViewer(Options.this.dialog);
                                viewer.showError(e.toString());
                            }
                            catch (UnsupportedEncodingException e) {
                                ErrorViewer viewer = new ErrorViewer(Options.this.dialog);
                                viewer.showError(e.toString());
                            }
                        }
                    }
                }
            });
            Options.this.clearCTButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SWCPCTTableModel model = (SWCPCTTableModel)Options.this.ctTable.getModel();
                    int s = Options.this.ct.size();
                    Options.this.ct = null;
                    model.fireTableRowsDeleted(0, s);
                    Options.this.clearCTButton.setEnabled(false);
                    Options.this.saveCTButton.setEnabled(false);
                }
            });
            Options.this.showSimplifiedForms.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean ok = true;
                    if (Options.this.ctTable.isEditing()) {
                        SWCPCTTableEditor editor = (SWCPCTTableEditor)Options.this.ctTable.getCellEditor();
                        ok = editor.stopCellEditing(false);
                    }
                    if (ok) {
                        SWCPCTTableModel model = (SWCPCTTableModel)Options.this.ctTable.getModel();
                        model.fireTableDataChanged();
                    }
                }
            });
            Options.this.clearCTButton.setEnabled(Options.this.ct != null);
            Options.this.saveCTButton.setEnabled(Options.this.ct != null);
            Options.this.removeCT.setSelected(((Options)Options.this).prefs.removeCommonTerms);
        }
    }

    private class CompPrepPanel
    extends JPanel {
        public CompPrepPanel() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
            this.arrangeComponents();
        }

        public void arrangeComponents() {
            Box hbox = Box.createHorizontalBox();
            Options.this.removeCP = new JCheckBox("Remove compound prepositions:");
            hbox.add(Options.this.removeCP);
            hbox.add(Box.createHorizontalGlue());
            this.add((Component)hbox, "North");
            Options.this.cpTable = new JTable();
            Options.this.cpTable.setModel(new SWCPCTTableModel(Options.this.cpTable));
            Options.this.cpTable.setShowHorizontalLines(false);
            Options.this.cpTable.setShowVerticalLines(false);
            Options.this.cpTable.setCellSelectionEnabled(true);
            Options.this.cpTable.setTableHeader(null);
            TableColumnModel columnModel = Options.this.cpTable.getColumnModel();
            TableColumn column = columnModel.getColumn(0);
            column.setCellRenderer(new RowRenderer());
            column.setCellEditor(new SWCPCTTableEditor(Options.this.cpTable));
            JScrollPane sp = new JScrollPane(Options.this.cpTable);
            sp.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            this.add((Component)sp, "Center");
            Box vbox = Box.createVerticalBox();
            vbox.add(Box.createVerticalStrut(2));
            hbox = Box.createHorizontalBox();
            Options.this.addCPButton = new PictButton("plus.png", true);
            Options.this.addCPButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            hbox.add(Options.this.addCPButton);
            Options.this.removeCPButton = new PictButton("minus.png", true);
            Options.this.removeCPButton.setEnabled(false);
            Options.this.removeCPButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            hbox.add(Options.this.removeCPButton);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(8));
            hbox = Box.createHorizontalBox();
            JLabel label = new JLabel(" and merge ");
            Options.this.loadCPButton = new JButton("Load...");
            Options.this.mergeCP = new JCheckBox();
            Options.this.mergeCP.setSelected(((Options)Options.this).prefs.mergeCP);
            Options.this.saveCPButton = new JButton("Save...");
            Options.this.clearCPButton = new JButton("Clear");
            hbox.add(Options.this.loadCPButton);
            hbox.add(label);
            hbox.add(Options.this.mergeCP);
            hbox.add(Box.createHorizontalStrut(8));
            hbox.add(Options.this.saveCPButton);
            hbox.add(Box.createHorizontalStrut(8));
            hbox.add(Box.createHorizontalGlue());
            hbox.add(Options.this.clearCPButton);
            vbox.add(hbox);
            this.add((Component)vbox, "South");
            Options.this.cpTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    int row = Options.this.cpTable.getSelectedRow();
                    Options.this.removeCPButton.setEnabled(row >= 0);
                }
            });
            Options.this.addCPButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean ok = Options.this.cpTable.isEditing() ? Options.this.cpTable.getCellEditor().stopCellEditing() : true;
                    if (ok) {
                        SWCPCTTableModel model = (SWCPCTTableModel)Options.this.cpTable.getModel();
                        if (Options.this.cp == null) {
                            Options.this.cp = new LinkedList();
                        }
                        int row = Options.this.cp.size();
                        Options.this.cp.add("");
                        model.fireTableRowsInserted(row, row);
                        Options.this.cpTable.scrollRectToVisible(Options.this.cpTable.getCellRect(row, 0, true));
                        Options.this.cpTable.editCellAt(row, 0);
                        Options.this.clearCPButton.setEnabled(Options.this.cp != null);
                        Options.this.saveCPButton.setEnabled(Options.this.cp != null);
                    }
                }
            });
            Options.this.removeCPButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SWCPCTTableModel model = (SWCPCTTableModel)Options.this.cpTable.getModel();
                    int[] rows = Options.this.cpTable.getSelectedRows();
                    if (rows != null) {
                        int i = 0;
                        while (i < rows.length) {
                            Options.this.cp.remove(rows[i] - i);
                            if (Options.this.cp.size() == 0) {
                                Options.this.cp = null;
                            }
                            ++i;
                        }
                        model.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
                    }
                    Options.this.clearCPButton.setEnabled(Options.this.cp != null);
                    Options.this.saveCPButton.setEnabled(Options.this.cp != null);
                }
            });
            Options.this.loadCPButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean ok;
                    if (Options.this.cpTable.isEditing()) {
                        if (Options.this.mergeCP.isSelected()) {
                            ok = Options.this.cpTable.getCellEditor().stopCellEditing();
                        } else {
                            Options.this.cpTable.getCellEditor().cancelCellEditing();
                            ok = true;
                        }
                    } else {
                        ok = true;
                    }
                    if (ok) {
                        JFileChooser chooser = new JFileChooser();
                        chooser.setDialogTitle("Load Compound Prepositions");
                        chooser.setMultiSelectionEnabled(false);
                        if (chooser.showOpenDialog(Options.this) == 0) {
                            File file = chooser.getSelectedFile();
                            if (!Options.this.mergeCP.isSelected()) {
                                Options.this.cp = null;
                            }
                            try {
                                String line;
                                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                                do {
                                    if ((line = reader.readLine()) == null || (line = line.trim()).isEmpty()) continue;
                                    if (Options.this.cp == null) {
                                        Options.this.cp = new LinkedList();
                                    }
                                    if (Options.this.cp.contains(line)) continue;
                                    Options.this.cp.add(line);
                                } while (line != null);
                                reader.close();
                            }
                            catch (IOException exception) {
                                ErrorViewer viewer = new ErrorViewer(Options.this.dialog);
                                viewer.showError(exception.toString());
                            }
                            SWCPCTTableModel model = (SWCPCTTableModel)Options.this.cpTable.getModel();
                            model.fireTableDataChanged();
                        }
                    }
                    Options.this.clearCPButton.setEnabled(Options.this.cp != null);
                    Options.this.saveCPButton.setEnabled(Options.this.cp != null);
                }
            });
            Options.this.saveCPButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean ok = Options.this.cpTable.isEditing() ? Options.this.cpTable.getCellEditor().stopCellEditing() : true;
                    if (ok) {
                        SaveFileChooser chooser = new SaveFileChooser();
                        chooser.setDialogTitle("Save Compound Prepositions");
                        chooser.setSelectedFile(new File("CompoundPrepositions.txt"));
                        if (chooser.showSaveDialog(Options.this) == 0) {
                            File file = chooser.getSelectedFile();
                            try {
                                PrintWriter pw = new PrintWriter(file, "UTF8");
                                if (Options.this.cp != null) {
                                    for (String s : Options.this.cp) {
                                        pw.println(s);
                                    }
                                }
                                pw.flush();
                                pw.close();
                            }
                            catch (FileNotFoundException e) {
                                ErrorViewer viewer = new ErrorViewer(Options.this.dialog);
                                viewer.showError(e.toString());
                            }
                            catch (UnsupportedEncodingException e) {
                                ErrorViewer viewer = new ErrorViewer(Options.this.dialog);
                                viewer.showError(e.toString());
                            }
                        }
                    }
                }
            });
            Options.this.clearCPButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SWCPCTTableModel model = (SWCPCTTableModel)Options.this.cpTable.getModel();
                    int s = Options.this.cp.size();
                    Options.this.cp = null;
                    model.fireTableRowsDeleted(0, s);
                    Options.this.clearCPButton.setEnabled(false);
                    Options.this.saveCPButton.setEnabled(false);
                }
            });
            Options.this.clearCPButton.setEnabled(Options.this.cp != null);
            Options.this.saveCPButton.setEnabled(Options.this.cp != null);
            Options.this.removeCP.setSelected(((Options)Options.this).prefs.removeCompoundPreps);
        }
    }

    private class ComparePanel
    extends JPanel {
        public ComparePanel() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
            this.arrangeComponents();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComparePanel.this.adjustControls();
                }
            });
        }

        public void arrangeComponents() {
            Box vbox = Box.createVerticalBox();
            Box hbox = Box.createHorizontalBox();
            Box hboxi = Box.createHorizontalBox();
            Box indent = Box.createHorizontalBox();
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints constr = new GridBagConstraints();
            ButtonGroup group = new ButtonGroup();
            DecimalFormat format = new DecimalFormat("#.##");
            constr.anchor = 17;
            constr.gridwidth = 0;
            Options.this.applyContrastiveRanking = new JCheckBox("Compare corpora using:");
            Options.this.applyContrastiveRanking.setSelected(((Options)Options.this).prefs.applyContrastiveRanking);
            hbox.add(Options.this.applyContrastiveRanking);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            hbox = Box.createHorizontalBox();
            indent.add(Box.createHorizontalStrut(32));
            Dimension dim = indent.getPreferredSize();
            indent.setMaximumSize(dim);
            hbox.add(indent);
            Options.this.LLButton = new JRadioButton("Corpora-comparing log-likelihood (LL),");
            Options.this.LLButton.setSelected(((Options)Options.this).prefs.contrastiveRankingMethod == 1);
            group.add(Options.this.LLButton);
            p.add((Component)Options.this.LLButton, constr);
            Options.this.TFITFButton = new JRadioButton("Term Frequency Inverse Term Frequency (TFITF),");
            Options.this.TFITFButton.setSelected(((Options)Options.this).prefs.contrastiveRankingMethod == 2);
            group.add(Options.this.TFITFButton);
            p.add((Component)Options.this.TFITFButton, constr);
            Options.this.CSmwButton = new JRadioButton("Contrastive Selection of multi-word terms (CSmw),");
            Options.this.CSmwButton.setSelected(((Options)Options.this).prefs.contrastiveRankingMethod == 3);
            group.add(Options.this.CSmwButton);
            p.add((Component)Options.this.CSmwButton, constr);
            Options.this.TWButton = new JRadioButton("Term Weight");
            Options.this.TWButton.setSelected(((Options)Options.this).prefs.contrastiveRankingMethod == 4);
            hboxi.setAlignmentY(0.5f);
            group.add(Options.this.TWButton);
            hboxi.add(Options.this.TWButton);
            Options.this.TWLabel = new JLabel(" (TW = ");
            hboxi.add(Options.this.TWLabel);
            Options.this.alpha = new JTextField(4);
            Options.this.alpha.setText(format.format(((Options)Options.this).prefs.alpha).replace(",", "."));
            dim = Options.this.alpha.getPreferredSize();
            Options.this.alpha.setMaximumSize(dim);
            hboxi.add(Options.this.alpha);
            Options.this.DRLabel = new JLabel(" \u00d7 DR + ");
            hboxi.add(Options.this.DRLabel);
            Options.this.beta = new JTextField(4);
            Options.this.beta.setText(format.format(((Options)Options.this).prefs.beta).replace(",", "."));
            dim = Options.this.beta.getPreferredSize();
            Options.this.beta.setMaximumSize(dim);
            hboxi.add(Options.this.beta);
            Options.this.DCLabel = new JLabel(" \u00d7 DC),");
            hboxi.add(Options.this.DCLabel);
            hboxi.add(Box.createHorizontalGlue());
            p.add((Component)hboxi, constr);
            constr.gridwidth = 1;
            Options.this.topRankedOnly = new JCheckBox("for terms with C-value greater than ");
            Options.this.topRankedOnly.setSelected(((Options)Options.this).prefs.applyContrastiveRankingForTopRankedTerms);
            p.add((Component)Options.this.topRankedOnly, constr);
            constr.gridwidth = 0;
            Options.this.mincvalue = new JTextField(4);
            Options.this.mincvalue.setText(format.format(((Options)Options.this).prefs.mincvalue));
            dim = Options.this.mincvalue.getPreferredSize();
            Options.this.mincvalue.setMaximumSize(dim);
            p.add((Component)Options.this.mincvalue, constr);
            constr.gridwidth = 1;
            Options.this.frequentOnly = new JCheckBox("for terms with frequency greater than ");
            Options.this.frequentOnly.setSelected(((Options)Options.this).prefs.applyContrastiveRankingForFrequentTerms);
            p.add((Component)Options.this.frequentOnly, constr);
            constr.gridwidth = 0;
            Options.this.minfrq = new JTextField(4);
            Options.this.minfrq.setText(Integer.toString(((Options)Options.this).prefs.minfrq));
            dim = Options.this.minfrq.getPreferredSize();
            Options.this.minfrq.setMaximumSize(dim);
            p.add((Component)Options.this.minfrq, constr);
            dim = p.getPreferredSize();
            p.setMaximumSize(dim);
            hbox.add(p);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            hbox = Box.createHorizontalBox();
            Options.this.useCValues = new JCheckBox("Use C-values instead of frequencies");
            Options.this.useCValues.setSelected(((Options)Options.this).prefs.useCValues);
            Options.this.useCValues.setEnabled(((Options)Options.this).prefs.contrastiveRankingMethod != 4);
            hbox.add(Options.this.useCValues);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalGlue());
            hbox = Box.createHorizontalBox();
            Options.this.contrastiveDataLabel = new JLabel("Contrastive terms: ");
            hbox.add(Options.this.contrastiveDataLabel);
            Options.this.contrastiveDataName = new JLabel();
            hbox.add(Options.this.contrastiveDataName);
            if (((Options)Options.this).prefs.contrastiveDataPath == null) {
                Options.this.contrastiveDataName.setFont(this.getFont().deriveFont(2));
                Options.this.contrastiveDataName.setText("not selected ");
                Options.this.contrastiveDataName.setEnabled(false);
            } else {
                Options.this.contrastiveDataName.setFont(this.getFont().deriveFont(0));
                Options.this.contrastiveDataName.setText(TermoPL.getFileName(((Options)Options.this).prefs.contrastiveDataPath));
                Options.this.contrastiveDataName.setEnabled(true);
            }
            hbox.add(Box.createHorizontalGlue());
            Options.this.selectContrastiveData = new JButton("Select");
            hbox.add(Options.this.selectContrastiveData);
            vbox.add(hbox);
            this.add((Component)vbox, "Center");
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ComparePanel.this.adjustControls();
                }
            };
            Options.this.applyContrastiveRanking.addActionListener(listener);
            Options.this.topRankedOnly.addActionListener(listener);
            listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ComparePanel.this.adjustControls2();
                }
            };
            Options.this.LLButton.addActionListener(listener);
            Options.this.TFITFButton.addActionListener(listener);
            Options.this.CSmwButton.addActionListener(listener);
            Options.this.TWButton.addActionListener(listener);
            Options.this.selectContrastiveData.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String path = TermoPL.selectContrastiveCorpus(Options.this);
                    if (!(path == null || Options.this.contrastiveDataPath != null && Options.this.contrastiveDataPath.equals(path))) {
                        Options.this.contrastiveDataName.setFont(ComparePanel.this.getFont().deriveFont(0));
                        Options.this.contrastiveDataName.setText(TermoPL.getFileName(path));
                        Options.this.contrastiveDataName.setEnabled(true);
                        Options.this.contrastiveDataPath = path;
                    }
                }
            });
        }

        public void adjustControls() {
            boolean f = Options.this.applyContrastiveRanking.isSelected();
            Options.this.LLButton.setEnabled(f);
            Options.this.TFITFButton.setEnabled(f);
            Options.this.CSmwButton.setEnabled(f);
            Options.this.TWButton.setEnabled(f);
            Options.this.topRankedOnly.setEnabled(f);
            Options.this.frequentOnly.setEnabled(f);
            Options.this.useCValues.setEnabled(f && !Options.this.TWButton.isSelected());
            Options.this.mincvalue.setEnabled(f);
            Options.this.minfrq.setEnabled(f);
            Options.this.alpha.setEnabled(f);
            Options.this.beta.setEnabled(f);
            Options.this.TWLabel.setEnabled(f);
            Options.this.DRLabel.setEnabled(f);
            Options.this.DCLabel.setEnabled(f);
        }

        public void adjustControls2() {
            if (Options.this.TWButton.isSelected()) {
                Options.this.useCValues.setSelected(false);
                Options.this.useCValues.setEnabled(false);
            } else {
                Options.this.useCValues.setEnabled(true);
            }
        }
    }

    private class ExportPanel
    extends JPanel {
        public ExportPanel() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
            this.arrangeComponents();
        }

        public void arrangeComponents() {
            Box vbox = Box.createVerticalBox();
            Box hbox = Box.createHorizontalBox();
            JLabel label = new JLabel("Select fields to be exported:");
            vbox.add(label);
            vbox.add(Box.createVerticalStrut(8));
            Options.this.countBox = new JCheckBox("#");
            Options.this.countBox.setSelected(((Options)Options.this).prefs.saveCount);
            vbox.add(Options.this.countBox);
            Options.this.rankBox = new JCheckBox("Rank");
            Options.this.rankBox.setSelected(((Options)Options.this).prefs.saveRank);
            vbox.add(Options.this.rankBox);
            Options.this.sfBox = new JCheckBox("Term (simplified form)");
            Options.this.sfBox.setSelected(((Options)Options.this).prefs.saveSF);
            vbox.add(Options.this.sfBox);
            Options.this.bfBox = new JCheckBox("Term (base form)");
            Options.this.bfBox.setSelected(((Options)Options.this).prefs.saveBF);
            vbox.add(Options.this.bfBox);
            Options.this.cvalueBox = new JCheckBox("C-value");
            Options.this.cvalueBox.setSelected(((Options)Options.this).prefs.saveCV);
            vbox.add(Options.this.cvalueBox);
            Options.this.compBox = new JCheckBox("LL/TFITF/CSmw/TW");
            Options.this.compBox.setSelected(((Options)Options.this).prefs.saveComp);
            vbox.add(Options.this.compBox);
            Options.this.lenBox = new JCheckBox("Length");
            Options.this.lenBox.setSelected(((Options)Options.this).prefs.saveLen);
            vbox.add(Options.this.lenBox);
            Options.this.freqsBox = new JCheckBox("Freq_s");
            Options.this.freqsBox.setSelected(((Options)Options.this).prefs.saveFreqs);
            vbox.add(Options.this.freqsBox);
            Options.this.freqinBox = new JCheckBox("Freq_in");
            Options.this.freqinBox.setSelected(((Options)Options.this).prefs.saveFreqin);
            vbox.add(Options.this.freqinBox);
            Options.this.contextBox = new JCheckBox("Context #");
            Options.this.contextBox.setSelected(((Options)Options.this).prefs.saveContext);
            vbox.add(Options.this.contextBox);
            vbox.add(Box.createVerticalStrut(32));
            vbox.add(Box.createVerticalGlue());
            Options.this.selectAllButton = new JButton("Select all fields");
            hbox.add(Options.this.selectAllButton);
            hbox.add(Box.createHorizontalGlue());
            Options.this.selectCCButton = new JButton("Select fields for corpora comparing");
            hbox.add(Options.this.selectCCButton);
            hbox.add(Box.createHorizontalGlue());
            Options.this.clearButton = new JButton("Clear");
            hbox.add(Options.this.clearButton);
            this.add((Component)vbox, "Center");
            this.add((Component)hbox, "South");
            Options.this.selectAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Options.this.countBox.setSelected(true);
                    Options.this.rankBox.setSelected(true);
                    Options.this.sfBox.setSelected(true);
                    Options.this.bfBox.setSelected(true);
                    Options.this.cvalueBox.setSelected(true);
                    Options.this.compBox.setSelected(true);
                    Options.this.lenBox.setSelected(true);
                    Options.this.freqsBox.setSelected(true);
                    Options.this.freqinBox.setSelected(true);
                    Options.this.contextBox.setSelected(true);
                }
            });
            Options.this.selectCCButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Options.this.countBox.setSelected(false);
                    Options.this.rankBox.setSelected(false);
                    Options.this.sfBox.setSelected(true);
                    Options.this.bfBox.setSelected(false);
                    Options.this.cvalueBox.setSelected(true);
                    Options.this.compBox.setSelected(false);
                    Options.this.lenBox.setSelected(false);
                    Options.this.freqsBox.setSelected(true);
                    Options.this.freqinBox.setSelected(false);
                    Options.this.contextBox.setSelected(false);
                }
            });
            Options.this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Options.this.countBox.setSelected(false);
                    Options.this.rankBox.setSelected(false);
                    Options.this.sfBox.setSelected(false);
                    Options.this.bfBox.setSelected(false);
                    Options.this.cvalueBox.setSelected(false);
                    Options.this.compBox.setSelected(false);
                    Options.this.lenBox.setSelected(false);
                    Options.this.freqsBox.setSelected(false);
                    Options.this.freqinBox.setSelected(false);
                    Options.this.contextBox.setSelected(false);
                }
            });
        }
    }

    private class GrammarPanel
    extends JPanel {
        public GrammarPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
            this.arrangeComponents();
        }

        public void arrangeComponents() {
            ButtonGroup group = new ButtonGroup();
            JPanel panel = new JPanel(new BorderLayout());
            Box hbox = Box.createHorizontalBox();
            JLabel label = new JLabel("Language: ");
            hbox.add(label);
            Options.this.languageCombo = new FlagCombo();
            hbox.add(Options.this.languageCombo);
            this.add(hbox);
            this.add(Box.createVerticalStrut(16));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Extraction Method"), BorderFactory.createEmptyBorder(16, 16, 16, 16)));
            Box vbox = Box.createVerticalBox();
            hbox = Box.createHorizontalBox();
            Options.this.UDButton = new JRadioButton("Universal Dependencies");
            Options.this.UDButton.setSelected(((Options)Options.this).prefs.useUD);
            Options.this.shallowGButton = new JRadioButton("Grammar Templates");
            Options.this.shallowGButton.setSelected(!((Options)Options.this).prefs.useUD);
            group.add(Options.this.UDButton);
            group.add(Options.this.shallowGButton);
            hbox.add(Options.this.UDButton);
            hbox.add(Box.createHorizontalStrut(32));
            hbox.add(Options.this.shallowGButton);
            vbox.add(hbox);
            panel.add((Component)vbox, "Center");
            this.add(panel);
            this.add(Box.createVerticalStrut(16));
            panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Tagset"), BorderFactory.createEmptyBorder(16, 16, 16, 16)));
            vbox = Box.createVerticalBox();
            hbox = Box.createHorizontalBox();
            Options.this.standardTagsetButton = new JRadioButton("Use built-in tagset");
            Options.this.standardTagsetButton.setSelected(!((Options)Options.this).prefs.useCustomTagset);
            group = new ButtonGroup();
            group.add(Options.this.standardTagsetButton);
            hbox.add(Options.this.standardTagsetButton);
            hbox.add(Box.createHorizontalGlue());
            this.add(hbox);
            vbox.add(hbox);
            hbox = Box.createHorizontalBox();
            Options.this.customTagsetButton = new JRadioButton("Use custom tagset");
            Options.this.customTagsetButton.setSelected(((Options)Options.this).prefs.useCustomTagset);
            group.add(Options.this.customTagsetButton);
            hbox.add(Options.this.customTagsetButton);
            hbox.add(Box.createHorizontalGlue());
            this.add(hbox);
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(16));
            hbox = Box.createHorizontalBox();
            label = new JLabel("Tagset: ");
            hbox.add(label);
            Options.this.tagsetName = new JLabel();
            hbox.add(Options.this.tagsetName);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(16));
            vbox.add(Box.createVerticalGlue());
            hbox = Box.createHorizontalBox();
            Options.this.changeTagset = new JButton("Change tagset...");
            hbox.add(Box.createHorizontalGlue());
            hbox.add(Options.this.changeTagset);
            vbox.add(hbox);
            panel.add((Component)vbox, "Center");
            this.add(panel);
            this.add(Box.createVerticalStrut(16));
            panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Grammar"), BorderFactory.createEmptyBorder(16, 16, 16, 16)));
            group = new ButtonGroup();
            vbox = Box.createVerticalBox();
            hbox = Box.createHorizontalBox();
            Options.this.standardGrammarButton = new JRadioButton("Use built-in grammar");
            Options.this.standardGrammarButton.setSelected(!((Options)Options.this).prefs.useCustomGrammar);
            group.add(Options.this.standardGrammarButton);
            hbox.add(Options.this.standardGrammarButton);
            hbox.add(Box.createHorizontalGlue());
            this.add(hbox);
            vbox.add(hbox);
            hbox = Box.createHorizontalBox();
            Options.this.customGrammarButton = new JRadioButton("Use custom grammar");
            Options.this.customGrammarButton.setSelected(((Options)Options.this).prefs.useCustomGrammar);
            group.add(Options.this.customGrammarButton);
            hbox.add(Options.this.customGrammarButton);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(16));
            hbox = Box.createHorizontalBox();
            label = new JLabel("Grammar: ");
            hbox.add(label);
            Options.this.grammarName = new JLabel();
            hbox.add(Options.this.grammarName);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(16));
            vbox.add(Box.createVerticalGlue());
            hbox = Box.createHorizontalBox();
            Options.this.changeGrammar = new JButton("Change grammar...");
            hbox.add(Box.createHorizontalGlue());
            hbox.add(Options.this.changeGrammar);
            vbox.add(hbox);
            panel.add((Component)vbox, "Center");
            this.add(panel);
            Options.this.languageCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    GrammarPanel.this.changeLanguage();
                }
            });
            Options.this.UDButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Options.this.searchPanel.adjustControls();
                }
            });
            Options.this.shallowGButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Options.this.searchPanel.adjustControls();
                }
            });
            Options.this.changeTagset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    GrammarPanel.this.changeTagset();
                }
            });
            Options.this.standardTagsetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    GrammarPanel.this.changeTagset(false);
                }
            });
            Options.this.customTagsetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    GrammarPanel.this.changeTagset(true);
                }
            });
            Options.this.changeGrammar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    GrammarPanel.this.changeGrammar();
                }
            });
            Options.this.standardGrammarButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    GrammarPanel.this.changeTagset(false);
                    GrammarPanel.this.changeGrammar(false);
                }
            });
            Options.this.customGrammarButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    GrammarPanel.this.changeGrammar(true);
                }
            });
            Options.this.standardGrammarButton.setSelected(!((Options)Options.this).prefs.useCustomGrammar);
            Options.this.customGrammarButton.setSelected(((Options)Options.this).prefs.useCustomGrammar);
            Options.this.standardTagsetButton.setSelected(!((Options)Options.this).prefs.useCustomTagset);
            Options.this.customTagsetButton.setSelected(((Options)Options.this).prefs.useCustomTagset);
            if (((Options)Options.this).prefs.useCustomGrammar) {
                Options.this.grammarName.setText(Options.this.grammarFile.getName());
            } else {
                Options.this.grammarName.setText(Options.BUILT_IN);
                Options.this.standardTagsetButton.setSelected(true);
            }
            if (((Options)Options.this).prefs.useCustomTagset) {
                Options.this.tagsetName.setText(Options.this.tagsetFile.getName());
            } else {
                Options.this.tagsetName.setText(Options.BUILT_IN);
            }
            this.initLanguageCombo();
        }

        public void initLanguageCombo() {
            Options.this.languageCombo.addItem(new LanguageInfo(null, null, null, null));
            if (!TermoPL.languages.isEmpty()) {
                for (LanguageInfo langInfo : TermoPL.languages.values()) {
                    Options.this.languageCombo.addItem(langInfo);
                }
            }
            Dimension dim = Options.this.languageCombo.getPreferredSize();
            Options.this.languageCombo.setMaximumSize(dim);
            if (((Options)Options.this).prefs.language == null) {
                Options.this.languageCombo.setSelectedIndex(0);
            } else {
                Options.this.languageCombo.setSelectedItem(TermoPL.languages.get(((Options)Options.this).prefs.language));
            }
        }

        public void changeLanguage() {
            final String str = ((LanguageInfo)Options.this.languageCombo.getSelectedItem()).getLanguageCode();
            if (str == null && Options.this.language != null || str != null && !str.equals(Options.this.language)) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Options.this.searchPanel.adjustControls();
                        Options.this.language = str;
                    }
                });
            }
        }

        public void changeTagset() {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Choose Tagset");
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showOpenDialog(Options.this) == 0) {
                this.changeTagset(chooser.getSelectedFile());
            }
        }

        public void changeTagset(boolean custom) {
            if (custom) {
                if (this.changeTagset(Options.this.tagsetPath)) {
                    Options.this.customTagsetButton.setSelected(true);
                    Options.this.standardTagsetButton.setSelected(false);
                }
            } else {
                Options.this.tagsetName.setText(Options.BUILT_IN);
                Options.this.tagset = Tagset.createDefaultTagset();
                Options.this.standardTagsetButton.setSelected(true);
                this.reloadGrammar();
            }
        }

        public boolean changeTagset(File file) {
            TParser parser = new TParser(file, Options.this.dialog);
            parser.parse();
            Tagset ts = parser.getTagset();
            if (ts != null && this.reloadGrammar()) {
                Options.this.tagsetPath = file.getPath();
                Options.this.tagset = ts;
                Options.this.tagsetName.setText(file.getName());
                Options.this.customTagsetButton.setSelected(true);
                Options.this.standardTagsetButton.setSelected(false);
                return true;
            }
            return false;
        }

        public boolean changeTagset(String path) {
            if (path == null) {
                this.changeTagset();
                return Options.this.tagsetPath != null;
            }
            return this.changeTagset(new File(path));
        }

        public void changeGrammar() {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Choose Grammar");
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showOpenDialog(Options.this) == 0) {
                this.changeGrammar(chooser.getSelectedFile());
            }
        }

        public void changeGrammar(boolean custom) {
            if (custom) {
                if (this.changeGrammar(Options.this.grammarPath)) {
                    Options.this.customGrammarButton.setSelected(true);
                    Options.this.standardGrammarButton.setSelected(false);
                }
            } else {
                Options.this.tagsetName.setText(Options.BUILT_IN);
                Options.this.tagset = Tagset.createDefaultTagset();
                Options.this.standardTagsetButton.setSelected(true);
                Options.this.grammarName.setText(Options.BUILT_IN);
                Options.this.template = Template.NPP();
                Options.this.standardGrammarButton.setSelected(true);
            }
        }

        public boolean changeGrammar(File file) {
            GParser parser = new GParser(file, Options.this.tagset, Options.this.dialog);
            parser.parse();
            Template tmp = parser.getTemplate();
            if (tmp != null) {
                Options.this.grammarPath = file.getPath();
                Options.this.template = tmp;
                Options.this.grammarName.setText(file.getName());
                Options.this.customGrammarButton.setSelected(true);
                Options.this.standardGrammarButton.setSelected(false);
                return true;
            }
            return false;
        }

        public boolean changeGrammar(String path) {
            if (path == null) {
                this.changeGrammar();
                return Options.this.grammarPath != null;
            }
            return this.changeGrammar(new File(path));
        }

        public boolean reloadGrammar() {
            if (Options.this.customGrammarButton.isSelected()) {
                return this.changeGrammar(Options.this.grammarPath);
            }
            return true;
        }
    }

    private class RowRenderer
    extends DefaultTableCellRenderer {
        private RowRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setValue(value);
            if (isSelected) {
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
                this.setBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                this.setForeground(Color.black);
                if (row % 2 == 0) {
                    this.setBackground(CommonResources.VLIGHT_BLUE);
                } else {
                    this.setBackground(Color.white);
                }
            }
            return this;
        }
    }

    private class SWCPCTTableEditor
    extends DefaultCellEditor {
        int row;
        String value;
        JTextField textField;
        JTable table;

        public SWCPCTTableEditor(JTable table) {
            super(new JTextField());
            this.table = table;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.textField = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.textField.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            this.row = row;
            this.value = this.textField.getText();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SWCPCTTableEditor.this.textField.requestFocusInWindow();
                }
            });
            return this.textField;
        }

        @Override
        public boolean stopCellEditing() {
            return this.stopCellEditing(true);
        }

        public boolean stopCellEditing(boolean f) {
            String newValue = this.textField.getText();
            boolean ok = this.stopEditing(newValue, f);
            if (ok) {
                return super.stopCellEditing();
            }
            return false;
        }

        public boolean stopEditing(String newValue, boolean f) {
            SWCPCTTableModel model = (SWCPCTTableModel)this.table.getModel();
            if (newValue.isEmpty()) {
                if (this.table == Options.this.swTable) {
                    Options.this.sw.remove(this.row);
                } else if (this.table == Options.this.cpTable) {
                    Options.this.cp.remove(this.row);
                } else {
                    Options.this.ct.remove(this.row);
                }
                model.fireTableRowsDeleted(this.row, this.row);
                if (this.table == Options.this.swTable) {
                    if (Options.this.sw.size() == 0) {
                        Options.this.sw = null;
                    }
                    Options.this.clearSWButton.setEnabled(Options.this.sw != null);
                    Options.this.saveSWButton.setEnabled(Options.this.sw != null);
                } else if (this.table == Options.this.cpTable) {
                    if (Options.this.cp.size() == 0) {
                        Options.this.cp = null;
                    }
                    Options.this.clearCPButton.setEnabled(Options.this.cp != null);
                    Options.this.saveCPButton.setEnabled(Options.this.cp != null);
                } else {
                    if (Options.this.ct.size() == 0) {
                        Options.this.ct = null;
                    }
                    Options.this.clearCTButton.setEnabled(Options.this.ct != null);
                    Options.this.saveCTButton.setEnabled(Options.this.ct != null);
                }
            } else if (!newValue.equals(this.value)) {
                if (this.table == Options.this.swTable) {
                    model.setValueAt(newValue, this.row, 0);
                    Options.this.sw.set(this.row, newValue);
                } else if (this.table == Options.this.cpTable) {
                    PParser parser = new PParser(newValue, (Object)Options.this.dialog);
                    parser.parse();
                    if (parser.getTemplate() == null) {
                        this.textField.selectAll();
                        this.textField.requestFocusInWindow();
                        return false;
                    }
                    model.setValueAt(newValue, this.row, 0);
                    Options.this.cp.set(this.row, newValue);
                } else {
                    CommonTerm t = (CommonTerm)Options.this.ct.get(this.row);
                    model.setValueAt(newValue, this.row, 0);
                    if (f) {
                        if (Options.this.showSimplifiedForms.isSelected()) {
                            t.sf = newValue;
                            if (t.bf.isEmpty()) {
                                t.bf = newValue;
                            }
                        } else {
                            t.bf = newValue;
                            if (t.sf.isEmpty()) {
                                t.sf = t.createSimplifiedForm(t.bf);
                            }
                        }
                    } else if (Options.this.showSimplifiedForms.isSelected()) {
                        t.bf = newValue;
                        if (t.sf.isEmpty()) {
                            t.sf = t.createSimplifiedForm(t.bf);
                        }
                    } else {
                        t.sf = newValue;
                        if (t.bf.isEmpty()) {
                            t.bf = newValue;
                        }
                    }
                    Options.this.ct.set(this.row, t);
                }
            }
            return true;
        }
    }

    private class SWCPCTTableModel
    extends AbstractTableModel {
        private JTable table;

        public SWCPCTTableModel(JTable table) {
            this.table = table;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            if (this.table == Options.this.swTable) {
                if (Options.this.sw == null) {
                    return 0;
                }
                return Options.this.sw.size();
            }
            if (this.table == Options.this.cpTable) {
                if (Options.this.cp == null) {
                    return 0;
                }
                return Options.this.cp.size();
            }
            if (Options.this.ct == null) {
                return 0;
            }
            return Options.this.ct.size();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.table == Options.this.swTable) {
                if (Options.this.sw == null) {
                    return null;
                }
                return Options.this.sw.get(row);
            }
            if (this.table == Options.this.cpTable) {
                if (Options.this.cp == null) {
                    return null;
                }
                return Options.this.cp.get(row);
            }
            if (Options.this.ct == null) {
                return null;
            }
            if (Options.this.showSimplifiedForms.isSelected()) {
                return ((CommonTerm)((Options)Options.this).ct.get((int)row)).sf;
            }
            return ((CommonTerm)((Options)Options.this).ct.get((int)row)).bf;
        }
    }

    private class SearchPanel
    extends JPanel {
        public SearchPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
            this.arrangeComponents();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchPanel.this.adjustControls();
                }
            });
        }

        public void arrangeComponents() {
            ButtonGroup group = new ButtonGroup();
            Box vbox = Box.createVerticalBox();
            Box hbox = Box.createHorizontalBox();
            Options.this.NPMI = new JCheckBox("Use NPMI method to search for nested terms");
            hbox.add(Options.this.NPMI);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalStrut(32));
            Options.this.method1Button = new JRadioButton("Method 1");
            group.add(Options.this.method1Button);
            hbox.add(Options.this.method1Button);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalStrut(32));
            Options.this.method2Button = new JRadioButton("Method 2");
            group.add(Options.this.method2Button);
            hbox.add(Options.this.method2Button);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalStrut(32));
            Options.this.method3Button = new JRadioButton("Method 3");
            group.add(Options.this.method3Button);
            hbox.add(Options.this.method3Button);
            hbox.add(Box.createHorizontalStrut(32));
            Options.this.label1 = new JLabel("Preference factor: ");
            hbox.add(Options.this.label1);
            Options.this.factor = new JTextField(3);
            Dimension dim = Options.this.factor.getPreferredSize();
            Options.this.factor.setMaximumSize(dim);
            hbox.add(Options.this.factor);
            Options.this.label2 = new JLabel("%");
            hbox.add(Options.this.label2);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            hbox = Box.createHorizontalBox();
            Options.this.leftToRight = new JCheckBox("Trim phrases from left to right");
            hbox.add(Options.this.leftToRight);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(6));
            hbox = Box.createHorizontalBox();
            Options.this.info1 = new JLabel();
            Options.this.info1.setFont(CommonResources.plainFont);
            hbox.add(Options.this.info1);
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(12));
            Options.this.NPMI.setSelected(((Options)Options.this).prefs.useNPMIMethod);
            Options.this.method1Button.setSelected(((Options)Options.this).prefs.NPMIMethod == 1);
            Options.this.method2Button.setSelected(((Options)Options.this).prefs.NPMIMethod == 2);
            Options.this.method3Button.setSelected(((Options)Options.this).prefs.NPMIMethod == 3);
            Options.this.leftToRight.setSelected(((Options)Options.this).prefs.trimFromLeftToRight);
            Options.this.factor.setText(Integer.toString(((Options)Options.this).prefs.NPMIfactor));
            group = new ButtonGroup();
            hbox = Box.createHorizontalBox();
            Options.this.label3 = new JLabel("Context counting method:");
            hbox.add(Options.this.label3);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(6));
            hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalStrut(32));
            Options.this.cntxMethod1Button = new JRadioButton("Method 1");
            group.add(Options.this.cntxMethod1Button);
            hbox.add(Options.this.cntxMethod1Button);
            hbox.add(Box.createHorizontalStrut(32));
            Options.this.cntxMethod2Button = new JRadioButton("Method 2");
            group.add(Options.this.cntxMethod2Button);
            hbox.add(Options.this.cntxMethod2Button);
            hbox.add(Box.createHorizontalStrut(32));
            Options.this.cntxMethod3Button = new JRadioButton("Method 3");
            group.add(Options.this.cntxMethod3Button);
            hbox.add(Options.this.cntxMethod3Button);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(6));
            hbox = Box.createHorizontalBox();
            Options.this.info2 = new JLabel();
            Options.this.info2.setFont(CommonResources.plainFont);
            hbox.add(Options.this.info2);
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(12));
            Options.this.cntxMethod1Button.setSelected(((Options)Options.this).prefs.cntxMethod == 1);
            Options.this.cntxMethod2Button.setSelected(((Options)Options.this).prefs.cntxMethod == 2);
            Options.this.cntxMethod3Button.setSelected(((Options)Options.this).prefs.cntxMethod == 3);
            group = new ButtonGroup();
            hbox = Box.createHorizontalBox();
            Options.this.label4 = new JLabel("Handling determiners:");
            hbox.add(Options.this.label4);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(6));
            hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalStrut(32));
            Options.this.includeDeterminers = new JRadioButton("Include");
            group.add(Options.this.includeDeterminers);
            hbox.add(Options.this.includeDeterminers);
            hbox.add(Box.createHorizontalStrut(32));
            Options.this.detectDeterminers = new JCheckBox("only if det/noun ratio exeeds ");
            hbox.add(Options.this.detectDeterminers);
            Options.this.detRatio = new JTextField(2);
            dim = Options.this.detRatio.getPreferredSize();
            Options.this.detRatio.setMaximumSize(dim);
            hbox.add(Options.this.detRatio);
            Options.this.label5 = new JLabel("%");
            hbox.add(Options.this.label5);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalStrut(32));
            Options.this.includeArticles = new JRadioButton("Include only articles");
            group.add(Options.this.includeArticles);
            hbox.add(Options.this.includeArticles);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            hbox = Box.createHorizontalBox();
            hbox.add(Box.createHorizontalStrut(32));
            Options.this.excludeDeterminers = new JRadioButton("Exclude");
            group.add(Options.this.excludeDeterminers);
            hbox.add(Options.this.excludeDeterminers);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            Options.this.sepBox = Box.createVerticalStrut(6);
            vbox.add(Options.this.sepBox);
            hbox = Box.createHorizontalBox();
            Options.this.info3 = new JLabel();
            Options.this.info3.setFont(CommonResources.plainFont);
            hbox.add(Options.this.info3);
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(12));
            Options.this.includeDeterminers.setSelected(((Options)Options.this).prefs.detHandling == 1);
            Options.this.includeArticles.setSelected(((Options)Options.this).prefs.detHandling == 2);
            Options.this.excludeDeterminers.setSelected(((Options)Options.this).prefs.detHandling == 3);
            Options.this.detectDeterminers.setSelected(((Options)Options.this).prefs.detectDeterminers);
            Options.this.detRatio.setText(Integer.toString(((Options)Options.this).prefs.detRatio));
            hbox = Box.createHorizontalBox();
            Options.this.makeGroups = new JCheckBox("Group terms");
            hbox.add(Options.this.makeGroups);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            hbox = Box.createHorizontalBox();
            Options.this.useWordNet = new JCheckBox("Use plWordNet for term grouping");
            hbox.add(Options.this.useWordNet);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(6));
            hbox = Box.createHorizontalBox();
            Options.this.label5 = new JLabel("plWordNet file: ");
            Options.this.label5.setFont(CommonResources.plainFont);
            hbox.add(Options.this.label5);
            Options.this.wordNetFile = new JLabel();
            Options.this.wordNetFile.setFont(CommonResources.plainFont);
            hbox.add(Options.this.wordNetFile);
            hbox.add(Box.createHorizontalStrut(32));
            hbox.add(Box.createHorizontalGlue());
            Options.this.changeWordNetButton = new JButton("Change...");
            hbox.add(Options.this.changeWordNetButton);
            vbox.add(hbox);
            Options.this.makeGroups.setSelected(((Options)Options.this).prefs.makeGroups);
            Options.this.useWordNet.setSelected(((Options)Options.this).prefs.useWordNet);
            if (Options.this.wordNetPath != null) {
                File f = new File(Options.this.wordNetPath);
                if (f.exists()) {
                    Options.this.wordNetFile.setText(f.getName());
                } else {
                    Options.this.wordNetPath = null;
                }
            }
            if (Options.this.wordNetPath == null) {
                Options.this.wordNetFile.setText("<not selected>");
            }
            this.add((Component)vbox, "North");
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SearchPanel.this.adjustControls();
                }
            };
            Options.this.NPMI.addActionListener(listener);
            Options.this.leftToRight.addActionListener(listener);
            Options.this.method1Button.addActionListener(listener);
            Options.this.method2Button.addActionListener(listener);
            Options.this.method3Button.addActionListener(listener);
            Options.this.cntxMethod1Button.addActionListener(listener);
            Options.this.cntxMethod2Button.addActionListener(listener);
            Options.this.cntxMethod3Button.addActionListener(listener);
            Options.this.includeDeterminers.addActionListener(listener);
            Options.this.includeArticles.addActionListener(listener);
            Options.this.excludeDeterminers.addActionListener(listener);
            Options.this.useWordNet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (Options.this.useWordNet.isSelected() && Options.this.wordNetPath == null) {
                        SearchPanel.this.changeWordNetPath();
                    }
                }
            });
            Options.this.changeWordNetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SearchPanel.this.changeWordNetPath();
                }
            });
        }

        public void adjustControls() {
            boolean f1 = Options.this.NPMI.isSelected();
            boolean f2 = Options.this.shallowGButton.isSelected();
            String lang = ((LanguageInfo)Options.this.languageCombo.getSelectedItem()).getLanguageCode();
            Options.this.NPMI.setEnabled(f2);
            Options.this.leftToRight.setEnabled(!f1 && f2);
            Options.this.method1Button.setEnabled(f1 && f2);
            Options.this.method2Button.setEnabled(f1 && f2);
            Options.this.method3Button.setEnabled(f1 && f2);
            Options.this.factor.setEnabled(f1 && f2);
            Options.this.label1.setEnabled(f1 && f2);
            Options.this.label2.setEnabled(f1 && f2);
            Options.this.info1.setEnabled(f2);
            Options.this.info2.setEnabled(f2);
            f1 = f1 || !Options.this.leftToRight.isSelected();
            Options.this.label3.setEnabled(f2);
            Options.this.cntxMethod1Button.setEnabled(f1 && f2);
            Options.this.cntxMethod2Button.setEnabled(f1 && f2);
            Options.this.cntxMethod3Button.setEnabled(f1 && f2);
            Options.this.label4.setEnabled(!f2);
            Options.this.includeDeterminers.setEnabled(!f2);
            Options.this.detectDeterminers.setEnabled(!f2);
            Options.this.detRatio.setEnabled(!f2);
            Options.this.includeArticles.setEnabled(!f2);
            Options.this.excludeDeterminers.setEnabled(!f2);
            Options.this.info3.setEnabled(!f2);
            f2 = lang != null && lang.equals("pl");
            Options.this.useWordNet.setEnabled(f2);
            Options.this.label5.setEnabled(f2);
            Options.this.wordNetFile.setEnabled(f2);
            Options.this.changeWordNetButton.setEnabled(f2);
            this.setInfo1();
            this.setInfo2();
            this.setInfo3();
        }

        public void setInfo1() {
            if (Options.this.NPMI.isSelected()) {
                if (Options.this.method1Button.isSelected()) {
                    Options.this.info1.setText(Options.INFO2);
                } else if (Options.this.method2Button.isSelected()) {
                    Options.this.info1.setText(Options.INFO3);
                } else {
                    Options.this.info1.setText(Options.INFO4);
                }
            } else if (Options.this.leftToRight.isSelected()) {
                Options.this.info1.setText(Options.INFO9);
            } else {
                Options.this.info1.setText(Options.INFO1);
            }
        }

        public void setInfo2() {
            if (Options.this.leftToRight.isSelected() && Options.this.leftToRight.isEnabled()) {
                Options.this.info2.setText(Options.INFO8);
            } else if (Options.this.cntxMethod1Button.isSelected()) {
                Options.this.info2.setText(Options.INFO5);
            } else if (Options.this.cntxMethod2Button.isSelected()) {
                Options.this.info2.setText(Options.INFO6);
            } else {
                Options.this.info2.setText(Options.INFO7);
            }
        }

        public void setInfo3() {
            if (Options.this.includeDeterminers.isSelected()) {
                Options.this.info3.setText(Options.INF10);
                Options.this.info3.setVisible(true);
                Options.this.sepBox.setVisible(true);
            } else {
                Options.this.info3.setText("");
                Options.this.info3.setVisible(false);
                Options.this.sepBox.setVisible(false);
            }
        }

        public void changeWordNetPath() {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Choose plWordNet");
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showOpenDialog(Options.this) == 0) {
                Options.this.wordNetPath = chooser.getSelectedFile().getAbsolutePath();
                Options.this.wordNetFile.setText(chooser.getSelectedFile().getName());
            } else if (Options.this.wordNetPath == null) {
                Options.this.useWordNet.setSelected(false);
            }
        }
    }

    private class StopWordsPanel
    extends JPanel {
        public StopWordsPanel() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
            this.arrangeComponents();
        }

        public void arrangeComponents() {
            Box hbox = Box.createHorizontalBox();
            Options.this.checkSW = new JCheckBox("Check for stop words:");
            hbox.add(Options.this.checkSW);
            hbox.add(Box.createHorizontalGlue());
            this.add((Component)hbox, "North");
            Options.this.swTable = new JTable();
            Options.this.swTable.setModel(new SWCPCTTableModel(Options.this.swTable));
            Options.this.swTable.setShowHorizontalLines(false);
            Options.this.swTable.setShowVerticalLines(false);
            Options.this.swTable.setCellSelectionEnabled(true);
            Options.this.swTable.setTableHeader(null);
            TableColumnModel columnModel = Options.this.swTable.getColumnModel();
            TableColumn column = columnModel.getColumn(0);
            column.setCellRenderer(new RowRenderer());
            column.setCellEditor(new SWCPCTTableEditor(Options.this.swTable));
            JScrollPane sp = new JScrollPane(Options.this.swTable);
            sp.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            this.add((Component)sp, "Center");
            Box vbox = Box.createVerticalBox();
            vbox.add(Box.createVerticalStrut(2));
            hbox = Box.createHorizontalBox();
            Options.this.addSWButton = new PictButton("plus.png", true);
            Options.this.addSWButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            hbox.add(Options.this.addSWButton);
            Options.this.removeSWButton = new PictButton("minus.png", true);
            Options.this.removeSWButton.setEnabled(false);
            Options.this.removeSWButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            hbox.add(Options.this.removeSWButton);
            hbox.add(Box.createHorizontalGlue());
            vbox.add(hbox);
            vbox.add(Box.createVerticalStrut(8));
            hbox = Box.createHorizontalBox();
            JLabel label = new JLabel(" and merge ");
            Options.this.loadSWButton = new JButton("Load...");
            Options.this.mergeSW = new JCheckBox();
            Options.this.mergeSW.setSelected(((Options)Options.this).prefs.mergeSW);
            Options.this.saveSWButton = new JButton("Save...");
            Options.this.clearSWButton = new JButton("Clear");
            hbox.add(Options.this.loadSWButton);
            hbox.add(label);
            hbox.add(Options.this.mergeSW);
            hbox.add(Box.createHorizontalStrut(8));
            hbox.add(Options.this.saveSWButton);
            hbox.add(Box.createHorizontalStrut(8));
            hbox.add(Box.createHorizontalGlue());
            hbox.add(Options.this.clearSWButton);
            vbox.add(hbox);
            this.add((Component)vbox, "South");
            Options.this.swTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    int row = Options.this.swTable.getSelectedRow();
                    Options.this.removeSWButton.setEnabled(row >= 0);
                }
            });
            Options.this.addSWButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean ok = Options.this.swTable.isEditing() ? Options.this.swTable.getCellEditor().stopCellEditing() : true;
                    if (ok) {
                        SWCPCTTableModel model = (SWCPCTTableModel)Options.this.swTable.getModel();
                        if (Options.this.sw == null) {
                            Options.this.sw = new LinkedList();
                        }
                        int row = Options.this.sw.size();
                        Options.this.sw.add("");
                        model.fireTableRowsInserted(row, row);
                        Options.this.swTable.scrollRectToVisible(Options.this.swTable.getCellRect(row, 0, true));
                        Options.this.swTable.editCellAt(row, 0);
                        Options.this.clearSWButton.setEnabled(Options.this.sw != null);
                        Options.this.saveSWButton.setEnabled(Options.this.sw != null);
                    }
                }
            });
            Options.this.removeSWButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SWCPCTTableModel model = (SWCPCTTableModel)Options.this.swTable.getModel();
                    int[] rows = Options.this.swTable.getSelectedRows();
                    if (rows != null) {
                        int i = 0;
                        while (i < rows.length) {
                            Options.this.sw.remove(rows[i] - i);
                            if (Options.this.sw.size() == 0) {
                                Options.this.sw = null;
                            }
                            ++i;
                        }
                        model.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
                    }
                    Options.this.clearSWButton.setEnabled(Options.this.sw != null);
                    Options.this.saveSWButton.setEnabled(Options.this.sw != null);
                }
            });
            Options.this.loadSWButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean ok;
                    if (Options.this.swTable.isEditing()) {
                        if (Options.this.mergeSW.isSelected()) {
                            ok = Options.this.swTable.getCellEditor().stopCellEditing();
                        } else {
                            Options.this.swTable.getCellEditor().cancelCellEditing();
                            ok = true;
                        }
                    } else {
                        ok = true;
                    }
                    if (ok) {
                        JFileChooser chooser = new JFileChooser();
                        chooser.setDialogTitle("Load Stop Words");
                        chooser.setMultiSelectionEnabled(false);
                        if (chooser.showOpenDialog(Options.this) == 0) {
                            File file = chooser.getSelectedFile();
                            try {
                                String line;
                                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                                if (!Options.this.mergeSW.isSelected()) {
                                    Options.this.sw = null;
                                }
                                do {
                                    if ((line = reader.readLine()) == null || (line = line.trim()).isEmpty()) continue;
                                    if (Options.this.sw == null) {
                                        Options.this.sw = new LinkedList();
                                    }
                                    if (Options.this.sw.contains(line)) continue;
                                    Options.this.sw.add(line);
                                } while (line != null);
                                reader.close();
                            }
                            catch (IOException exception) {
                                ErrorViewer viewer = new ErrorViewer(Options.this.dialog);
                                viewer.showError(exception.toString());
                            }
                            SWCPCTTableModel model = (SWCPCTTableModel)Options.this.swTable.getModel();
                            model.fireTableDataChanged();
                        }
                    }
                    Options.this.clearSWButton.setEnabled(Options.this.sw != null);
                    Options.this.saveSWButton.setEnabled(Options.this.sw != null);
                }
            });
            Options.this.saveSWButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    boolean ok = Options.this.swTable.isEditing() ? Options.this.swTable.getCellEditor().stopCellEditing() : true;
                    if (ok) {
                        SaveFileChooser chooser = new SaveFileChooser();
                        chooser.setDialogTitle("Save Stop Words");
                        chooser.setSelectedFile(new File("StopWords.txt"));
                        if (chooser.showSaveDialog(Options.this) == 0) {
                            File file = chooser.getSelectedFile();
                            try {
                                PrintWriter pw = new PrintWriter(file, "UTF8");
                                if (Options.this.sw != null) {
                                    for (String s : Options.this.sw) {
                                        pw.println(s);
                                    }
                                }
                                pw.flush();
                                pw.close();
                            }
                            catch (FileNotFoundException e) {
                                ErrorViewer viewer = new ErrorViewer(Options.this.dialog);
                                viewer.showError(e.toString());
                            }
                            catch (UnsupportedEncodingException e) {
                                ErrorViewer viewer = new ErrorViewer(Options.this.dialog);
                                viewer.showError(e.toString());
                            }
                        }
                    }
                }
            });
            Options.this.clearSWButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SWCPCTTableModel model = (SWCPCTTableModel)Options.this.swTable.getModel();
                    int s = Options.this.sw.size();
                    Options.this.sw = null;
                    model.fireTableRowsDeleted(0, s);
                    Options.this.clearSWButton.setEnabled(false);
                    Options.this.saveSWButton.setEnabled(false);
                }
            });
            Options.this.clearSWButton.setEnabled(Options.this.sw != null);
            Options.this.saveSWButton.setEnabled(Options.this.sw != null);
            Options.this.checkSW.setSelected(((Options)Options.this).prefs.checkStopWords);
        }
    }
}

