/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import termopl.Commander;
import termopl.DefaultMasterFrame;
import termopl.MenuFactory;
import termopl.TermoPL;
import termopl.TermoPLDocument;
import termopl.TermoPLWindow;

public class TermoPLDefaultWindow
extends JInternalFrame
implements TermoPLWindow {
    private int ID;
    private TermoPLDocument doc;
    private InternalFrameListener internalFrameListener;

    public TermoPLDefaultWindow(TermoPLDocument doc, int ID, Container view) {
        super("", true, true, true, true);
        this.doc = doc;
        this.ID = ID;
        this.setDefaultCloseOperation(0);
        this.setContentPane(view);
        this.pack();
        ((DefaultMasterFrame)TermoPL.mainWindow).getDesktopPane().add(this);
        this.internalFrameListener = new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent event) {
                TermoPLDefaultWindow.this.close();
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent event) {
                TermoPLDefaultWindow.this.activate();
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent event) {
                TermoPLDefaultWindow.this.deactivate();
            }
        };
        this.addInternalFrameListener(this.internalFrameListener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent event) {
                TermoPLDefaultWindow.this.saveBounds();
            }

            @Override
            public void componentResized(ComponentEvent event) {
                TermoPLDefaultWindow.this.saveBounds();
            }
        });
    }

    @Override
    public void select() {
        try {
            if (this.isIcon()) {
                this.setIcon(false);
            }
            this.setVisible(true);
            this.toFront();
            this.setSelected(true);
            this.activate();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public TermoPLDocument getDocument() {
        return this.doc;
    }

    @Override
    public void close() {
        this.doc.close(this);
    }

    @Override
    public void destroySelf() {
        this.removeInternalFrameListener(this.internalFrameListener);
        this.setVisible(false);
        this.deactivate();
        try {
            this.setClosed(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        this.dispose();
    }

    @Override
    public void activate() {
        if (Commander.getCommander() != this.doc) {
            Commander.setCommander(this.doc);
        }
        TermoPL.changeZOrder(this);
        MenuFactory.resetWindowMenu(this.doc);
        MenuFactory.resetSelection(this.doc, this);
    }

    @Override
    public void deactivate() {
        MenuFactory.resetWindowMenu(this.doc);
        MenuFactory.resetSelection(this.doc, this);
    }

    public void saveBounds() {
        Rectangle r;
        Rectangle bounds = this.getBounds();
        if (!bounds.equals(r = TermoPL.preferences.getBounds(this.ID))) {
            TermoPL.preferences.setBounds(this.ID, bounds);
            TermoPL.preferences.setModified(true);
        }
    }
}

