/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import termopl.AndTemplate;
import termopl.CompoundTemplate;
import termopl.FormTemplate;
import termopl.OrTemplate;
import termopl.Parser;
import termopl.ParserException;
import termopl.Template;

public class PParser
extends Parser {
    private LinkedList<String> patterns;
    private Template template;

    public PParser(String pattern, Object owner) {
        super(owner);
        this.string = pattern;
        this.patterns = null;
    }

    public PParser(LinkedList<String> patterns, Object owner) {
        super(owner);
        this.patterns = patterns;
    }

    @Override
    public void parse() {
        if (this.patterns != null) {
            this.parsePatterns();
        } else {
            this.parseSinglePattern();
        }
    }

    public void parsePatterns() {
        OrTemplate ot = new OrTemplate();
        try {
            for (String pat : this.patterns) {
                this.reader = new BufferedReader(new StringReader(pat));
                ot.add(this.parsePattern());
                this.reader.close();
            }
            this.template = this.noErrors() ? ot : null;
        }
        catch (IOException exception) {
            this.template = null;
        }
        catch (ParserException exception) {
            this.template = null;
        }
        this.reportErrors();
    }

    public void parseSinglePattern() {
        try {
            this.reader = new BufferedReader(new StringReader(this.string));
            Template temp = this.parsePattern();
            this.reader.close();
            this.template = this.noErrors() ? temp : null;
        }
        catch (IOException exception) {
            this.template = null;
        }
        catch (ParserException exception) {
            this.template = null;
        }
        this.reportErrors();
    }

    public Template parsePattern() throws ParserException {
        return this.parsePatternList(Parser.Symbol.EMPTY);
    }

    public Template parsePatternList(Parser.Symbol stopSym) throws ParserException {
        CompoundTemplate temp2;
        this.getSymbol();
        OrTemplate temp1 = null;
        do {
            temp2 = null;
            do {
                boolean f;
                Template temp;
                if (this.symbol == Parser.Symbol.LBRCT) {
                    temp = this.parsePatternList(Parser.Symbol.RBRCT);
                    temp.setQuantifier(1);
                    if (temp2 == null) {
                        temp2 = new AndTemplate(temp);
                        continue;
                    }
                    temp2.add(temp);
                    continue;
                }
                if (this.symbol == Parser.Symbol.LPAR) {
                    temp = this.parsePatternList(Parser.Symbol.RPAR);
                    if (temp2 == null) {
                        temp2 = new AndTemplate(temp);
                        continue;
                    }
                    temp2.add(temp);
                    continue;
                }
                if (this.symbol == Parser.Symbol.HASH) {
                    f = true;
                    this.getSymbol();
                } else {
                    f = false;
                }
                if (this.symbol == Parser.Symbol.IDENTIFIER) {
                    temp = f ? (this.identifier.equals("adjp") ? Template.adjp : null) : new FormTemplate(this.identifier);
                    this.getSymbol();
                    if (temp == null) continue;
                    if (temp2 == null) {
                        temp2 = new AndTemplate(temp);
                        continue;
                    }
                    temp2.add(temp);
                    continue;
                }
                this.error(3);
                this.skip(Parser.Symbol.IDENTIFIER);
            } while (!this.tooManyErrors() && (this.symbol == Parser.Symbol.IDENTIFIER || this.symbol == Parser.Symbol.HASH || this.symbol == Parser.Symbol.LPAR || this.symbol == Parser.Symbol.LBRCT));
            if (this.symbol != Parser.Symbol.OR) continue;
            this.getSymbol();
            if (temp1 == null) {
                temp1 = new OrTemplate();
            }
            if (temp2.size() > 1) {
                temp1.add(temp2);
                continue;
            }
            temp1.add(temp2.getFirst());
        } while (this.symbol != stopSym && !this.tooManyErrors());
        if (stopSym != Parser.Symbol.EMPTY) {
            this.getSymbol();
        }
        if (temp1 != null) {
            if (temp2.size() > 1) {
                temp1.add(temp2);
            } else {
                temp1.add(temp2.getFirst());
            }
        }
        return temp1 == null ? temp2 : temp1;
    }

    @Override
    public void getSymbol() throws ParserException {
        int ch = 32;
        while (Character.isWhitespace(ch)) {
            ch = this.getNextChar();
        }
        this.scanPos = this.charCount - 1;
        if (Character.isLetter(ch)) {
            this.buffer.setLength(0);
            while (Character.isLetter(ch)) {
                this.buffer.append((char)ch);
                ch = this.getNextChar();
            }
            this.identifier = this.buffer.toString();
            this.symbol = Parser.Symbol.IDENTIFIER;
            if (ch != 32 && ch != -1 && ch != 10) {
                --this.charCount;
            }
        } else {
            this.symbol = ch == 35 ? Parser.Symbol.HASH : (ch == -1 ? Parser.Symbol.EMPTY : (ch == 40 ? Parser.Symbol.LPAR : (ch == 41 ? Parser.Symbol.RPAR : (ch == 91 ? Parser.Symbol.LBRCT : (ch == 93 ? Parser.Symbol.RBRCT : (ch == 124 ? Parser.Symbol.OR : Parser.Symbol.UNKNOWN))))));
        }
    }

    public Template getTemplate() {
        return this.template;
    }
}

