/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import termopl.Commander;
import termopl.MenuFactory;
import termopl.TermoPL;
import termopl.TermoPLDocument;
import termopl.TermoPLWindow;

public class TermoPLMacWindow
extends JFrame
implements TermoPLWindow {
    private int ID;
    private TermoPLDocument doc;

    public TermoPLMacWindow(TermoPLDocument doc, int ID, Container view) {
        this.doc = doc;
        this.ID = ID;
        this.setDefaultCloseOperation(0);
        this.setContentPane(view);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                TermoPLMacWindow.this.close();
            }

            @Override
            public void windowActivated(WindowEvent event) {
                TermoPLMacWindow.this.activate();
            }

            @Override
            public void windowDeactivated(WindowEvent event) {
                TermoPLMacWindow.this.deactivate();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent event) {
                TermoPLMacWindow.this.saveBounds();
            }

            @Override
            public void componentResized(ComponentEvent event) {
                TermoPLMacWindow.this.saveBounds();
            }
        });
        JMenuBar mbar = MenuFactory.createMenuBar(true);
        this.setJMenuBar(mbar);
        for (TermoPLDocument document : TermoPL.documents) {
            MenuFactory.addToDocumentSwitchMenu(MenuFactory.getDocumentSwitchMenu(mbar), document);
        }
    }

    @Override
    public void select() {
        this.setVisible(true);
        this.toFront();
        this.requestFocus();
        this.activate();
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public TermoPLDocument getDocument() {
        return this.doc;
    }

    @Override
    public void close() {
        this.doc.close(this);
    }

    @Override
    public void destroySelf() {
        this.setVisible(false);
        this.deactivate();
        this.dispose();
    }

    @Override
    public void activate() {
        if (Commander.getCommander() != this.doc) {
            Commander.setCommander(this.doc);
        }
        TermoPL.changeZOrder(this);
        MenuFactory.resetWindowMenu(this.doc, this);
        MenuFactory.resetSelection(this.doc, this);
    }

    @Override
    public void deactivate() {
        MenuFactory.resetWindowMenu(this.doc, this);
        MenuFactory.resetSelection(this.doc, this);
    }

    public void saveBounds() {
        Rectangle r;
        Rectangle bounds = this.getBounds();
        if (!bounds.equals(r = TermoPL.preferences.getBounds(this.ID))) {
            TermoPL.preferences.setBounds(this.ID, bounds);
            TermoPL.preferences.setModified(true);
        }
    }
}

