/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;
import termopl.ExtractorEngine;
import termopl.MatchedToken;
import termopl.MultiWordToken;
import termopl.Token;
import termopl.UDToken;

public class Form
implements Serializable {
    private LinkedList<MatchedToken> tokens = null;
    private int inner = 0;
    private int standalone = 0;

    public static Form createFromMatchedTokens(LinkedList<MatchedToken> tokens) {
        Form form = new Form();
        form.tokens = tokens;
        return form;
    }

    public static Form createFromTokens(LinkedList<? extends Token> tokens) {
        Form form = new Form();
        form.tokens = Form.convertToMatchedTokens(tokens);
        return form;
    }

    public static LinkedList<MatchedToken> convertToMatchedTokens(LinkedList<? extends Token> tokens) {
        LinkedList<MatchedToken> list = new LinkedList<MatchedToken>();
        for (Token token : tokens) {
            MatchedToken mt = new MatchedToken(token);
            list.add(mt);
        }
        MatchedToken matchedToken = Form.findHead(list);
        if (matchedToken != null) {
            int s;
            int e;
            Token ht = matchedToken.token;
            matchedToken.head = true;
            if (ht instanceof UDToken) {
                s = e = ((UDToken)ht).index;
            } else {
                s = ((MultiWordToken)ht).startToken();
                e = ((MultiWordToken)ht).endToken();
            }
            matchedToken.computeBaseForm = true;
            for (MatchedToken mt : list) {
                Token t;
                if (mt == matchedToken || !((t = mt.token) instanceof UDToken)) continue;
                UDToken ut = (UDToken)t;
                if (ut.UDLink < s || ut.UDLink > e || !ExtractorEngine.headPhraseRel(ut)) continue;
                mt.computeBaseForm = true;
            }
        }
        return list;
    }

    public static MatchedToken findHead(LinkedList<MatchedToken> tokens) {
        MatchedToken head = null;
        for (MatchedToken mt : tokens) {
            Token t = mt.token;
            if (t instanceof UDToken) {
                if (Form.findUDLink(((UDToken)t).UDLink, tokens)) continue;
                head = mt;
                break;
            }
            MultiWordToken mwt = (MultiWordToken)t;
            boolean found = false;
            for (UDToken ut : mwt.getTokens()) {
                if (!Form.findUDLink(ut.UDLink, tokens)) continue;
                found = true;
                break;
            }
            if (found) continue;
            head = mt;
            break;
        }
        return head;
    }

    public static boolean findUDLink(int link, LinkedList<MatchedToken> tokens) {
        for (MatchedToken mt : tokens) {
            Token t = mt.token;
            if (t instanceof UDToken) {
                if (link != ((UDToken)t).index) continue;
                return true;
            }
            MultiWordToken mwt = (MultiWordToken)t;
            for (UDToken it : mwt.getTokens()) {
                if (link != it.index) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.tokens == null) {
            return 0;
        }
        return this.tokens.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Form) {
            Form form = (Form)obj;
            if (form.length() != this.length()) {
                return false;
            }
            LinkedList<MatchedToken> list = form.getTokens();
            ListIterator it1 = list.listIterator();
            ListIterator it2 = this.tokens.listIterator();
            while (it1.hasNext()) {
                Token t1 = ((MatchedToken)it1.next()).token;
                Token t2 = ((MatchedToken)it2.next()).token;
                if (t1.form.equals(t2.form)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void addOccurence(boolean asInner) {
        if (asInner) {
            ++this.inner;
        } else {
            ++this.standalone;
        }
    }

    public LinkedList<MatchedToken> getTokens() {
        return this.tokens;
    }

    public MatchedToken getMatchedToken(int index) {
        if (this.tokens != null && this.tokens.size() > index) {
            return this.tokens.get(index);
        }
        return null;
    }

    public int length() {
        if (this.tokens == null) {
            return 0;
        }
        return this.tokens.size();
    }

    public void addInnerOccurences(int n) {
        this.inner += n;
    }

    public int innerOccurences() {
        return this.inner;
    }

    public void addStandaloneOccurences(int n) {
        this.standalone += n;
    }

    public int standaloneOccurences() {
        return this.standalone;
    }

    public int allOccurences() {
        return this.standalone + this.inner;
    }

    public String[] getLemmas() {
        String[] lemmas = new String[this.tokens.size()];
        int i = 0;
        for (MatchedToken t : this.tokens) {
            lemmas[i++] = t.token.lemma;
        }
        return lemmas;
    }

    public String getTag() {
        String tag = null;
        for (MatchedToken mt : this.getTokens()) {
            Token t;
            if (!mt.computeBaseForm || (t = mt.token) instanceof MultiWordToken) continue;
            if (t instanceof UDToken) {
                UDToken ut = (UDToken)t;
                tag = ut.UDTag;
                break;
            }
            tag = t.ctag;
            break;
        }
        return tag;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Token prev = null;
        int index = 0;
        int prevIndex = 0;
        boolean appendSpace = false;
        for (MatchedToken mt : this.getTokens()) {
            Token tok = mt.token;
            index = tok instanceof UDToken ? ((UDToken)tok).index : (tok instanceof MultiWordToken ? ((MultiWordToken)tok).endToken() : prevIndex + 1);
            if (prev != null && (appendSpace || index > prevIndex + 1)) {
                buffer.append(" ");
            }
            buffer.append(tok.form);
            appendSpace = tok.spaceAfter;
            prev = tok;
            prevIndex = index;
        }
        return buffer.toString();
    }

    public String occurences() {
        return "[" + this.standalone + "," + this.inner + "]";
    }
}

