/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import termopl.CommonTerm;
import termopl.GParser;
import termopl.PParser;
import termopl.TParser;
import termopl.Tagset;
import termopl.Template;
import termopl.TermoPL;

public class Preferences
implements Serializable,
Cloneable {
    public static final int MIN_FONT_SIZE = 11;
    public static final int MAX_FONT_SIZE = 15;
    public static final int[] DEFAULT_SORT_PREFS = new int[]{1, 1, 1, -1, -1, -1, -1, -1, -1};
    public static final String DEFAULT_WORKSPACE = String.valueOf(System.getProperty("user.home")) + File.separator + "TermoPLWorkspace";
    public int sortedColumn;
    public int maxResults;
    public int minLength;
    public int maxLength;
    public int contrastiveRankingMethod;
    public int NPMIMethod;
    public int NPMIfactor;
    public int detRatio;
    public int cntxMethod;
    public int detHandling;
    public int minfrq;
    public int fontSize;
    public int[] sortPrefs;
    public double mincvalue;
    public double alpha;
    public double beta;
    public boolean reuseTaggedFiles;
    public boolean trimResults;
    public boolean filterResults;
    public boolean multiWordTermsOnly;
    public boolean checkStopWords;
    public boolean makeGroups;
    public boolean useWordNet;
    public boolean mergeSW;
    public boolean removeCompoundPreps;
    public boolean mergeCP;
    public boolean removeCommonTerms;
    public boolean mergeCT;
    public boolean showSimplifiedForms;
    public boolean useUD;
    public boolean useCustomTagset;
    public boolean useCustomGrammar;
    public boolean calculateBaseForms;
    public boolean collectAllForms;
    public boolean makeIndex;
    public boolean useNPMIMethod;
    public boolean trimFromLeftToRight;
    public boolean detectDeterminers;
    public boolean applyContrastiveRanking;
    public boolean applyContrastiveRankingForTopRankedTerms;
    public boolean applyContrastiveRankingForFrequentTerms;
    public boolean useCValues;
    public boolean saveCount;
    public boolean saveRank;
    public boolean saveSF;
    public boolean saveBF;
    public boolean saveCV;
    public boolean saveComp;
    public boolean saveLen;
    public boolean saveFreqs;
    public boolean saveFreqin;
    public boolean saveContext;
    public boolean extract;
    public boolean compare;
    public boolean reloadContrastiveTerms;
    public boolean caseSensitive;
    public boolean entireWord;
    public boolean regEx;
    public String language;
    public String workSpace;
    public String filePath;
    public String tagsetPath;
    public String grammarPath;
    public String wordNetPath;
    public String contrastiveDataPath;
    public LinkedList<String> stopWords;
    public LinkedList<String> compPreps;
    public LinkedList<CommonTerm> commonTerms;
    public LinkedList<String> recentFiles;
    public HashMap<Integer, Rectangle> sizeAndLocation;
    public transient boolean modified = false;
    public transient boolean repaint;
    public transient boolean recalculate;
    public transient Tagset tagset;
    public transient Template template;
    public transient Template compoundPrepositions;
    public transient Font plainFont;
    public transient Font boldFont;
    public transient Set<String> stopWordSet;
    public transient Set<String> commonTermSet;

    public Object clone() {
        try {
            Preferences cloned = (Preferences)super.clone();
            return cloned;
        }
        catch (CloneNotSupportedException exception) {
            return null;
        }
    }

    public void setDefaults() {
        this.sortedColumn = 1;
        this.maxResults = 1000;
        this.minLength = 2;
        this.maxLength = -1;
        this.contrastiveRankingMethod = 1;
        this.NPMIMethod = 3;
        this.NPMIfactor = 120;
        this.detRatio = 20;
        this.cntxMethod = 1;
        this.detHandling = 1;
        this.minfrq = 1;
        this.fontSize = 11;
        this.sortPrefs = new int[DEFAULT_SORT_PREFS.length];
        System.arraycopy(DEFAULT_SORT_PREFS, 0, this.sortPrefs, 0, DEFAULT_SORT_PREFS.length);
        this.mincvalue = 0.0;
        this.alpha = 0.9;
        this.beta = 0.3;
        this.reuseTaggedFiles = true;
        this.trimResults = false;
        this.filterResults = false;
        this.multiWordTermsOnly = false;
        this.checkStopWords = true;
        this.makeGroups = true;
        this.mergeSW = false;
        this.removeCompoundPreps = true;
        this.mergeCP = false;
        this.removeCommonTerms = false;
        this.mergeCT = false;
        this.showSimplifiedForms = false;
        this.useUD = false;
        this.useCustomTagset = false;
        this.useCustomGrammar = false;
        this.calculateBaseForms = true;
        this.collectAllForms = false;
        this.makeIndex = false;
        this.useNPMIMethod = true;
        this.trimFromLeftToRight = false;
        this.detectDeterminers = true;
        this.applyContrastiveRanking = false;
        this.applyContrastiveRankingForTopRankedTerms = true;
        this.applyContrastiveRankingForFrequentTerms = true;
        this.useCValues = true;
        this.saveCount = true;
        this.saveRank = true;
        this.saveSF = true;
        this.saveBF = true;
        this.saveCV = true;
        this.saveComp = true;
        this.saveLen = true;
        this.saveFreqs = true;
        this.saveFreqin = true;
        this.saveContext = true;
        this.repaint = false;
        this.recalculate = false;
        this.useWordNet = false;
        this.language = "pl";
        this.workSpace = DEFAULT_WORKSPACE;
        this.filePath = DEFAULT_WORKSPACE;
        this.tagsetPath = null;
        this.grammarPath = null;
        this.wordNetPath = null;
        this.contrastiveDataPath = null;
        this.stopWords = null;
        this.compPreps = null;
        this.reloadContrastiveTerms = false;
        this.caseSensitive = false;
        this.entireWord = true;
        this.regEx = false;
        this.commonTerms = null;
        this.tagset = null;
        this.template = null;
        this.stopWordSet = null;
        this.commonTermSet = null;
        this.compoundPrepositions = null;
        this.extract = false;
        this.compare = false;
        this.recentFiles = new LinkedList();
        this.sizeAndLocation = new HashMap();
        this.createFonts();
        this.setModified(true);
    }

    public static Preferences createPreferences(boolean finalize) {
        Preferences preferences;
        String path = String.valueOf(System.getProperty("user.home")) + File.separator + ".TermoPL-7";
        File file = new File(path);
        try {
            ObjectInputStream input = new ObjectInputStream(new FileInputStream(file));
            preferences = (Preferences)input.readObject();
        }
        catch (Exception exception) {
            preferences = new Preferences();
            preferences.setDefaults();
        }
        preferences.finalizeCreate(finalize);
        return preferences;
    }

    public void finalizeCreate(boolean finalize) {
        if (finalize) {
            String path;
            File f;
            File ws = new File(this.workSpace);
            if (!ws.exists()) {
                if (!this.workSpace.equals(DEFAULT_WORKSPACE)) {
                    this.workSpace = DEFAULT_WORKSPACE;
                }
                ws = new File(this.workSpace);
                ws.mkdirs();
            }
            this.createFonts();
            if (this.filePath != null && !(f = new File(this.filePath)).exists()) {
                this.filePath = this.workSpace;
            }
            if (this.contrastiveDataPath != null) {
                path = this.resolvePath(this.contrastiveDataPath);
                f = new File(path);
                this.contrastiveDataPath = f.exists() ? path : null;
            }
            if (this.tagsetPath != null) {
                path = this.resolvePath(this.tagsetPath);
                f = new File(path);
                this.tagsetPath = f.exists() ? path : null;
            }
            if (this.useCustomTagset) {
                this.readCustomTagset(TermoPL.dialogOwner);
            } else {
                this.tagset = Tagset.createDefaultTagset();
            }
            if (this.grammarPath != null) {
                path = this.resolvePath(this.grammarPath);
                f = new File(path);
                this.grammarPath = f.exists() ? path : null;
            }
            if (this.useCustomGrammar) {
                this.readCustomGrammar(TermoPL.dialogOwner);
            } else {
                this.template = Template.NPP();
            }
            if (this.checkStopWords) {
                this.readStopWords(TermoPL.dialogOwner);
            }
            if (this.removeCompoundPreps) {
                this.readCompoundPreps(TermoPL.dialogOwner);
            } else {
                this.compoundPrepositions = null;
            }
        }
    }

    public void save() {
        String path = String.valueOf(System.getProperty("user.home")) + File.separator + ".TermoPL-7";
        this.save(new File(path));
    }

    public void save(File file) {
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(file));
            this.save(output);
            output.flush();
            output.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save(ObjectOutputStream output) {
        String tp = this.tagsetPath;
        String gp = this.grammarPath;
        String dp = this.contrastiveDataPath;
        if (this.tagsetPath != null) {
            this.tagsetPath = this.getRelativizedPath(this.tagsetPath);
        }
        if (this.grammarPath != null) {
            this.grammarPath = this.getRelativizedPath(this.grammarPath);
        }
        if (this.contrastiveDataPath != null) {
            this.contrastiveDataPath = this.getRelativizedPath(this.workSpace, this.contrastiveDataPath, "WORKSPACE");
        }
        try {
            output.writeObject(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tagsetPath = tp;
        this.grammarPath = gp;
        this.contrastiveDataPath = dp;
    }

    public Tagset getTagset() {
        return this.tagset;
    }

    public void readCustomTagset(Component owner) {
        if (this.tagsetPath != null) {
            File tfile = new File(this.tagsetPath);
            if (tfile.exists()) {
                TParser parser = new TParser(tfile, owner);
                parser.parse();
                Tagset tset = parser.getTagset();
                if (tset != null) {
                    this.tagset = tset;
                } else {
                    this.tagsetPath = null;
                    this.useCustomTagset = false;
                    this.tagset = Tagset.createDefaultTagset();
                }
            } else {
                this.tagsetPath = null;
                this.useCustomTagset = false;
                this.tagset = Tagset.createDefaultTagset();
            }
        } else {
            this.useCustomTagset = false;
            this.tagset = Tagset.createDefaultTagset();
        }
    }

    public void readCustomGrammar(Component owner) {
        if (this.grammarPath != null) {
            File gfile = new File(this.grammarPath);
            if (gfile.exists()) {
                GParser parser = new GParser(gfile, this.tagset, owner);
                parser.parse();
                Template tmp = parser.getTemplate();
                if (tmp != null) {
                    this.template = tmp;
                } else {
                    this.grammarPath = null;
                    this.tagsetPath = null;
                    this.useCustomGrammar = false;
                    this.useCustomTagset = false;
                    this.template = Template.NPP();
                }
            } else {
                this.grammarPath = null;
                this.tagsetPath = null;
                this.useCustomGrammar = false;
                this.useCustomTagset = false;
                this.template = Template.NPP();
            }
        } else {
            this.useCustomGrammar = false;
            this.useCustomTagset = false;
            this.template = Template.NPP();
        }
    }

    public void readStopWords(Component owner) {
        String path;
        File file;
        LinkedList<String> sw = this.stopWords;
        if (sw == null && (file = new File(path = String.valueOf(System.getProperty("user.dir")) + File.separator + "termopl_sw.txt")).exists()) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                do {
                    if ((line = reader.readLine()) == null || (line = line.trim()).isEmpty()) continue;
                    if (sw == null) {
                        sw = new LinkedList();
                    }
                    if (sw.contains(line)) continue;
                    sw.add(line);
                } while (line != null);
                reader.close();
                this.stopWords = sw;
            }
            catch (IOException exception) {
                sw = null;
            }
        }
    }

    public void readCompoundPreps(Component owner) {
        String path;
        File file;
        LinkedList<String> cp = this.compPreps;
        if (cp == null && (file = new File(path = String.valueOf(System.getProperty("user.dir")) + File.separator + "termopl_cp.txt")).exists()) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
                do {
                    if ((line = reader.readLine()) == null || (line = line.trim()).isEmpty()) continue;
                    if (cp == null) {
                        cp = new LinkedList();
                    }
                    if (cp.contains(line)) continue;
                    cp.add(line);
                } while (line != null);
                reader.close();
            }
            catch (IOException exception) {
                cp = null;
            }
        }
        if (cp != null) {
            PParser parser = new PParser(cp, (Object)owner);
            parser.parse();
            Template tmp = parser.getTemplate();
            if (tmp != null) {
                this.compoundPrepositions = tmp;
                this.compPreps = cp;
            } else {
                this.compoundPrepositions = null;
            }
        } else {
            this.compoundPrepositions = null;
        }
    }

    public void setModified(boolean f) {
        this.modified = f;
    }

    public boolean isModified() {
        return this.modified;
    }

    public Rectangle getBounds(int windowID) {
        Rectangle rect = this.sizeAndLocation.get(windowID);
        if (rect == null) {
            rect = new Rectangle();
        }
        return rect;
    }

    public void setBounds(int windowID, Rectangle bounds) {
        this.sizeAndLocation.put(windowID, bounds);
        this.setModified(true);
    }

    public void createFonts() {
        this.plainFont = new Font("SansSerif", 0, this.fontSize);
        this.boldFont = new Font("SansSerif", 1, this.fontSize);
    }

    public String resolvePath(String path) {
        int index = path.lastIndexOf(43);
        if (index < 0) {
            return path;
        }
        String p = path.substring(index + 1);
        if (path.startsWith("WORKSPACE+")) {
            p = String.valueOf(this.workSpace) + File.separator + p;
        } else if (path.startsWith("APPLOC+")) {
            p = String.valueOf(TermoPL.appLocation) + File.separator + p;
        }
        return p;
    }

    public String resolveFilePath(String path) {
        File file = new File(path);
        String filePath = null;
        if (file.getAbsolutePath().equals(path)) {
            if (file.exists()) {
                filePath = path;
            }
        } else {
            filePath = String.valueOf(this.workSpace) + File.separator + path;
            file = new File(filePath);
            if (!file.exists() && !(file = new File(filePath = String.valueOf(TermoPL.appLocation) + File.separator + path)).exists()) {
                filePath = null;
            }
        }
        return filePath;
    }

    public static String resolveFilePath(String workSpace, String path) {
        File file = new File(path);
        String fPath = file.getAbsolutePath();
        if (path.equals(fPath) || workSpace == null) {
            return fPath;
        }
        return String.valueOf(workSpace) + File.separator + path;
    }

    public String getRelativizedPath(String path) {
        Path wpath = FileSystems.getDefault().getPath(this.workSpace, new String[0]);
        Path ppath = FileSystems.getDefault().getPath(path, new String[0]);
        if (wpath.getRoot().compareTo(ppath.getRoot()) == 0) {
            return "WORKSPACE+" + wpath.relativize(ppath).toString();
        }
        wpath = FileSystems.getDefault().getPath(TermoPL.appLocation, new String[0]);
        if (wpath.getRoot().compareTo(ppath.getRoot()) == 0) {
            return "APPLOC+" + wpath.relativize(ppath).toString();
        }
        return "ABSOLUTE+" + path;
    }

    public String getRelativizedPath(String workSpace, String path, String label) {
        String p;
        if (workSpace.isEmpty()) {
            p = "ABSOLUTE+" + path;
        } else {
            Path wpath = FileSystems.getDefault().getPath(workSpace, new String[0]);
            Path ppath = FileSystems.getDefault().getPath(path, new String[0]);
            p = wpath.getRoot().compareTo(ppath.getRoot()) == 0 ? String.valueOf(label) + "+" + wpath.relativize(ppath).toString() : "ABSOLUTE+" + path;
        }
        return p;
    }
}

