/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import termopl.Context;
import termopl.DocFreq;
import termopl.Form;
import termopl.MatchedToken;
import termopl.SentenceRef;
import termopl.SentenceRefEx;
import termopl.UDToken;

public class Term
implements Serializable {
    public static final byte DEFAULT_STATUS = -1;
    public static final byte IGNORE_STATUS = 10;
    public static final byte UNIQUE_STATUS = 11;
    private static final Color[] TERM_COLORS = new Color[]{new Color(139, 169, 82), new Color(165, 194, 106), new Color(194, 214, 155), new Color(214, 227, 188), new Color(233, 240, 220), new Color(255, 255, 204), new Color(255, 255, 153), new Color(255, 255, 102), new Color(255, 217, 97), new Color(255, 169, 65), new Color(221, 221, 221), Color.white};
    private LinkedList<Context> contexts;
    private LinkedList<Form> forms;
    private LinkedList<DocFreq> docFreq;
    private LinkedList<SentenceRef> sentenceRef;
    private HashMap<String, Integer> formsWithTAG;
    private Term cterm;
    private byte status;
    private byte matching;
    public String str;
    public int freq_s;
    public int freq_in;
    public int lk;
    public int len;
    public int rank;
    public double cvalue;
    public double contrast;

    public Term() {
    }

    public Term(String str, int len) {
        this.str = str;
        this.len = len;
        this.rank = 0;
        this.lk = 0;
        this.freq_in = 0;
        this.freq_s = 0;
        this.cvalue = 0.0;
        this.contrast = 0.0;
        this.forms = null;
        this.formsWithTAG = null;
        this.status = (byte)-1;
        this.matching = 0;
        this.contexts = new LinkedList();
        this.docFreq = null;
        this.sentenceRef = null;
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Term) {
            String s = ((Term)obj).str;
            return s.equals(this.str);
        }
        return false;
    }

    public Term copy() {
        Term cp = new Term();
        cp.str = this.str;
        cp.freq_s = this.freq_s;
        cp.freq_in = this.freq_in;
        cp.lk = this.lk;
        cp.len = this.len;
        cp.rank = this.rank;
        cp.cvalue = this.cvalue;
        cp.contrast = this.contrast;
        cp.contexts = this.contexts;
        cp.forms = this.forms;
        cp.formsWithTAG = this.formsWithTAG;
        cp.docFreq = this.docFreq;
        cp.sentenceRef = this.sentenceRef;
        cp.cterm = this.cterm;
        cp.status = this.status;
        cp.matching = this.matching;
        return cp;
    }

    public boolean isMatching() {
        return this.matching != 0;
    }

    public void setMatching(boolean m) {
        this.matching = (byte)(m ? 1 : 0);
    }

    public void addForm(Form form, int doc, boolean inner, boolean collectAllForms) {
        if (this.formsWithTAG == null) {
            this.formsWithTAG = new HashMap();
        }
        String str = form.toString();
        String tag = form.getTag();
        if (tag != null) {
            str = String.valueOf(str) + "\t" + tag;
        }
        if (this.formsWithTAG.containsKey(str)) {
            int val = this.formsWithTAG.get(str);
            this.formsWithTAG.put(str, val + 1);
        } else {
            this.formsWithTAG.put(str, 1);
        }
        if (this.forms == null) {
            this.forms = new LinkedList();
            this.forms.add(form);
            form.addOccurence(inner);
        } else if (collectAllForms) {
            int index = this.forms.indexOf(form);
            if (index < 0) {
                this.forms.add(form);
                form.addOccurence(inner);
            } else {
                Form frm = this.forms.get(index);
                frm.addOccurence(inner);
            }
        }
        ++this.freq_s;
        if (inner) {
            ++this.freq_in;
        }
        if (doc >= 1) {
            if (this.docFreq == null) {
                this.docFreq = new LinkedList();
            }
            if (this.docFreq.size() > 0) {
                DocFreq df = this.docFreq.getLast();
                if (df.docID != doc) {
                    df = new DocFreq(doc);
                    df.freq = 1;
                    this.docFreq.add(df);
                } else {
                    ++df.freq;
                }
            } else {
                DocFreq df = new DocFreq(doc);
                df.freq = 1;
                this.docFreq.add(df);
            }
        }
    }

    public void addForm(Form form, boolean collectAllForms) {
        if (this.forms == null) {
            this.forms = new LinkedList();
            this.forms.add(form);
        } else if (collectAllForms) {
            int index = this.forms.indexOf(form);
            if (index < 0) {
                this.forms.add(form);
            } else {
                Form frm = this.forms.get(index);
                frm.addInnerOccurences(form.innerOccurences());
                frm.addStandaloneOccurences(form.standaloneOccurences());
            }
        } else if (this.prefer(form, this.forms.getFirst())) {
            this.forms.removeFirst();
            this.forms.add(form);
        }
        this.freq_s += form.allOccurences();
        this.freq_in += form.innerOccurences();
    }

    public void addForms(LinkedList<Form> flist, boolean collectAllForms) {
        for (Form form : flist) {
            this.addForm(form, collectAllForms);
        }
    }

    public boolean prefer(Form newForm, Form oldForm) {
        boolean n1 = this.isNominative(newForm);
        boolean n2 = this.isNominative(oldForm);
        boolean s1 = this.isSingular(newForm);
        boolean s2 = this.isSingular(oldForm);
        if (n2 && s2) {
            return false;
        }
        if (n1 && s1) {
            return true;
        }
        if (n2) {
            return false;
        }
        if (n1) {
            return true;
        }
        if (s2) {
            return false;
        }
        return s1;
    }

    public boolean isNominative(Form form) {
        LinkedList<MatchedToken> tokens = form.getTokens();
        for (MatchedToken mt : tokens) {
            if (!mt.computeBaseForm || !(mt.token instanceof UDToken)) continue;
            UDToken t = (UDToken)mt.token;
            if (!t.UDTag.contains("Case=Nom")) continue;
            return true;
        }
        return false;
    }

    public boolean isSingular(Form form) {
        LinkedList<MatchedToken> tokens = form.getTokens();
        for (MatchedToken mt : tokens) {
            if (!mt.computeBaseForm || !(mt.token instanceof UDToken)) continue;
            UDToken t = (UDToken)mt.token;
            if (!t.UDTag.contains("Number=Sing")) continue;
            return true;
        }
        return false;
    }

    public void registerForms(Term t) {
        this.freq_s += t.freq_s;
        this.freq_in += t.freq_in;
    }

    public void addContext(String lc, String rc) {
        if (lc != null || rc != null) {
            boolean found = false;
            for (Context c : this.contexts) {
                if (!c.redundant(lc, rc)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.contexts.add(new Context(lc, rc));
            }
        }
    }

    public void addContext(Context ctx) {
        if (ctx.leftContext != null || ctx.rightContext != null) {
            boolean found = false;
            for (Context c : this.contexts) {
                if (!c.redundant(ctx.leftContext, ctx.rightContext)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.contexts.add(ctx);
            }
        }
    }

    public void addContexts(LinkedList<Context> cntxList) {
        for (Context c : cntxList) {
            this.addContext(c);
        }
    }

    public void addSentenceRef(SentenceRef ref) {
        if (this.sentenceRef == null) {
            this.sentenceRef = new LinkedList();
            this.sentenceRef.add(ref);
        } else if (ref.getIndex() == 0) {
            SentenceRef lastRef = this.sentenceRef.getLast();
            if (lastRef.getFileID() != ref.getFileID() || lastRef.getStartPos() != ref.getStartPos()) {
                this.sentenceRef.add(ref);
            }
        } else {
            this.sentenceRef.add(ref);
        }
    }

    public void addSentenceRef(LinkedList<SentenceRef> sr, int fileIndexOffset) {
        if (sr != null) {
            for (SentenceRef s : sr) {
                SentenceRefEx se;
                if (s instanceof SentenceRefEx) {
                    se = (SentenceRefEx)s;
                    se.fileID += fileIndexOffset;
                } else {
                    se = new SentenceRefEx(fileIndexOffset, s.start, s.len, s.index);
                }
                if (this.sentenceRef == null) {
                    this.sentenceRef = new LinkedList();
                    continue;
                }
                this.sentenceRef.add(se);
            }
        }
    }

    public LinkedList<SentenceRef> getSentenceRef() {
        return this.sentenceRef;
    }

    public LinkedList<Form> getForms() {
        return this.forms;
    }

    public HashMap<String, Integer> getFormsWithTAG() {
        return this.formsWithTAG;
    }

    public void trimForms() {
        if (this.forms.size() > 1) {
            Form f = this.forms.getFirst();
            this.forms.clear();
            this.forms.add(f);
        }
    }

    public void trimIndex() {
        this.sentenceRef = null;
    }

    public LinkedList<Context> getContexts() {
        return this.contexts;
    }

    public void deleteContexts() {
        this.contexts = null;
    }

    public void calc(int cntxMethod) {
        double log2;
        if (this.len == 1) {
            log2 = 0.1;
        } else if (this.len <= 3) {
            log2 = Math.log(this.len) / Math.log(2.0);
        } else {
            log2 = Math.max(2.0, 7.0 - (double)this.len);
            log2 = Math.log(log2) / Math.log(2.0);
        }
        if (this.contexts == null) {
            this.lk = 0;
        } else if (cntxMethod == 1) {
            HashSet<String> sl = new HashSet<String>();
            HashSet<String> sr = new HashSet<String>();
            for (Context c : this.contexts) {
                if (c.leftContext != null) {
                    sl.add(c.leftContext);
                }
                if (c.rightContext == null) continue;
                sr.add(c.rightContext);
            }
            this.lk = Math.max(sl.size(), sr.size());
        } else if (cntxMethod == 2) {
            HashSet<String> sl = new HashSet<String>();
            HashSet<String> sr = new HashSet<String>();
            for (Context c : this.contexts) {
                if (c.leftContext != null && !sl.contains(c.leftContext) && !sr.contains(c.leftContext)) {
                    sl.add(c.leftContext);
                }
                if (c.rightContext == null || sl.contains(c.rightContext) || sr.contains(c.rightContext)) continue;
                sr.add(c.rightContext);
            }
            this.lk = Math.max(sl.size(), sr.size());
        } else {
            this.lk = this.contexts.size();
        }
        this.cvalue = this.freq_in == 0 ? log2 * (double)this.freq_s : log2 * ((double)this.freq_s - (double)this.freq_in / (double)this.lk);
    }

    public void setCTerm(Term cterm) {
        this.cterm = cterm;
    }

    public Term getCTerm() {
        return this.cterm;
    }

    public void addDocFreq(LinkedList<DocFreq> flist) {
        if (flist != null) {
            if (this.docFreq == null) {
                this.docFreq = flist;
            } else {
                this.docFreq.addAll(flist);
            }
        }
    }

    public LinkedList<DocFreq> getDocFreq() {
        return this.docFreq;
    }

    public LinkedList<SentenceRef> getRef() {
        return this.sentenceRef;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public byte getStatus() {
        return this.status;
    }

    public Color getColor() {
        return TERM_COLORS[this.status];
    }
}

