/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.util.LinkedList;
import termopl.AndTemplate;
import termopl.Chain;
import termopl.MatchedElement;
import termopl.MatchedFragment;
import termopl.MatchedToken;
import termopl.OrTemplate;
import termopl.SimpleTemplate;
import termopl.Tagset;
import termopl.Template;
import termopl.Token;

public class TermMatcher {
    private LinkedList<Token> tokens = null;
    private Chain<Token> tokPtr = null;
    private Template template;
    private Tagset tagset;
    private MatchedFragment matched;

    public TermMatcher(Template template, Tagset tagset) {
        this.template = template instanceof SimpleTemplate ? new AndTemplate(template) : template;
        this.tagset = tagset;
    }

    public void setTokens(LinkedList<Token> tokens) {
        this.tokens = tokens;
        this.tokPtr = new Chain<Token>(tokens);
    }

    public void setMatchedTokens(LinkedList<MatchedToken> mtokens) {
        this.tokens = new LinkedList();
        for (MatchedToken mt : mtokens) {
            this.tokens.add(mt.token);
        }
        this.tokPtr = new Chain<Token>(this.tokens);
    }

    public void setTemplate(Template template) {
        this.template = template instanceof SimpleTemplate ? new AndTemplate(template) : template;
        this.tokPtr = new Chain<Token>(this.tokens);
    }

    public boolean find() {
        while (this.tokPtr != null) {
            TestedFragment tf = new TestedFragment();
            Chain<TestedFragment> fragments = new Chain<TestedFragment>(tf);
            this.matched = new MatchedFragment(this.template.computeBaseForm, this.template);
            tf.template = this.template;
            tf.handle = this.matched.getHandle();
            if (this.lookingAt(fragments, this.tokPtr, new SetOfMarkedTemplates()) && this.matched.length() > 0) {
                this.tokPtr = this.tokPtr.skip(this.matched.length());
                return true;
            }
            this.tokPtr = this.tokPtr.tail();
        }
        this.matched = null;
        return false;
    }

    public boolean match() {
        TestedFragment tf = new TestedFragment();
        Chain<TestedFragment> fragments = new Chain<TestedFragment>(tf);
        int len = this.tokPtr.length();
        this.matched = new MatchedFragment(this.template.computeBaseForm, this.template);
        tf.template = this.template;
        tf.handle = this.matched.getHandle();
        if (this.lookingAt(fragments, this.tokPtr, new SetOfMarkedTemplates()) && this.matched.length() == len) {
            return true;
        }
        this.matched = null;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean lookingAt(Chain<TestedFragment> fragments, Chain<Token> tokens, SetOfMarkedTemplates smt) {
        void var11_80;
        Token t;
        if (fragments == null) {
            return true;
        }
        TestedFragment tf = fragments.head();
        Template temp = tf.getTemplate();
        Token token = t = tokens == null ? null : tokens.head();
        if (smt.contains(temp, t)) {
            return this.lookingAt(fragments.tail(), tokens, smt);
        }
        if (temp.quantifier == 0) {
            void var11_59;
            if (temp instanceof SimpleTemplate) {
                SimpleTemplate st = (SimpleTemplate)temp;
                MatchedFragment matched = tf.getMatchedFragment();
                if (t != null && !t.skip() && st.test(t, this.tagset)) {
                    MatchedToken mt = new MatchedToken(temp.computeBaseForm || matched.getTemplate().computeBaseForm, temp.head, t);
                    matched.add(mt);
                    if (matched.testSelf(this.tagset) && this.lookingAt(fragments.tail(), tokens.tail(), smt)) {
                        return true;
                    }
                    matched.remove();
                }
                return false;
            }
            if (temp instanceof OrTemplate) {
                OrTemplate ot = (OrTemplate)temp;
                LinkedList<LinkedList<MatchedElement>> mfList = null;
                for (Template tp : ot.getElements()) {
                    MatchedFragment matchedFragment = tf.getMatchedFragment();
                    MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matchedFragment.computeBaseForm(), temp);
                    TestedFragment newTF = new TestedFragment();
                    Chain<TestedFragment> newFragments = new Chain<TestedFragment>(newTF, fragments.tail());
                    newTF.template = tp;
                    newTF.handle = newMF.getHandle();
                    matchedFragment.add(newMF);
                    if (this.lookingAt(newFragments, tokens, smt)) {
                        LinkedList<MatchedElement> lst = matchedFragment.remove(newMF);
                        if (mfList == null) {
                            mfList = new LinkedList<LinkedList<MatchedElement>>();
                        }
                        mfList.add(lst);
                        continue;
                    }
                    matchedFragment.remove();
                }
                if (mfList == null) {
                    return false;
                }
                LinkedList lst = null;
                int maxLen = 0;
                for (LinkedList linkedList : mfList) {
                    int len = this.length(linkedList);
                    if (lst == null) {
                        lst = linkedList;
                        maxLen = len;
                        continue;
                    }
                    if (maxLen >= len) continue;
                    lst = linkedList;
                    maxLen = len;
                }
                tf.getMatchedFragment().append(lst);
                return true;
            }
            AndTemplate at = (AndTemplate)temp;
            MatchedFragment matched = tf.getMatchedFragment();
            MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matched.computeBaseForm(), temp);
            Chain<TestedFragment> newFragments = null;
            Object var11_58 = null;
            for (Template tp : at.getElements()) {
                TestedFragment newTF = new TestedFragment();
                newTF.template = tp;
                newTF.handle = newMF.getHandle();
                if (newFragments == null) {
                    Chain<TestedFragment> chain;
                    newFragments = chain = new Chain<TestedFragment>(newTF);
                    continue;
                }
                var11_59.setTail(new Chain<TestedFragment>(newTF));
                Chain chain = var11_59.tail();
            }
            var11_59.setTail(fragments.tail());
            matched.add(newMF);
            if (this.lookingAt(newFragments, tokens, smt)) {
                return true;
            }
            matched.remove();
            return false;
        }
        if (temp.quantifier == 1) {
            void var11_66;
            if (temp instanceof SimpleTemplate) {
                SimpleTemplate st = (SimpleTemplate)temp;
                MatchedFragment matched = tf.getMatchedFragment();
                if (t != null && !t.skip() && st.test(t, this.tagset)) {
                    MatchedToken mt = new MatchedToken(temp.computeBaseForm || matched.getTemplate().computeBaseForm, temp.head, t);
                    matched.add(mt);
                    if (matched.testSelf(this.tagset) && this.lookingAt(fragments.tail(), tokens.tail(), smt)) {
                        return true;
                    }
                    matched.remove();
                }
                return this.lookingAt(fragments.tail(), tokens, smt);
            }
            if (temp instanceof OrTemplate) {
                OrTemplate ot = (OrTemplate)temp;
                LinkedList<LinkedList<MatchedElement>> mfList = null;
                for (Template tp : ot.getElements()) {
                    MatchedFragment matchedFragment = tf.getMatchedFragment();
                    MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matchedFragment.computeBaseForm(), temp);
                    TestedFragment newTF = new TestedFragment();
                    Chain<TestedFragment> newFragments = new Chain<TestedFragment>(newTF, fragments.tail());
                    newTF.template = tp;
                    newTF.handle = newMF.getHandle();
                    matchedFragment.add(newMF);
                    if (this.lookingAt(newFragments, tokens, smt)) {
                        LinkedList<MatchedElement> lst = matchedFragment.remove(newMF);
                        if (mfList == null) {
                            mfList = new LinkedList<LinkedList<MatchedElement>>();
                        }
                        mfList.add(lst);
                        continue;
                    }
                    matchedFragment.remove();
                }
                if (mfList == null) {
                    return this.lookingAt(fragments.tail(), tokens, smt);
                }
                LinkedList lst = null;
                int maxLen = 0;
                for (LinkedList linkedList : mfList) {
                    int len = this.length(linkedList);
                    if (lst == null) {
                        lst = linkedList;
                        maxLen = len;
                        continue;
                    }
                    if (maxLen >= len) continue;
                    lst = linkedList;
                    maxLen = len;
                }
                tf.getMatchedFragment().append(lst);
                return true;
            }
            AndTemplate at = (AndTemplate)temp;
            MatchedFragment matched = tf.getMatchedFragment();
            MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matched.computeBaseForm(), temp);
            Chain<TestedFragment> newFragments = null;
            Object var11_65 = null;
            for (Template tp : at.getElements()) {
                TestedFragment newTF = new TestedFragment();
                newTF.template = tp;
                newTF.handle = newMF.getHandle();
                if (newFragments == null) {
                    Chain<TestedFragment> chain;
                    newFragments = chain = new Chain<TestedFragment>(newTF);
                    continue;
                }
                var11_66.setTail(new Chain<TestedFragment>(newTF));
                Chain chain = var11_66.tail();
            }
            var11_66.setTail(fragments.tail());
            matched.add(newMF);
            if (this.lookingAt(newFragments, tokens, smt)) {
                return true;
            }
            matched.remove();
            return this.lookingAt(fragments.tail(), tokens, smt);
        }
        if (temp.quantifier == 2) {
            void var11_73;
            if (temp instanceof SimpleTemplate) {
                SimpleTemplate st = (SimpleTemplate)temp;
                MatchedFragment matched = tf.getMatchedFragment();
                if (t != null && !t.skip() && st.test(t, this.tagset)) {
                    MatchedToken mt = new MatchedToken(temp.computeBaseForm || matched.getTemplate().computeBaseForm, temp.head, t);
                    matched.add(mt);
                    if (matched.testSelf(this.tagset) && this.lookingAt(fragments, tokens.tail(), smt)) {
                        return true;
                    }
                    matched.remove();
                }
                return this.lookingAt(fragments.tail(), tokens, smt);
            }
            if (temp instanceof OrTemplate) {
                OrTemplate ot = (OrTemplate)temp;
                LinkedList<LinkedList<MatchedElement>> mfList = null;
                for (Template tp : ot.getElements()) {
                    MatchedFragment matchedFragment = tf.getMatchedFragment();
                    MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matchedFragment.computeBaseForm(), temp);
                    TestedFragment newTF = new TestedFragment();
                    Chain<TestedFragment> newFragments = new Chain<TestedFragment>(newTF, fragments);
                    newTF.template = tp;
                    newTF.handle = newMF.getHandle();
                    matchedFragment.add(newMF);
                    if (this.lookingAt(newFragments, tokens, new SetOfMarkedTemplates(smt, temp, t))) {
                        LinkedList<MatchedElement> lst = matchedFragment.remove(newMF);
                        if (mfList == null) {
                            mfList = new LinkedList<LinkedList<MatchedElement>>();
                        }
                        mfList.add(lst);
                        continue;
                    }
                    matchedFragment.remove();
                }
                if (mfList == null) {
                    return this.lookingAt(fragments.tail(), tokens, smt);
                }
                LinkedList lst = null;
                int maxLen = 0;
                for (LinkedList linkedList : mfList) {
                    int len = this.length(linkedList);
                    if (lst == null) {
                        lst = linkedList;
                        maxLen = len;
                        continue;
                    }
                    if (maxLen >= len) continue;
                    lst = linkedList;
                    maxLen = len;
                }
                tf.getMatchedFragment().append(lst);
                return true;
            }
            AndTemplate at = (AndTemplate)temp;
            MatchedFragment matched = tf.getMatchedFragment();
            MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matched.computeBaseForm(), temp);
            Chain<TestedFragment> newFragments = null;
            Object var11_72 = null;
            for (Template tp : at.getElements()) {
                TestedFragment newTF = new TestedFragment();
                newTF.template = tp;
                newTF.handle = newMF.getHandle();
                if (newFragments == null) {
                    Chain<TestedFragment> chain;
                    newFragments = chain = new Chain<TestedFragment>(newTF);
                    continue;
                }
                var11_73.setTail(new Chain<TestedFragment>(newTF));
                Chain chain = var11_73.tail();
            }
            var11_73.setTail(fragments);
            matched.add(newMF);
            if (this.lookingAt(newFragments, tokens, new SetOfMarkedTemplates(smt, temp, t))) {
                return true;
            }
            matched.remove();
            return this.lookingAt(fragments.tail(), tokens, smt);
        }
        if (temp instanceof SimpleTemplate) {
            SimpleTemplate st = (SimpleTemplate)temp;
            MatchedFragment matched = tf.getMatchedFragment();
            if (t != null && !t.skip() && st.test(t, this.tagset)) {
                MatchedToken mt = new MatchedToken(temp.computeBaseForm || matched.getTemplate().computeBaseForm, temp.head, t);
                matched.add(mt);
                if (matched.testSelf(this.tagset)) {
                    temp.quantifier = 2;
                    if (this.lookingAt(fragments, tokens.tail(), smt)) {
                        temp.quantifier = 3;
                        return true;
                    }
                    temp.quantifier = 3;
                }
                matched.remove();
            }
            return false;
        }
        if (temp instanceof OrTemplate) {
            OrTemplate ot = (OrTemplate)temp;
            LinkedList<LinkedList<MatchedElement>> mfList = null;
            for (Template tp : ot.getElements()) {
                MatchedFragment matchedFragment = tf.getMatchedFragment();
                MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matchedFragment.computeBaseForm(), temp);
                TestedFragment newTF = new TestedFragment();
                Chain<TestedFragment> newFragments = new Chain<TestedFragment>(newTF, fragments);
                newTF.template = tp;
                newTF.handle = newMF.getHandle();
                matchedFragment.add(newMF);
                temp.quantifier = 2;
                if (this.lookingAt(newFragments, tokens, smt)) {
                    LinkedList<MatchedElement> lst = matchedFragment.remove(newMF);
                    if (mfList == null) {
                        mfList = new LinkedList<LinkedList<MatchedElement>>();
                    }
                    mfList.add(lst);
                } else {
                    matchedFragment.remove();
                }
                temp.quantifier = 3;
            }
            if (mfList == null) {
                return false;
            }
            LinkedList lst = null;
            int maxLen = 0;
            for (LinkedList linkedList : mfList) {
                int len = this.length(linkedList);
                if (lst == null) {
                    lst = linkedList;
                    maxLen = len;
                    continue;
                }
                if (maxLen >= len) continue;
                lst = linkedList;
                maxLen = len;
            }
            tf.getMatchedFragment().append(lst);
            return true;
        }
        AndTemplate at = (AndTemplate)temp;
        MatchedFragment matched = tf.getMatchedFragment();
        MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matched.computeBaseForm(), temp);
        Chain<TestedFragment> newFragments = null;
        Object var11_79 = null;
        for (Template tp : at.getElements()) {
            TestedFragment newTF = new TestedFragment();
            newTF.template = tp;
            newTF.handle = newMF.getHandle();
            if (newFragments == null) {
                Chain<TestedFragment> chain;
                newFragments = chain = new Chain<TestedFragment>(newTF);
                continue;
            }
            var11_80.setTail(new Chain<TestedFragment>(newTF));
            Chain chain = var11_80.tail();
        }
        var11_80.setTail(fragments);
        matched.add(newMF);
        temp.quantifier = 2;
        if (this.lookingAt(newFragments, tokens, smt)) {
            temp.quantifier = 3;
            return true;
        }
        temp.quantifier = 3;
        matched.remove();
        return false;
    }

    public int length(LinkedList<MatchedElement> list) {
        int len = 0;
        for (MatchedElement e : list) {
            len += e.length();
        }
        return len;
    }

    public MatchedFragment getMatchedFragment() {
        return this.matched;
    }

    private class MarkedTemplate {
        public Template template;
        public Token token;

        public MarkedTemplate(Template template, Token token) {
            this.template = template;
            this.token = token;
        }
    }

    private class SetOfMarkedTemplates {
        public LinkedList<MarkedTemplate> markedTemplates;

        public SetOfMarkedTemplates() {
            this.markedTemplates = new LinkedList();
        }

        public SetOfMarkedTemplates(SetOfMarkedTemplates smt, Template template, Token token) {
            this.markedTemplates = (LinkedList)smt.markedTemplates.clone();
            this.add(new MarkedTemplate(template, token));
        }

        public boolean contains(Template template, Token token) {
            for (MarkedTemplate mt : this.markedTemplates) {
                if (mt.template != template || mt.token != token) continue;
                return true;
            }
            return false;
        }

        public void add(MarkedTemplate template) {
            this.markedTemplates.add(template);
        }
    }

    private class TestedFragment {
        private Template template;
        private MatchedFragment.Handle handle;

        private TestedFragment() {
        }

        public Template getTemplate() {
            return this.template;
        }

        public MatchedFragment getMatchedFragment() {
            return this.handle.getMatchedFragment();
        }
    }
}

