/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import termopl.CommonResources;
import termopl.TermoPL;

public class Workspace
extends JPanel {
    public static final int OK = 1;
    private String currentWorkspace;
    private JDialog dialog;
    private int answer;
    private JButton okButton;
    private JButton cancelButton;
    private JButton changeButton;
    private JTextArea workspace;

    public Workspace(String currentWorkspace) {
        super(new BorderLayout());
        this.currentWorkspace = currentWorkspace;
        this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.arrangeComponents();
    }

    public void arrangeComponents() {
        Box hbox = Box.createHorizontalBox();
        hbox.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        hbox.add(new JLabel("Selected Workspace:"));
        hbox.add(Box.createHorizontalGlue());
        this.add((Component)hbox, "North");
        this.workspace = new JTextArea();
        this.workspace.setFont(CommonResources.ttFont);
        this.workspace.setEditable(false);
        this.workspace.setCursor(null);
        this.workspace.setOpaque(false);
        this.workspace.setFocusable(false);
        this.workspace.setLineWrap(true);
        this.workspace.setWrapStyleWord(true);
        this.workspace.setPreferredSize(new Dimension(400, 120));
        this.workspace.setText(this.currentWorkspace);
        this.add((Component)this.workspace, "Center");
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.changeButton = new JButton("Change");
        Dimension dim = this.changeButton.getPreferredSize();
        this.okButton.setPreferredSize(dim);
        this.cancelButton.setPreferredSize(dim);
        hbox = Box.createHorizontalBox();
        hbox.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        hbox.add(Box.createHorizontalGlue());
        hbox.add(this.changeButton);
        hbox.add(Box.createHorizontalStrut(8));
        hbox.add(this.cancelButton);
        hbox.add(Box.createHorizontalStrut(8));
        hbox.add(this.okButton);
        this.add((Component)hbox, "South");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Workspace.this.answer = 1;
                Workspace.this.dialog.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Workspace.this.dialog.setVisible(false);
            }
        });
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser chooser = new JFileChooser();
                File dir = new File(Workspace.this.currentWorkspace);
                chooser.setDialogTitle("Select New Workspace");
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(1);
                chooser.setApproveButtonText("Select");
                chooser.setApproveButtonMnemonic('S');
                chooser.setCurrentDirectory(dir);
                if (chooser.showOpenDialog(TermoPL.dialogOwner) == 0) {
                    Workspace.this.currentWorkspace = chooser.getSelectedFile().getPath();
                    Workspace.this.workspace.setText(Workspace.this.currentWorkspace);
                }
            }
        });
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public int doDialog() {
        this.answer = -1;
        this.dialog = new JDialog(TermoPL.dialogOwner);
        this.dialog.setModal(true);
        this.dialog.setDefaultCloseOperation(1);
        this.dialog.setTitle("Workspace");
        this.dialog.setResizable(true);
        this.dialog.getContentPane().add(this);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(TermoPL.dialogOwner);
        this.dialog.setVisible(true);
        return this.answer;
    }

    public String getCurrentWorkspace() {
        return this.currentWorkspace;
    }
}

