/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import termopl.CommonResources;
import termopl.Form;
import termopl.InfoPanel;
import termopl.Term;
import termopl.TermoPL;
import termopl.TermoPLDocument;
import termopl.TermsView;

public class FormsView
extends JPanel {
    private TermoPLDocument doc;
    private JScrollPane sp;
    private Content content;
    private InfoPanel infoPanel;
    private Term term;

    public FormsView(TermoPLDocument document) {
        this.doc = document;
        this.setLayout(new BorderLayout());
        this.arrangeComponents();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TermsView tv = FormsView.this.doc.getTermsView();
                if (tv != null) {
                    FormsView.this.setData(tv.getSelectedTerm());
                }
            }
        });
    }

    public void arrangeComponents() {
        this.content = new Content();
        this.infoPanel = new InfoPanel();
        this.sp = new JScrollPane(this.content);
        this.sp.getViewport().setBackground(CommonResources.LIGHT_GRAY);
        this.sp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, -1, 0, -1), BorderFactory.createLineBorder(Color.lightGray)));
        this.add((Component)this.sp, "Center");
        this.add((Component)this.infoPanel, "South");
    }

    public void setData(Term term) {
        this.term = term;
        this.content.calcSize();
        this.content.invalidate();
        this.scrollRectToVisible(CommonResources.nullRect);
        this.repaint();
        if (term != null) {
            this.infoPanel.setInfo("Forms found: " + term.getForms().size());
        } else {
            this.infoPanel.setWarning("Term is not selected.");
        }
    }

    public void reset() {
        this.setData(null);
    }

    public void changeFontSize() {
        this.content.calcSize();
        this.invalidate();
        this.repaint();
    }

    private class Content
    extends JPanel {
        private int height;

        public Content() {
            this.setBackground(CommonResources.LIGHT_GRAY);
        }

        public void calcSize() {
            this.height = FormsView.this.term == null ? 0 : this.calcHeight(FormsView.this.term.getForms());
            this.setPreferredSize(new Dimension(0, this.height));
        }

        public int calcHeight(LinkedList<Form> elements) {
            Graphics graphics = this.getGraphics();
            int x = 4;
            int w = this.getWidth() - 4;
            int height = 0;
            graphics.setFont(TermoPL.preferences.plainFont);
            FontMetrics fm = graphics.getFontMetrics();
            if (elements == null) {
                height += fm.getHeight();
            } else {
                String c = ",";
                int sp = fm.stringWidth(" ");
                Form last = elements.getLast();
                for (Form form : elements) {
                    String str = form.toString();
                    String[] strings = str.split(" ");
                    if (form == last) {
                        c = "";
                    }
                    String[] stringArray = strings;
                    int n = strings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int sw;
                        String s = stringArray[n2];
                        if (s == strings[strings.length - 1]) {
                            s = String.valueOf(s) + c;
                        }
                        if (x + (sw = fm.stringWidth(s)) > w) {
                            x = 4;
                            height += fm.getHeight();
                        }
                        if ((x += sw) + sp > w) {
                            x = 4;
                            height += fm.getHeight();
                        } else {
                            x += sp;
                        }
                        ++n2;
                    }
                }
                height += fm.getHeight() + 2;
            }
            return height;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (FormsView.this.term != null) {
                this.paintElements(graphics, FormsView.this.term.getForms(), "Forms:");
            }
        }

        public void paintElements(Graphics graphics, LinkedList<Form> elements, String header) {
            int x = 4;
            int y = 0;
            int w = this.getWidth() - 4;
            graphics.setColor(Color.black);
            graphics.setFont(TermoPL.preferences.plainFont);
            FontMetrics fm = graphics.getFontMetrics();
            if (elements == null) {
                graphics.drawString("none", x, y + fm.getAscent());
            } else {
                String c = ",";
                int sp = fm.stringWidth(" ");
                Form last = elements.getLast();
                for (Form form : elements) {
                    String str = form.toString();
                    String o = form.occurences();
                    String[] strings = str.split(" ");
                    if (form == last) {
                        c = "";
                    }
                    String[] stringArray = strings;
                    int n = strings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int sw;
                        String s = stringArray[n2];
                        if (s == strings[strings.length - 1]) {
                            s = String.valueOf(s) + o + c;
                        }
                        if (x + (sw = fm.stringWidth(s)) > w) {
                            x = 4;
                            y += fm.getHeight();
                        }
                        graphics.drawString(s, x, y + fm.getAscent());
                        if ((x += sw) + sp > w) {
                            x = 4;
                            y += fm.getHeight();
                        } else {
                            x += sp;
                        }
                        ++n2;
                    }
                }
            }
        }
    }
}

