/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.util.LinkedList;
import termopl.MatchedElement;
import termopl.MatchedToken;
import termopl.SentenceRef;
import termopl.Tagset;
import termopl.Template;
import termopl.Token;

public class MatchedFragment
implements MatchedElement,
Cloneable {
    private Handle handle = new Handle(this);
    private MatchedFragment parent = null;
    private LinkedList<MatchedElement> matchedElements = new LinkedList();
    private Template template;
    private SentenceRef sentenceRef = null;
    private int docID = 0;
    public boolean computeBaseForm;

    public MatchedFragment(boolean computeBaseForm, Template template) {
        this.computeBaseForm = computeBaseForm;
        this.template = template;
    }

    public Object clone() {
        try {
            MatchedFragment cloned = (MatchedFragment)super.clone();
            LinkedList<MatchedElement> list = new LinkedList<MatchedElement>();
            for (MatchedElement me : this.matchedElements) {
                if (me instanceof MatchedToken) {
                    MatchedToken mt = (MatchedToken)me;
                    mt.setParent(cloned);
                    list.add(me);
                    continue;
                }
                MatchedFragment mf = (MatchedFragment)((MatchedFragment)me).clone();
                mf.setParent(cloned);
                list.add(mf);
            }
            this.handle.setMatchedFragment(cloned);
            cloned.matchedElements = list;
            cloned.handle = this.handle;
            return cloned;
        }
        catch (CloneNotSupportedException exception) {
            return null;
        }
    }

    public Handle getHandle() {
        return this.handle;
    }

    @Override
    public void setParent(MatchedFragment parent) {
        this.parent = parent;
    }

    public boolean testSelf(Tagset tagset) {
        if (this.template.test(this, tagset)) {
            if (this.parent == null) {
                return true;
            }
            return this.parent.testSelf(tagset);
        }
        return false;
    }

    public Template getTemplate() {
        return this.template;
    }

    public boolean computeBaseForm() {
        return this.computeBaseForm;
    }

    public void setDocID(int docID) {
        this.docID = docID;
    }

    public int getDocID() {
        return this.docID;
    }

    public void setRef(SentenceRef sentenceRef) {
        this.sentenceRef = sentenceRef;
    }

    public SentenceRef getRef() {
        return this.sentenceRef;
    }

    public LinkedList<MatchedElement> getMatchedElements() {
        return this.matchedElements;
    }

    public void add(MatchedToken element) {
        element.setParent(this);
        this.matchedElements.add(element);
    }

    public void add(MatchedFragment element) {
        element.setParent(this);
        this.matchedElements.add(element);
    }

    public void append(LinkedList<MatchedElement> list) {
        for (MatchedElement element : list) {
            element.setParent(this);
            this.matchedElements.add(element);
        }
    }

    public MatchedElement remove() {
        return this.matchedElements.removeLast();
    }

    public LinkedList<MatchedElement> remove(MatchedElement me) {
        LinkedList<MatchedElement> list = new LinkedList<MatchedElement>();
        MatchedElement element = null;
        while (element != me && !this.matchedElements.isEmpty()) {
            element = this.remove();
            list.addFirst(element);
        }
        return list;
    }

    public LinkedList<MatchedToken> getMatchedTokens() {
        LinkedList<MatchedToken> tokens = new LinkedList<MatchedToken>();
        for (MatchedElement e : this.matchedElements) {
            if (e instanceof MatchedToken) {
                tokens.add((MatchedToken)e);
                continue;
            }
            MatchedFragment mf = (MatchedFragment)e;
            LinkedList<MatchedToken> list = mf.getMatchedTokens();
            if (mf.computeBaseForm) {
                for (MatchedToken t : list) {
                    t.computeBaseForm = true;
                }
            }
            tokens.addAll(list);
        }
        return tokens;
    }

    public LinkedList<Token> getTokens() {
        LinkedList<Token> tokens = new LinkedList<Token>();
        for (MatchedElement e : this.matchedElements) {
            if (e instanceof MatchedToken) {
                tokens.add(((MatchedToken)e).token);
                continue;
            }
            MatchedFragment mf = (MatchedFragment)e;
            tokens.addAll(mf.getTokens());
        }
        return tokens;
    }

    @Override
    public int length() {
        return this.getTokens().size();
    }

    public String toString() {
        String str = "";
        LinkedList<MatchedToken> tokens = this.getMatchedTokens();
        boolean appendSpace = false;
        for (MatchedToken t : tokens) {
            if (appendSpace) {
                str = String.valueOf(str) + " ";
            } else {
                appendSpace = true;
            }
            str = String.valueOf(str) + t.token.form;
        }
        return str;
    }

    public class Handle {
        private MatchedFragment fragment;

        public Handle(MatchedFragment fragment) {
            this.fragment = fragment;
        }

        public void setMatchedFragment(MatchedFragment fragment) {
            this.fragment = fragment;
        }

        public MatchedFragment getMatchedFragment() {
            return this.fragment;
        }
    }
}

