/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import termopl.ErrorViewer;
import termopl.ParserError;
import termopl.ParserException;

public abstract class Parser {
    public static final int EOF = -1;
    public static final int EOL = 10;
    public static final int SPACE = 32;
    public static final int EXCLM = 33;
    public static final int QUOTE = 34;
    public static final int HASH = 35;
    public static final int DOLLAR = 36;
    public static final int LPAR = 40;
    public static final int RPAR = 41;
    public static final int STAR = 42;
    public static final int PLUS = 43;
    public static final int COMMA = 44;
    public static final int SLASH = 47;
    public static final int COLON = 58;
    public static final int SCOLON = 59;
    public static final int LANGLE = 60;
    public static final int EQ = 61;
    public static final int RANGLE = 62;
    public static final int QMARK = 63;
    public static final int LBRCT = 91;
    public static final int BSLASH = 92;
    public static final int RBRCT = 93;
    public static final int CIRCMFX = 94;
    public static final int VBAR = 124;
    public static final int TILDE = 126;
    private Object owner;
    protected int lineCount = 0;
    protected int charCount = 0;
    protected int scanPos = 0;
    protected char[] line = null;
    protected boolean loadNewLine = true;
    protected Symbol symbol;
    protected String identifier;
    protected String string = null;
    protected BufferedReader reader;
    protected StringBuffer buffer = new StringBuffer();
    protected LinkedList<ParserError> errors = new LinkedList();

    public abstract void parse();

    public abstract void getSymbol() throws ParserException;

    public Parser(Object owner) {
        this.owner = owner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNextChar() throws ParserException {
        try {
            char nch;
            if (this.loadNewLine) {
                String l = this.reader.readLine();
                if (l == null) {
                    return -1;
                }
                if (l.isEmpty()) {
                    return 10;
                }
                if (l.startsWith("#")) {
                    return 10;
                }
                this.line = l.toCharArray();
                ++this.lineCount;
                this.charCount = 0;
                this.loadNewLine = false;
            } else if (this.line.length <= this.charCount) {
                this.loadNewLine = true;
                return 10;
            }
            char ch = this.line[this.charCount++];
            if (ch == '/' && (nch = this.line[this.charCount]) == '/') {
                String l = this.reader.readLine();
                if (l == null) {
                    return -1;
                }
                this.line = l.toCharArray();
                ++this.lineCount;
                this.charCount = 0;
                return 10;
            }
            return ch;
        }
        catch (IOException exception) {
            this.error(exception.getMessage());
            return -1;
        }
    }

    public void getString() throws ParserException {
        int ch;
        this.buffer.setLength(0);
        do {
            if ((ch = this.getNextChar()) != 34) {
                this.buffer.append((char)ch);
            }
            if (ch != 92) continue;
            ch = this.getNextChar();
            if (ch == 34) {
                this.buffer.setCharAt(this.buffer.length() - 1, (char)ch);
                continue;
            }
            if (ch == 10) {
                this.buffer.setLength(this.buffer.length() - 1);
                ch = 32;
                continue;
            }
            this.buffer.append((char)ch);
        } while (ch != 34 && ch != 10 && ch != -1);
        if (ch == 34) {
            this.string = this.buffer.toString();
            this.symbol = Symbol.STRING;
        } else {
            this.string = null;
            this.symbol = Symbol.UNKNOWN;
            this.error(7, this.line, this.lineCount, this.charCount);
            this.skip(Symbol.RBRCT);
        }
    }

    public boolean isLetter(int ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122;
    }

    public boolean isDigit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    public boolean isIdentifierChar(int ch) {
        return this.isLetter(ch) || this.isDigit(ch) || ch == 95 || ch == 45;
    }

    public void skip(Symbol ... list) throws ParserException {
        while (!this.belongs(this.symbol, list) && this.symbol != Symbol.EMPTY) {
            this.getSymbol();
        }
    }

    public boolean belongs(Symbol symbol, Symbol[] list) {
        Symbol[] symbolArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Symbol s = symbolArray[n2];
            if (s == symbol) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void error(int err, char[] line, int lineCount, int scanPos) throws ParserException {
        if (this.symbol == Symbol.EMPTY) {
            this.errors.add(new ParserError(1));
            throw new ParserException();
        }
        for (ParserError e : this.errors) {
            if (e.lineNo != lineCount || e.pos != scanPos) continue;
            return;
        }
        this.errors.add(new ParserError(err, line, lineCount, scanPos));
    }

    public void error(String msg) throws ParserException {
        this.errors.add(new ParserError(msg));
        throw new ParserException();
    }

    public void error(int err) throws ParserException {
        this.error(err, this.line, this.lineCount, this.scanPos);
    }

    public boolean noErrors() {
        return this.errors.size() == 0;
    }

    public boolean tooManyErrors() {
        int n = this.errors.size();
        if (n >= 10) {
            if (n == 10) {
                this.errors.add(new ParserError(32));
            }
            return true;
        }
        return false;
    }

    public void reportErrors() {
        if (!this.noErrors()) {
            ErrorViewer viewer = null;
            if (this.owner != null) {
                viewer = new ErrorViewer(this.owner);
            }
            for (ParserError err : this.errors) {
                if (this.owner == null) {
                    err.print();
                    continue;
                }
                viewer.showError(err.toString());
            }
            if (this.owner != null) {
                viewer.setVisible(true);
            }
        }
    }

    public static enum Symbol {
        EMPTY,
        IDENTIFIER,
        STRING,
        NUMBER,
        HASH,
        DOLLAR,
        CIRCMFX,
        QMARK,
        STAR,
        PLUS,
        OR,
        COMMA,
        COLON,
        SCOLON,
        EQ,
        NEQ,
        MATCH,
        NMATCH,
        LPAR,
        RPAR,
        LBRCT,
        RBRCT,
        LANGLE,
        RANGLE,
        UNKNOWN;

    }
}

