/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import termopl.CommonResources;
import termopl.PictButton;
import termopl.TermoPL;
import termopl.TermoPLDocument;

public class SelectedFiles
extends JPanel {
    public static final int OK = 1;
    public static final String[] HEADERS = new String[]{"#", "File Path"};
    private TermoPLDocument doc;
    private File[] files;
    private File[] oldFiles;
    private File[] newFiles;
    private JLabel missingFiles;
    private JTextField corpusName;
    private JTable table;
    private JScrollPane sp;
    private PictButton addButton;
    private PictButton removeButton;
    private JCheckBox reuseBox;
    private JDialog dialog = null;
    private int numOfOldFiles = 0;
    private int numOfNewFiles = 0;
    private int answer;

    public SelectedFiles(TermoPLDocument doc) {
        super(new BorderLayout());
        int i;
        this.doc = doc;
        this.oldFiles = doc.getOldFiles();
        this.newFiles = doc.getNewFiles();
        if (this.oldFiles != null) {
            this.numOfOldFiles = this.oldFiles.length;
        }
        if (this.newFiles != null) {
            this.numOfNewFiles = this.newFiles.length;
        }
        this.files = new File[this.numOfOldFiles + this.numOfNewFiles];
        int s = 0;
        if (this.oldFiles != null) {
            i = 0;
            while (i < this.numOfOldFiles) {
                this.files[s++] = this.oldFiles[i];
                ++i;
            }
        }
        if (this.newFiles != null) {
            i = 0;
            while (i < this.numOfNewFiles) {
                this.files[s++] = this.newFiles[i];
                ++i;
            }
        }
        this.table = new JTable();
        this.table.setAutoResizeMode(3);
        this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.arrangeComponents();
        this.initTable();
        if (this.numOfOldFiles + this.numOfNewFiles == 0) {
            this.addNewFiles();
        }
    }

    public void arrangeComponents() {
        JButton acceptButton = new JButton("Accept");
        JButton cancelButton = new JButton("Cancel");
        JButton workspaceButton = new JButton("Workspace");
        JPanel topPanel = new JPanel(new FlowLayout(0));
        Box vbox = Box.createVerticalBox();
        Box hbox = Box.createHorizontalBox();
        this.reuseBox = new JCheckBox("Reuse already tagged text files.");
        this.reuseBox.setSelected(this.doc.getPreferences().reuseTaggedFiles);
        vbox.add(Box.createVerticalStrut(2));
        this.addButton = new PictButton("plus.png", true);
        this.addButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        hbox.add(this.addButton);
        this.removeButton = new PictButton("minus.png", true);
        this.removeButton.setEnabled(false);
        this.removeButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        hbox.add(this.removeButton);
        hbox.add(Box.createHorizontalGlue());
        this.missingFiles = new JLabel("There are missing file(s)!");
        this.missingFiles.setForeground(Color.red);
        hbox.add(this.missingFiles);
        vbox.add(hbox);
        hbox = Box.createHorizontalBox();
        hbox.add(this.reuseBox);
        hbox.add(Box.createHorizontalStrut(8));
        hbox.add(Box.createHorizontalGlue());
        hbox.add(workspaceButton);
        hbox.add(Box.createHorizontalStrut(4));
        hbox.add(cancelButton);
        hbox.add(Box.createHorizontalStrut(4));
        hbox.add(acceptButton);
        vbox.add(hbox);
        this.sp = new JScrollPane(this.table);
        this.sp.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        topPanel.add(new JLabel("Corpus name: "));
        this.corpusName = new JTextField(20);
        if (this.doc.getCorpusName() != null) {
            this.corpusName.setText(this.doc.getCorpusName());
        }
        topPanel.add(this.corpusName);
        this.add((Component)topPanel, "North");
        this.add((Component)this.sp, "Center");
        this.add((Component)vbox, "South");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectedFiles.this.addNewFiles();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectedFiles.this.removeFiles();
            }
        });
        acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectedFiles.this.isFileNameValid(SelectedFiles.this.corpusName.getText())) {
                    SelectedFiles.this.answer = 1;
                    SelectedFiles.this.dialog.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(SelectedFiles.this.dialog, "Enter a valid corpus name.", "Error", 0);
                    SelectedFiles.this.corpusName.selectAll();
                    SelectedFiles.this.corpusName.requestFocus();
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectedFiles.this.dialog.setVisible(false);
            }
        });
        workspaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectedFiles.this.doc.selectWorkspace();
                ((AbstractTableModel)SelectedFiles.this.table.getModel()).fireTableDataChanged();
            }
        });
        this.showMissingFiles();
    }

    public void initTable() {
        FontMetrics fm = this.getFontMetrics(TermoPL.preferences.boldFont);
        this.table.setModel(new SFTableModel());
        this.table.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, -1, 0, -1), BorderFactory.createLineBorder(Color.lightGray)));
        this.table.setBackground(CommonResources.LIGHT_GRAY);
        this.table.setGridColor(Color.lightGray);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(true);
        this.table.setRowHeight(fm.getHeight() + 4);
        TableColumnModel cmodel = this.table.getColumnModel();
        RowRenderer cellRenderer = new RowRenderer();
        TableHeader tableHeader = new TableHeader(cmodel);
        this.table.setTableHeader(tableHeader);
        int i = 0;
        while (i < cmodel.getColumnCount()) {
            TableColumn column = cmodel.getColumn(i);
            column.setHeaderValue(HEADERS[i]);
            column.setCellRenderer(cellRenderer);
            if (i == 0) {
                column.setPreferredWidth(40);
                column.setMinWidth(40);
                column.setMaxWidth(40);
            } else {
                column.setPreferredWidth(this.sp.getViewport().getPreferredSize().width - 20);
            }
            ++i;
        }
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int row = SelectedFiles.this.table.getSelectedRow();
                SelectedFiles.this.removeButton.setEnabled(row >= 0);
            }
        });
    }

    public void showMissingFiles() {
        File[] fileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.exists()) {
                this.missingFiles.setVisible(true);
                return;
            }
            ++n2;
        }
        this.missingFiles.setVisible(false);
    }

    public void addNewFiles() {
        File[] newList = this.doc.selectSourceFiles();
        if (newList != null) {
            File f;
            LinkedList<File> list = new LinkedList<File>();
            File[] fileArray = this.files;
            int n = this.files.length;
            int n2 = 0;
            while (n2 < n) {
                f = fileArray[n2];
                list.add(f);
                ++n2;
            }
            fileArray = newList;
            n = newList.length;
            n2 = 0;
            while (n2 < n) {
                f = fileArray[n2];
                String fpath = f.getPath();
                boolean found = false;
                for (File e : list) {
                    String epath = e.getPath();
                    if (!epath.equals(fpath)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    list.add(f);
                }
                ++n2;
            }
            if (list.size() > this.files.length) {
                this.files = list.toArray(this.files);
                ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
                if (this.corpusName.getText().equals("")) {
                    String str = TermoPL.getFileName(this.files[0]);
                    this.corpusName.setText(str);
                }
            }
        }
    }

    public void removeFiles() {
        int[] selected = this.table.getSelectedRows();
        File[] list = new File[this.files.length - selected.length];
        int i = 0;
        int j = 0;
        int n = 0;
        while (i < this.files.length) {
            if (n < selected.length) {
                if (i == selected[n]) {
                    if (i < this.numOfOldFiles) {
                        --this.numOfOldFiles;
                    } else {
                        --this.numOfNewFiles;
                    }
                    ++n;
                } else {
                    list[j++] = this.files[i];
                }
            } else {
                list[j++] = this.files[i];
            }
            ++i;
        }
        this.files = list;
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
    }

    public boolean isFileNameValid(String str) {
        File f = new File(str);
        try {
            return f.getCanonicalFile().getName().equals(str);
        }
        catch (IOException e) {
            return false;
        }
    }

    public File[] getFiles() {
        return this.files;
    }

    public File[] getNewFiles() {
        LinkedList<File> newf = new LinkedList<File>();
        File[] fileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            File f1 = fileArray[n2];
            boolean found = false;
            if (this.oldFiles != null) {
                File[] fileArray2 = this.oldFiles;
                int n3 = this.oldFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File f2 = fileArray2[n4];
                    if (f1.getAbsolutePath().equals(f2.getAbsolutePath())) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
            }
            if (!found) {
                newf.add(f1);
            }
            ++n2;
        }
        if (newf.isEmpty()) {
            return null;
        }
        return newf.toArray(new File[0]);
    }

    public File[] getOldFiles() {
        LinkedList<File> oldf = new LinkedList<File>();
        File[] fileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            File f1 = fileArray[n2];
            if (this.oldFiles != null) {
                File[] fileArray2 = this.oldFiles;
                int n3 = this.oldFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File f2 = fileArray2[n4];
                    if (f1.getAbsolutePath().equals(f2.getAbsolutePath())) {
                        oldf.add(f1);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (oldf.isEmpty()) {
            return null;
        }
        return oldf.toArray(new File[0]);
    }

    public String getCorpusName() {
        return this.corpusName.getText();
    }

    public int rebuild() {
        File[] oldf = this.getOldFiles();
        File[] newf = this.getNewFiles();
        File[] selectedFiles = this.doc.getSelectedFiles();
        int len1 = oldf == null ? 0 : oldf.length;
        int len2 = newf == null ? 0 : newf.length;
        if (selectedFiles != null) {
            System.out.println("not null");
            boolean subset = true;
            File[] fileArray = selectedFiles;
            int n = selectedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f2;
                int n3;
                int n4;
                File[] fileArray2;
                File f1 = fileArray[n2];
                boolean found = false;
                if (oldf != null) {
                    fileArray2 = oldf;
                    n4 = oldf.length;
                    n3 = 0;
                    while (n3 < n4) {
                        f2 = fileArray2[n3];
                        if (f1.getAbsolutePath().equals(f2.getAbsolutePath())) {
                            found = true;
                            break;
                        }
                        ++n3;
                    }
                }
                if (!found && newf != null) {
                    fileArray2 = newf;
                    n4 = newf.length;
                    n3 = 0;
                    while (n3 < n4) {
                        f2 = fileArray2[n3];
                        if (f1.getAbsolutePath().equals(f2.getAbsolutePath())) {
                            found = true;
                            break;
                        }
                        ++n3;
                    }
                }
                if (!found) {
                    subset = false;
                    break;
                }
                ++n2;
            }
            if (subset) {
                if (selectedFiles.length == len1 + len2) {
                    return 0;
                }
                return 1;
            }
            return 2;
        }
        if (oldf != null || newf != null) {
            return 2;
        }
        return 3;
    }

    public boolean reuse() {
        return this.reuseBox.isSelected();
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    public int doDialog() {
        this.answer = -1;
        this.dialog = new JDialog(TermoPL.dialogOwner);
        this.dialog.setModal(true);
        this.dialog.setDefaultCloseOperation(1);
        this.dialog.setTitle("Selected Files");
        this.dialog.setResizable(true);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(TermoPL.dialogOwner);
        this.dialog.setVisible(true);
        return this.answer;
    }

    private class RowRenderer
    extends DefaultTableCellRenderer {
        private final Border border = BorderFactory.createEmptyBorder(0, 4, 0, 4);
        private final ImageIcon missingIcon = new ImageIcon(ClassLoader.getSystemClassLoader().getResource("deleted.png"));
        private final ImageIcon warningIcon = new ImageIcon(ClassLoader.getSystemClassLoader().getResource("warning-small.png"));

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(Color.black);
            if (isSelected) {
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
                this.setBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                this.setForeground(Color.black);
                if (row < SelectedFiles.this.numOfOldFiles) {
                    this.setBackground(CommonResources.PALE_ORANGE);
                } else {
                    this.setBackground(Color.white);
                }
            }
            this.setValue(value);
            this.setFont(TermoPL.preferences.plainFont);
            this.setBorder(this.border);
            if (column == 0) {
                this.setHorizontalAlignment(0);
                if (SelectedFiles.this.files[row].exists()) {
                    Path workspace = FileSystems.getDefault().getPath(((SelectedFiles)SelectedFiles.this).doc.getPreferences().workSpace, new String[0]);
                    Path p = FileSystems.getDefault().getPath(SelectedFiles.this.files[row].getPath(), new String[0]);
                    if (p.startsWith(workspace)) {
                        this.setIcon(null);
                    } else {
                        this.setIcon(this.warningIcon);
                    }
                } else {
                    this.setIcon(this.missingIcon);
                }
            } else {
                this.setHorizontalAlignment(2);
                this.setIcon(null);
            }
            return this;
        }
    }

    private class SFTableModel
    extends AbstractTableModel {
        private SFTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (SelectedFiles.this.files == null) {
                return 0;
            }
            return SelectedFiles.this.files.length;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Path workspace = FileSystems.getDefault().getPath(((SelectedFiles)SelectedFiles.this).doc.getPreferences().workSpace, new String[0]);
            if (SelectedFiles.this.files == null) {
                return 0;
            }
            if (column == 0) {
                return row + 1;
            }
            Path p = FileSystems.getDefault().getPath(SelectedFiles.this.files[row].getAbsolutePath(), new String[0]);
            if (p.startsWith(workspace)) {
                return workspace.relativize(p).toString();
            }
            return p.toString();
        }
    }

    private class TableHeader
    extends JTableHeader {
        public TableHeader(TableColumnModel model) {
            super(model);
            this.setDefaultRenderer(new TableHeaderRenderer());
            this.setReorderingAllowed(false);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            FontMetrics fm = this.getFontMetrics(TermoPL.preferences.boldFont);
            dim.height = fm.getHeight() + 4;
            return dim;
        }
    }

    private class TableHeaderRenderer
    implements TableCellRenderer {
        private JLabel renderer;

        public TableHeaderRenderer() {
            this.initRenderer();
        }

        public void initRenderer() {
            Border headerBorder = UIManager.getBorder("TableHeader.cellBorder");
            this.renderer = new JLabel();
            this.renderer.setFont(TermoPL.preferences.boldFont);
            this.renderer.setBorder(headerBorder);
            this.renderer.setBackground(UIManager.getColor("TableHeader.background"));
            this.renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.renderer.setText((String)value);
            if (column == 0) {
                this.renderer.setHorizontalAlignment(0);
            } else {
                this.renderer.setHorizontalAlignment(2);
            }
            return this.renderer;
        }
    }
}

